/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Code
extends Attribute {
    private int max_stack;
    private int max_locals;
    private byte[] code;
    private CodeException[] exception_table;
    private Attribute[] attributes;

    public Code(Code code) {
        this(code.getNameIndex(), code.getLength(), code.getMaxStack(), code.getMaxLocals(), code.getCode(), code.getExceptionTable(), code.getAttributes(), code.getConstantPool());
    }

    Code(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), null, null, null, constantPool);
        int n3;
        int n4 = dataInput.readInt();
        this.code = new byte[n4];
        dataInput.readFully(this.code);
        int n5 = dataInput.readUnsignedShort();
        this.exception_table = new CodeException[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            this.exception_table[n3] = new CodeException(dataInput);
        }
        n3 = dataInput.readUnsignedShort();
        this.attributes = new Attribute[n3];
        for (int i = 0; i < n3; ++i) {
            this.attributes[i] = Attribute.readAttribute(dataInput, constantPool);
        }
        super.setLength(n2);
    }

    public Code(int n, int n2, int n3, int n4, byte[] byArray, CodeException[] codeExceptionArray, Attribute[] attributeArray, ConstantPool constantPool) {
        super((byte)2, n, n2, constantPool);
        this.max_stack = n3;
        this.max_locals = n4;
        this.code = byArray != null ? byArray : new byte[]{};
        this.exception_table = codeExceptionArray != null ? codeExceptionArray : new CodeException[]{};
        this.attributes = attributeArray != null ? attributeArray : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCode(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.max_locals);
        dataOutputStream.writeInt(this.code.length);
        dataOutputStream.write(this.code, 0, this.code.length);
        dataOutputStream.writeShort(this.exception_table.length);
        for (CodeException cloneable : this.exception_table) {
            cloneable.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes.length);
        for (Cloneable cloneable : this.attributes) {
            ((Attribute)cloneable).dump(dataOutputStream);
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LineNumberTable)) continue;
            return (LineNumberTable)attribute;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LocalVariableTable)) continue;
            return (LocalVariableTable)attribute;
        }
        return null;
    }

    public final byte[] getCode() {
        return this.code;
    }

    public final CodeException[] getExceptionTable() {
        return this.exception_table;
    }

    public final int getMaxLocals() {
        return this.max_locals;
    }

    public final int getMaxStack() {
        return this.max_stack;
    }

    private int getInternalLength() {
        return 8 + this.code.length + 2 + 8 * (this.exception_table == null ? 0 : this.exception_table.length) + 2;
    }

    private int calculateLength() {
        int n = 0;
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                n += attribute.getLength() + 6;
            }
        }
        return n + this.getInternalLength();
    }

    public final void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray != null ? attributeArray : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    public final void setCode(byte[] byArray) {
        this.code = byArray != null ? byArray : new byte[]{};
        super.setLength(this.calculateLength());
    }

    public final void setExceptionTable(CodeException[] codeExceptionArray) {
        this.exception_table = codeExceptionArray != null ? codeExceptionArray : new CodeException[]{};
        super.setLength(this.calculateLength());
    }

    public final void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public final void setMaxStack(int n) {
        this.max_stack = n;
    }

    public final String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("Code(max_stack = ").append(this.max_stack).append(", max_locals = ").append(this.max_locals).append(", code_length = ").append(this.code.length).append(")\n").append(Utility.codeToString(this.code, super.getConstantPool(), 0, -1, bl));
        if (this.exception_table.length > 0) {
            stringBuilder.append("\nException handler(s) = \n").append("From\tTo\tHandler\tType\n");
            for (Cloneable cloneable : this.exception_table) {
                stringBuilder.append(((CodeException)cloneable).toString(super.getConstantPool(), bl)).append("\n");
            }
        }
        if (this.attributes.length > 0) {
            stringBuilder.append("\nAttribute(s) = ");
            for (Cloneable cloneable : this.attributes) {
                stringBuilder.append("\n").append(cloneable);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public final String toString() {
        return this.toString(true);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        int n;
        Code code = (Code)this.clone();
        if (this.code != null) {
            code.code = new byte[this.code.length];
            System.arraycopy(this.code, 0, code.code, 0, this.code.length);
        }
        code.setConstantPool(constantPool);
        code.exception_table = new CodeException[this.exception_table.length];
        for (n = 0; n < this.exception_table.length; ++n) {
            code.exception_table[n] = this.exception_table[n].copy();
        }
        code.attributes = new Attribute[this.attributes.length];
        for (n = 0; n < this.attributes.length; ++n) {
            code.attributes[n] = this.attributes[n].copy(constantPool);
        }
        return code;
    }
}

