/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ArrayElementValue;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ElementValueGen;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ArrayElementValueGen
extends ElementValueGen {
    private final List<ElementValueGen> evalues;

    public ArrayElementValueGen(ConstantPoolGen constantPoolGen) {
        super(91, constantPoolGen);
        this.evalues = new ArrayList<ElementValueGen>();
    }

    public ArrayElementValueGen(int n, ElementValue[] elementValueArray, ConstantPoolGen constantPoolGen) {
        super(n, constantPoolGen);
        if (n != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor - type specified: " + n);
        }
        this.evalues = new ArrayList<ElementValueGen>();
        for (ElementValue elementValue : elementValueArray) {
            this.evalues.add(ElementValueGen.copy(elementValue, constantPoolGen, true));
        }
    }

    @Override
    public ElementValue getElementValue() {
        ElementValue[] elementValueArray = new ElementValue[this.evalues.size()];
        int n = 0;
        for (ElementValueGen elementValueGen : this.evalues) {
            elementValueArray[n++] = elementValueGen.getElementValue();
        }
        return new ArrayElementValue(super.getElementValueType(), elementValueArray, this.getConstantPool().getConstantPool());
    }

    public ArrayElementValueGen(ArrayElementValue arrayElementValue, ConstantPoolGen constantPoolGen, boolean bl) {
        super(91, constantPoolGen);
        ElementValue[] elementValueArray;
        this.evalues = new ArrayList<ElementValueGen>();
        for (ElementValue elementValue : elementValueArray = arrayElementValue.getElementValuesArray()) {
            this.evalues.add(ElementValueGen.copy(elementValue, constantPoolGen, bl));
        }
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getElementValueType());
        dataOutputStream.writeShort(this.evalues.size());
        for (ElementValueGen elementValueGen : this.evalues) {
            elementValueGen.dump(dataOutputStream);
        }
    }

    @Override
    public String stringifyValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        String string = "";
        for (ElementValueGen elementValueGen : this.evalues) {
            stringBuilder.append(string);
            string = ",";
            stringBuilder.append(elementValueGen.stringifyValue());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public List<ElementValueGen> getElementValues() {
        return this.evalues;
    }

    public int getElementValuesSize() {
        return this.evalues.size();
    }

    public void addElement(ElementValueGen elementValueGen) {
        this.evalues.add(elementValueGen);
    }
}

