/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.BIPUSH;
import com.sun.org.apache.bcel.internal.generic.BREAKPOINT;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DLOAD;
import com.sun.org.apache.bcel.internal.generic.DSTORE;
import com.sun.org.apache.bcel.internal.generic.FLOAD;
import com.sun.org.apache.bcel.internal.generic.FSTORE;
import com.sun.org.apache.bcel.internal.generic.GETFIELD;
import com.sun.org.apache.bcel.internal.generic.GETSTATIC;
import com.sun.org.apache.bcel.internal.generic.GOTO;
import com.sun.org.apache.bcel.internal.generic.GOTO_W;
import com.sun.org.apache.bcel.internal.generic.IFEQ;
import com.sun.org.apache.bcel.internal.generic.IFGE;
import com.sun.org.apache.bcel.internal.generic.IFGT;
import com.sun.org.apache.bcel.internal.generic.IFLE;
import com.sun.org.apache.bcel.internal.generic.IFLT;
import com.sun.org.apache.bcel.internal.generic.IFNE;
import com.sun.org.apache.bcel.internal.generic.IFNONNULL;
import com.sun.org.apache.bcel.internal.generic.IFNULL;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPNE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPEQ;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPGE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPGT;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPLE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPLT;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPNE;
import com.sun.org.apache.bcel.internal.generic.IINC;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.IMPDEP1;
import com.sun.org.apache.bcel.internal.generic.IMPDEP2;
import com.sun.org.apache.bcel.internal.generic.INSTANCEOF;
import com.sun.org.apache.bcel.internal.generic.INVOKEDYNAMIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKESTATIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.InstructionComparator;
import com.sun.org.apache.bcel.internal.generic.InstructionConst;
import com.sun.org.apache.bcel.internal.generic.JSR;
import com.sun.org.apache.bcel.internal.generic.JSR_W;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.LDC2_W;
import com.sun.org.apache.bcel.internal.generic.LDC_W;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LOOKUPSWITCH;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MULTIANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.PUTFIELD;
import com.sun.org.apache.bcel.internal.generic.PUTSTATIC;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.SIPUSH;
import com.sun.org.apache.bcel.internal.generic.TABLESWITCH;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Instruction
implements Cloneable {
    private short length = 1;
    private short opcode = (short)-1;
    private static InstructionComparator cmp = InstructionComparator.DEFAULT;

    Instruction() {
    }

    public Instruction(short s, short s2) {
        this.length = s2;
        this.opcode = s;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
    }

    public String getName() {
        return Const.getOpcodeName(this.opcode);
    }

    public String toString(boolean bl) {
        if (bl) {
            return this.getName() + "[" + this.opcode + "](" + this.length + ")";
        }
        return this.getName();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(ConstantPool constantPool) {
        return this.toString(false);
    }

    public Instruction copy() {
        Instruction instruction = null;
        if (InstructionConst.getInstruction(this.getOpcode()) != null) {
            instruction = this;
        } else {
            try {
                instruction = (Instruction)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                System.err.println(cloneNotSupportedException);
            }
        }
        return instruction;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
    }

    public static Instruction readInstruction(ByteSequence byteSequence) throws IOException {
        Instruction instruction;
        boolean bl = false;
        short s = (short)byteSequence.readUnsignedByte();
        Instruction instruction2 = null;
        if (s == 196) {
            bl = true;
            s = (short)byteSequence.readUnsignedByte();
        }
        if ((instruction = InstructionConst.getInstruction(s)) != null) {
            return instruction;
        }
        switch (s) {
            case 16: {
                instruction2 = new BIPUSH();
                break;
            }
            case 17: {
                instruction2 = new SIPUSH();
                break;
            }
            case 18: {
                instruction2 = new LDC();
                break;
            }
            case 19: {
                instruction2 = new LDC_W();
                break;
            }
            case 20: {
                instruction2 = new LDC2_W();
                break;
            }
            case 21: {
                instruction2 = new ILOAD();
                break;
            }
            case 22: {
                instruction2 = new LLOAD();
                break;
            }
            case 23: {
                instruction2 = new FLOAD();
                break;
            }
            case 24: {
                instruction2 = new DLOAD();
                break;
            }
            case 25: {
                instruction2 = new ALOAD();
                break;
            }
            case 26: {
                instruction2 = new ILOAD(0);
                break;
            }
            case 27: {
                instruction2 = new ILOAD(1);
                break;
            }
            case 28: {
                instruction2 = new ILOAD(2);
                break;
            }
            case 29: {
                instruction2 = new ILOAD(3);
                break;
            }
            case 30: {
                instruction2 = new LLOAD(0);
                break;
            }
            case 31: {
                instruction2 = new LLOAD(1);
                break;
            }
            case 32: {
                instruction2 = new LLOAD(2);
                break;
            }
            case 33: {
                instruction2 = new LLOAD(3);
                break;
            }
            case 34: {
                instruction2 = new FLOAD(0);
                break;
            }
            case 35: {
                instruction2 = new FLOAD(1);
                break;
            }
            case 36: {
                instruction2 = new FLOAD(2);
                break;
            }
            case 37: {
                instruction2 = new FLOAD(3);
                break;
            }
            case 38: {
                instruction2 = new DLOAD(0);
                break;
            }
            case 39: {
                instruction2 = new DLOAD(1);
                break;
            }
            case 40: {
                instruction2 = new DLOAD(2);
                break;
            }
            case 41: {
                instruction2 = new DLOAD(3);
                break;
            }
            case 42: {
                instruction2 = new ALOAD(0);
                break;
            }
            case 43: {
                instruction2 = new ALOAD(1);
                break;
            }
            case 44: {
                instruction2 = new ALOAD(2);
                break;
            }
            case 45: {
                instruction2 = new ALOAD(3);
                break;
            }
            case 54: {
                instruction2 = new ISTORE();
                break;
            }
            case 55: {
                instruction2 = new LSTORE();
                break;
            }
            case 56: {
                instruction2 = new FSTORE();
                break;
            }
            case 57: {
                instruction2 = new DSTORE();
                break;
            }
            case 58: {
                instruction2 = new ASTORE();
                break;
            }
            case 59: {
                instruction2 = new ISTORE(0);
                break;
            }
            case 60: {
                instruction2 = new ISTORE(1);
                break;
            }
            case 61: {
                instruction2 = new ISTORE(2);
                break;
            }
            case 62: {
                instruction2 = new ISTORE(3);
                break;
            }
            case 63: {
                instruction2 = new LSTORE(0);
                break;
            }
            case 64: {
                instruction2 = new LSTORE(1);
                break;
            }
            case 65: {
                instruction2 = new LSTORE(2);
                break;
            }
            case 66: {
                instruction2 = new LSTORE(3);
                break;
            }
            case 67: {
                instruction2 = new FSTORE(0);
                break;
            }
            case 68: {
                instruction2 = new FSTORE(1);
                break;
            }
            case 69: {
                instruction2 = new FSTORE(2);
                break;
            }
            case 70: {
                instruction2 = new FSTORE(3);
                break;
            }
            case 71: {
                instruction2 = new DSTORE(0);
                break;
            }
            case 72: {
                instruction2 = new DSTORE(1);
                break;
            }
            case 73: {
                instruction2 = new DSTORE(2);
                break;
            }
            case 74: {
                instruction2 = new DSTORE(3);
                break;
            }
            case 75: {
                instruction2 = new ASTORE(0);
                break;
            }
            case 76: {
                instruction2 = new ASTORE(1);
                break;
            }
            case 77: {
                instruction2 = new ASTORE(2);
                break;
            }
            case 78: {
                instruction2 = new ASTORE(3);
                break;
            }
            case 132: {
                instruction2 = new IINC();
                break;
            }
            case 153: {
                instruction2 = new IFEQ();
                break;
            }
            case 154: {
                instruction2 = new IFNE();
                break;
            }
            case 155: {
                instruction2 = new IFLT();
                break;
            }
            case 156: {
                instruction2 = new IFGE();
                break;
            }
            case 157: {
                instruction2 = new IFGT();
                break;
            }
            case 158: {
                instruction2 = new IFLE();
                break;
            }
            case 159: {
                instruction2 = new IF_ICMPEQ();
                break;
            }
            case 160: {
                instruction2 = new IF_ICMPNE();
                break;
            }
            case 161: {
                instruction2 = new IF_ICMPLT();
                break;
            }
            case 162: {
                instruction2 = new IF_ICMPGE();
                break;
            }
            case 163: {
                instruction2 = new IF_ICMPGT();
                break;
            }
            case 164: {
                instruction2 = new IF_ICMPLE();
                break;
            }
            case 165: {
                instruction2 = new IF_ACMPEQ();
                break;
            }
            case 166: {
                instruction2 = new IF_ACMPNE();
                break;
            }
            case 167: {
                instruction2 = new GOTO();
                break;
            }
            case 168: {
                instruction2 = new JSR();
                break;
            }
            case 169: {
                instruction2 = new RET();
                break;
            }
            case 170: {
                instruction2 = new TABLESWITCH();
                break;
            }
            case 171: {
                instruction2 = new LOOKUPSWITCH();
                break;
            }
            case 178: {
                instruction2 = new GETSTATIC();
                break;
            }
            case 179: {
                instruction2 = new PUTSTATIC();
                break;
            }
            case 180: {
                instruction2 = new GETFIELD();
                break;
            }
            case 181: {
                instruction2 = new PUTFIELD();
                break;
            }
            case 182: {
                instruction2 = new INVOKEVIRTUAL();
                break;
            }
            case 183: {
                instruction2 = new INVOKESPECIAL();
                break;
            }
            case 184: {
                instruction2 = new INVOKESTATIC();
                break;
            }
            case 185: {
                instruction2 = new INVOKEINTERFACE();
                break;
            }
            case 186: {
                instruction2 = new INVOKEDYNAMIC();
                break;
            }
            case 187: {
                instruction2 = new NEW();
                break;
            }
            case 188: {
                instruction2 = new NEWARRAY();
                break;
            }
            case 189: {
                instruction2 = new ANEWARRAY();
                break;
            }
            case 192: {
                instruction2 = new CHECKCAST();
                break;
            }
            case 193: {
                instruction2 = new INSTANCEOF();
                break;
            }
            case 197: {
                instruction2 = new MULTIANEWARRAY();
                break;
            }
            case 198: {
                instruction2 = new IFNULL();
                break;
            }
            case 199: {
                instruction2 = new IFNONNULL();
                break;
            }
            case 200: {
                instruction2 = new GOTO_W();
                break;
            }
            case 201: {
                instruction2 = new JSR_W();
                break;
            }
            case 202: {
                instruction2 = new BREAKPOINT();
                break;
            }
            case 254: {
                instruction2 = new IMPDEP1();
                break;
            }
            case 255: {
                instruction2 = new IMPDEP2();
                break;
            }
            default: {
                throw new ClassGenException("Illegal opcode detected: " + s);
            }
        }
        if (bl && !(instruction2 instanceof LocalVariableInstruction) && !(instruction2 instanceof IINC) && !(instruction2 instanceof RET)) {
            throw new ClassGenException("Illegal opcode after wide: " + s);
        }
        instruction2.setOpcode(s);
        instruction2.initFromFile(byteSequence, bl);
        return instruction2;
    }

    public int consumeStack(ConstantPoolGen constantPoolGen) {
        return Const.getConsumeStack(this.opcode);
    }

    public int produceStack(ConstantPoolGen constantPoolGen) {
        return Const.getProduceStack(this.opcode);
    }

    public short getOpcode() {
        return this.opcode;
    }

    public int getLength() {
        return this.length;
    }

    final void setOpcode(short s) {
        this.opcode = s;
    }

    final void setLength(int n) {
        this.length = (short)n;
    }

    void dispose() {
    }

    public abstract void accept(Visitor var1);

    @Deprecated
    public static InstructionComparator getComparator() {
        return cmp;
    }

    @Deprecated
    public static void setComparator(InstructionComparator instructionComparator) {
        cmp = instructionComparator;
    }

    public boolean equals(Object object) {
        return object instanceof Instruction ? cmp.equals(this, (Instruction)object) : false;
    }

    public int hashCode() {
        return this.opcode;
    }

    public static boolean isValidByte(int n) {
        return n >= -128 && n <= 127;
    }

    public static boolean isValidShort(int n) {
        return n >= Short.MIN_VALUE && n <= Short.MAX_VALUE;
    }
}

