/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ExceptionThrower;
import com.sun.org.apache.bcel.internal.generic.FieldOrMethod;
import com.sun.org.apache.bcel.internal.generic.StackConsumer;
import com.sun.org.apache.bcel.internal.generic.StackProducer;
import com.sun.org.apache.bcel.internal.generic.Type;
import java.util.StringTokenizer;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
StackConsumer,
StackProducer {
    InvokeInstruction() {
    }

    protected InvokeInstruction(short s, int n) {
        super(s, n);
    }

    @Override
    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(super.getIndex());
        StringTokenizer stringTokenizer = new StringTokenizer(constantPool.constantToString(constant));
        return Const.getOpcodeName(super.getOpcode()) + " " + stringTokenizer.nextToken().replace('.', '/') + stringTokenizer.nextToken();
    }

    @Override
    public int consumeStack(ConstantPoolGen constantPoolGen) {
        int n = super.getOpcode() == 184 || super.getOpcode() == 186 ? 0 : 1;
        String string = this.getSignature(constantPoolGen);
        return n += Type.getArgumentTypesSize(string);
    }

    @Override
    public int produceStack(ConstantPoolGen constantPoolGen) {
        String string = this.getSignature(constantPoolGen);
        return Type.getReturnTypeSize(string);
    }

    @Override
    @Deprecated
    public String getClassName(ConstantPoolGen constantPoolGen) {
        ConstantPool constantPool = constantPoolGen.getConstantPool();
        ConstantCP constantCP = (ConstantCP)constantPool.getConstant(super.getIndex());
        String string = constantPool.getConstantString(constantCP.getClassIndex(), (byte)7);
        return string.replace('/', '.');
    }

    @Override
    public Type getType(ConstantPoolGen constantPoolGen) {
        return this.getReturnType(constantPoolGen);
    }

    public String getMethodName(ConstantPoolGen constantPoolGen) {
        return this.getName(constantPoolGen);
    }

    public Type getReturnType(ConstantPoolGen constantPoolGen) {
        return Type.getReturnType(this.getSignature(constantPoolGen));
    }

    public Type[] getArgumentTypes(ConstantPoolGen constantPoolGen) {
        return Type.getArgumentTypes(this.getSignature(constantPoolGen));
    }
}

