/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    private final String class_name;

    public static ObjectType getInstance(String string) {
        return new ObjectType(string);
    }

    public ObjectType(String string) {
        super((byte)14, "L" + string.replace('.', '/') + ";");
        this.class_name = string.replace('/', '.');
    }

    public String getClassName() {
        return this.class_name;
    }

    @Override
    public int hashCode() {
        return this.class_name.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ObjectType ? ((ObjectType)object).class_name.equals(this.class_name) : false;
    }

    @Deprecated
    public boolean referencesClass() {
        try {
            JavaClass javaClass = Repository.lookupClass(this.class_name);
            return javaClass.isClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Deprecated
    public boolean referencesInterface() {
        try {
            JavaClass javaClass = Repository.lookupClass(this.class_name);
            return !javaClass.isClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean referencesClassExact() throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.class_name);
        return javaClass.isClass();
    }

    public boolean referencesInterfaceExact() throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.class_name);
        return !javaClass.isClass();
    }

    public boolean subclassOf(ObjectType objectType) throws ClassNotFoundException {
        if (this.referencesInterfaceExact() || objectType.referencesInterfaceExact()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, objectType.class_name);
    }

    public boolean accessibleTo(ObjectType objectType) throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.class_name);
        if (javaClass.isPublic()) {
            return true;
        }
        JavaClass javaClass2 = Repository.lookupClass(objectType.class_name);
        return javaClass2.getPackageName().equals(javaClass.getPackageName());
    }
}

