/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.jaxws;

import com.sun.xml.internal.ws.api.model.wsdl.WSDLExtensible;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLObject;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLBoundFault;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLFault;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLInput;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLMessage;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLOutput;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLPortType;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLService;
import com.sun.xml.internal.ws.api.policy.PolicyResolver;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtensionContext;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicyMapMutator;
import com.sun.xml.internal.ws.policy.jaxws.BuilderHandlerEndpointScope;
import com.sun.xml.internal.ws.policy.jaxws.BuilderHandlerMessageScope;
import com.sun.xml.internal.ws.policy.jaxws.BuilderHandlerOperationScope;
import com.sun.xml.internal.ws.policy.jaxws.BuilderHandlerServiceScope;
import com.sun.xml.internal.ws.policy.jaxws.PolicyMapBuilder;
import com.sun.xml.internal.ws.policy.jaxws.PolicyUtil;
import com.sun.xml.internal.ws.policy.jaxws.SafePolicyReader;
import com.sun.xml.internal.ws.policy.jaxws.WSDLBoundFaultContainer;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModelContext;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.XmlToken;
import com.sun.xml.internal.ws.resources.PolicyMessages;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;

public final class PolicyWSDLParserExtension
extends WSDLParserExtension {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyWSDLParserExtension.class);
    private static final StringBuffer AnonymnousPolicyIdPrefix = new StringBuffer("#__anonymousPolicy__ID");
    private int anonymousPoliciesCount;
    private final SafePolicyReader policyReader = new SafePolicyReader();
    private SafePolicyReader.PolicyRecord expandQueueHead = null;
    private Map<String, SafePolicyReader.PolicyRecord> policyRecordsPassedBy = null;
    private Map<String, PolicySourceModel> anonymousPolicyModels = null;
    private List<String> unresolvedUris = null;
    private final LinkedList<String> urisNeeded = new LinkedList();
    private final Map<String, PolicySourceModel> modelsNeeded = new HashMap<String, PolicySourceModel>();
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4ServiceMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4PortMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4PortTypeMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BindingMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BoundOperationMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4OperationMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4MessageMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4InputMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4OutputMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4FaultMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BindingInputOpMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BindingOutputOpMap = null;
    private Map<WSDLObject, Collection<PolicyRecordHandler>> handlers4BindingFaultOpMap = null;
    private PolicyMapBuilder policyBuilder = new PolicyMapBuilder();

    private boolean isPolicyProcessed(String string) {
        return this.modelsNeeded.containsKey(string);
    }

    private void addNewPolicyNeeded(String string, PolicySourceModel policySourceModel) {
        if (!this.modelsNeeded.containsKey(string)) {
            this.modelsNeeded.put(string, policySourceModel);
            this.urisNeeded.addFirst(string);
        }
    }

    private Map<String, PolicySourceModel> getPolicyModels() {
        return this.modelsNeeded;
    }

    private Map<String, SafePolicyReader.PolicyRecord> getPolicyRecordsPassedBy() {
        if (null == this.policyRecordsPassedBy) {
            this.policyRecordsPassedBy = new HashMap<String, SafePolicyReader.PolicyRecord>();
        }
        return this.policyRecordsPassedBy;
    }

    private Map<String, PolicySourceModel> getAnonymousPolicyModels() {
        if (null == this.anonymousPolicyModels) {
            this.anonymousPolicyModels = new HashMap<String, PolicySourceModel>();
        }
        return this.anonymousPolicyModels;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4ServiceMap() {
        if (null == this.handlers4ServiceMap) {
            this.handlers4ServiceMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4ServiceMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4PortMap() {
        if (null == this.handlers4PortMap) {
            this.handlers4PortMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4PortMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4PortTypeMap() {
        if (null == this.handlers4PortTypeMap) {
            this.handlers4PortTypeMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4PortTypeMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BindingMap() {
        if (null == this.handlers4BindingMap) {
            this.handlers4BindingMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BindingMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4OperationMap() {
        if (null == this.handlers4OperationMap) {
            this.handlers4OperationMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4OperationMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BoundOperationMap() {
        if (null == this.handlers4BoundOperationMap) {
            this.handlers4BoundOperationMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BoundOperationMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4MessageMap() {
        if (null == this.handlers4MessageMap) {
            this.handlers4MessageMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4MessageMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4InputMap() {
        if (null == this.handlers4InputMap) {
            this.handlers4InputMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4InputMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4OutputMap() {
        if (null == this.handlers4OutputMap) {
            this.handlers4OutputMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4OutputMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4FaultMap() {
        if (null == this.handlers4FaultMap) {
            this.handlers4FaultMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4FaultMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BindingInputOpMap() {
        if (null == this.handlers4BindingInputOpMap) {
            this.handlers4BindingInputOpMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BindingInputOpMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BindingOutputOpMap() {
        if (null == this.handlers4BindingOutputOpMap) {
            this.handlers4BindingOutputOpMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BindingOutputOpMap;
    }

    private Map<WSDLObject, Collection<PolicyRecordHandler>> getHandlers4BindingFaultOpMap() {
        if (null == this.handlers4BindingFaultOpMap) {
            this.handlers4BindingFaultOpMap = new HashMap<WSDLObject, Collection<PolicyRecordHandler>>();
        }
        return this.handlers4BindingFaultOpMap;
    }

    private List<String> getUnresolvedUris(boolean bl) {
        if (null == this.unresolvedUris || bl) {
            this.unresolvedUris = new LinkedList<String>();
        }
        return this.unresolvedUris;
    }

    private void policyRecToExpandQueue(SafePolicyReader.PolicyRecord policyRecord) {
        this.expandQueueHead = null == this.expandQueueHead ? policyRecord : this.expandQueueHead.insert(policyRecord);
    }

    private PolicyRecordHandler readSinglePolicy(SafePolicyReader.PolicyRecord policyRecord, boolean bl) {
        PolicyRecordHandler policyRecordHandler = null;
        String string = policyRecord.policyModel.getPolicyId();
        if (string == null) {
            string = policyRecord.policyModel.getPolicyName();
        }
        if (string != null) {
            policyRecordHandler = new PolicyRecordHandler(HandlerType.PolicyUri, policyRecord.getUri());
            this.getPolicyRecordsPassedBy().put(policyRecord.getUri(), policyRecord);
            this.policyRecToExpandQueue(policyRecord);
        } else if (bl) {
            String string2 = AnonymnousPolicyIdPrefix.append(this.anonymousPoliciesCount++).toString();
            policyRecordHandler = new PolicyRecordHandler(HandlerType.AnonymousPolicyId, string2);
            this.getAnonymousPolicyModels().put(string2, policyRecord.policyModel);
            if (null != policyRecord.unresolvedURIs) {
                this.getUnresolvedUris(false).addAll(policyRecord.unresolvedURIs);
            }
        }
        return policyRecordHandler;
    }

    private void addHandlerToMap(Map<WSDLObject, Collection<PolicyRecordHandler>> map, WSDLObject wSDLObject, PolicyRecordHandler policyRecordHandler) {
        if (map.containsKey(wSDLObject)) {
            map.get(wSDLObject).add(policyRecordHandler);
        } else {
            LinkedList<PolicyRecordHandler> linkedList = new LinkedList<PolicyRecordHandler>();
            linkedList.add(policyRecordHandler);
            map.put(wSDLObject, linkedList);
        }
    }

    private String getBaseUrl(String string) {
        if (null == string) {
            return null;
        }
        int n = string.indexOf(35);
        return n == -1 ? string : string.substring(0, n);
    }

    private void processReferenceUri(String string, WSDLObject wSDLObject, XMLStreamReader xMLStreamReader, Map<WSDLObject, Collection<PolicyRecordHandler>> map) {
        if (null == string || string.length() == 0) {
            return;
        }
        if ('#' != string.charAt(0)) {
            this.getUnresolvedUris(false).add(string);
        }
        this.addHandlerToMap(map, wSDLObject, new PolicyRecordHandler(HandlerType.PolicyUri, SafePolicyReader.relativeToAbsoluteUrl(string, xMLStreamReader.getLocation().getSystemId())));
    }

    private boolean processSubelement(WSDLObject wSDLObject, XMLStreamReader xMLStreamReader, Map<WSDLObject, Collection<PolicyRecordHandler>> map) {
        if (NamespaceVersion.resolveAsToken(xMLStreamReader.getName()) == XmlToken.PolicyReference) {
            this.processReferenceUri(this.policyReader.readPolicyReferenceElement(xMLStreamReader), wSDLObject, xMLStreamReader, map);
            return true;
        }
        if (NamespaceVersion.resolveAsToken(xMLStreamReader.getName()) == XmlToken.Policy) {
            PolicyRecordHandler policyRecordHandler = this.readSinglePolicy(this.policyReader.readPolicyElement(xMLStreamReader, null == xMLStreamReader.getLocation().getSystemId() ? "" : xMLStreamReader.getLocation().getSystemId()), true);
            if (null != policyRecordHandler) {
                this.addHandlerToMap(map, wSDLObject, policyRecordHandler);
            }
            return true;
        }
        return false;
    }

    private void processAttributes(WSDLObject wSDLObject, XMLStreamReader xMLStreamReader, Map<WSDLObject, Collection<PolicyRecordHandler>> map) {
        String[] stringArray = this.getPolicyURIsFromAttr(xMLStreamReader);
        if (null != stringArray) {
            for (String string : stringArray) {
                this.processReferenceUri(string, wSDLObject, xMLStreamReader, map);
            }
        }
    }

    @Override
    public boolean portElements(EditableWSDLPort editableWSDLPort, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLPort, xMLStreamReader, this.getHandlers4PortMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void portAttributes(EditableWSDLPort editableWSDLPort, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLPort, xMLStreamReader, this.getHandlers4PortMap());
        LOGGER.exiting();
    }

    @Override
    public boolean serviceElements(EditableWSDLService editableWSDLService, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLService, xMLStreamReader, this.getHandlers4ServiceMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void serviceAttributes(EditableWSDLService editableWSDLService, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLService, xMLStreamReader, this.getHandlers4ServiceMap());
        LOGGER.exiting();
    }

    @Override
    public boolean definitionsElements(XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        if (NamespaceVersion.resolveAsToken(xMLStreamReader.getName()) == XmlToken.Policy) {
            this.readSinglePolicy(this.policyReader.readPolicyElement(xMLStreamReader, null == xMLStreamReader.getLocation().getSystemId() ? "" : xMLStreamReader.getLocation().getSystemId()), false);
            LOGGER.exiting();
            return true;
        }
        LOGGER.exiting();
        return false;
    }

    @Override
    public boolean bindingElements(EditableWSDLBoundPortType editableWSDLBoundPortType, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLBoundPortType, xMLStreamReader, this.getHandlers4BindingMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void bindingAttributes(EditableWSDLBoundPortType editableWSDLBoundPortType, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLBoundPortType, xMLStreamReader, this.getHandlers4BindingMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeElements(EditableWSDLPortType editableWSDLPortType, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLPortType, xMLStreamReader, this.getHandlers4PortTypeMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void portTypeAttributes(EditableWSDLPortType editableWSDLPortType, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLPortType, xMLStreamReader, this.getHandlers4PortTypeMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeOperationElements(EditableWSDLOperation editableWSDLOperation, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLOperation, xMLStreamReader, this.getHandlers4OperationMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void portTypeOperationAttributes(EditableWSDLOperation editableWSDLOperation, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLOperation, xMLStreamReader, this.getHandlers4OperationMap());
        LOGGER.exiting();
    }

    @Override
    public boolean bindingOperationElements(EditableWSDLBoundOperation editableWSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLBoundOperation, xMLStreamReader, this.getHandlers4BoundOperationMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void bindingOperationAttributes(EditableWSDLBoundOperation editableWSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLBoundOperation, xMLStreamReader, this.getHandlers4BoundOperationMap());
        LOGGER.exiting();
    }

    @Override
    public boolean messageElements(EditableWSDLMessage editableWSDLMessage, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLMessage, xMLStreamReader, this.getHandlers4MessageMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void messageAttributes(EditableWSDLMessage editableWSDLMessage, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLMessage, xMLStreamReader, this.getHandlers4MessageMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeOperationInputElements(EditableWSDLInput editableWSDLInput, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLInput, xMLStreamReader, this.getHandlers4InputMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void portTypeOperationInputAttributes(EditableWSDLInput editableWSDLInput, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLInput, xMLStreamReader, this.getHandlers4InputMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeOperationOutputElements(EditableWSDLOutput editableWSDLOutput, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLOutput, xMLStreamReader, this.getHandlers4OutputMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void portTypeOperationOutputAttributes(EditableWSDLOutput editableWSDLOutput, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLOutput, xMLStreamReader, this.getHandlers4OutputMap());
        LOGGER.exiting();
    }

    @Override
    public boolean portTypeOperationFaultElements(EditableWSDLFault editableWSDLFault, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLFault, xMLStreamReader, this.getHandlers4FaultMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void portTypeOperationFaultAttributes(EditableWSDLFault editableWSDLFault, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLFault, xMLStreamReader, this.getHandlers4FaultMap());
        LOGGER.exiting();
    }

    @Override
    public boolean bindingOperationInputElements(EditableWSDLBoundOperation editableWSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLBoundOperation, xMLStreamReader, this.getHandlers4BindingInputOpMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void bindingOperationInputAttributes(EditableWSDLBoundOperation editableWSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLBoundOperation, xMLStreamReader, this.getHandlers4BindingInputOpMap());
        LOGGER.exiting();
    }

    @Override
    public boolean bindingOperationOutputElements(EditableWSDLBoundOperation editableWSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLBoundOperation, xMLStreamReader, this.getHandlers4BindingOutputOpMap());
        LOGGER.exiting();
        return bl;
    }

    @Override
    public void bindingOperationOutputAttributes(EditableWSDLBoundOperation editableWSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLBoundOperation, xMLStreamReader, this.getHandlers4BindingOutputOpMap());
        LOGGER.exiting();
    }

    @Override
    public boolean bindingOperationFaultElements(EditableWSDLBoundFault editableWSDLBoundFault, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        boolean bl = this.processSubelement(editableWSDLBoundFault, xMLStreamReader, this.getHandlers4BindingFaultOpMap());
        LOGGER.exiting(bl);
        return bl;
    }

    @Override
    public void bindingOperationFaultAttributes(EditableWSDLBoundFault editableWSDLBoundFault, XMLStreamReader xMLStreamReader) {
        LOGGER.entering();
        this.processAttributes(editableWSDLBoundFault, xMLStreamReader, this.getHandlers4BindingFaultOpMap());
        LOGGER.exiting();
    }

    private PolicyMapBuilder getPolicyMapBuilder() {
        if (null == this.policyBuilder) {
            this.policyBuilder = new PolicyMapBuilder();
        }
        return this.policyBuilder;
    }

    private Collection<String> getPolicyURIs(Collection<PolicyRecordHandler> collection, PolicySourceModelContext policySourceModelContext) throws PolicyException {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (PolicyRecordHandler policyRecordHandler : collection) {
            String string = policyRecordHandler.handler;
            if (HandlerType.AnonymousPolicyId == policyRecordHandler.type) {
                PolicySourceModel policySourceModel = this.getAnonymousPolicyModels().get(string);
                policySourceModel.expand(policySourceModelContext);
                while (this.getPolicyModels().containsKey(string)) {
                    string = AnonymnousPolicyIdPrefix.append(this.anonymousPoliciesCount++).toString();
                }
                this.getPolicyModels().put(string, policySourceModel);
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean readExternalFile(String string) {
        boolean bl;
        InputStream inputStream = null;
        XMLStreamReader xMLStreamReader = null;
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
            xMLStreamReader = XmlUtil.newXMLInputFactory(true).createXMLStreamReader(inputStream);
            while (xMLStreamReader.hasNext()) {
                if (xMLStreamReader.isStartElement() && NamespaceVersion.resolveAsToken(xMLStreamReader.getName()) == XmlToken.Policy) {
                    this.readSinglePolicy(this.policyReader.readPolicyElement(xMLStreamReader, string), false);
                }
                xMLStreamReader.next();
            }
            bl = true;
        }
        catch (IOException iOException) {
            boolean bl2 = false;
            PolicyUtils.IO.closeResource(xMLStreamReader);
            PolicyUtils.IO.closeResource(inputStream);
            return bl2;
        }
        catch (XMLStreamException xMLStreamException) {
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    PolicyUtils.IO.closeResource(xMLStreamReader);
                    PolicyUtils.IO.closeResource(inputStream);
                    throw throwable;
                }
            }
            PolicyUtils.IO.closeResource(xMLStreamReader);
            PolicyUtils.IO.closeResource(inputStream);
            return bl3;
        }
        PolicyUtils.IO.closeResource(xMLStreamReader);
        PolicyUtils.IO.closeResource(inputStream);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void finished(WSDLParserExtensionContext wSDLParserExtensionContext) {
        Object object3;
        List<String> list;
        LOGGER.entering(wSDLParserExtensionContext);
        if (null != this.expandQueueHead) {
            void var4_6;
            list = this.getUnresolvedUris(false);
            this.getUnresolvedUris(true);
            object3 = new LinkedList();
            SafePolicyReader.PolicyRecord object22 = this.expandQueueHead;
            while (null != var4_6) {
                ((LinkedList)object3).addFirst((String)var4_6.getUri());
                SafePolicyReader.PolicyRecord policyRecord = var4_6.next;
            }
            this.getUnresolvedUris(false).addAll((Collection<String>)object3);
            this.expandQueueHead = null;
            this.getUnresolvedUris(false).addAll(list);
        }
        while (!this.getUnresolvedUris(false).isEmpty()) {
            list = this.getUnresolvedUris(false);
            this.getUnresolvedUris(true);
            for (String string : list) {
                if (this.isPolicyProcessed(string)) continue;
                SafePolicyReader.PolicyRecord policyRecord = this.getPolicyRecordsPassedBy().get(string);
                if (null == policyRecord) {
                    if (this.policyReader.getUrlsRead().contains(this.getBaseUrl(string))) {
                        LOGGER.logSevereException(new PolicyException(PolicyMessages.WSP_1014_CAN_NOT_FIND_POLICY(string)));
                        continue;
                    }
                    if (!this.readExternalFile(this.getBaseUrl(string))) continue;
                    this.getUnresolvedUris(false).add(string);
                    continue;
                }
                if (null != policyRecord.unresolvedURIs) {
                    this.getUnresolvedUris(false).addAll(policyRecord.unresolvedURIs);
                }
                this.addNewPolicyNeeded(string, policyRecord.policyModel);
            }
        }
        list = PolicySourceModelContext.createContext();
        for (String string : this.urisNeeded) {
            PolicySourceModel policySourceModel = this.modelsNeeded.get(string);
            try {
                policySourceModel.expand((PolicySourceModelContext)((Object)list));
                ((PolicySourceModelContext)((Object)list)).addModel(new URI(string), policySourceModel);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.logSevereException(uRISyntaxException);
            }
            catch (PolicyException policyException) {
                LOGGER.logSevereException(policyException);
            }
        }
        try {
            object3 = new HashSet();
            for (EditableWSDLService editableWSDLService : wSDLParserExtensionContext.getWSDLModel().getServices().values()) {
                if (this.getHandlers4ServiceMap().containsKey(editableWSDLService)) {
                    this.getPolicyMapBuilder().registerHandler(new BuilderHandlerServiceScope(this.getPolicyURIs(this.getHandlers4ServiceMap().get(editableWSDLService), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLService, editableWSDLService.getName()));
                }
                for (EditableWSDLPort editableWSDLPort : editableWSDLService.getPorts()) {
                    if (this.getHandlers4PortMap().containsKey(editableWSDLPort)) {
                        this.getPolicyMapBuilder().registerHandler(new BuilderHandlerEndpointScope(this.getPolicyURIs(this.getHandlers4PortMap().get(editableWSDLPort), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLPort, editableWSDLPort.getOwner().getName(), editableWSDLPort.getName()));
                    }
                    if (null == editableWSDLPort.getBinding()) continue;
                    if (this.getHandlers4BindingMap().containsKey(editableWSDLPort.getBinding())) {
                        this.getPolicyMapBuilder().registerHandler(new BuilderHandlerEndpointScope(this.getPolicyURIs(this.getHandlers4BindingMap().get(editableWSDLPort.getBinding()), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLPort.getBinding(), editableWSDLService.getName(), editableWSDLPort.getName()));
                    }
                    if (this.getHandlers4PortTypeMap().containsKey(editableWSDLPort.getBinding().getPortType())) {
                        this.getPolicyMapBuilder().registerHandler(new BuilderHandlerEndpointScope(this.getPolicyURIs(this.getHandlers4PortTypeMap().get(editableWSDLPort.getBinding().getPortType()), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLPort.getBinding().getPortType(), editableWSDLService.getName(), editableWSDLPort.getName()));
                    }
                    for (EditableWSDLBoundOperation editableWSDLBoundOperation : editableWSDLPort.getBinding().getBindingOperations()) {
                        Object object;
                        WSDLExtensible wSDLExtensible;
                        EditableWSDLInput editableWSDLInput;
                        EditableWSDLOperation editableWSDLOperation = editableWSDLBoundOperation.getOperation();
                        QName qName = new QName(editableWSDLBoundOperation.getBoundPortType().getName().getNamespaceURI(), editableWSDLBoundOperation.getName().getLocalPart());
                        if (this.getHandlers4BoundOperationMap().containsKey(editableWSDLBoundOperation)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerOperationScope(this.getPolicyURIs(this.getHandlers4BoundOperationMap().get(editableWSDLBoundOperation), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLBoundOperation, editableWSDLService.getName(), editableWSDLPort.getName(), qName));
                        }
                        if (this.getHandlers4OperationMap().containsKey(editableWSDLOperation)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerOperationScope(this.getPolicyURIs(this.getHandlers4OperationMap().get(editableWSDLOperation), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLOperation, editableWSDLService.getName(), editableWSDLPort.getName(), qName));
                        }
                        if (null != (editableWSDLInput = editableWSDLOperation.getInput()) && (wSDLExtensible = editableWSDLInput.getMessage()) != null && this.getHandlers4MessageMap().containsKey(wSDLExtensible)) {
                            ((HashSet)object3).add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4MessageMap().get(wSDLExtensible), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), wSDLExtensible, BuilderHandlerMessageScope.Scope.InputMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, null));
                        }
                        if (this.getHandlers4BindingInputOpMap().containsKey(editableWSDLBoundOperation)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4BindingInputOpMap().get(editableWSDLBoundOperation), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLBoundOperation, BuilderHandlerMessageScope.Scope.InputMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, null));
                        }
                        if (null != editableWSDLInput && this.getHandlers4InputMap().containsKey(editableWSDLInput)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4InputMap().get(editableWSDLInput), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLInput, BuilderHandlerMessageScope.Scope.InputMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, null));
                        }
                        if (null != (wSDLExtensible = editableWSDLOperation.getOutput()) && (object = wSDLExtensible.getMessage()) != null && this.getHandlers4MessageMap().containsKey(object)) {
                            ((HashSet)object3).add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4MessageMap().get(object), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), object, BuilderHandlerMessageScope.Scope.OutputMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, null));
                        }
                        if (this.getHandlers4BindingOutputOpMap().containsKey(editableWSDLBoundOperation)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4BindingOutputOpMap().get(editableWSDLBoundOperation), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), editableWSDLBoundOperation, BuilderHandlerMessageScope.Scope.OutputMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, null));
                        }
                        if (null != wSDLExtensible && this.getHandlers4OutputMap().containsKey(wSDLExtensible)) {
                            this.getPolicyMapBuilder().registerHandler(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4OutputMap().get(wSDLExtensible), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), wSDLExtensible, BuilderHandlerMessageScope.Scope.OutputMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, null));
                        }
                        object = editableWSDLBoundOperation.getFaults().iterator();
                        while (object.hasNext()) {
                            EditableWSDLBoundFault editableWSDLBoundFault = (EditableWSDLBoundFault)object.next();
                            EditableWSDLFault editableWSDLFault = editableWSDLBoundFault.getFault();
                            if (editableWSDLFault == null) {
                                LOGGER.warning(PolicyMessages.WSP_1021_FAULT_NOT_BOUND(editableWSDLBoundFault.getName()));
                                continue;
                            }
                            EditableWSDLMessage editableWSDLMessage = editableWSDLFault.getMessage();
                            QName qName2 = new QName(editableWSDLBoundOperation.getBoundPortType().getName().getNamespaceURI(), editableWSDLBoundFault.getName());
                            if (editableWSDLMessage != null && this.getHandlers4MessageMap().containsKey(editableWSDLMessage)) {
                                ((HashSet)object3).add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4MessageMap().get(editableWSDLMessage), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), new WSDLBoundFaultContainer(editableWSDLBoundFault, editableWSDLBoundOperation), BuilderHandlerMessageScope.Scope.FaultMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, qName2));
                            }
                            if (this.getHandlers4FaultMap().containsKey(editableWSDLFault)) {
                                ((HashSet)object3).add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4FaultMap().get(editableWSDLFault), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), new WSDLBoundFaultContainer(editableWSDLBoundFault, editableWSDLBoundOperation), BuilderHandlerMessageScope.Scope.FaultMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, qName2));
                            }
                            if (!this.getHandlers4BindingFaultOpMap().containsKey(editableWSDLBoundFault)) continue;
                            ((HashSet)object3).add(new BuilderHandlerMessageScope(this.getPolicyURIs(this.getHandlers4BindingFaultOpMap().get(editableWSDLBoundFault), (PolicySourceModelContext)((Object)list)), this.getPolicyModels(), new WSDLBoundFaultContainer(editableWSDLBoundFault, editableWSDLBoundOperation), BuilderHandlerMessageScope.Scope.FaultMessageScope, editableWSDLService.getName(), editableWSDLPort.getName(), qName, qName2));
                        }
                    }
                }
            }
            Iterator iterator = ((HashSet)object3).iterator();
            while (iterator.hasNext()) {
                BuilderHandlerMessageScope builderHandlerMessageScope = (BuilderHandlerMessageScope)iterator.next();
                this.getPolicyMapBuilder().registerHandler(builderHandlerMessageScope);
            }
        }
        catch (PolicyException policyException) {
            LOGGER.logSevereException(policyException);
        }
        LOGGER.exiting();
    }

    @Override
    public void postFinished(WSDLParserExtensionContext wSDLParserExtensionContext) {
        PolicyMap policyMap;
        EditableWSDLModel editableWSDLModel = wSDLParserExtensionContext.getWSDLModel();
        try {
            policyMap = wSDLParserExtensionContext.isClientSide() ? wSDLParserExtensionContext.getPolicyResolver().resolve(new PolicyResolver.ClientContext(this.policyBuilder.getPolicyMap(new PolicyMapMutator[0]), wSDLParserExtensionContext.getContainer())) : wSDLParserExtensionContext.getPolicyResolver().resolve(new PolicyResolver.ServerContext(this.policyBuilder.getPolicyMap(new PolicyMapMutator[0]), wSDLParserExtensionContext.getContainer(), null, new PolicyMapMutator[0]));
            editableWSDLModel.setPolicyMap(policyMap);
        }
        catch (PolicyException policyException) {
            LOGGER.logSevereException(policyException);
            throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1007_POLICY_EXCEPTION_WHILE_FINISHING_PARSING_WSDL(), policyException));
        }
        try {
            PolicyUtil.configureModel(editableWSDLModel, policyMap);
        }
        catch (PolicyException policyException) {
            LOGGER.logSevereException(policyException);
            throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1012_FAILED_CONFIGURE_WSDL_MODEL(), policyException));
        }
        LOGGER.exiting();
    }

    private String[] getPolicyURIsFromAttr(XMLStreamReader xMLStreamReader) {
        StringBuilder stringBuilder = new StringBuilder();
        for (NamespaceVersion namespaceVersion : NamespaceVersion.values()) {
            String string = xMLStreamReader.getAttributeValue(namespaceVersion.toString(), XmlToken.PolicyUris.toString());
            if (string == null) continue;
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString().split("[\\n ]+") : null;
    }

    static enum HandlerType {
        PolicyUri,
        AnonymousPolicyId;

    }

    static final class PolicyRecordHandler {
        String handler;
        HandlerType type;

        PolicyRecordHandler(HandlerType handlerType, String string) {
            this.type = handlerType;
            this.handler = string;
        }

        HandlerType getType() {
            return this.type;
        }

        String getHandler() {
            return this.handler;
        }
    }
}

