/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.handler.MessageContext;

public final class EndpointMessageContextImpl
extends AbstractMap<String, Object>
implements MessageContext {
    private Set<Map.Entry<String, Object>> entrySet;
    private final Packet packet;

    public EndpointMessageContextImpl(Packet packet) {
        this.packet = packet;
    }

    @Override
    public Object get(Object object) {
        if (this.packet.supports(object)) {
            return this.packet.get(object);
        }
        if (this.packet.getHandlerScopePropertyNames(true).contains(object)) {
            return null;
        }
        Object object2 = this.packet.invocationProperties.get(object);
        if (object.equals("javax.xml.ws.binding.attachments.outbound") || object.equals("javax.xml.ws.binding.attachments.inbound")) {
            HashMap<String, DataHandler> hashMap = (HashMap<String, DataHandler>)object2;
            if (hashMap == null) {
                hashMap = new HashMap<String, DataHandler>();
            }
            AttachmentSet attachmentSet = this.packet.getMessage().getAttachments();
            for (Attachment attachment : attachmentSet) {
                hashMap.put(attachment.getContentId(), attachment.asDataHandler());
            }
            return hashMap;
        }
        return object2;
    }

    @Override
    public Object put(String string, Object object) {
        if (this.packet.supports(string)) {
            return this.packet.put(string, object);
        }
        Object object2 = this.packet.invocationProperties.get(string);
        if (object2 != null) {
            if (this.packet.getHandlerScopePropertyNames(true).contains(string)) {
                throw new IllegalArgumentException("Cannot overwrite property in HANDLER scope");
            }
            this.packet.invocationProperties.put(string, object);
            return object2;
        }
        this.packet.invocationProperties.put(string, object);
        return null;
    }

    @Override
    public Object remove(Object object) {
        if (this.packet.supports(object)) {
            return this.packet.remove(object);
        }
        Object object2 = this.packet.invocationProperties.get(object);
        if (object2 != null) {
            if (this.packet.getHandlerScopePropertyNames(true).contains(object)) {
                throw new IllegalArgumentException("Cannot remove property in HANDLER scope");
            }
            this.packet.invocationProperties.remove(object);
            return object2;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public void setScope(String string, MessageContext.Scope scope) {
        throw new UnsupportedOperationException("All the properties in this context are in APPLICATION scope. Cannot do setScope().");
    }

    @Override
    public MessageContext.Scope getScope(String string) {
        throw new UnsupportedOperationException("All the properties in this context are in APPLICATION scope. Cannot do getScope().");
    }

    private Map<String, Object> createBackupMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.packet.createMapView());
        Set<String> set = this.packet.getHandlerScopePropertyNames(true);
        for (Map.Entry<String, Object> entry : this.packet.invocationProperties.entrySet()) {
            if (set.contains(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            final Iterator iterator = EndpointMessageContextImpl.this.createBackupMap().entrySet().iterator();
            return new Iterator<Map.Entry<String, Object>>(){
                Map.Entry<String, Object> cur;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    this.cur = (Map.Entry)iterator.next();
                    return this.cur;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    EndpointMessageContextImpl.this.remove(this.cur.getKey());
                }
            };
        }

        @Override
        public int size() {
            return EndpointMessageContextImpl.this.createBackupMap().size();
        }
    }
}

