/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import sun.nio.fs.BasicFileAttributesHolder;

class FileTreeWalker
implements Closeable {
    private final boolean followLinks;
    private final LinkOption[] linkOptions;
    private final int maxDepth;
    private final ArrayDeque<DirectoryNode> stack = new ArrayDeque();
    private boolean closed;

    FileTreeWalker(Collection<FileVisitOption> collection, int n) {
        LinkOption[] linkOptionArray;
        boolean bl = false;
        block3: for (FileVisitOption fileVisitOption : collection) {
            switch (fileVisitOption) {
                case FOLLOW_LINKS: {
                    bl = true;
                    continue block3;
                }
            }
            throw new AssertionError((Object)"Should not get here");
        }
        if (n < 0) {
            throw new IllegalArgumentException("'maxDepth' is negative");
        }
        this.followLinks = bl;
        if (bl) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        this.linkOptions = linkOptionArray;
        this.maxDepth = n;
    }

    private BasicFileAttributes getAttributes(Path path, boolean bl) throws IOException {
        BasicFileAttributes basicFileAttributes;
        if (bl && path instanceof BasicFileAttributesHolder && System.getSecurityManager() == null && (basicFileAttributes = ((BasicFileAttributesHolder)((Object)path)).get()) != null && (!this.followLinks || !basicFileAttributes.isSymbolicLink())) {
            return basicFileAttributes;
        }
        try {
            basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, this.linkOptions);
        }
        catch (IOException iOException) {
            if (!this.followLinks) {
                throw iOException;
            }
            basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        return basicFileAttributes;
    }

    private boolean wouldLoop(Path path, Object object) {
        for (DirectoryNode directoryNode : this.stack) {
            Object object2 = directoryNode.key();
            if (object != null && object2 != null) {
                if (!object.equals(object2)) continue;
                return true;
            }
            try {
                if (!Files.isSameFile(path, directoryNode.directory())) continue;
                return true;
            }
            catch (IOException | SecurityException exception) {
            }
        }
        return false;
    }

    private Event visit(Path path, boolean bl, boolean bl2) {
        BasicFileAttributes basicFileAttributes;
        try {
            basicFileAttributes = this.getAttributes(path, bl2);
        }
        catch (IOException iOException) {
            return new Event(EventType.ENTRY, path, iOException);
        }
        catch (SecurityException securityException) {
            if (bl) {
                return null;
            }
            throw securityException;
        }
        int n = this.stack.size();
        if (n >= this.maxDepth || !basicFileAttributes.isDirectory()) {
            return new Event(EventType.ENTRY, path, basicFileAttributes);
        }
        if (this.followLinks && this.wouldLoop(path, basicFileAttributes.fileKey())) {
            return new Event(EventType.ENTRY, path, new FileSystemLoopException(path.toString()));
        }
        DirectoryStream<Path> directoryStream = null;
        try {
            directoryStream = Files.newDirectoryStream(path);
        }
        catch (IOException iOException) {
            return new Event(EventType.ENTRY, path, iOException);
        }
        catch (SecurityException securityException) {
            if (bl) {
                return null;
            }
            throw securityException;
        }
        this.stack.push(new DirectoryNode(path, basicFileAttributes.fileKey(), directoryStream));
        return new Event(EventType.START_DIRECTORY, path, basicFileAttributes);
    }

    Event walk(Path path) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        Event event = this.visit(path, false, false);
        assert (event != null);
        return event;
    }

    Event next() {
        Path path;
        Event event;
        DirectoryNode directoryNode = this.stack.peek();
        if (directoryNode == null) {
            return null;
        }
        do {
            path = null;
            IOException iOException = null;
            if (!directoryNode.skipped()) {
                Iterator<Path> iterator = directoryNode.iterator();
                try {
                    if (iterator.hasNext()) {
                        path = iterator.next();
                    }
                }
                catch (DirectoryIteratorException directoryIteratorException) {
                    iOException = directoryIteratorException.getCause();
                }
            }
            if (path != null) continue;
            try {
                directoryNode.stream().close();
            }
            catch (IOException iOException2) {
                if (iOException != null) {
                    iOException = iOException2;
                }
                iOException.addSuppressed(iOException2);
            }
            this.stack.pop();
            return new Event(EventType.END_DIRECTORY, directoryNode.directory(), iOException);
        } while ((event = this.visit(path, true, true)) == null);
        return event;
    }

    void pop() {
        if (!this.stack.isEmpty()) {
            DirectoryNode directoryNode = this.stack.pop();
            try {
                directoryNode.stream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void skipRemainingSiblings() {
        if (!this.stack.isEmpty()) {
            this.stack.peek().skip();
        }
    }

    boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            while (!this.stack.isEmpty()) {
                this.pop();
            }
            this.closed = true;
        }
    }

    private static class DirectoryNode {
        private final Path dir;
        private final Object key;
        private final DirectoryStream<Path> stream;
        private final Iterator<Path> iterator;
        private boolean skipped;

        DirectoryNode(Path path, Object object, DirectoryStream<Path> directoryStream) {
            this.dir = path;
            this.key = object;
            this.stream = directoryStream;
            this.iterator = directoryStream.iterator();
        }

        Path directory() {
            return this.dir;
        }

        Object key() {
            return this.key;
        }

        DirectoryStream<Path> stream() {
            return this.stream;
        }

        Iterator<Path> iterator() {
            return this.iterator;
        }

        void skip() {
            this.skipped = true;
        }

        boolean skipped() {
            return this.skipped;
        }
    }

    static class Event {
        private final EventType type;
        private final Path file;
        private final BasicFileAttributes attrs;
        private final IOException ioe;

        private Event(EventType eventType, Path path, BasicFileAttributes basicFileAttributes, IOException iOException) {
            this.type = eventType;
            this.file = path;
            this.attrs = basicFileAttributes;
            this.ioe = iOException;
        }

        Event(EventType eventType, Path path, BasicFileAttributes basicFileAttributes) {
            this(eventType, path, basicFileAttributes, null);
        }

        Event(EventType eventType, Path path, IOException iOException) {
            this(eventType, path, null, iOException);
        }

        EventType type() {
            return this.type;
        }

        Path file() {
            return this.file;
        }

        BasicFileAttributes attributes() {
            return this.attrs;
        }

        IOException ioeException() {
            return this.ioe;
        }
    }

    static enum EventType {
        START_DIRECTORY,
        END_DIRECTORY,
        ENTRY;

    }
}

