/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory;
import java.io.File;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SchemaFactoryConfigurationError;
import javax.xml.validation.SecuritySupport;

class SchemaFactoryFinder {
    private static boolean debug = false;
    private static final SecuritySupport ss = new SecuritySupport();
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xerces.internal";
    private static final Properties cacheProps = new Properties();
    private static volatile boolean firstTime = true;
    private final ClassLoader classLoader;
    private static final Class<SchemaFactory> SERVICE_CLASS;

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    public SchemaFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == ss.getContextClassLoader()) {
                SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public SchemaFactory newFactory(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SchemaFactory schemaFactory = this._newFactory(string);
        if (schemaFactory != null) {
            SchemaFactoryFinder.debugPrintln("factory '" + schemaFactory.getClass().getName() + "' was found for " + string);
        } else {
            SchemaFactoryFinder.debugPrintln("unable to find a factory for " + string);
        }
        return schemaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaFactory _newFactory(String string) {
        Object object;
        block17: {
            SchemaFactory schemaFactory;
            String string2;
            String string3;
            block16: {
                string3 = SERVICE_CLASS.getName() + ":" + string;
                try {
                    SchemaFactoryFinder.debugPrintln("Looking up system property '" + string3 + "'");
                    string2 = ss.getSystemProperty(string3);
                    if (string2 != null) {
                        SchemaFactoryFinder.debugPrintln("The value is '" + string2 + "'");
                        schemaFactory = this.createInstance(string2);
                        if (schemaFactory != null) {
                            return schemaFactory;
                        }
                    } else {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable throwable) {
                    if (!debug) break block16;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + string3 + "'");
                    throwable.printStackTrace();
                }
            }
            string2 = ss.getSystemProperty("java.home");
            String string4 = string2 + File.separator + "lib" + File.separator + "jaxp.properties";
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            File file = new File(string4);
                            firstTime = false;
                            if (ss.doesFileExist(file)) {
                                SchemaFactoryFinder.debugPrintln("Read properties file " + file);
                                cacheProps.load(ss.getFileInputStream(file));
                            }
                        }
                    }
                }
                object = cacheProps.getProperty(string3);
                SchemaFactoryFinder.debugPrintln("found " + (String)object + " in $java.home/jaxp.properties");
                if (object != null && (schemaFactory = this.createInstance((String)object)) != null) {
                    return schemaFactory;
                }
            }
            catch (Exception exception) {
                if (!debug) break block17;
                exception.printStackTrace();
            }
        }
        if ((object = this.findServiceProvider(string)) != null) {
            return object;
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema validator");
            return new XMLSchemaFactory();
        }
        SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private Class<?> createClass(String string) {
        Class<?> clazz;
        boolean bl = false;
        if (System.getSecurityManager() != null && string != null && string.startsWith(DEFAULT_PACKAGE)) {
            bl = true;
        }
        try {
            clazz = this.classLoader != null && !bl ? Class.forName(string, false, this.classLoader) : Class.forName(string);
        }
        catch (Throwable throwable) {
            if (debug) {
                throwable.printStackTrace();
            }
            return null;
        }
        return clazz;
    }

    SchemaFactory createInstance(String string) {
        SchemaFactory schemaFactory = null;
        SchemaFactoryFinder.debugPrintln("createInstance(" + string + ")");
        Class<?> clazz = this.createClass(string);
        if (clazz == null) {
            SchemaFactoryFinder.debugPrintln("failed to getClass(" + string + ")");
            return null;
        }
        SchemaFactoryFinder.debugPrintln("loaded " + string + " from " + SchemaFactoryFinder.which(clazz));
        try {
            if (!SchemaFactory.class.isAssignableFrom(clazz)) {
                throw new ClassCastException(clazz.getName() + " cannot be cast to " + SchemaFactory.class);
            }
            schemaFactory = (SchemaFactory)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                classCastException.printStackTrace();
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                instantiationException.printStackTrace();
            }
            return null;
        }
        return schemaFactory;
    }

    private boolean isSchemaLanguageSupportedBy(final SchemaFactory schemaFactory, final String string, AccessControlContext accessControlContext) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return schemaFactory.isSchemaLanguageSupported(string);
            }
        }, accessControlContext);
    }

    private SchemaFactory findServiceProvider(final String string) {
        assert (string != null);
        final AccessControlContext accessControlContext = AccessController.getContext();
        try {
            return AccessController.doPrivileged(new PrivilegedAction<SchemaFactory>(){

                @Override
                public SchemaFactory run() {
                    ServiceLoader<SchemaFactory> serviceLoader = ServiceLoader.load(SERVICE_CLASS);
                    for (SchemaFactory schemaFactory : serviceLoader) {
                        if (!SchemaFactoryFinder.this.isSchemaLanguageSupportedBy(schemaFactory, string, accessControlContext)) continue;
                        return schemaFactory;
                    }
                    return null;
                }
            });
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new SchemaFactoryConfigurationError("Provider for " + SERVICE_CLASS + " cannot be created", serviceConfigurationError);
        }
    }

    private static String which(Class<?> clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String string, ClassLoader classLoader) {
        URL uRL;
        String string2 = string.replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = ss.getResourceAsURL(classLoader, string2)) != null) {
            return uRL.toString();
        }
        return null;
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {
            debug = false;
        }
        SERVICE_CLASS = SchemaFactory.class;
    }
}

