;;; menu.el --- Base major mode for menus

;; Copyright (C) 2014 Steven Rémot

;;; Author: Steven Rémot

;;; License:
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:
;;

;;; Code:
(require 'roguel-ike/mode)

(defvar rlk--menu-mode-map
    (let ((map (make-sparse-keymap)))
    (define-key map (kbd "n") 'rlk--menu-mode-next-button)
    (define-key map (kbd "p") 'rlk--menu-mode-previous-button)
    map)
    "Keymap forroguel-ike menu mode.")

(define-derived-mode rlk--menu-mode rlk--mode "roguel-ike:menu"
  "This mode defines key bindings for menu navigation."
  (setq buffer-read-only t)
  (goto-char (point-min))
  (forward-button 1))

(defun rlk--menu-mode-next-button ()
  "Move to the next button in the buffer."
  (interactive)
  (forward-button 1))

(defun rlk--menu-mode-previous-button ()
  "Move to the previous button in the buffer."
  (interactive)
  (backward-button 1))

(provide 'roguel-ike/mode/menu)

;;; menu.el ends here
