;;; speechd-el.el --- info file for package managers  -*- lexical-binding: t -*-

;; Copyright (C) 2021-2022 Milan Zamazal

;; Author: Milan Zamazal <pdm@zamazal.org>
;; Package-Version: 20250118.1141
;; Package-Revision: 0e509d392c7f
;; URL: https://github.com/brailcom/speechd-el

;; COPYRIGHT NOTICE
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:
;;
;; speechd-el is an Emacs client to speech synthesizers, Braille
;; displays and other alternative output interfaces.  It provides full
;; speech and Braille output environment for Emacs.

;; It is aimed primarily at visually impaired users who need
;; non-visual communication with Emacs, but it can be used by anybody
;; who needs sophisticated speech or other kind of alternative output
;; from Emacs.  speechd-el can make Emacs a completely speech and
;; BRLTTY enabled application suitable for visually impaired users or,
;; depending on its configuration, it can only speak in certain
;; situations or when asked, to serve needs of any Emacs user.

;;; Code:

(provide 'speechd-el)

;;; speechd-el.el ends here
