;;; white-theme.el --- Minimalistic light color theme inspired by basic-theme

;; Copyright (c) 2014-2016 A. Hdez

;; Author: A. Hdez <trefoil_chilled_7k@icloud.com>
;; Keywords: color, theme, minimal, basic, simple, white
;; URL: http://github.com/nullvec/white-theme.el
;; Package-Version: 20250921.2105
;; Package-Revision: 7c42cb08425a
;; Package-Requires: ((emacs "24"))

;; This file is not part of GNU Emacs.

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;; The theme attempts to reduce the usage of colors to a minimum based on my
;; personal preferences.  It's not fully monochrome, for example diffs, active
;; regions, comments and keywords are distinguished via colors.

;; More information: http://github.com/nullvec/white-theme.el

;; Theme setup is based on basic-theme.el available at:
;; https://github.com/fgeller/basic-theme.el

(deftheme white "Minimalistic light color theme inspired by basic-theme.")

(defvar white-theme-colors-alist
  '(("black" . "#181818")
    ("gray1" . "#282828")
    ("gray2" . "#383838")
    ("gray3" . "#585858")
    ("gray4" . "#b8b8b8")
    ("gray5" . "#d8d8d8")
    ("gray6" . "#e8e8e8")
    ("gray7" . "#f8f8f8")
    ("white" . "#ffffff")
    ("red" . "#ab4642")
    ("orange" . "#dc9656")
    ("yellow" . "#f7ca88")
    ("green" . "#a1b56c")
    ("turquoise" . "#86c1b9")
    ("blue" . "#7cafc2")
    ("purple" . "#8331b7")
    ("brown" . "#a16046"))
  "List of base16 colors.")

(defmacro white-theme-with-color-variables (&rest body)
  (declare (indent 0))
  `(let ((class '((class color) (min-colors 89)))
         ,@(mapcar (lambda (cons)
                     (list (intern (car cons)) (cdr cons)))
                   white-theme-colors-alist))
     ,@body))

;;; Theme Faces
(white-theme-with-color-variables
  (custom-theme-set-faces
   'white
   `(button ((t (:foreground ,blue :underline nil :weight normal))))
   `(comint-highlight-input ((t (:foreground nil :background nil))))
   `(comint-highlight-prompt ((t (:foreground nil :background nil))))
   `(compilation-error ((t (:foreground ,white :background ,red))))
   `(compilation-info ((t (:foreground nil :background nil :weight bold))))
   `(compilation-column-number ((t (:foreground ,red :background nil :weight bold))))
   `(compilation-line-number ((t (:foreground ,red :background nil :weight bold))))
   `(compilation-mode-line-exit ((t (:inherit mode-line))))
   `(compilation-mode-line-fail ((t (:inherit mode-line))))
   `(compilation-mode-line-run ((t (:inherit mode-line))))
   `(compilation-warning ((t (:foreground ,white :background ,yellow))))
   `(cursor ((t (:foreground nil :background ,red))))
   `(default ((t (:foreground ,black :background ,white))))
   `(fringe ((t (:foreground ,gray6 :background ,white))))
   `(header-line ((t (:inherit mode-line))))
   `(hi-yellow ((t (:foreground ,red :background ,nil))))
   `(isearch ((t (:foreground nil :background ,gray6))))
   `(isearch-fail ((t (:foreground nil :background ,orange))))
   `(italic ((t (:foreground nil :background nil :underline nil))))
   `(lazy-highlight ((t (:foreground nil :background ,gray6))))
   `(link ((t (:foreground nil :background nil :underline nil))))
   `(link-visited ((t (:foreground nil :background nil :underline nil))))
   `(linum  ((t (:foreground ,gray5 :background ,white))))
   `(match ((t (:foreground nil :background ,gray6))))
   `(minibuffer-prompt ((t (:foreground ,red :background nil))))
   `(mode-line ((t (:foreground ,white :background ,red :box nil))))
   `(mode-line-buffer-id ((t (:weight bold :foreground ,white))))
   `(mode-line-inactive-buffer-id ((t (:weight bold :foreground ,red))))
   `(mode-line-inactive ((t (:foreground ,purple :background ,purple :box nil))))
   `(region ((t (:foreground nil :background ,green))))
   `(secondary-selection ((t (:foreground nil :background ,gray6))))
   `(trailing-whitespace ((t (:foreground nil :background ,red))))
   `(underline ((t (:foreground nil :background nil :underline nil))))

   `(ace-jump-face-background ((t (:foreground ,gray4 :background nil))))
   `(ace-jump-face-foreground ((t (:foreground ,red :background nil))))

   `(anzu-mode-line ((t (:inherit mode-line))))
   `(anzu-replace-highlight ((t (:foreground nil :background ,gray6))))
   `(anzu-replace-to ((t (:foreground ,red :background ,gray6))))

   `(avy-lead-face-0 ((t (:foreground ,red :background nil))))
   `(avy-lead-face-1 ((t (:foreground ,red :background nil))))
   `(avy-lead-face-2 ((t (:foreground ,red :background nil))))
   `(avy-lead-face ((t (:foreground ,red :background nil))))
   `(avy-background-face ((t (:foreground ,gray4))))

   `(custom-face-tag ((t (:foreground nil :background nil))))
   `(custom-visibility ((t (:foreground ,blue :background nil))))
   `(custom-link ((t (:foreground ,blue :background nil))))

   `(diff-added ((t (:foreground ,green :background nil))))
   `(diff-removed ((t (:foreground ,red :background nil))))
   `(diff-context ((t (:foreground ,black :background nil))))
   `(diff-refine-added ((t :inherit diff-added :foreground nil :weight bold)))
   `(diff-refine-change ((t :inherit diff-changed :foreground nil :weight bold)))
   `(diff-refine-removed ((t :inherit diff-removed :foreground nil :weight bold)))
   `(diff-header ((t (:foreground ,black :background nil))))
   `(diff-file-header ((t (:foreground ,black :background nil))))
   `(diff-hunk-header ((t (:foreground ,black :background nil))))

   `(eldoc-highlight-function-argument ((t (:weight normal :foreground ,red :background nil))))

   `(erc-action-face ((t (:foreground ,black :background nil))))
   `(erc-bold-face ((t (:foreground ,black :background nil))))
   `(erc-button ((t (:foreground ,black :background nil))))
   `(erc-command-indicator-face ((t (:foreground ,black :background nil))))
   `(erc-current-nick-face ((t (:foreground ,black :background nil))))
   `(erc-dangerous-host-face ((t (:foreground ,black :background nil))))
   `(erc-default-face ((t (:foreground ,black :background nil))))
   `(erc-direct-msg-face ((t (:foreground ,black :background nil))))
   `(erc-error-face ((t (:foreground ,black :background nil))))
   `(erc-fool-face ((t (:foreground ,black :background nil))))
   `(erc-header-line ((t (:foreground ,black :background nil))))
   `(erc-input-face ((t (:foreground ,black :background nil))))
   `(erc-inverse-face ((t (:foreground ,black :background nil))))
   `(erc-keyword-face ((t (:foreground ,black :background nil))))
   `(erc-my-nick-face ((t (:foreground ,black :background nil))))
   `(erc-nick-default-face ((t (:foreground ,black :background nil))))
   `(erc-nick-msg-face ((t (:foreground ,black :background nil))))
   `(erc-notice-face ((t (:foreground ,black :background nil))))
   `(erc-pal-face ((t (:foreground ,black :background nil))))
   `(erc-prompt-face ((t (:foreground ,black :background nil))))
   `(erc-timestamp-face ((t (:foreground ,black :background nil))))
   `(erc-underline-face ((t (:foreground ,black :background nil))))

   `(eshell-prompt ((t (:foreground ,gray4 :background nil :weight normal))))
   `(eshell-ls-directory ((t (:foreground nil :background nil :weight normal))))
   `(eshell-ls-executable ((t (:foreground nil :background nil :weight normal))))

   `(font-lock-builtin-face ((t :foreground nil :background nil :weight bold)))
   `(font-lock-comment-delimiter-face ((t :foreground ,gray4 :background ,gray7 :slant italic)))
   `(font-lock-comment-face ((t :foreground ,gray4 :background ,gray7 :slant italic)))
   `(font-lock-preprocessor-face ((t :foreground nil :background nil :slant italic)))
   `(font-lock-constant-face ((t :foreground nil :background nil :weight bold :slant italic)))
   `(font-lock-doc-face ((t :foreground nil :background ,gray7 :slant italic)))
   `(font-lock-function-name-face ((t :foreground nil :background nil :weight bold)))
   `(font-lock-keyword-face ((t :foreground ,gray3 :background nil)))
   `(font-lock-negation-char-face ((t :foreground nil :background nil)))
   `(font-lock-regexp-grouping-backslash ((t :foreground nil :background nil)))
   `(font-lock-regexp-grouping-construct ((t :foreground nil :background nil)))
   `(font-lock-string-face ((t :foreground nil :background ,gray7 :slant italic)))
   `(font-lock-type-face ((t :foreground nil :background nil :weight bold)))
   `(font-lock-variable-name-face ((t :foreground nil :background ,gray7)))
   `(font-lock-warning-face ((t :foreground nil :background ,orange)))

   `(helm-action ((t (:foreground ,black :background nil :underline nil))))
   `(helm-candidate-number ((t (:foreground ,gray6 :background ,gray6))))
   `(helm-header ((t (:inherit mode-line))))
   `(helm-selection ((t (:foreground ,black :background ,gray6 :underline nil))))
   `(helm-source-header ((t (:inherit default :foreground ,black :background nil :underline nil :weight normal :family ,(face-attribute 'default :family) :height ,(face-attribute 'default :height)))))
   `(helm-buffer-file ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-buffer-directory ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-buffer-process ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-buffer-size ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-buffer-not-saved ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-ff-directory ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-ff-executable ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-ff-file ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-ff-invalid-symlink ((t (:foreground ,black :background ,red :underline nil :italic nil))))
   `(helm-ff-prefix ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-ff-symlink ((t (:foreground ,black :background nil :underline nil :italic nil))))
   `(helm-history-remote ((t (:foreground ,black :background ,orange :underline nil :italic nil))))
   `(helm-history-deleted ((t (:foreground ,black :background ,red :underline nil :italic nil))))
   `(helm-visible-mark ((t (:foreground ,black :background ,yellow :underline nil :italic nil))))
   `(helm-separator ((t (:foreground ,gray6 :background nil :underline nil :italic nil))))
   `(helm-prefarg ((t (:foreground ,red :background nil :underline nil :italic nil))))
   `(helm-M-x-key ((t (:foreground ,blue :background nil :underline nil :italic nil))))

   ;; js2-mode
   `(js2-error ((t (:foreground ,orange background nil))))
   `(js2-external-variable ((t (:foreground nil background nil))))
   `(js2-function-call ((t (:foreground nil background nil))))
   `(js2-function-param ((t (:foreground nil background nil))))
   `(js2-instance-member ((t (:foreground nil background nil))))
   `(js2-jsdoc-html-tag-delimiter ((t (:foreground nil background nil))))
   `(js2-jsdoc-html-tag-name ((t (:foreground nil background nil))))
   `(js2-jsdoc-tag ((t (:foreground nil background nil))))
   `(js2-jsdoc-type ((t (:foreground nil background nil))))
   `(js2-jsdoc-value ((t (:foreground nil background nil))))
   `(js2-private-function-call ((t (:foreground nil background nil))))
   `(js2-private-member ((t (:foreground nil background nil))))
   `(js2-warning ((t (:foreground ,orange background nil))))

   ;; magit-next
   `(magit-bisect-bad ((t (:foreground nil :background nil))))
   `(magit-bisect-good ((t (:foreground nil :background nil))))
   `(magit-bisect-skip ((t (:foreground nil :background nil))))
   `(magit-blame-date ((t (:foreground nil :background nil))))
   `(magit-blame-hash ((t (:foreground nil :background nil))))
   `(magit-blame-heading ((t (:foreground nil :background nil))))
   `(magit-blame-name ((t (:foreground nil :background nil))))
   `(magit-blame-summary ((t (:foreground nil :background nil))))
   `(magit-branch-current ((t (:foreground nil :background nil))))
   `(magit-branch-local ((t (:foreground nil :background nil))))
   `(magit-branch-remote ((t (:foreground nil :background nil))))
   `(magit-cherry-equivalent ((t (:foreground nil :background nil))))
   `(magit-cherry-unmatched ((t (:foreground nil :background nil))))
   `(magit-diff-added ((t (:foreground ,green :background nil))))
   `(magit-diff-added-highlight ((t (:foreground ,green :background ,gray6))))
   `(magit-diff-conflict-heading ((t (:foreground nil :background nil))))
   `(magit-diff-context ((t (:foreground nil :background nil))))
   `(magit-diff-context-highlight ((t (:foreground nil :background nil))))
   `(magit-diff-file-heading ((t (:foreground nil :background nil))))
   `(magit-diff-file-heading-highlight ((t (:foreground nil :background nil))))
   `(magit-diff-file-heading-selection ((t (:foreground nil :background nil))))
   `(magit-diff-hunk-heading ((t (:foreground nil :background nil))))
   `(magit-diff-hunk-heading-highlight ((t (:foreground nil :background nil))))
   `(magit-diff-hunk-heading-selection ((t (:foreground nil :background nil))))
   `(magit-diff-lines-boundary ((t (:foreground nil :background nil))))
   `(magit-diff-lines-heading ((t (:foreground nil :background nil))))
   `(magit-diff-removed ((t (:foreground ,red :background nil))))
   `(magit-diff-removed-highlight ((t (:foreground ,red :background ,gray6))))
   `(magit-diff-whitespace-warning ((t (:foreground nil :background ,red))))
   `(magit-diffstat-added ((t (:foreground nil :background nil))))
   `(magit-diffstat-removed ((t (:foreground nil :background nil))))
   `(magit-dimmed ((t (:foreground nil :background nil))))
   `(magit-filename ((t (:foreground nil :background nil))))
   `(magit-hash ((t (:foreground nil :background nil))))
   `(magit-head ((t (:foreground nil :background nil))))
   `(magit-log-author ((t (:foreground nil :background nil))))
   `(magit-log-date ((t (:foreground nil :background nil))))
   `(magit-log-graph ((t (:foreground nil :background nil))))
   `(magit-popup-argument ((t (:foreground nil :background nil :weight bold))))
   `(magit-popup-disabled-argument ((t (:foreground nil :background nil))))
   `(magit-popup-header ((t (:foreground nil :background nil))))
   `(magit-popup-key ((t (:foreground nil :background nil))))
   `(magit-popup-option-value ((t (:foreground nil :background nil))))
   `(magit-process-ng ((t (:foreground nil :background ,orange))))
   `(magit-process-ok ((t (:foreground nil :background nil))))
   `(magit-reflog-amend ((t (:foreground nil :background nil))))
   `(magit-reflog-checkout ((t (:foreground nil :background nil))))
   `(magit-reflog-cherry-pick ((t (:foreground nil :background nil))))
   `(magit-reflog-commit ((t (:foreground nil :background nil))))
   `(magit-reflog-merge ((t (:foreground nil :background nil))))
   `(magit-reflog-other ((t (:foreground nil :background nil))))
   `(magit-reflog-rebase ((t (:foreground nil :background nil))))
   `(magit-reflog-remote ((t (:foreground nil :background nil))))
   `(magit-reflog-reset ((t (:foreground nil :background nil))))
   `(magit-refname ((t (:foreground nil :background nil))))
   `(magit-refname-stash ((t (:foreground nil :background nil))))
   `(magit-refname-wip ((t (:foreground nil :background nil))))
   `(magit-section-heading ((t (:foreground nil :background nil))))
   `(magit-section-highlight ((t (:foreground nil :background nil))))
   `(magit-sequence-done ((t (:foreground nil :background nil))))
   `(magit-sequence-drop ((t (:foreground nil :background nil))))
   `(magit-sequence-head ((t (:foreground nil :background nil))))
   `(magit-sequence-onto ((t (:foreground nil :background nil))))
   `(magit-sequence-part ((t (:foreground nil :background nil))))
   `(magit-sequence-pick ((t (:foreground nil :background nil))))
   `(magit-sequence-stop ((t (:foreground nil :background nil))))
   `(magit-signature-bad ((t (:foreground nil :background nil))))
   `(magit-signature-good ((t (:foreground nil :background nil))))
   `(magit-signature-untrusted ((t (:foreground nil :background nil))))
   `(magit-tag ((t (:foreground nil :background nil))))

   ;; "old" magit
   `(magit-section-title ((t (:inherit default))))
   `(magit-item-highlight ((t (:foreground nil :background nil))))
   `(magit-process-ok ((t (:foreground nil :background nil))))
   `(magit-process-ng ((t (:foreground nil :background ,orange))))
   `(magit-branch ((t (:foreground nil :background nil))))
   `(magit-log-sha1 ((t (:foreground ,black :background nil))))
   `(magit-log-author ((t (:foreground ,black :background nil))))
   `(magit-log-head-label-head ((t (:foreground ,black :background nil))))
   `(magit-log-head-label-local ((t (:foreground ,black :background nil))))
   `(magit-log-head-label-default ((t (:foreground ,black :background nil))))
   `(magit-log-head-label-remote ((t (:foreground ,black :background nil))))
   `(magit-log-head-label-tags ((t (:foreground ,black :background nil))))
   `(magit-key-mode-button-face ((t (:foreground ,black :background nil))))
   `(magit-key-mode-header-face ((t (:foreground ,black :background nil))))
   `(magit-key-mode-switch-face ((t (:foreground ,green :background nil))))
   `(magit-diff-merge-current ((t (:foreground ,black :background nil))))
   `(magit-tag ((t (:foreground ,black :background nil))))

   `(message-cited-text ((t (:foreground ,black :background nil :weight normal))))
   `(message-header-cc ((t (:foreground ,black :background nil :weight normal))))
   `(message-header-name ((t (:foreground ,black :background nil :weight normal))))
   `(message-header-newsgroups ((t (:foreground ,black :background nil :weight normal))))
   `(message-header-other ((t (:foreground ,black :background nil :weight normal))))
   `(message-header-subject ((t (:foreground ,black :background nil :weight normal))))
   `(message-header-to ((t (:foreground ,black :background nil :weight normal))))
   `(message-header-xheader ((t (:foreground ,black :background nil :weight normal))))
   `(message-mml ((t (:foreground ,black :background nil :weight normal))))
   `(message-separator ((t (:foreground ,black :background nil :weight normal))))

   `(notmuch-crypto-decryption ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-crypto-part-header ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-crypto-signature-bad ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-crypto-signature-good ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-crypto-signature-good-key ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-crypto-signature-unknown ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-hello-logo-background ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-message-summary-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-search-count ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-search-date ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-search-matching-authors ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-search-non-matching-authors ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-search-subject ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tag-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-match-author-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-match-date-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-match-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-match-subject-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-match-tag-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-match-tree-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-no-match-author-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-no-match-date-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-no-match-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-no-match-subject-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-no-match-tag-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-tree-no-match-tree-face ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-wash-cited-text ((t (:foreground ,black :background nil :weight normal))))
   `(notmuch-wash-toggle-button ((t (:foreground ,black :background nil :weight normal))))

   `(org-agenda-calendar-event ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-calendar-sexp ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-clocking ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-column-dateline ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-current-time ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-date ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-date-today ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-date-weekend ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-diary ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-dimmed-todo-face ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-done ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-filter-category ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-filter-regexp ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-filter-tags ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-restriction-lock ((t (:foreground ,black :background nil :weight normal))))
   `(org-agenda-structure ((t (:foreground ,black :background nil :weight normal))))
   `(org-archived ((t (:foreground ,black :background nil :weight normal))))
   `(org-block ((t (:foreground ,black :background nil :weight normal))))
   `(org-block-background ((t (:foreground ,black :background nil :weight normal))))
   `(org-block-begin-line ((t (:foreground ,black :background nil :weight normal))))
   `(org-block-end-line ((t (:foreground ,black :background nil :weight normal))))
   `(org-checkbox ((t (:foreground ,black :background nil :weight normal))))
   `(org-checkbox-statistics-done ((t (:foreground ,black :background nil :weight normal))))
   `(org-checkbox-statistics-todo ((t (:foreground ,black :background nil :weight normal))))
   `(org-clock-overlay ((t (:foreground ,black :background nil :weight normal))))
   `(org-code ((t (:foreground ,black :background nil :weight normal))))
   `(org-column ((t (:foreground ,black :background nil :weight normal))))
   `(org-column-title ((t (:foreground ,black :background nil :weight normal))))
   `(org-date ((t (:foreground ,black :background nil :weight normal))))
   `(org-date-selected ((t (:foreground ,black :background nil :weight normal))))
   `(org-default ((t (:foreground ,black :background nil :weight normal))))
   `(org-document-info ((t (:foreground ,black :background nil :weight normal))))
   `(org-document-info-keyword ((t (:foreground ,black :background nil :weight normal))))
   `(org-document-title ((t (:foreground ,black :background nil :weight normal))))
   `(org-done ((t (:foreground ,black :background nil :weight normal))))
   `(org-drawer ((t (:foreground ,black :background nil :weight normal))))
   `(org-ellipsis ((t (:foreground ,black :background nil :weight normal))))
   `(org-footnote ((t (:foreground ,black :background nil :weight normal))))
   `(org-formula ((t (:foreground ,black :background nil :weight normal))))
   `(org-headline-done ((t (:foreground ,black :background nil :weight normal))))
   `(org-hide ((t (:foreground ,black :background nil :weight normal))))
   `(org-latex-and-related ((t (:foreground ,black :background nil :weight normal))))
   `(org-level-1 ((t (:foreground ,black :background nil :weight normal))))
   `(org-level-2 ((t (:foreground ,black :background nil :weight normal))))
   `(org-level-3 ((t (:foreground ,black :background nil :weight normal))))
   `(org-level-4 ((t (:foreground ,black :background nil :weight normal))))
   `(org-level-5 ((t (:foreground ,black :background nil :weight normal))))
   `(org-level-6 ((t (:foreground ,black :background nil :weight normal))))
   `(org-level-7 ((t (:foreground ,black :background nil :weight normal))))
   `(org-level-8 ((t (:foreground ,black :background nil :weight normal))))
   `(org-link ((t (:foreground ,black :background nil :underline t :weight normal))))
   `(org-list-dt ((t (:foreground ,black :background nil :weight normal))))
   `(org-macro ((t (:foreground ,black :background nil :weight normal))))
   `(org-meta-line ((t (:foreground ,black :background nil :weight normal))))
   `(org-mode-line-clock ((t (:inherit modeline))))
   `(org-mode-line-clock-overrun ((t (:inherit modeline))))
   `(org-priority ((t (:foreground ,black :background nil :weight normal))))
   `(org-property-value ((t (:foreground ,black :background nil :weight normal))))
   `(org-quote ((t (:foreground ,black :background nil :weight normal))))
   `(org-scheduled ((t (:foreground ,black :background nil :weight normal))))
   `(org-scheduled-previously ((t (:foreground ,black :background nil :weight normal))))
   `(org-scheduled-today ((t (:foreground ,black :background nil :weight normal))))
   `(org-sexp-date ((t (:foreground ,black :background nil :weight normal))))
   `(org-special-keyword ((t (:foreground ,black :background nil :weight normal))))
   `(org-table ((t (:foreground ,black :background nil :weight normal))))
   `(org-tag ((t (:foreground ,black :background nil :weight normal))))
   `(org-tag-group ((t (:foreground ,black :background nil :weight normal))))
   `(org-target ((t (:foreground ,black :background nil :weight normal))))
   `(org-time-grid ((t (:foreground ,black :background nil :weight normal))))
   `(org-todo ((t (:foreground ,black :background nil :weight normal))))
   `(org-upcoming-deadline ((t (:foreground ,black :background nil :weight normal))))
   `(org-verbatim ((t (:foreground ,black :background nil :weight normal))))
   `(org-verse ((t (:foreground ,black :background nil :weight normal))))
   `(org-warning ((t (:foreground ,black :background nil :weight normal))))

   `(rng-error ((t (:foreground nil :background ,orange))))

   `(show-paren-match ((t (:foreground nil :background ,green))))
   `(show-paren-mismatch ((t (:foreground nil :background ,orange))))

   `(shr-link ((t (:foreground ,blue :background nil :weight normal :underline nil))))
   `(shr-strike-through ((t (:foreground nil :background nil :weight normal :strike-through t))))

   `(wgrep-face ((t (:foreground ,green :background nil))))
   `(wgrep-done-face ((t (:foreground ,black :background nil))))

   `(racket-keyword-argument-face ((t (:inherit font-lock-constant-face))))
   `(racket-selfeval-face ((t (:inherit font-lock-type-face))))
   ))

(white-theme-with-color-variables
  (custom-theme-set-variables
   'white
   `(ansi-color-names-vector [
                              (,black . ,gray1)
                              (,red . ,orange)
                              (,green . ,gray2)
                              (,yellow . ,gray2)
                              (,blue . ,gray3)
                              (,red . ,gray4)
                              (,turquoise . ,gray5)
                              (,white . ,white)
                              ])
   `(vc-annotate-very-old-color ,gray3)
   `(vc-annotate-background ,white)
   `(vc-annotate-color-map
     '((20 . ,red)
       (50 . ,orange)
       (80 . ,yellow)
       (110 . ,green)
       (140 . ,turquoise)
       (170 . ,blue)
       (200 . ,red)
       (230 . ,brown)
       (260 . ,black)
       (290 . ,gray1)
       (320 . ,gray2)
       (350 . ,gray3)))
   ))

;;;###autoload
(and load-file-name
     (boundp 'custom-theme-load-path)
     (add-to-list 'custom-theme-load-path
                  (file-name-as-directory
                   (file-name-directory load-file-name))))

(provide-theme 'white)

;; Local Variables:
;; no-byte-compile: t
;; indent-tabs-mode: nil
;; End:
;;; white-theme.el ends here
