<?php
/* * * * * * * * * * * * * * * * * * * * * * *
 * _     _ _  _   _                          *
 * \ \  ///                [ 2 0 0 6 ]       *
 *  \ \///  i s h i o u s . d e              *
 *   \///                                    *
 * * * * * * * * ` W H A T  * * * * * * * * *
 *   \// I N C E  subversion: Custom         *
 * * * * * * * * ` D A T A  * * * * * * * * *
 *  For: q4max                               *
 *  Sub: q4maxXML_class.php                  *
 *  Chg: 20.02.2006                          *
 * * * * * * * * * * * * * * * * * * * * * * */
 
 
class XMLstats {
	// basic
	var $configuration;	// config.ini
	var $XMLfiles;		// arrayed
	var $XMLparsed;		// arrayed
	var $statfolders;	// arrayed
	var $XMLfilecount;
	var $classversion;
	var $wasiparsed;	// BOOL
	var $prevparsed;	// arrayed
	
	// stat-related
	var $outputtype;
	var $statfiles;		// arrayed
	var $players; 		// subclassed
	var $clans;			// arrayed
	var $maps;			// arrayed
	var $gametypes;		// arrayed
	var $matchesplayed;
	var $topplayers;	// arrayed
	var $topclans;		// arrayed
	var $cmatcheswon;	// arrayed (hack - internal array for clan win/loss)
	
	function XMLstats () {
		// constructor
		// parse config file
		$this->XMLfiles = array();
		$this->Parse_Configuration();
		
		// set basic datatypes (cosmetic)
		$this->players 					= array();
		$this->players["playerlist"] 	= array();
		$this->clans					= array();
		$this->clans["clanlist"]		= array();
		$this->XMLfiles 				= array();
		$this->XMLparsed 				= array();
		$this->statfolders 				= array();
		$this->statfiles 				= array();
		$this->maps						= array();
		$this->gametypes 				= array();
		$this->prevparsed				= array();
		$this->topplayers				= array();
		$this->topclans					= array();
		$this->cmatcheswon				= array();
		$this->cmatcheswon["won"]		= array();
		$this->cmatcheswon["lost"]		= array();
		$this->XMLfilecount				= 0;
	}
	
	function Parse_Configuration() {
		$this->configuration = @parse_ini_file("config.ini", TRUE);
		if (!is_array($this->configuration)) {
			return FALSE;
			die("Configuration-File not found!");
		}
		return TRUE;
	}
	
	function Parse_Stats() {
		$this->Get_Stat_Dumps();
		$this->Get_Stat_Files();
		$this->Parse_Info_From_Files();
		$this->Parse_Info_Into_Players();
		$this->Calculate_Player_Stats();
		$this->Calculate_Clan_Stats();
		$this->Get_Top_Players();
		$this->Get_Top_Clans();
		$this->Get_Top_Players_Clans();
		$this->Write_Stat_Dumps();
	}
	
	function Get_Stat_Dumps() {
		if ($this->configuration["GENERAL"]["dump_stats"] != 1 || !is_file("parsed.ini")) return TRUE;
		// get parsed.ini contents
		$parsed = new iniParser("parsed.ini");
		$prevparsed = $parsed->getSection("PREVPARSED");
		$expparsed = array();
		if (is_array($prevparsed)) {
			foreach ($prevparsed as $key => $parsefileinfo) {
				$tmpparsed = explode("/", $parsefileinfo);
				$expparsed[$key]["filename"] = $tmpparsed[count($tmpparsed)-1];
				$expparsed[$key]["pathname"] = $parsefileinfo;
			}
		}
		$this->prevparsed = $expparsed;
		
		// get playerdata and reparse
		$playerdata = $parsed->_iniParsedArray;
		unset($playerdata["PREVPARSED"]);
		
		// initialize players using dump function
		foreach ($playerdata as $player) {
			$newindex = count($this->players["playerlist"]);
			$this->players["playerlist"][$newindex] = $player["guid"];
			$this->players[$newindex] = new player($player, $this->configuration, TRUE);
			// clanstats hack
			if (!isset($this->cmatcheswon["won"][$this->players[$newindex]->clan]) && !empty($player["cmatches_won"])) $this->cmatcheswon["won"][$this->players[$newindex]->clan] = $player["cmatches_won"];
			if (!isset($this->cmatcheswon["lost"][$this->players[$newindex]->clan]) && !empty($player["cmatches_lost"])) $this->cmatcheswon["lost"][$this->players[$newindex]->clan] = $player["cmatches_lost"];
		}
	}
	
	function Write_Stat_Dumps() {
		// if we had new XML files, write stat-dump
		if ($this->XMLfilecount > 0) {
			// set PREVPARSED ini settings
			$parsed = new iniParser("parsed.ini");
			$packarray = array();
			if ($this->XMLfilecount >0) {
				foreach ($this->XMLparsed as $folderstr => $data) {
					$packarray[$folderstr] = $data;
				}
			}
			else {
				foreach ($this->prevparsed as $folderstr => $data) {
					$packarray[$folderstr] = $data["pathname"];
				}
			}
			$parsed->setSection("PREVPARSED", $packarray);
			
			// dump players using dump function
			foreach ($this->players as $key => $player) {
				if (is_numeric($key)) {
					$playersettings = get_object_vars($player);
					foreach ($playersettings as $settingname => $playersetting) {
						if (is_array($playersetting)) {
							if (count($playersetting) >1) $playersettings[$settingname] = $player->serialize_arraydata($playersetting);
							else unset($playersettings[$settingname]);
						}
					}
					// clanstats hack
					if (!empty($this->cmatcheswon["won"][$playersettings["clan"]])) $playersettings["cmatches_won"] = $this->cmatcheswon["won"][$playersettings["clan"]];
					if (!empty($this->cmatcheswon["lost"][$playersettings["clan"]])) $playersettings["cmatches_lost"] = $this->cmatcheswon["lost"][$playersettings["clan"]];
					$parsed->setSection($player->guid, $playersettings);
				}
			}
			$parsed->save();
		}
	}
	
	function Get_Stat_Files() {
		// partly UNOPTIMIZED
		// arrays are indexed with config.ini statfoldernames
		// get basic dirlisting of stats-root
		foreach ($this->configuration["STATFOLDERS"] as $foldervar => $statfolder) {
			// fill up statfolders array
			$this->statfolders[$foldervar] = $statfolder;
			$dirlist_years[$foldervar] = $this->dirlist($statfolder);
			// get subdirlisting of yearsfolder
			$dirlist_months = array();
			foreach ($dirlist_years[$foldervar] as $yearfolder) {
				// dirlist_years[__foldername__][__yearname__]
				$dirlist_months[$foldervar][$yearfolder] = $this->dirlist("{$this->statfolders[$foldervar]}/{$yearfolder}");
			}
			// get subdirlisting of monthsfolder
			$dirlist_days = array();
			$complete_dirlist = array();
			
			// break folderstring of last parse open for skipping specific old date folders
			$subfolderstr = str_replace($this->configuration["STATFOLDERS"][$foldervar], "", $this->prevparsed[$foldervar]["pathname"]);
			if (!empty($subfolderstr)) {
				$subfolders = explode("/", $subfolderstr);
				$lastyear = $subfolders[1];
				$lastmonth = $subfolders[2];
				$lastday = $subfolders[3];
				$lastfile = $subfolders[4];
			}
			else {
				$lastyear = 0;
				$lastmonth = 0;
				$lastday = 0;
				$lastfile = NULL;
			}
			
			foreach ($dirlist_months[$foldervar] as $yearname => $monthfolders) {
				// dirlist_months[__foldername__][__yearname__][index] = __monthname__
				// if year has been processed, skip
				if ($yearname >= $lastyear) {
					foreach ($monthfolders as $monthname) {
						// if month has been processed, skip
						if ($monthname >= $lastmonth) {
							$dirlist_days[$foldervar][$yearname][$monthname] = $this->dirlist("{$this->statfolders[$foldervar]}/{$yearname}/{$monthname}");
							// if month has been processed, skip
							foreach ($dirlist_days[$foldervar][$yearname][$monthname] as $dayname) {
								if ($dayname >= $lastday) {
									// get subdir listing of daysfolders
									// dirlist_days[__foldername__][__yearname__][__monthname__][index] = __dayname__
									$complete_dirlist[$foldervar][$yearname][$monthfolder][$dayname] = $this->dirlist("{$this->statfolders[$foldervar]}/{$yearfolder}/{$monthname}/{$dayname}");
									$foundlast = FALSE;
									// fill up local XMLfiles array
									foreach ($complete_dirlist[$foldervar][$yearname][$monthfolder][$dayname] as $xmlfilename) {
										//var_dump($lastfile);
										if ($this->configuration["GENERAL"]["dump_stats"] == 1 && !empty($lastfile)) {
											// skip "old" statfiles for parsing
											if ($xmlfilename == $lastfile) $foundlast = TRUE;
											// found last parsed file, parse rest
											elseif ($dayname > $lastday || $foundlast == TRUE) {
												$curindex = count($this->XMLfiles[$foldervar]);
												$this->XMLfilecount++;
												$this->XMLfiles[$foldervar][$curindex]["filename"] = $xmlfilename;
												$this->XMLfiles[$foldervar][$curindex]["pathname"] = "{$this->statfolders[$foldervar]}/{$yearfolder}/{$monthname}/{$dayname}/{$xmlfilename}";
											}
										}
										else {
											$curindex = count($this->XMLfiles[$foldervar]);
											$this->XMLfilecount++;
											$this->XMLfiles[$foldervar][$curindex]["filename"] = $xmlfilename;
											$this->XMLfiles[$foldervar][$curindex]["pathname"] = "{$this->statfolders[$foldervar]}/{$yearfolder}/{$monthname}/{$dayname}/{$xmlfilename}";
										}
									}
								}
							}
						}
					}
				}
			}
			// got XML listing
			// set last parsed file
			$this->XMLparsed[$foldervar] = $this->XMLfiles[$foldervar][count($this->XMLfiles[$foldervar])-1];
			$this->XMLparsed[$foldervar] = $this->XMLparsed[$foldervar]["pathname"];
		}	
	}
	
	function Parse_Info_From_Files() {
		if (count($this->XMLfiles) == 0 && count($this->players) <1) die("No Statfiles found!");
		else {
			//var_dump($this->XMLfiles);
			// parse whole XML files for list
			foreach ($this->XMLfiles as $foldervar => $filelist) {
				$foundlast = FALSE;
				foreach ($filelist as $file) {
					/*if ($this->configuration["GENERAL"]["dump_stats"] == 1 && !empty($this->prevparsed[$foldervar])) {
						// skip "old" statfiles for parsing
						if ($file["filename"] == $this->prevparsed[$foldervar]) $foundlast = TRUE;
						// found last parsed file, parse rest
						else {
							if ($foundlast == TRUE) {
								$tmpxml = new SofeeXmlParser();
								$tmpxml->parseFile($file["pathname"]);
								$this->XMLfiles[$foldervar]["parsed"][] = $tmpxml->getTree();
							}
						}
					}
					else {*/
						$tmpxml = new SofeeXmlParser();
						$tmpxml->parseFile($file["pathname"]);
						$tmpparsed = $tmpxml->getTree();
						$tmpparsed["match"]["xmlfile"] = $file["pathname"];
						$this->XMLfiles[$foldervar]["parsed"][] = $tmpparsed;
						//echo "\n\r\n\r BLABLA";
						//var_dump($tmpparsed);
					//}
				}
			}
		}
	}
	
	function Parse_Info_Into_Players() {
		// run through parsed XML data
		foreach ($this->XMLfiles as $substats) {
			if (count($substats["parsed"])>0) {
				foreach ($substats["parsed"] as $xmldata) {
					// run through matches
					$this->matchesplayed = 0;
					foreach	($xmldata as $match) {
						$this->matchesplayed++;
						$themap = $match["map"];
						// parse up array if game was a teamgame
						if (isset($match["Team"])) {
							// who's won the match?
							if ($match["Team"][0]["score"] > $match["Team"][1]["score"]) $won = 0;
							else $won = 1;
							$wonskiplist = array();
							$lostskiplist = array();
							foreach ($match["Team"] as $tkey => $team) {
								// set value for win-determination-hack
								$winnerteam = NULL;
								if ($won == $tkey) $winnerteam = TRUE;
								else $winnerteam = FALSE;
								if (!isset($team["player"]["stat"])) {
									// multiple players in team
									foreach ($team["player"] as $oneplayer) {
										if (!empty($oneplayer["clan"])) {
											$truncclan = substr($this->process_colorcodes($oneplayer["clan"]), 0, 19);
											$oneplayer["clan"] = $truncclan;
											// WIN/LOSS HACK
											if ($winnerteam === TRUE && !isset($wonskiplist[$truncclan])) {
												if (empty($this->cmatcheswon["won"][$truncclan])) { 
													$this->cmatcheswon["won"][$truncclan] = 1;
												}
												else $this->cmatcheswon["won"][$truncclan] += 1;
												$wonskiplist[$truncclan] = "skipme";
											}
											if ($winnerteam === FALSE && !isset($lostskiplist[$truncclan])) {
												if (empty($this->cmatcheswon["lost"][$truncclan]))  
													$this->cmatcheswon["lost"][$truncclan] = 1;
												else $this->cmatcheswon["lost"][$truncclan] += 1;
												$lostskiplist[$truncclan] = "skipme";
											}
										}
										
										$oneplayer["xmlfile"] = $match["xmlfile"];
										//if (strlen($oneplayer["guid"])<5) var_dump($xmldata);
										// if player already existing as object, add new info
										$gotplayer = array_search($oneplayer["guid"], $this->players["playerlist"]);
										// add up match infos into array
										$oneplayer["map"] = $themap;
										if (is_numeric($gotplayer)) {
											$this->players[$gotplayer]->Pump_New_Stats($oneplayer);
										}
										else {
											// not existing, add new
											$newindex = count($this->players["playerlist"]);
											$this->players["playerlist"][$newindex] = $oneplayer["guid"];
											$this->players[$newindex] = new player($oneplayer, $this->configuration);
											$this->players[$newindex]->uniqueplid = base64_encode($oneplayer["guid"]);
										}
									}
								}
								else {
									// single player in team
									$oneplayer = $team["player"];
									if (!empty($oneplayer["clan"])) {
										$truncclan = substr($this->process_colorcodes($oneplayer["clan"]), 0, 19);										
										$oneplayer["clan"] = $truncclan;
										// WIN/LOSS HACK
										if ($winnerteam === TRUE && !isset($wonskiplist[$truncclan])) {
											if (empty($this->cmatcheswon["won"][$truncclan]))  
												$this->cmatcheswon["won"][$truncclan] = 1;
											else $cthis->matcheswon["won"][$truncclan] += 1;
											$wonskiplist[$truncclan] = "skipme";
										}
										if ($winnerteam === FALSE && !isset($lostskiplist[$truncclan])) {
											if (empty($this->cmatcheswon["lost"][$truncclan]))  
												$this->cmatcheswon["lost"][$truncclan] = 1;
											else $this->cmatcheswon["lost"][$truncclan] += 1;
											$lostskiplist[$truncclan] = "skipme";
										}
									}
									
									$oneplayer["xmlfile"] = $match["xmlfile"];
									$gotplayer = array_search($oneplayer["guid"], $this->players["playerlist"]);
									// add up match infos into array
									$oneplayer["map"] = $themap;
									if (is_numeric($gotplayer)) {
										$this->players[$gotplayer]->Pump_New_Stats($oneplayer);
									}
									else {
										// not existing, add new
										$newindex = count($this->players["playerlist"]);
										$this->players["playerlist"][$newindex] = $oneplayer["guid"];
										$this->players[$newindex] = new player($oneplayer, $this->configuration);
										$this->players[$newindex]->uniqueplid = base64_encode($oneplayer["guid"]);
									}
								}
							}
						}
						else {
							// run through matchdata (players)
							if (!isset($match["player"]["stat"])) {
								// multiple players in match
								foreach ($match["player"] as $oneplayer) {
									$oneplayer["xmlfile"] = $match["xmlfile"];
									//if (strlen($oneplayer["guid"])<5) var_dump($xmldata);
									// if player already existing as object, add new info
									$gotplayer = array_search($oneplayer["guid"], $this->players["playerlist"]);
									$oneplayer["map"] = $themap;
									if (is_numeric($gotplayer)) {
										$this->players[$gotplayer]->Pump_New_Stats($oneplayer);
									}
									else {
										// not existing, add new
										$newindex = count($this->players["playerlist"]);
										$this->players["playerlist"][$newindex] = $oneplayer["guid"];
										$this->players[$newindex] = new player($oneplayer, $this->configuration);
										$this->players[$newindex]->uniqueplid = base64_encode($oneplayer["guid"]);
									}
								}
							}
							else {
								// single player in match
								$oneplayer = $match["player"];
								$oneplayer["xmlfile"] = $match["xmlfile"];
								//if (strlen($oneplayer["guid"])<5) var_dump($xmldata);
								// if player already existing as object, add new info
								$gotplayer = array_search($oneplayer["guid"], $this->players["playerlist"]);
								$oneplayer["map"] = $themap;
								if (is_numeric($gotplayer)) {
									$this->players[$gotplayer]->Pump_New_Stats($oneplayer);
								}
								else {
									// not existing, add new
									$newindex = count($this->players["playerlist"]);
									$this->players["playerlist"][$newindex] = $oneplayer["guid"];
									$this->players[$newindex] = new player($oneplayer, $this->configuration);
									$this->players[$newindex]->uniqueplid = base64_encode($oneplayer["guid"]);
								}
							}
						}
					}
				}
			}
		}
	}
	
	function Calculate_Player_Stats() {
		foreach ($this->players as $key => $player) {
			if (is_numeric($key)) $this->players[$key]->Calculate_Stats();
		}
	}
		
	function Calculate_Clan_Stats() {
		// run through playerlist and build clans
		$runcount = 0;
		foreach ($this->players as $index => $player) {
			if (is_numeric($index) && !empty($player->clan)) {
				$gotclan = array_search($player->clan, $this->clans["clanlist"]);
				if (is_numeric($gotclan)) {
					$this->clans[$gotclan]["players"][] = $index;
					$this->clans[$gotclan]["efficiency"] = (($this->clans[$gotclan]["efficiency"] + $player->overallefficiency) / 2);
					if ($this->players[$this->clans[$gotclan]["bestplayer"]]->overallefficiency < $player->overallefficiency) $this->clans[$gotclan]["bestplayer"] = $index;
					$this->clans[$gotclan]["kills"] += $player->kills;
					$this->clans[$gotclan]["deaths"] += $player->deaths;
					$this->clans[$gotclan]["suicides"] += $player->suicides;
					$this->clans[$gotclan]["score"] += $player->score;
					$this->clans[$gotclan]["damagegiven"] = $player->damagegiven;
					$this->clans[$gotclan]["damagetaken"] = $player->damagetaken;
					
					// fill up weapon efficiency array
					foreach ($player->weapons as $windex => $weapon) {
						if (is_numeric($windex)) {
							$gotweapon = array_search($weapon["name"], $this->clans[$gotclan]["weapons"]["weaponlist"]);
							if (is_numeric($gotweapon) && $weapon["shots"] >0) {
								$this->clans[$gotclan]["weapons"][$gotweapon] = ((($this->clans[$gotclan]["weapons"][$gotweapon]) + $weapon["efficiency"]) / 2);
							}
							else {
								$newwindex = count($this->clans[$gotclan]["weapons"]["weaponlist"]);
								$this->clans[$gotclan]["weapons"]["weaponlist"][$newwindex] = $weapon["name"];
								$this->clans[$gotclan]["weapons"][$newwindex] = $weapon["efficiency"];
							}
						}
					}
					
					// fill up map efficiency array
					foreach ($player->maps as $mindex => $map) {
						if (is_numeric($mindex)) {
							$gotmap = array_search($map["name"], $this->clans[$gotclan]["maps"]["maplist"]);
							if (is_numeric($gotmap)) {
								$this->clans[$gotclan]["maps"][$gotmap]["count"] += 1;
								$this->clans[$gotclan]["maps"][$gotmap]["efficiency_added"] += $map["efficiency"];
							}
							else {
								$newmindex = count($this->clans[$gotclan]["maps"]["maplist"]);
								$this->clans[$gotclan]["maps"]["maplist"][$newmindex] = $map["name"];
								$this->clans[$gotclan]["maps"][$newmindex]["count"] = 1;
								$this->clans[$gotclan]["maps"][$newmindex]["efficiency_added"] = $map["efficiency"];
							}
						}
					}
				}
				else {
					$newindex = count($this->clans["clanlist"]);
					$this->clans["clanlist"][$newindex] = $player->clan;
					$this->clans[$newindex]["players"][] = $index;
					$this->clans[$newindex]["weapons"] = array();
					$this->clans[$newindex]["maps"] = array();
					$this->clans[$newindex]["weapons"]["weaponlist"] = array();
					$this->clans[$newindex]["maps"]["maplist"] = array();
					$this->clans[$newindex]["efficiency"] = $player->overallefficiency;
					if ($this->players[$this->clans[$newindex]["bestplayer"]]->overallefficiency < $player->overallefficiency) $this->clans[$newindex]["bestplayer"] = $index;
					$this->clans[$newindex]["name"] = $player->clan;
					$this->clans[$newindex]["kills"] = $player->kills;
					$this->clans[$newindex]["deaths"] = $player->deaths;
					$this->clans[$newindex]["suicides"] = $player->suicides;
					$this->clans[$newindex]["score"] = $player->score;
					$this->clans[$newindex]["damagegiven"] = $player->damagegiven;
					$this->clans[$newindex]["damagetaken"] = $player->damagetaken;
					
					// fill up weapon efficiency array
					foreach ($player->weapons as $windex => $weapon) {
						if (is_numeric($windex)) {
							$gotweapon = array_search($weapon["name"], $this->clans[$newindex]["weapons"]["weaponlist"]);
							if (is_numeric($gotweapon) && $weapon["shots"] >0) {
								$this->clans[$newindex]["weapons"][$gotweapon] = ((($this->clans[$newindex]["weapons"][$gotweapon]) + $weapon["efficiency"]) / 2);
							}
							else {
								$newwindex = count($this->clans[$newindex]["weapons"]["weaponlist"]);
								$this->clans[$newindex]["weapons"]["weaponlist"][$newwindex] = $weapon["name"];
								$this->clans[$newindex]["weapons"][$newwindex] = $weapon["efficiency"];
							}
						}
					}
					
					// fill up map efficiency array
					foreach ($player->maps as $mindex => $map) {
						if (is_numeric($mindex)) {
							$gotmap = array_search($map["name"], $this->clans[$newindex]["maps"]["maplist"]);
							if (is_numeric($gotmap)) {
								$this->clans[$newindex]["maps"][$gotmap]["count"] += 1;
								$this->clans[$newindex]["maps"][$gotmap]["efficiency_added"] += $map["efficiency"];
							}
							else {
								$newmindex = count($this->clans[$newindex]["maps"]["maplist"]);
								$this->clans[$newindex]["maps"]["maplist"][$newmindex] = $map["name"];
								$this->clans[$newindex]["maps"][$newmindex]["count"] = 1;
								$this->clans[$newindex]["maps"][$newmindex]["efficiency_added"] = $map["efficiency"];
							}
						}
					}
				}
			}
		}
		// got clan array with basic infos, now calculate stats
		if (count($this->clans) >1) {
			foreach ($this->clans as $index => $clan) {
				if (is_numeric($index)) {
					// calculate best weapon
					$bestweapon = 0;
					foreach ($clan["weapons"] as $key => $accuracy) {
						if (is_numeric($key)) {
							if ($clan["weapons"][$bestweapon] < $accuracy) $bestweapon = $key;
						}
					}
					
					// calculate map stats then best map
					$lasteff = 0;
					$bestmap = 0;
					foreach ($clan["maps"] as $key => $map) {
						if (is_numeric($key)) {
							$this->clans[$index]["maps"][$key] = ($map["efficiency_added"] / $map["count"]);
							if ($this->clans[$index]["maps"][$key]["efficiency"] > $lasteff) {
								$lasteff = $this->clans[$index]["maps"][$key]["efficiency"];
								$bestmap = $key;
							}
						}
					}
					$this->clans[$index]["bestmap"] = $bestmap;
					$this->clans[$index]["bestweapon"] = $bestweapon;
				}
			}
		}
	}
	
	function Get_Top_Players() {
		// run through player classes and collect top players
		$efflist = array();
		foreach ($this->players as $key => $player) {
			if (is_numeric($key) && !is_null($player->overallefficiency)) {
				$efflist[$key] = $player->overallefficiency;
			}
		}
		arsort($efflist);
		$count = 0;
		foreach ($efflist as $playerkey => $eff) {
			// are we inside the top-players count definition of ini?
			if ($count > $this->configuration["GENERAL"]["top_count"]) break;
			$this->topplayers[$playerkey] = $eff;
		}
	}
	
	function Get_Top_Players_Clans() {
		// run through clans' player classes and collect top players
		if (count($this->clans > 1)) {
			foreach ($this->clans as $clkey => $clan) {
				$efflist = array();
				if (isset($clan["players"])) {
					if (is_array($clan["players"])) {
						foreach ($clan["players"] as $key => $player) {
							if (is_numeric($key)) { 
								$efflist[$player] = $this->players[$player]->overallefficiency;
							}
						}
					}
				}
				arsort($efflist);
				$count = 0;
				foreach ($efflist as $playerkey => $eff) {
					// are we inside the top-players count definition of ini?
					if ($count > $this->configuration["GENERAL"]["top_count"]) break;
					$this->clans[$clkey]["topplayers"][$playerkey] = $eff;
				}
			}
		}
	}
	
	function Get_Top_Clans() {
		// run through clans array and collect top clans
		$efflist = array();
		foreach ($this->clans as $key => $clan) {
			if (is_numeric($key) && !is_null($clan["efficiency"])) {
				$efflist[$key] = $clan["efficiency"];
			}
		}
		arsort($efflist);
		$count = 0;
		foreach ($efflist as $clankey => $eff) {
			// are we inside the top-count count definition of ini?
			if ($count > $this->configuration["GENERAL"]["top_count"]) break;
			$this->topclans[$clankey] = $eff;
		}
	}
	
	function Generate_Output() {
		global $script_time;
		// parse topplayer stats
		$toprepeatout = "";
		if (count($this->players)>1) {
			if ($this->outputtype == "players") {
				//
				// if outputtype players ---
				//
				foreach ($this->topplayers as $playerkey => $eff) {
					$varlist = array();
					$varlist["name"] = $this->Process_Colorcodes($this->players[$playerkey]->name);
					// name too long?
					if (strlen($varlist["name"]) > 20) $varlist["name"] = (substr($varlist["name"], 0, 17))."...";
					$varlist["name"] = "<a href=\"?detail=$playerkey\">{$varlist['name']}</a>";
					$varlist["clan"] = empty($this->players[$playerkey]->clan)?"-":$this->Process_Colorcodes($this->players[$playerkey]->clan);
					// got details for clan?
					$probclan = array_search($this->players[$playerkey]->clan, $this->clans["clanlist"]);
					if (is_numeric($probclan)) $varlist["clan"] = "<a href=\"?clandetail=$probclan\">{$varlist['clan']}</a>";
					$varlist["overallefficiency"] = $this->players[$playerkey]->overallefficiency;
					$varlist["playerefficiency"] = $this->players[$playerkey]->playerefficiency;
					$varlist["kills"] = $this->players[$playerkey]->kills;
					$varlist["deaths"] = $this->players[$playerkey]->deaths;
					$toprepeatout .= $this->Parse_Template("template/top_players_repeat.tpl", $varlist);
				}
				$varlist = array();
				$varlist["top_players_repeat"] = $toprepeatout;
				$varlist["toptype"] = "Top {$this->configuration['GENERAL']['top_count']} $this->outputtype | <a href=\"?top=clans\">Top {$this->configuration['GENERAL']['top_count']} clans</a>";
				$topbasicout = $this->Parse_Template("template/top_players_basic.tpl", $varlist);
			}
			else {
				//
				// if outputtype clans ---
				//
				foreach ($this->topclans as $clankey => $eff) {
					$varlist = array();
					$varlist["name"] = $this->Process_Colorcodes($this->clans[$clankey]["name"]);
					// name too long?
					if (strlen($varlist["name"]) > 20) $varlist["name"] = (substr($varlist["name"], 0, 17))."...";
					$varlist["name"] = "<a href=\"?clandetail=$clankey\">{$varlist['name']}</a>";
					$varlist["efficiency"] = round($eff, 2);
					$varlist["bestmap"] = $this->clans[$clankey]["maps"]["maplist"][$this->clans[$clankey]["bestmap"]];
					$varlist["playercount"] = count($this->clans[$clankey]["players"]);
					$varlist["kills"] = $this->clans[$clankey]["kills"];
					$varlist["deaths"] = $this->clans[$clankey]["deaths"];
					$toprepeatout .= $this->Parse_Template("template/top_clans_repeat.tpl", $varlist);
				}
				$varlist = array();
				$varlist["top_clans_repeat"] = $toprepeatout;
				$varlist["toptype"] = "<a href=\"?top=players\">Top {$this->configuration['GENERAL']['top_count']} players</a> | Top {$this->configuration['GENERAL']['top_count']} ".$this->outputtype;
				$topbasicout = $this->Parse_Template("template/top_clans_basic.tpl", $varlist);
			}
			$varlist = array();
			
			$varlist["content"] = "";
			$newcont = "";
			
			// basic things parsed, do content
			if (isset($_REQUEST["detail"])) {
				//
				// if request = (player) DETAIL ---
				//
				if (!isset($this->players[$_REQUEST["detail"]])) $varlist["content"] = "Wrong Player specified.";
				else {
					$probclan = NULL;
					$theplayer = $this->players[$_REQUEST["detail"]];
					// get general info
					$varlist["name"] = $this->Process_Colorcodes($theplayer->name);
					$varlist["clanshort"] = $this->Process_Colorcodes($theplayer->clan);
					$varlist["clan"] = empty($varlist["clanshort"])?"":"of ".$varlist["clanshort"];
					if (!empty($varlist["clanshort"])) $probclan = array_search($varlist["clanshort"], $this->clans["clanlist"]);
					$varlist["clanshort"] = is_numeric($probclan)?"<a href=\"?clandetail=$probclan\">".$varlist["clanshort"]."</a>":$varlist["clanshort"];
					$varlist["clanshort"] = empty($varlist["clanshort"])?"-":$varlist["clanshort"];
					$varlist["guid"] = $theplayer->guid;
					$varlist["kills"] = $theplayer->kills;
					$varlist["deaths"] = $theplayer->deaths;
					$varlist["score"] = $theplayer->score;
					$varlist["suicides"] = $theplayer->suicides;
					$varlist["damagegiven"] = $theplayer->damagegiven;
					$varlist["damagetaken"] = $theplayer->damagetaken;
					$varlist["bestweapon"] = $theplayer->weapons[$theplayer->bestweapon]["name"];
					$varlist["bestmap"] = $theplayer->maps[$theplayer->bestmap]["name"];
					$varlist["bestmapefficiency"] = $theplayer->maps[$theplayer->bestmap]["efficiency"];
					$varlist["playerefficiency"] = $theplayer->playerefficiency;
					$varlist["overallefficiency"] = $theplayer->overallefficiency;
					$varlist["uniqueplid"] = $theplayer->uniqueplid;
					$varlist["mostplayedmap"] = $theplayer->maps[$theplayer->mostplayedmap]["name"];
					$varlist["mostplayedmapcount"] = $theplayer->maps[$theplayer->mostplayedmap]["count"];
					$varlist["awardsearned"] = 0;
					foreach ($theplayer->awards as $key => $award) {
						if (is_numeric($key)) $varlist["awardsearned"] += $award["count"];
					}
					
					// get weapon stats
					$weaprepeatout = "";
					foreach ($theplayer->weapons as $key => $weapon) {
						if (is_numeric($key)) {
							$weaptplvars = array();
							$weaptplvars["weaponimage"] = is_file("img/weapons/{$weapon['name']}.gif")?"<img src=\"img/weapons/{$weapon['name']}.gif\" border=\"0\">":"";
							$weaptplvars["weaponname"] = $weapon["name"];
							$weaptplvars["shots"] = $weapon["shots"];
							$weaptplvars["hits"] = $weapon["hits"];
							$weaptplvars["efficiency"] = is_null($weapon["efficiency"])?"0":$weapon["efficiency"];
							$weaprepeatout .= $this->Parse_Template("template/pl_details_weapons_repeat.tpl", $weaptplvars);
						}
					}
					
					// get awards stats
					$awardsrepeatout = "";
					foreach ($theplayer->awards as $key => $award) {
						if (is_numeric($key)) {
							$awardtplvars = array();
							$award['name'] = strtolower($award["name"]);
							// RAVEN TE NOOB
							if ($award["name"] == "critical failure") $awardtplvars["awardimage"] = "<a href=\"img/awards/raven_hi_res.gif\" target=\"_blank\"><img src=\"img/awards/{$award['name']}.gif\" border=\"0\"></a>";
							else $awardtplvars["awardimage"] = is_file("img/awards/{$award['name']}.gif")?"<img src=\"img/awards/{$award['name']}.gif\" border=\"0\">":"";
							$awardtplvars["name"] = $this->Refurbish_Award($award["name"]);
							$awardtplvars["count"] = $award["count"];
							$awardsrepeatout .= $this->Parse_Template("template/pl_details_awards_repeat.tpl", $awardtplvars);
						}
					}
					
					// get maps stats
					$mapsrepeatout = "";
					foreach ($theplayer->maps as $key => $map) {
						if (is_numeric($key)) {
							$maptplvars = array();
							$maptplvars["name"] = $map["name"];
							$maptplvars["count"] = $map["count"];
							$maptplvars["kills"] = $map["kills"];
							$maptplvars["deaths"] = $map["deaths"];
							$maptplvars["efficiency"] = $map["efficiency"];
							$mapsrepeatout .= $this->Parse_Template("template/pl_details_maps_repeat.tpl", $maptplvars);
						}
					}
					
					// get alternative nicks
					$altnicks = array();
					$gotfirst = FALSE;
					if (count($theplayer->altnicks["nicklist"])>0) {
						foreach ($theplayer->altnicks["nicklist"] as $key => $nick) {
							if (!$gotfirst) {
								$altnicks[] = "<strong>$nick</strong> ({$theplayer->altnicks[$key]['count']})";
								$gotfirst = TRUE;
							}
							else $altnicks[] = "$nick ({$theplayer->altnicks[$key]['count']})";
						}
					}
					$varlist["pl_details_altnicks"] = implode(", ", $altnicks);
					$varlist["pl_details_altnicks"] = empty($varlist["pl_details_altnicks"])?"-":$varlist["pl_details_altnicks"];

					// get alternative clantags
					$alttags = array();
					$gotfirst = FALSE;
					if (count($theplayer->altclantags["taglist"])>0) {
						foreach ($theplayer->altclantags["taglist"] as $key => $tag) {
							if (!$gotfirst) {
								$alttags[] = "<strong>$tag</strong> ({$theplayer->altclantags[$key]['count']})";
								$gotfirst = TRUE;
							}
							else $alttags[] = "$tag ({$theplayer->altclantags[$key]['count']})";
						}
					}
					$varlist["pl_details_alttags"] = implode(", ", $alttags);
					$varlist["pl_details_alttags"] = empty($varlist["pl_details_alttags"])?"-":$varlist["pl_details_alttags"];
					
					$varlist["pl_details_maps_repeat"] = $mapsrepeatout;
					$varlist["pl_details_awards_repeat"] = $awardsrepeatout;				
					$varlist["pl_details_weapons_repeat"] = $weaprepeatout;
					
					// kill empty values
					foreach($varlist as $key => $var) {
						if (is_null($var)) $varlist[$key] = "0";
					}
					
					$newcont .= $this->Parse_Template("template/pl_details_basic.tpl", $varlist);
					$varlist = array();
					$varlist["content"] = $newcont;
				}
			}
			elseif (isset($_REQUEST["clandetail"])) {
				//
				// if request = CLANDETAIL ---
				//
				if (!isset($this->clans[$_REQUEST["clandetail"]])) $varlist["content"] = "Wrong Clan specified.";
				else {
					$theclan = $this->clans[$_REQUEST["clandetail"]];
					// get general info
					$varlist["name"] = $this->Process_Colorcodes($theclan["name"]);
					$varlist["playercount"] = count($theclan["players"]);
					$varlist["kills"] = $theclan["kills"];
					$varlist["deaths"] = $theclan["deaths"];
					$varlist["score"] = $theclan["score"];
					$varlist["suicides"] = $theclan["suicides"];
					$varlist["damagegiven"] = $theclan["damagegiven"];
					$varlist["damagetaken"] = $theclan["damagetaken"];
					$varlist["bestweapon"] = $theclan["weapons"]["weaponlist"][$theclan["bestweapon"]];
					$varlist["bestweaponeff"] = $theclan["weapons"][$theclan["bestweapon"]];
					$varlist["bestmap"] = $theclan["maps"]["maplist"][$theclan["bestmap"]];
					$varlist["bestmapefficiency"] = $theclan["maps"][$theclan["bestmap"]];
					$varlist["efficiency"] = round($theclan["efficiency"], 2);
					
					$varlist["matcheswon"] = empty($this->cmatcheswon["won"][$varlist["name"]])?0:$this->cmatcheswon["won"][$varlist["name"]];
					$varlist["matcheslost"] = empty($this->cmatcheswon["lost"][$varlist["name"]])?0:$this->cmatcheswon["lost"][$varlist["name"]];
					
					$subpllistout = "";
					foreach ($theclan["topplayers"] as $playerkey => $eff) {
						$subpllist["name"] = $this->Process_Colorcodes($this->players[$playerkey]->name);
						// name too long?
						if (strlen($subpllist["name"]) > 20) $subpllist["name"] = (substr($subpllist["name"], 0, 17))."...";
						$subpllist["name"] = "<a href=\"?detail=$playerkey\">{$subpllist['name']}</a>";
						$subpllist["clan"] = empty($this->players[$playerkey]->clan)?"-":$this->Process_Colorcodes($this->players[$playerkey]->clan);
						
						$subpllist["bestweapon"] = $this->players[$playerkey]->weapons[$this->players[$playerkey]->bestweapon]["name"];
						$subpllist["bestweapimg"] = is_file("img/weapons/{$subpllist['bestweapon']}.gif")?"<img src=\"img/weapons/{$subpllist['bestweapon']}.gif\" border=\"0\">":"";
						$subpllist["bestweaponeff"] = $this->players[$playerkey]->weapons[$this->players[$playerkey]->bestweapon]["efficiency"];
						$subpllist["overallefficiency"] = $this->players[$playerkey]->overallefficiency;
						$subpllist["playerefficiency"] = $this->players[$playerkey]->playerefficiency;
						$subpllist["kills"] = $this->players[$playerkey]->kills;
						$subpllist["deaths"] = $this->players[$playerkey]->deaths;
						$subpllistout .= $this->Parse_Template("template/clan_details_players_repeat.tpl", $subpllist);
					}
					
					$varlist["clan_details_players_repeat"] = $subpllistout;
					
					// kill empty values
					foreach($varlist as $key => $var) {
						if (is_null($var)) $varlist[$key] = "0";
					}
					
					$newcont .= $this->Parse_Template("template/clan_details_basic.tpl", $varlist);
					$varlist = array();
					$varlist["content"] = $newcont;
				}
			}
			
			$varlist["toplists"] = $topbasicout;
			
			$varlist["force_reparse"] = "<a href=\"?reparse\">Force reparsing of all data</a>";
			$varlist["gohome"] = "<a href=\"index.php\">Go Home</a>";
			
			// was script parsed?
			$cached = ($this->wasiparsed == TRUE)?", realtime":", cached";
			$prevpcount = count($this->prevparsed);
			$reparsewhen = "";
			if ($prevpcount > 0) {
				if ($this->wasiparsed == TRUE) $cached = ", dumped, realtime";
				else $cached = ", dump cached";			
			}
			if ($this->wasiparsed == FALSE) $reparsewhen = ", reparsing in ".($_SESSION["q4maxstats"]["reparse_when"] - (time()))."s";
			$howmuch = ($prevpcount>0)?NULL:", for <strong>$this->XMLfilecount</strong> XML files";
			$varlist["classversion"] = "Script loaded in <strong>{$script_time}s</strong>$cached$reparsewhen$howmuch using <strong>$this->classversion</strong>";
			$indexout = $this->Parse_Template("template/index.tpl", $varlist);
			
			return $indexout;
		}
		else echo "no stat-files found";
	}
	
	function Parse_Template($tplfile, $vararray) {
		$tplfile = file_get_contents($tplfile);
		preg_match_all("=TPL__(.*?)__TPL=si", $tplfile, $matches);
		foreach ($matches[1] as $key => $match) {
			$realvarname = strtolower($match);
			if (isset($vararray[$realvarname])) $tplfile = str_replace($matches[0][$key], $vararray[$realvarname], $tplfile);
		}
		return $tplfile;
	}
	
	function Process_Colorcodes($data) {
		$data = preg_replace("=[\^][c]*[0-9]*=si", "", $data);
		return $data;
	}
	
	function Refurbish_Award($data) {
		$data = str_replace("_", " ", $data);
		$data = ucwords($data);
		return $data;
	}
	
	function dirlist($path) {
		$dirlist = array();
		if ($handle = opendir($path)) {
		   while (false !== ($file = readdir($handle))) {
			   if ($file != "." && $file != "..") {
				   $dirlist[] = $file;
			   }
		   }
		   closedir($handle);
		}
		else return FALSE;
		return $dirlist;	
	}
	
	function cool_var_dump($var, $dontecho = FALSE) {
		// replaces linefeeds with html tags using output buffer
		ob_start();
		var_dump($var);
		$output = ob_get_contents();
		ob_end_clean();	
		$output = nl2br($output);
		if ($dontecho == TRUE) return $output;	
		echo $output;
	}
}

class player {
	var $name;
	var $clan;
	var $guid;
	var $kills;
	var $deaths;
	var $score;
	var $suicides;
	var $damagegiven;
	var $damagetaken;
	var $awards; 		// arrayed
	var $weapons;		// arrayed
	var $bestweapon;
	var $playerefficiency;  // score/deaths
	var $overallefficiency; // score/deaths incl average weapon eff
	var $uniqueplid;
	var $configuration;	// configurational data from parent
	var $maps; 			// arrayed
	var $mostplayedmap;
	var $bestmap;
	var $altnicks;		// arrayed
	var $altclantags;	// arrayed
	function player($statdata, $configuration, $parse_dumped = FALSE) {
		// constructor
		// recieves an array with new statdata and processes it
		$this->configuration 			= $configuration;
		$this->awards 					= array();
		$this->awards["awardlist"] 		= array();
		$this->maps 					= array();
		$this->maps["maplist"] 			= array();
		$this->altnicks 				= array();
		$this->altnicks["nicklist"] 	= array();
		$this->altclantags 				= array();
		$this->altclantags["taglist"] 	= array();
		
		$this->name = $statdata["name"];
		$this->clan = substr(XMLstats::process_colorcodes($statdata["clan"]), 0, 19);
		$this->guid = $statdata["guid"];
		
		// is $statdata array a dumped one?
		if ($parse_dumped == TRUE) $this->Parse_Dumped_Stat_Data($statdata);
		else $this->Parse_Stat_Data($statdata);
		return TRUE;
	}
	
	function Parse_Dumped_Stat_Data($statdata) {
		// simple values
		
		$this->kills 				= $statdata["kills"];
		$this->clan 				= $statdata["clan"];
		$this->deaths 				= $statdata["deaths"];
		$this->score 				= $statdata["score"];
		$this->suicides 			= $statdata["suicides"];
		$this->damagegiven 			= $statdata["damagegiven"];
		$this->damagetaken 			= $statdata["damagetaken"];
		$this->bestweapon 			= $statdata["bestweapon"];
		$this->playerefficiency 	= $statdata["playerefficiency"];
		$this->overallefficiency 	= $statdata["overallefficiency"];
		$this->uniqueplid 			= $statdata["uniqueplid"];
		$this->mostplayedmap 		= $statdata["mostplayedmap"];
		$this->bestmap 				= $statdata["bestmap"];
		
		// punched arrays
		$this->awards 		= !empty($statdata["awards"])?$this->unserialize_arraydata($statdata["awards"]):NULL;
		$this->weapons		= !empty($statdata["weapons"])?$this->unserialize_arraydata($statdata["weapons"]):NULL;
		$this->maps 		= !empty($statdata["maps"])?$this->unserialize_arraydata($statdata["maps"]):NULL;
		$this->altnicks		= !empty($statdata["altnicks"])?$this->unserialize_arraydata($statdata["altnicks"]):NULL;
		$this->altclantags	= !empty($statdata["altclantags"])?$this->unserialize_arraydata($statdata["altclantags"]):NULL;
	}
	
	function serialize_arraydata($array) {
		// workaround for weird PHP float bug (round doesnt cut internal value of float)
		foreach ($array as $key => $setting) {
			if (is_float($setting)) {
				//$array[$key] = $setting."DBL";
				$array[$key] = strval($setting);
				//$array[$key] = substr($setting, 0, 2);
			}
			if (is_array($setting)) {
				foreach ($setting as $subkey => $subsetting) {
					if (is_float($subsetting)) {
						//$array[$key][$subkey] = $subsetting."DBL";
						$array[$key][$subkey] = strval($subsetting);
					}
				}
			}
		}
		$return = serialize($array);
		$return = str_replace(array('\n', '\r', '\t', '"'), array("__N__", "__R__", "__T__", "__Q__"), $return);
		$return = addslashes($return);
		return $return;
	}
	
	function unserialize_arraydata($data) {
		$return = stripslashes($data);
		$return = str_replace(array("__N__", "__R__", "__T__", "__Q__"), array('\n', '\r', '\t', '"'), $return);
		$return = unserialize($return);	
		return $return;
	}
	
	function Parse_Stat_Data($statdata) {
		// basic stats, section "stat"
		$this->kills 			= empty($statdata["stat"][0]["value"])?0:$statdata["stat"][0]["value"];
		$this->deaths 			= empty($statdata["stat"][1]["value"])?0:$statdata["stat"][1]["value"];
		$this->score 			= empty($statdata["stat"][2]["value"])?0:$statdata["stat"][2]["value"];
		$this->suicides 		= empty($statdata["stat"][3]["value"])?0:$statdata["stat"][3]["value"];
		$this->damagegiven 		= empty($statdata["stat"][4]["value"])?0:$statdata["stat"][4]["value"];
		$this->damagetaken 		= empty($statdata["stat"][5]["value"])?0:$statdata["stat"][5]["value"];
		
		//var_dump( $statdata["clan"]);
		
		if (empty($this->clan)) $this->clan = substr(XMLstats::process_colorcodes($statdata["clan"]), 0, 19);
		
		// fill up altnicks and altclantags array
		$foundnick = array_search($statdata["name"], $this->altnicks["nicklist"]);
		if (is_numeric($foundnick)) $this->altnicks[$foundnick]["count"]++;
		else {
			$newindex = count($this->altnicks)-1;
			$this->altnicks["nicklist"][$newindex] = $statdata["name"];
			$this->altnicks[$newindex]["name"] = $statdata["name"];
			$this->altnicks[$newindex]["count"] = 1;
		}
		if (!empty($statdata["clan"])) {
			$theclan = substr(XMLstats::process_colorcodes($statdata["clan"]), 0, 19);
			$foundtag = array_search($theclan, $this->altclantags["taglist"]);
			if (is_numeric($foundtag)) $this->altclantags[$foundtag]["count"]++;
			else {
				$newindex = count($this->altclantags)-1;
				$this->altclantags["taglist"][$newindex] = $theclan;
				$this->altclantags[$newindex]["name"] = $theclan;
				$this->altclantags[$newindex]["count"] = 1;
			}
		}
		
		// parse map information
		if (!empty($statdata["map"])) {
			// break string open for clearer view
			$brokenmap = explode("/", $statdata["map"]);
			$mapname = $brokenmap[count($brokenmap)-1];
			$mapname = explode(".", $mapname);
			$mapname = $mapname[0];
			$newindex = count($this->maps["maplist"]);
			$this->maps["maplist"][$newindex] = $mapname;
			$this->maps[$newindex]["name"] = $mapname;
			$this->maps[$newindex]["count"] = 1;
			$this->maps[$newindex]["kills"] = empty($statdata["stat"][0]["value"])?0:$statdata["stat"][0]["value"];
			$this->maps[$newindex]["deaths"] = empty($statdata["stat"][1]["value"])?0:$statdata["stat"][1]["value"];
			$this->maps[$newindex]["efficiency"] = 0;
		}

		// awards, section "awards"
		if (isset($statdata["awards"]["award"])) $statdata["awards"]["Award"] = array_merge($statdata["awards"]["Award"], $statdata["awards"]["award"]);
		if (isset($statdata["awards"]["Award"])) {
			if (isset($statdata["awards"]["Award"]["name"])) $awards[0] = $statdata["awards"]["Award"];
			else $awards = $statdata["awards"]["Award"];
			foreach ($awards as $award) {
				// is awardname in skiplist or empty, skip
				if (!empty($award["name"])) {
					if (!strstr($this->configuration["GENERAL"]["skip_awards"], $award["name"])) {
						$newindex = count($this->awards["awardlist"]);
						$this->awards["awardlist"][$newindex] = $award["name"];
						$this->awards[$newindex]["name"] = $award["name"];
						$this->awards[$newindex]["count"] = empty($award["value"])?1:$award["value"];
					}
				}
			}
		}
		
		// weapons, section "weapons"
		foreach ($statdata["weapons"]["weapon"] as $weapon) {
			if (!empty($weapon["name"])) {
				if (!strstr($this->configuration["GENERAL"]["skip_weapons"], $weapon["name"])) {
					$newindex = count($this->weapons["weaponlist"]);
					$this->weapons["weaponlist"][$newindex] = $weapon["name"];
					$this->weapons[$newindex]["name"] = $weapon["name"];
					$this->weapons[$newindex]["hits"] = $weapon["hits"];
					$this->weapons[$newindex]["shots"] = $weapon["shots"];
				}
			}
		}
	}
	
	function Pump_New_Stats($statdata) {
		// recieves an array with new statdata and processes it upon old data
		// basic stats, section "stat"
		$this->kills 			+= empty($statdata["stat"][0]["value"])?0:$statdata["stat"][0]["value"];
		$this->deaths 			+= empty($statdata["stat"][1]["value"])?0:$statdata["stat"][1]["value"];
		$this->score 			+= empty($statdata["stat"][2]["value"])?0:$statdata["stat"][2]["value"];
		$this->suicides 		+= empty($statdata["stat"][3]["value"])?0:$statdata["stat"][3]["value"];
		$this->damagegiven 		+= empty($statdata["stat"][4]["value"])?0:$statdata["stat"][4]["value"];
		$this->damagetaken 		+= empty($statdata["stat"][5]["value"])?0:$statdata["stat"][5]["value"];
		
		if (empty($this->clan)) $this->clan = substr(XMLstats::process_colorcodes($statdata["clan"]), 0, 19);
		
		// fill up altnicks and altclantags array
		$foundnick = array_search($statdata["name"], $this->altnicks["nicklist"]);
		if (is_numeric($foundnick)) $this->altnicks[$foundnick]["count"]++;
		else {
			$newindex = count($this->altnicks)-1;
			$this->altnicks["nicklist"][$newindex] = $statdata["name"];
			$this->altnicks[$newindex]["name"] = $statdata["name"];
			$this->altnicks[$newindex]["count"] = 1;
		}
		if (!empty($statdata["clan"])) {
			$theclan = substr(XMLstats::process_colorcodes($statdata["clan"]), 0, 19);
			$foundtag = array_search($theclan, $this->altclantags["taglist"]);
			if (is_numeric($foundtag)) $this->altclantags[$foundtag]["count"]++;
			else {
				$newindex = count($this->altclantags)-1;
				$this->altclantags["taglist"][$newindex] = $theclan;
				$this->altclantags[$newindex]["name"] = $theclan;
				$this->altclantags[$newindex]["count"] = 1;
			}
		}
		
		// parse map information
		if (!empty($statdata["map"])) {
			// break string open for clearer view
			$brokenmap = explode("/", $statdata["map"]);
			$mapname = $brokenmap[count($brokenmap)-1];
			$mapname = explode(".", $mapname);
			$mapname = $mapname[0];
			$havemap = array_search($mapname, $this->maps["maplist"]);
			if (is_numeric($havemap)) {
				$this->maps[$havemap]["count"] += 1;
				$this->maps[$havemap]["kills"] += empty($statdata["stat"][0]["value"])?0:$statdata["stat"][0]["value"];
				$this->maps[$havemap]["deaths"] += empty($statdata["stat"][1]["value"])?0:$statdata["stat"][1]["value"];
			}
			else {
				$newindex = count($this->maps["maplist"]);
				$this->maps["maplist"][$newindex] = $mapname;
				$this->maps[$newindex]["name"] = $mapname;
				$this->maps[$newindex]["count"] = 1;
				$this->maps[$newindex]["kills"] = empty($statdata["stat"][0]["value"])?0:$statdata["stat"][0]["value"];
				$this->maps[$newindex]["deaths"] = empty($statdata["stat"][1]["value"])?0:$statdata["stat"][1]["value"];		
				$this->maps[$newindex]["efficiency"] = 0;
			}
		}

		// awards, section "awards"
		if (isset($statdata["awards"]["award"]) && isset($statdata["awards"]["Award"])) $statdata["awards"]["Award"] = array_merge($statdata["awards"]["Award"], $statdata["awards"]["award"]);
		elseif (isset($statdata["awards"]["award"]) && !isset($statdata["awards"]["Award"])) $statdata["awards"]["Award"] = $statdata["awards"]["award"];
		if (isset($statdata["awards"]["Award"])) {
			if (isset($statdata["awards"]["Award"]["name"])) $awards[0] = $statdata["awards"]["Award"];
			else $awards = $statdata["awards"]["Award"];
			foreach ($awards as $award) {
				// is awardname in skiplist or empty, skip
				if (!empty($award["name"])) {
					if (!strstr($this->configuration["GENERAL"]["skip_awards"], $award["name"])) {
						// award already in list? update
						$haveaward = array_search($award["name"], $this->awards["awardlist"]);
						if (is_numeric($haveaward)) {
							$this->awards[$haveaward]["count"] += empty($award["value"])?1:$award["value"];
						}
						else {
							$newindex = count($this->awards["awardlist"]);
							$this->awards["awardlist"][$newindex] = $award["name"];
							$this->awards[$newindex]["name"] = $award["name"];
							$this->awards[$newindex]["count"] = empty($award["value"])?1:$award["value"];
						}
					}
				}
			}
		}
		
		// weapons, section "weapons"
		foreach ($statdata["weapons"]["weapon"] as $weapon) {
			if (!empty($weapon["name"])) {
				if (!strstr($this->configuration["GENERAL"]["skip_weapons"], $weapon["name"])) {
					// weapon already in list? update
					$haveweapon = array_search($weapon["name"], $this->weapons["weaponlist"]);
					if (is_numeric($haveweapon)) {
						$this->weapons[$haveweapon]["hits"] += $weapon["hits"];
						$this->weapons[$haveweapon]["shots"] += $weapon["shots"];
					}
					else {
						$newindex = count($this->weapons["weaponlist"]);
						$this->weapons["weaponlist"][$newindex] = $weapon["name"];
						$this->weapons[$newindex]["name"] = $weapon["name"];
						$this->weapons[$newindex]["hits"] = $weapon["hits"];
						$this->weapons[$newindex]["shots"] = $weapon["shots"];
					}
				}
			}
		}
	}
	
	function Calculate_Stats() {
		// to be called after all data has been parsed
		$this->Get_Weapon_Efficiencies();
		$this->Get_Map_Efficiencies();
		$this->Get_Overall_Efficiency();
		$this->Get_Most_Played_Map();
		$this->Sort_Alternative_Nickclan();
		//$this->Get_Best_Map();
	}
	
	function Get_Weapon_Efficiencies() {
		$maxeff = 0.0;
		$maxeff_key = NULL;
		foreach ($this->weapons as $index => $weapon) {
			if (is_numeric($index) && $weapon["shots"]>0) {
				$percents = round(($weapon["hits"] * 100 / ($weapon["hits"] + $weapon["shots"])), 2);
				$this->weapons[$index]["efficiency"] = $percents;
				if ($percents > $maxeff) {
					$maxeff = $percents;
					$maxeff_key = $index;
				}
			}
		}
		$this->bestweapon = $maxeff_key;
	}
	
	function Get_Map_Efficiencies() {
		$maxeff = 0.0;
		$maxeff_key = NULL;
		foreach ($this->maps as $index => $map) {
			if (is_numeric($index) && $map["kills"]>0) {
				$percents = round(($map["kills"] * 100 / ($map["kills"] + $map["deaths"])), 2);
				$this->maps[$index]["efficiency"] = $percents;
				if ($percents > $maxeff) {
					$maxeff = $percents;
					$maxeff_key = $index;
				}
			}
		}
		$this->bestmap = $maxeff_key;
	}
	
	function Get_Overall_Efficiency() {
		// get player efficiency
		if (is_numeric($this->deaths) && $this->deaths > 0) {
			$this->playerefficiency = round(($this->kills * 100 / ($this->kills + $this->deaths)), 2);
		}
		
		// get overall efficiency
		$effcount = 0;
		$alleff = 0.0;
		foreach ($this->weapons as $index => $weapon) {
			if (isset($weapon["efficiency"])) {
				if (is_numeric($index) && is_float($weapon["efficiency"]) && $weapon["shots"] >0) {
					$alleff += $weapon["efficiency"];
					$effcount++;
				}
			}
		}
		if ($effcount > 0) $avgweapeff = round(($alleff / $effcount), 2);
		else return FALSE;
		if (is_numeric($this->playerefficiency)) {
			$overall_eff = round((($avgweapeff + $this->playerefficiency) / 2), 2);
		}
		else $overall_eff = $avgweapeff;
		$this->overallefficiency = $overall_eff;
		return TRUE;
	}
	
	function Get_Most_Played_Map() {
		// name says it all
		$mostplayed = NULL;
		$mostcount = 0;
		foreach ($this->maps as $key=> $map) {
			if (is_numeric($key)) {
				if ($map["count"] > $mostcount) {
					$mostcount = $map["count"];
					$mostplayed = $key;
				}
			}
		}
		$this->mostplayedmap = $mostplayed;
	}
	
	function Get_Best_Map() {
		// name says it all
		$bestmap = NULL;
		$bestcount = 0;
		foreach ($this->maps as $key=> $map) {
			if (is_numeric($key)) {
				if ($map["efficiency"] > $bestcount) {
					$bestcount = $map["efficiency"];
					$bestmap = $key;
				}
			}
		}
		$this->bestmap = $bestmap;
	}
	
	function Sort_Alternative_Nickclan() {
		// run through altnicklist array and sort by count
		if (count($this->altnicks) >0) {
			$list = array();
			foreach ($this->altnicks as $key => $nick) {
				if (is_numeric($key)) {
					$list[$key] = $nick["count"];
				}
			}
			arsort($list);
			$oldlist = $this->altnicks;
			$this->altnicks = array();
			$count = 0;
			$foundmost = FALSE;
			foreach ($list as $nickkey => $count) {
				if (!$foundmost) {
					$this->altnicks["nicklist"][$nickkey] = "<strong>".XMLstats::Process_Colorcodes($oldlist["nicklist"][$nickkey])."</strong>";
					$foundmost = TRUE;
				}
				else $this->altnicks["nicklist"][$nickkey] = XMLstats::Process_Colorcodes($oldlist["nicklist"][$nickkey]);
				$this->altnicks[$nickkey]["name"] = $oldlist["nicklist"][$nickkey];
				$this->altnicks[$nickkey]["count"] = $count;
			}
		}
		
		// run through altclantags array and sort by count
		if (count($this->altclantags) >0) {
			// run through altnicklist array and sort by count
			$list = array();
			foreach ($this->altclantags as $key => $clantag) {
				if (is_numeric($key)) {
					$list[$key] = $clantag["count"];
				}
			}
			arsort($list);
			$oldlist = $this->altclantags;
			$this->altclantags = array();
			$count = 0;
			$foundmost = FALSE;
			foreach ($list as $clantagkey => $count) {
				if (!$foundmost) {
					$this->altclantags["taglist"][$clantagkey] = "<strong>".XMLstats::Process_Colorcodes($oldlist["taglist"][$clantagkey])."</strong>";
					$foundmost = TRUE;
				}
				else $this->altclantags["taglist"][$clantagkey] = $oldlist["taglist"][$clantagkey];
				$this->altclantags[$clantagkey]["name"] = $oldlist["taglist"][$clantagkey];
				$this->altclantags[$clantagkey]["count"] = $count;
			}
		}
	}
}

function microtime_float() {
   list($usec, $sec) = explode(" ", microtime());
   return ((float)$usec + (float)$sec);
}

?>