<?xml version="1.0" encoding="iso-8859-1"?>
<!DOCTYPE xsl:stylesheet  [ 
     <!ENTITY nbsp   "&#160;"> 
     <!ENTITY copy   "&#169;"> 
     <!ENTITY reg    "&#174;"> 
     <!ENTITY trade  "&#8482;"> 
     <!ENTITY mdash  "&#8212;"> 
     <!ENTITY ldquo  "&#8220;"> 
     <!ENTITY rdquo  "&#8221;">  
     <!ENTITY pound  "&#163;"> 
     <!ENTITY yen    "&#165;"> 
     <!ENTITY euro   "&#8364;"> 
     <!ENTITY raquo     "&#187;"> 
]>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">
    <html>
    <head>
    <meta http-equiv="content-type" content="text/html; charset=ISO-8859-2" />
    <title>Q4MaxXSL</title>
    <script language="javascript">
<!--
function ToggleDisplayBlock(elementID)
                    {
                       
                        var element = document.getElementById(elementID);

                        if (element.style.display == 'none')
                        {
                            element.style.display = 'block';
                        }
                        else
                        {
							element.style.display = 'none';
                        }
                    }


-->
</script>
    <link href="../../../basics/styl.css" type="text/css" rel="stylesheet" />
    </head>
    <body onLoad="parent.processFilter(this)">
	<div align="center">
    <a name="top"></a>
    <xsl:for-each select="match">
      <table cellpadding="0" cellspacing="0" class="tableScoreboard">
        <tr>
          <td align="center" colspan="2"><br />
            <div align="left"><span class="stats_title_big">Information</span></div>
            <table cellpadding="0" cellspacing="5" class="tablePlayerScore" style="width:90%; background:none;">
              <tr>
                <td width="80%" colspan="2"><span class="stats_title"><span class="i-title">&raquo;&#160;</span>Match-Details</span></td>
              </tr>
              <tr>
                <td width="80%" colspan="2"><span class="stats_title">Time: </span><span id="filterdatetime" class="stats_title" style="font-weight:normal;"><xsl:value-of select="@datetime" /></span></td>
              </tr>
			  <tr>
                <td width="80%" colspan="2"><span class="stats_title">Date: </span><span id="filterdatetime_date" class="stats_title" style="font-weight:normal;">&#160;</span></td>
              </tr>
              <tr>
                <td width="80%" colspan="2"><span class="stats_title">Map: <font style="font-weight:normal;"><xsl:value-of select="@map" /></font></span> </td>
              </tr>
              <tr>
                <td width="80%" colspan="2"><xsl:variable name="teamgame">
                  <xsl:choose>
                    <xsl:when test="@isTeamGame = 'true'">
                      <xsl:value-of select="'Teamgame, '" />
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="''" />
                    </xsl:otherwise>
                  </xsl:choose>
                  </xsl:variable>
                  <span class="stats_title">Gametype: <font style="font-weight:normal;"><xsl:value-of select="$teamgame" /><xsl:value-of select="@type" /></font></span> </td>
              </tr>
              <tr>
                <td width="80%" colspan="2"><span class="stats_title">Server: <font style="font-weight:normal;"><xsl:value-of select="@server" /></font></span> </td>
              </tr>
              <tr>
                <td width="80%" colspan="2"><xsl:choose>
                    <xsl:when test="@isTeamGame = 'true'">
                      <br />
                      <span class="stats_title"><span class="i-title">&raquo;&#160;</span>Showing <xsl:value-of select="count(Team)" /> teams:</span>
                    </xsl:when>
                    <xsl:otherwise>
                      <br />
                      <span class="stats_title"><span class="i-title">&raquo;&#160;</span>Showing <xsl:value-of select="count(player)" /> players:</span>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </tr>
            </table></td>
        </tr>
        <tr>
          <xsl:choose>
            <xsl:when test="@isTeamGame = 'true'">
              <!-- 
			LISTING FOR TEAMGAMES
			//////////////////////
			//////////////////////
			-->
              <xsl:for-each select="Team">
                <td align="center"><table cellpadding="0" cellspacing="5" class="tableTeamScore">
                    <tr>
                      <td width="80%"><p class="teamName"> <xsl:value-of select="@name" /> </p></td>
                      <td width="20%"><p class="teamScore"> <xsl:value-of select="@score" /> </p></td>
                    </tr>
                    <xsl:for-each select="player">
                      <xsl:sort select="number(stat[@name='Score']/@value)" data-type="number" order="descending" />
                      <!-- get correct suicides value-->
                      <xsl:variable name="suicides">
                      <xsl:choose>
                        <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                          <xsl:value-of select="0" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="stat[@name='Suicides']/@value" />
                        </xsl:otherwise>
                      </xsl:choose>
                      </xsl:variable>
                      <!-- set dtaken/dgiven to 0 if empty -->
                      <xsl:variable name="dtaken">
                      <xsl:choose>
                        <xsl:when test="string(0 - stat[@name='Damage Taken']/@value) = 'NaN'">
                          <xsl:value-of select="none" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="stat[@name='Damage Taken']/@value" />
                        </xsl:otherwise>
                      </xsl:choose>
                      </xsl:variable>
                      <xsl:variable name="dgiven">
                      <xsl:choose>
                        <xsl:when test="string(0 - stat[@name='Damage Given']/@value) = 'NaN'">
                          <xsl:value-of select="none" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="stat[@name='Damage Given']/@value" />
                        </xsl:otherwise>
                      </xsl:choose>
                      </xsl:variable>
                      <xsl:variable name="dnet">
                      <xsl:choose>
                        <xsl:when test="string($dgiven - $dtaken) = 'NaN'">
                          <xsl:value-of select="'none'" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="$dgiven - $dtaken" />
                        </xsl:otherwise>
                      </xsl:choose>
                      </xsl:variable>
                      <!-- CALCULATE NETTO FOR PLAYER, EVIL STATEMACHINE -->
                      <xsl:variable name="netto">
                      <xsl:choose>
                        <xsl:when test="string(0 - stat[@name='Kills']/@value) = 'NaN'">
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Deaths']/@value) = 'NaN'">
                              <xsl:choose>
                                <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                                  <xsl:value-of select="0" />
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="0 - stat[@name='Suicides']/@value" />
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:choose>
                                <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                                  <xsl:value-of select="0 - stat[@name='Deaths']/@value" />
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="0 - stat[@name='Suicides']/@value - stat[@name='Deaths']/@value" />
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Deaths']/@value) = 'NaN'">
                              <xsl:choose>
                                <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                                  <xsl:value-of select="stat[@name='Kills']/@value" />
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Suicides']/@value" />
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:choose>
                                <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                                  <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Deaths']/@value" />
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Suicides']/@value - stat[@name='Deaths']/@value" />
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:otherwise>
                      </xsl:choose>
                      </xsl:variable>
                      <tr>
                        <td><a href="#{@name}" id="filterme" target="_self"><img src="../../../basics/arrdown.gif" /> &#160;<span class="matchPlayer" id="filterme"><xsl:value-of select="@name" /></span>
                          </a></td>
                        <td><p class="matchScore"><xsl:value-of select="number(stat[@name='Score']/@value)" /></p></td>
                      </tr>
                      <tr>
                        <td colspan="2"><table style="table-layout:fixed;width:100%" cellpadding="0" cellspacing="0">
                            <tr>
                              <td align="left"><p class="matchMinor"> DNET: <xsl:value-of select="$dnet" /> </p></td>
                              <td align="left"><p class="matchMinor" style="margin-left:25px;"> NET: <xsl:value-of select="$netto" /> </p></td>
                            </tr>
                          </table></td>
                      </tr>
                    </xsl:for-each>
                  </table>
                  <br />
                </td>
              </xsl:for-each>
            </xsl:when>
          </xsl:choose>
        </tr>
        <xsl:choose>
          <xsl:when test="@isTeamGame = 'true'">
            <!-- 
			LISTING FOR TEAMGAMES ->
            PLAYERS
            //////////////////////
            //////////////////////
            -->
            <tr>
              <td colspan="2"><xsl:for-each select="Team">
                  <span class="stats_title_big"> <xsl:value-of select="@name" />-Details </span>
                  <xsl:for-each select="player">
                    <xsl:sort select="number(stat[@name='Score']/@value)" data-type="number" order="descending" />
                    <table class="tablePlayer" cellpadding="0" cellspacing="0">
                      <xsl:apply-templates select="." />
                      
                    </table>
                    <br />
                    <div align="right"><a href="#top"><img src="../../../basics/arrup.gif" />&#160;
                      <span class="returnup">Return to Matchinformation</span>
                      </a></div>
                    <br />
                    <br />
                    <br />
                    <br />
                  </xsl:for-each>
                  <br />
                  <br />
                </xsl:for-each>
              </td>
            </tr>
          </xsl:when>
          <xsl:otherwise>
            <!-- 
			LISTING FOR DMGAMES
			//////////////////////
			//////////////////////
			-->
            <tr>
              <td align="center" colspan="2"><table width="90%">
                  <tr>
                    <td><table cellpadding="0" cellspacing="5" class="tablePlayerScore">
                        <tr>
                          <td width="50%"><p class="teamName"> <xsl:value-of select="@name" /> </p></td>
                          <td width="50%"><p class="teamScore"> <xsl:value-of select="@score" /> </p></td>
                        </tr>
                        <xsl:for-each select="player">
                          <xsl:sort select="number(stat[@name='Score']/@value)" data-type="number" order="descending" />
                          <!-- get correct suicides value-->
                          <xsl:variable name="suicides">
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                              <xsl:value-of select="0" />
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="stat[@name='Suicides']/@value" />
                            </xsl:otherwise>
                          </xsl:choose>
                          </xsl:variable>
                          <!-- CALCULATE NETTO FOR PLAYER, EVIL STATEMACHINE -->
                          <xsl:variable name="netto">
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Kills']/@value) = 'NaN'">
                              <xsl:choose>
                                <xsl:when test="string(0 - stat[@name='Deaths']/@value) = 'NaN'">
                                  <xsl:choose>
                                    <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                                      <xsl:value-of select="0" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:value-of select="0 - stat[@name='Suicides']/@value" />
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:choose>
                                    <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                                      <xsl:value-of select="0 - stat[@name='Deaths']/@value" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:value-of select="0 - stat[@name='Suicides']/@value - stat[@name='Deaths']/@value" />
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:choose>
                                <xsl:when test="string(0 - stat[@name='Deaths']/@value) = 'NaN'">
                                  <xsl:choose>
                                    <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                                      <xsl:value-of select="stat[@name='Kills']/@value" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Suicides']/@value" />
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:choose>
                                    <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                                      <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Deaths']/@value" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Suicides']/@value - stat[@name='Deaths']/@value" />
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:otherwise>
                          </xsl:choose>
                          </xsl:variable>
                          <!-- set dtaken/dgiven to 0 if empty -->
                          <xsl:variable name="dtaken">
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Damage Taken']/@value) = 'NaN'">
                              <xsl:value-of select="'-'" />
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="stat[@name='Damage Taken']/@value" />
                            </xsl:otherwise>
                          </xsl:choose>
                          </xsl:variable>
                          <xsl:variable name="dgiven">
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Damage Given']/@value) = 'NaN'">
                              <xsl:value-of select="'-'" />
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="stat[@name='Damage Given']/@value" />
                            </xsl:otherwise>
                          </xsl:choose>
                          </xsl:variable>
                          <xsl:variable name="dnet">
                          <xsl:choose>
                            <xsl:when test="string($dgiven - $dtaken) = 'NaN'">
                              <xsl:value-of select="'-'" />
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="$dgiven - $dtaken" />
                            </xsl:otherwise>
                          </xsl:choose>
                          </xsl:variable>
                          <tr>
                            <td width="20%"><a href="#{@name}" id="filterme"><img src="../../../basics/arrdown.gif" />
                              &#160;<span class="matchPlayer" id="filterme"><xsl:value-of select="@name" /></span>
                              </a></td>
                            <td width="20%"><p class="matchScore"><xsl:value-of select="stat[@name='Score']/@value" /></p></td>
                          </tr>
                          <tr>
                            <td colspan="2"><table style="table-layout:fixed;width:100%" cellpadding="0" cellspacing="0">
                                <tr>
                                  <td align="left" width="100%"><p class="matchMinor"> DNET: <xsl:value-of select="$dnet" /> </p></td>
                                  <td align="left" width="100%"><p class="matchMinor" style="margin-left:25px;"> NET: <xsl:value-of select="$netto" /> </p></td>
                                </tr>
                              </table></td>
                          </tr>
                        </xsl:for-each>
                      </table></td>
                    <td> ... </td>
                  </tr>
                </table></td>
            </tr>
            <tr>
              <td colspan="2"><br />
                <br />
                <div align="left"><span class="stats_title_big">Player-Details</span></div>
                <xsl:for-each select="player">
                  <table class="tablePlayer" cellpadding="0" cellspacing="0">
                    <xsl:apply-templates select="." />
                    
                  </table>
                  <div align="right"><a href="#top"><img src="../../../basics/arrup.gif" />&#160;
                    <p class="returnup">Return to Matchinformation</p>
                    </a></div>
                  <br />
                  <br />
                </xsl:for-each>
              </td>
            </tr>
          </xsl:otherwise>
        </xsl:choose>
      </table>
    </xsl:for-each>
	  </div>
    </body>
    </html>
  </xsl:template>
  <xsl:template match="player">
    <tr><a name="{@name}" id="filterme"></a>
      <td width="100%"><table cellpadding="0" cellspacing="0" width="90%" align="center">
          <tr>
            <td><p class="tabHeader"><span class="i-title">&raquo;&#160;</span><span class="stats_title">Playerinfo / Weapons</span></p>
              <table border="0" cellpadding="0" cellspacing="0" class="playerInfo">
                <tr>
                  <td width="80%"><span class="playerName_red_big" id="filterme"><xsl:value-of select="@name" />&#160;</span></td>
                  <td rowspan="4" width="20%" class="playerScoreTab"><p class="playerScore"><xsl:value-of select="stat[@name='Score']/@value" /></p>
                    </td>
                </tr>
                <xsl:variable name="clan">
                <xsl:choose>
                  <xsl:when test="@clan = ''">
                    <xsl:value-of select="'no clan'" />
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@clan" />
                  </xsl:otherwise>
                </xsl:choose>
                </xsl:variable>
                <tr>
                  <td><span class="playerClan" id="filterme"><xsl:value-of select="$clan" />&#160;</span></td>
                </tr>
                <tr>
                  <td><p class="playerGUID">ingame:<xsl:value-of select="@name" />&#160;</p></td>
                </tr>
                <xsl:variable name="guid">
                <xsl:choose>
                  <xsl:when test="@guid = ''">
                    <xsl:value-of select="'none'" />
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@guid" />
                  </xsl:otherwise>
                </xsl:choose>
                </xsl:variable>
                <tr>
                  <td><p class="playerGUID">GuID:<xsl:value-of select="$guid" />&#160;</p></td>
                </tr>
              </table></td>
            <td><p class="tabHeader"><span class="i-title">&raquo;&#160;</span><span class="stats_title">Statistics / </span><span class="stats_title">Awards</span></p>
              <table class="tableStats_right_dark" cellpadding="0" cellspacing="0">
                <tr>
                  <td><p class="statName">Kills</p></td>
                  <td><p class="statName">Deaths</p></td>
                  <td><p class="statName">Suicides</p></td>
                  <td><p class="statName">NET</p></td>
                </tr>
                <tr>
                  <td><p class="number"><xsl:value-of select="stat[@name='Kills']/@value" /></p></td>
                  <td><p class="number"><xsl:value-of select="stat[@name='Deaths']/@value" /></p></td>
                  <xsl:variable name="suicides">
                  <xsl:choose>
                    <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                      <xsl:value-of select="0" />
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="stat[@name='Suicides']/@value" />
                    </xsl:otherwise>
                  </xsl:choose>
                  </xsl:variable>
                  <td><p class="number"><xsl:value-of select="$suicides" /></p></td>
                  <!-- CALCULATE NETTO FOR PLAYER, EVIL STATEMACHINE -->
                  <xsl:variable name="netto">
                  <xsl:choose>
                    <xsl:when test="string(0 - stat[@name='Kills']/@value) = 'NaN'">
                      <xsl:choose>
                        <xsl:when test="string(0 - stat[@name='Deaths']/@value) = 'NaN'">
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                              <xsl:value-of select="0" />
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="0 - stat[@name='Suicides']/@value" />
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                              <xsl:value-of select="0 - stat[@name='Deaths']/@value" />
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="0 - stat[@name='Suicides']/@value - stat[@name='Deaths']/@value" />
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:choose>
                        <xsl:when test="string(0 - stat[@name='Deaths']/@value) = 'NaN'">
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                              <xsl:value-of select="stat[@name='Kills']/@value" />
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Suicides']/@value" />
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:choose>
                            <xsl:when test="string(0 - stat[@name='Suicides']/@value) = 'NaN'">
                              <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Deaths']/@value" />
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="stat[@name='Kills']/@value - stat[@name='Suicides']/@value - stat[@name='Deaths']/@value" />
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:otherwise>
                  </xsl:choose>
                  </xsl:variable>
                  <td><p class="number"><xsl:value-of select="$netto" /></p></td>
                  <!-- TODO: Efficeincy
				<td><p class="number">
					<xsl:choose>
						<xsl:when test="stat[@name='Deaths'] = 0">
							100%
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="(round (stat[@name='Kills']/@value div stat[@name='Deaths']/@value * 10000)) div 100" /> %
						</xsl:otherwise>
					</xsl:choose>
				</p></td>
				-->
                </tr>
                <tr>
                  <td><p class="statName">DGiven</p></td>
                  <td><p class="statName">DTaken</p></td>
                  <td><p class="statName">&#160;</p></td>
                  <td><p class="statName">DNET</p></td>
                </tr>
                <tr>
                  <!-- set dtaken/dgiven to 0 if empty -->
                  <xsl:variable name="dtaken">
                  <xsl:choose>
                    <xsl:when test="string(0 - stat[@name='Damage Taken']/@value) = 'NaN'">
                      <xsl:value-of select="'-'" />
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="stat[@name='Damage Taken']/@value" />
                    </xsl:otherwise>
                  </xsl:choose>
                  </xsl:variable>
                  <xsl:variable name="dgiven">
                  <xsl:choose>
                    <xsl:when test="string(0 - stat[@name='Damage Given']/@value) = 'NaN'">
                      <xsl:value-of select="'-'" />
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="stat[@name='Damage Given']/@value" />
                    </xsl:otherwise>
                  </xsl:choose>
                  </xsl:variable>
                  <!-- CALCULATE NETTO FOR PLAYER, EVIL STATEMACHINE -->
                  <xsl:variable name="dnetto">
                  <xsl:choose>
                    <xsl:when test="string(0 - stat[@name='Damage Given']/@value) = 'NaN'">
                      <xsl:choose>
                        <xsl:when test="string(0 - stat[@name='Damage Taken']/@value) = 'NaN'">
                          <xsl:value-of select="'-'" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="0 - stat[@name='Damage Taken']/@value" />
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:choose>
                        <xsl:when test="string(0 - stat[@name='Damage Taken']/@value) = 'NaN'">
                          <xsl:value-of select="stat[@name='Damage Given']/@value" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="stat[@name='Damage Given']/@value - stat[@name='Damage Taken']/@value" />
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:otherwise>
                  </xsl:choose>
                  </xsl:variable>
                  <td><p class="number"><xsl:value-of select="$dgiven" /></p></td>
                  <td><p class="number"><xsl:value-of select="$dtaken" /></p></td>
                  <td><p class="statName">&#160;</p></td>
                  <td><p class="number"><xsl:value-of select="$dnetto" /></p></td>
                </tr>
              </table></td>
          </tr>
          <tr>
            <td class="tdRight"><table class="tableWeapons" cellpadding="0" cellspacing="0">
                <tr>
                  <td><p class="statName_left">Weapon</p></td>
                  <td><p class="statName">Hits</p></td>
                  <td><p class="statName">Shots</p></td>
                  <td><p class="statName">Acc</p></td>
                </tr>
                <xsl:for-each select="weapons/weapon">
                  <tr>
                    <!-- weaponname filtering -->
                    <xsl:variable name="wpnname">
                    <xsl:choose>
                      <xsl:when test="@name = 'Dark Matter Gun'">
                        <xsl:value-of select="'DMG'" />
                      </xsl:when>
                      <xsl:when test="@name = 'Rocket Launcher'">
                        <xsl:value-of select="'RL'" />
                      </xsl:when>
                      <xsl:when test="@name = 'Lightning Gun'">
                        <xsl:value-of select="'LG'" />
                      </xsl:when>
                      <xsl:when test="@name = 'Grenade Launcher'">
                        <xsl:value-of select="'GL'" />
                      </xsl:when>
                      <xsl:when test="@name = 'Gauntlet'">
                        <xsl:value-of select="'Pummel'" />
                      </xsl:when>
                      <xsl:when test="@name = 'Machinegun'">
                        <xsl:value-of select="'MG'" />
                      </xsl:when>
                      <xsl:when test="@name = 'Shotgun'">
                        <xsl:value-of select="'SG'" />
                      </xsl:when>
                      <xsl:when test="@name = 'HyperBlaster'">
                        <xsl:value-of select="'HB'" />
                      </xsl:when>
                      <xsl:when test="@name = 'Nailgun'">
                        <xsl:value-of select="'NG'" />
                      </xsl:when>
                      <xsl:when test="@name = 'Railgun'">
                        <xsl:value-of select="'RG'" />
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="@name" />
                      </xsl:otherwise>
                    </xsl:choose>
                    </xsl:variable>
                    <td><p class="weaponName"><img src="../../../basics/weapons/{@name}.gif" />&nbsp;<xsl:value-of select="$wpnname" /></p></td>
                    <td><p class="number"><xsl:value-of select="@hits" /></p></td>
                    <td><p class="number"><xsl:value-of select="@shots" /></p></td>
                    <td style="padding-right:5px"><p class="number">
                        <xsl:apply-templates select="." /></p></td>
                  </tr>
                </xsl:for-each>
              </table></td>
            <td><table class="tableAwards" cellpadding="0" cellspacing="0" name="checkheight" height="100%">
                <xsl:variable name="awardcount"><xsl:value-of select="count(awards/Award) + count(awards/award)" /></xsl:variable>
                <xsl:if test="$awardcount &gt; 0">
                  <tr>
                    <td width="50%"><p class="statName_left">Award</p></td>
                    <td width="50%"><p class="statName_right">Count</p></td>
                  </tr>
                  <xsl:for-each select="awards/Award">
                    <tr>
                      <td width="50%"><p class="statName_left"><img src="../../../basics/awards/{@name}.gif" />&nbsp;<xsl:value-of select="@name" /></p></td>
                      <td width="50%"><p class="number"><xsl:value-of select="@value" /></p></td>
                    </tr>
                  </xsl:for-each>
                  <xsl:for-each select="awards/award">
                    <tr>
                      <td width="50%"><p class="statName_left"><img src="../../../basics/awards/{@name}.gif" />&nbsp;<xsl:value-of select="@name" /></p></td>
                      <td width="50%"><p class="number"><xsl:value-of select="@value" /></p></td>
                    </tr>
                  </xsl:for-each>
                </xsl:if>
                <xsl:if test="$awardcount = 0">
                  <tr>
                    <td><p class="statName_left">No awards gained</p></td>
                  </tr>
                </xsl:if>
              </table></td>
          </tr>
        </table></td>
    </tr>
    <tr>
      <td></td>
    </tr>
  </xsl:template>
  <xsl:template match="weapon">
    <xsl:if test="@shots > 0">
      <xsl:value-of select="(round (@hits div @shots * 10000)) div 100" />%
    </xsl:if>
    <xsl:if test="@shots &lt; 1">
---                                          &#160;&#160;
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
