"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeParser = initializeParser;
const Parser = require("web-tree-sitter");
const _global = global;
function initializeParser() {
    return __awaiter(this, void 0, void 0, function* () {
        if (_global.fetch) {
            // NOTE: temporary workaround for emscripten node 18 support.
            // emscripten is used for compiling tree-sitter to wasm.
            // https://github.com/emscripten-core/emscripten/issues/16915
            delete _global.fetch;
        }
        yield Parser.init();
        const parser = new Parser();
        /**
         * See https://github.com/tree-sitter/tree-sitter/tree/master/lib/binding_web#generate-wasm-language-files
         *
         * To compile and use a new tree-sitter-bash version:
         *    sh scripts/upgrade-tree-sitter.sh
         */
        const lang = yield Parser.Language.load(`${__dirname}/../tree-sitter-bash.wasm`);
        parser.setLanguage(lang);
        return parser;
    });
}
//# sourceMappingURL=parser.js.map