/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.File;
import java.util.MissingResourceException;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlCaller;
import org.perl.inline.java.InlineJavaPerlException;
import org.perl.inline.java.InlineJavaServer;
import org.perl.inline.java.InlineJavaUtils;

public class InlineJavaPerlInterpreter
extends InlineJavaPerlCaller {
    private static boolean inited = false;
    static InlineJavaPerlInterpreter instance = null;
    static boolean test = false;
    static String libperl_so = "";

    protected InlineJavaPerlInterpreter() throws InlineJavaPerlException, InlineJavaException {
        InlineJavaPerlInterpreter.init();
        InlineJavaUtils.debug(2, "constructing perl interpreter");
        InlineJavaPerlInterpreter.construct();
        InlineJavaUtils.debug(2, "perl interpreter constructed");
        if (!libperl_so.equals("")) {
            InlineJavaPerlInterpreter.evalNoReturn("require DynaLoader ;");
            InlineJavaPerlInterpreter.evalNoReturn("DynaLoader::dl_load_file(\"" + libperl_so + "\", 0x01) ;");
        }
        if (test) {
            InlineJavaPerlInterpreter.evalNoReturn("use blib ;");
        }
        InlineJavaPerlInterpreter.evalNoReturn("use Inline::Java::PerlInterpreter ;");
    }

    public static synchronized InlineJavaPerlInterpreter create() throws InlineJavaPerlException, InlineJavaException {
        if (instance == null) {
            InlineJavaUtils.debug(2, "creating temporary JNI InlineJavaServer");
            InlineJavaServer.jni_main(InlineJavaUtils.get_debug(), false);
            InlineJavaUtils.debug(2, "temporary JNI InlineJavaServer created");
            InlineJavaUtils.debug(2, "creating InlineJavaPerlInterpreter");
            instance = new InlineJavaPerlInterpreter();
            InlineJavaUtils.debug(2, "InlineJavaPerlInterpreter created");
        }
        return instance;
    }

    protected static synchronized void init() throws InlineJavaException {
        InlineJavaPerlInterpreter.init("install");
    }

    protected static synchronized void init(String mode) throws InlineJavaException {
        InlineJavaPerlCaller.init();
        if (!inited) {
            test = mode.equals("test");
            try {
                String perlinterpreter_so = InlineJavaPerlInterpreter.GetBundle().getString("inline_java_perlinterpreter_so_" + mode);
                File f = new File(perlinterpreter_so);
                if (!f.exists()) {
                    throw new InlineJavaException("Can't initialize PerlInterpreter functionnality: PerlInterpreter extension (" + perlinterpreter_so + ") can't be found");
                }
                InlineJavaUtils.debug(2, "loading shared library " + perlinterpreter_so);
                System.load(perlinterpreter_so);
                InlineJavaUtils.debug(2, "shared library " + perlinterpreter_so + " loaded");
                libperl_so = InlineJavaPerlInterpreter.GetBundle().getString("inline_java_libperl_so");
                inited = true;
            }
            catch (MissingResourceException mre) {
                throw new InlineJavaException("Error loading InlineJava.properties resource: " + mre.getMessage());
            }
        }
    }

    private static synchronized native void construct();

    private static synchronized native void evalNoReturn(String var0) throws InlineJavaPerlException;

    private static synchronized native void destruct();

    public static synchronized void destroy() {
        if (instance != null) {
            InlineJavaPerlInterpreter.destruct();
            instance = null;
        }
    }
}

