.\" auto generated by yuck -*- nroff -*-
.TH DATEGREP "1" "January 2016" "dateutils 0.3.5" "User Commands"
.SH NAME
dategrep - Grep standard input for lines that match EXPRESSION.
.SH SYNOPSIS
.B dategrep
[\fIOPTION\fR]... EXPRESSION
.SH DESCRIPTION
Grep standard input for lines that match EXPRESSION.

EXPRESSION may be date/times prefixed with an operator `<', `<=', `=', `>=',
`>', `!=', `<>' (if omitted defaults to `='),
which will match lines with date/times which are older, older-equal, equal,
newer-equal, newer, or not equal respectively.

EXPRESSION may also be format specifiers infixed by above operators
and suffixed by a value (e.g. `%a="Wed"') which matches lines whose
%a representation (weekday name abbreviated) is "Wed".

EXPRESSION may be statements as described above concatenated through `&&' (for
conjunction) or `||' (disjunction), both of which may be parenthesised as per
usual to change precedence (`&&' goes over `||').

If multiple date/times occur on the same line and any one of them fulfills the
criteria then the line is considered a match and will be output.

Note:
  Operations can be specified by options (--eq, --gt, ...) as well.
  This serves solely as a means of convenience, e.g. the datetest tool has a
  similar syntax.

.PP

Recognized \fIOPTION\fRs:
.TP
.B   \fB-h\fR, \fB--help
Print help and exit
.TP
.B   \fB-V\fR, \fB--version
Print version and exit
.TP
.B   \fB-q\fR, \fB--quiet
Suppress message about date/time and duration
parser errors.
.TP
.B   \fB-i\fR, \fB--input-format\fR=\fISTRING\fR...
Input format, can be used multiple times.
Each date/time will be passed to the input
format parsers in the order they are given, if a
date/time can be read successfully with a given
input format specifier string, that value will
be used.
.TP
.B   \fB-b\fR, \fB--base\fR=\fIDT
For underspecified input use DT as a fallback to
fill in missing fields.  Also used for ambiguous
format specifiers to position their range on the
absolute time line.
Must be a date/time in ISO8601 format.
If omitted defaults to the current date/time.
.TP
.B   \fB-e\fR, \fB--backslash-escapes
Enable interpretation of backslash escapes in the
output and input format specifier strings.
.TP
.B   \fB-o\fR, \fB--only-matching
Show only the part of a line matching DATE.
.TP
.B   \fB-v\fR, \fB--invert-match
Select non-matching lines.
.TP
.B       \fB--from-zone\fR=\fIZONE
Consider date/times on stdin as coming from the
zone ZONE, default: UTC.
.TP
.B   \fB-z\fR, \fB--zone\fR=\fIZONE
Consider date/times in EXPRESSION as coming from
the zone ZONE, default: UTC.
.TP
.B       \fB--eq
Lines match when date/times are equal to
EXPRESSION.
.TP
.B       \fB--ne
Lines match when date/times are not the same as
EXPRESSION.
.TP
.B       \fB--gt
Lines match when date/times are newer than
EXPRESSION.
.TP
.B       \fB--lt
Lines match when date/times are older than
EXPRESSION.
.TP
.B       \fB--ge
Lines match when date/times are newer than or
equal EXPRESSION.
.TP
.B       \fB--le
Lines match when date/times are older than or
equal EXPRESSION.
.TP
.B       \fB--nt
Lines match when date/times are newer than or
equal EXPRESSION.
.TP
.B       \fB--ot
Lines match when date/times are older than or
equal EXPRESSION.
.SH FORMAT SPECS
.PP
Format specs in dateutils are similar to posix' strftime().
.PP
However, due to a broader range of supported calendars dateutils must
employ different rules.
.PP
Date specs:
.nf
  %a  The abbreviated weekday name
  %A  The full weekday name
  %_a The weekday name shortened to a single character (MTWRFAS)
  %b  The abbreviated month name
  %B  The full month name
  %_b The month name shortened to a single character (FGHJKMNQUVXZ)
  %c  The count of the weekday within the month (range 00 to 05)
  %C  The count of the weekday within the year (range 00 to 53)
  %d  The day of the month, 2 digits (range 00 to 31)
  %D  The day of the year, 3 digits (range 000 to 366)
  %F  Equivalent to %Y-%m-%d (ymd's canonical format)
  %j  Equivalent to %D
  %m  The month in the current calendar (range 00 to 19)
  %Q  The quarter of the year (range Q1 to Q4)
  %q  The number of the quarter (range 01 to 04)
  %s  The number of seconds since the Epoch.
  %u  The weekday as number (range 01 to 07, Sunday being 07)
  %U  The week count,  day of week is Sun (range 00 to 53)
  %V  The ISO week count,  day of week is Mon (range 01 to 53)
  %w  The weekday as number (range 00 to 06, Sunday being 00)
  %W  The week count,  day of week is Mon (range 00 to 53)
  %y  The year without a century (range 00 to 99)
  %Y  The year including the century
  %_y The year shortened to a single digit
  %Z  The zone offset in hours and minutes (HH:MM) with
      a preceding sign (+ for offsets east of UTC, - for offsets
      west of UTC)
.fi
.PP
.nf
  %Od The day as roman numerals
  %Om The month as roman numerals
  %Oy The two digit year as roman numerals
  %OY The year including the century as roman numerals
.fi
.PP
.nf
  %rs In time systems whose Epoch is different from the unix Epoch, this
      selects the number of seconds since then.
  %rY In calendars with years that don't coincide with the Gregorian
      years, this selects the calendar's year.
.fi
.PP
.nf
  %dth  The day of the month as an ordinal number, 1st, 2nd, 3rd, etc.
  %mth  The month of the year as an ordinal number, 1st, 2nd, 3rd, etc.
.fi
.PP
.nf
  %db The business day of the month (since last month's ultimo)
  %dB Number of business days until this month's ultimo
.fi
.PP
Time specs:
.nf
  %H  The hour of the day using a 24h clock, 2 digits (range 00 to 23)
  %I  The hour of the day using a 12h clock, 2 digits (range 01 to 12)
  %M  The minute (range 00 to 59)
  %N  The nanoseconds (range 000000000 to 999999999)
  %p  The string AM or PM, noon is PM and midnight is AM.
  %P  Like %p but in lowercase
  %S  The  (range 00 to 60, 60 is for leap seconds)
  %T  Equivalent to %H:%M:%S
.fi
.PP
General specs:
.nf
  %n  A newline character
  %t  A tab character
  %%  A literal % character
.fi
.PP
Modifiers:
.nf
  %O  Modifier to turn decimal numbers into Roman numerals
  %r  Modifier to turn units into real units
  th  Suffix, read and print ordinal numbers
  b   Suffix, treat days as business days
.fi
.PP
By design dates before 1601-01-01 are not supported.
.PP
For conformity here is a list of calendar designators and their
corresponding format string:
.nf
  ymd     %Y-%m-%d
  ymcw    %Y-%m-%c-%w
  ywd     %rY-W%V-%u
  bizda   %Y-%m-%db
  lilian     n/a
  ldn        n/a
  julian     n/a
  jdn        n/a
.fi
.PP
These designators can be used as output format string, moreover,
@code{lilian}/@code{ldn} and @code{julian}/@code{jdn} can also be used
as input format string.

.SH EXAMPLES
.PP
.nf
  $ dategrep 2012-03-01 <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-03-01
  $
.fi
.PP
.nf
  $ dategrep '<2012-03-01' <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-02-28
  2012-02-29
  $
.fi
.PP
.nf
  $ dategrep \\!=2012-03-01 <<EOF
  2012-02-28
  2012-02-29
  2012-03-01
  2012-03-02
  EOF
  2012-02-28
  2012-02-29
  2012-03-02
  $
.fi
.PP
.nf
  $ dategrep =2012-03-01 <<EOF
  Feb	2012-02-28
  Feb	2012-02-29	leap day
  Mar	2012-03-01
  Mar	2012-03-02
  EOF
  Mar	2012-03-01
  $
.fi
.PP
.nf
  $ dategrep -o \\<2012-03-01 <<EOF
  Feb	2012-02-28
  Feb	2012-02-29	leap day
  Mar	2012-03-01
  Mar	2012-03-02
  EOF
  2012-02-28
  2012-02-29
  $
.fi
.PP
.nf
  $ dategrep '>=12:00:00' <<EOF
  fileA	11:59:58
  fileB	11:59:59	leap ?
  fileNOON	12:00:00	new version
  fileC	12:03:12
  EOF
  fileNOON	12:00:00	new version
  fileC	12:03:12
  $
.fi
.PP
.nf
  $ dategrep -o '>=12:00:00' <<EOF
  fileA	11:59:58
  fileB	11:59:59	leap ?
  fileNOON	12:00:00	new version
  fileC	12:03:12
  EOF
  12:00:00
  12:03:12
  $
.fi
.PP
.nf
  $ dategrep 2012-03-01 <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-03-01T10:00:00
  $
.fi
.PP
.nf
  $ dategrep '<2012-03-01' <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  $
.fi
.PP
.nf
  $ dategrep 2012-03-01T10:00:00 <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-03-01T10:00:00
  $
.fi
.PP
.nf
  $ dategrep '<2012-03-01T14:00:00' <<EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  2012-03-02T10:00:00
  EOF
  2012-02-28T10:00:00
  2012-02-29T10:00:00
  2012-03-01T10:00:00
  $
.fi
.PP

.SH AUTHOR
Written by Sebastian Freundt <freundt@fresse.org>
.PP
.SH REPORTING BUGS
Report bugs to: https://github.com/hroptatyr/dateutils/issues
.PP



.SH "SEE ALSO"
The full documentation for
.B dategrep
is maintained as a Texinfo manual.  If the
.B info
and
.B dategrep
programs are properly installed at your site, the command
.IP
.B info (dateutils)dategrep
.PP
should give you access to the complete manual.
.\" yuck.m4man ends here
