/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.16
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/accel.h>

        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
    wxAcceleratorTable* _wxAcceleratorTable_ctor(PyObject* entries)
    {
        const char* errmsg = "Expected a sequence of 3-tuples or wx.AcceleratorEntry objects.";
        if (!PySequence_Check(entries)) {
            PyErr_SetString(PyExc_TypeError, errmsg);
            return NULL;
        }
        int count = PySequence_Size(entries);
        wxAcceleratorEntry* tmpEntries = new wxAcceleratorEntry[count];
        if (! tmpEntries) {
            PyErr_SetString(PyExc_MemoryError, "Unable to allocate temporary array");
            return NULL;
        }
        int idx;
        for (idx=0; idx<count; idx++) {
            PyObject* obj = PySequence_ITEM(entries, idx);
            if (sipCanConvertToType(obj, sipType_wxAcceleratorEntry, SIP_NO_CONVERTORS)) {
                int err = 0;
                wxAcceleratorEntry* entryPtr = reinterpret_cast<wxAcceleratorEntry*>(
                    sipConvertToType(obj, sipType_wxAcceleratorEntry, NULL, 0, 0, &err));
                tmpEntries[idx] = *entryPtr;
            }
            else if (PySequence_Check(obj) && PySequence_Size(obj) == 3) {
                PyObject* o1 = PySequence_ITEM(obj, 0);
                PyObject* o2 = PySequence_ITEM(obj, 1);
                PyObject* o3 = PySequence_ITEM(obj, 2);
                tmpEntries[idx].Set(wxPyInt_AsLong(o1), wxPyInt_AsLong(o2), wxPyInt_AsLong(o3));
                Py_DECREF(o1);
                Py_DECREF(o2);
                Py_DECREF(o3);
            }
            else {
                PyErr_SetString(PyExc_TypeError, errmsg);
                return NULL;
            }
            Py_DECREF(obj);
        }
        
        wxAcceleratorTable* table = new wxAcceleratorTable(count, tmpEntries);
        delete [] tmpEntries;
        return table;
    }


PyDoc_STRVAR(doc_wxAcceleratorTable_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the accelerator table is valid.");

extern "C" {static PyObject *meth_wxAcceleratorTable_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxAcceleratorTable_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxAcceleratorTable *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAcceleratorTable, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_AcceleratorTable, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxAcceleratorTable(void *, const sipTypeDef *);}
static void *cast_wxAcceleratorTable(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxAcceleratorTable *sipCpp = reinterpret_cast< ::wxAcceleratorTable *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAcceleratorTable(void *, int);}
static void release_wxAcceleratorTable(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxAcceleratorTable *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxAcceleratorTable(void *, SIP_SSIZE_T, void *);}
static void assign_wxAcceleratorTable(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxAcceleratorTable *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxAcceleratorTable *>(sipSrc);
}


extern "C" {static void *array_wxAcceleratorTable(SIP_SSIZE_T);}
static void *array_wxAcceleratorTable(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxAcceleratorTable[sipNrElem];
}


extern "C" {static void *copy_wxAcceleratorTable(const void *, SIP_SSIZE_T);}
static void *copy_wxAcceleratorTable(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxAcceleratorTable(reinterpret_cast<const  ::wxAcceleratorTable *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxAcceleratorTable(sipSimpleWrapper *);}
static void dealloc_wxAcceleratorTable(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAcceleratorTable(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxAcceleratorTable(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxAcceleratorTable(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxAcceleratorTable *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAcceleratorTable();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        PyObject * entries;

        static const char *sipKwdList[] = {
            sipName_entries,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "P0", &entries))
        {
        PyErr_Clear();
        sipCpp = _wxAcceleratorTable_ctor(entries);

            return sipCpp;
        }
    }

    {
        const  ::wxAcceleratorTable* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxAcceleratorTable, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxAcceleratorTable(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxAcceleratorTable[] = {{358, 255, 1}};


static PyMethodDef methods_wxAcceleratorTable[] = {
    {SIP_MLNAME_CAST(sipName_IsOk), meth_wxAcceleratorTable_IsOk, METH_VARARGS, SIP_MLDOC_CAST(doc_wxAcceleratorTable_IsOk)}
};

PyDoc_STRVAR(doc_wxAcceleratorTable, "AcceleratorTable()\n"
"AcceleratorTable(entries)\n"
"\n"
"An accelerator table allows the application to specify a table of\n"
"keyboard shortcuts for menu or button commands.");


sipClassTypeDef sipTypeDef__core_wxAcceleratorTable = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxAcceleratorTable,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_AcceleratorTable,
        {0, 0, 1},
        1, methods_wxAcceleratorTable,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxAcceleratorTable,
    -1,
    -1,
    supers_wxAcceleratorTable,
    SIP_NULLPTR,
    init_type_wxAcceleratorTable,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxAcceleratorTable,
    assign_wxAcceleratorTable,
    array_wxAcceleratorTable,
    copy_wxAcceleratorTable,
    release_wxAcceleratorTable,
    cast_wxAcceleratorTable,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
