typedef struct {
	gchar *fname;
	int start;
} EmbFile;

EmbFile emb_index[11] = {
	{"sqlite_specs_add_column.xml", 0},
	{"sqlite_specs_create_db.xml", 941},
	{"sqlite_specs_create_index.xml", 1378},
	{"sqlite_specs_create_table.xml", 3504},
	{"sqlite_specs_create_view.xml", 5739},
	{"sqlite_specs_drop_db.xml", 6442},
	{"sqlite_specs_drop_index.xml", 6847},
	{"sqlite_specs_drop_table.xml", 7179},
	{"sqlite_specs_drop_view.xml", 7510},
	{"sqlite_specs_dsn.xml", 7834},
	{"sqlite_specs_rename_table.xml", 9275}
};

gchar *emb_string="<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <parameters id=\"COLUMN_DEF_P\" name=\"Column's description\">\n"
"    <parameter id=\"TABLE_NAME\" name=\"Table\" descr=\"Table's name\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"    <parameter id=\"COLUMN_NAME\" name=\"Field name\" gdatype=\"gchararray\" nullok=\"FALSE\">\n"
"      <gda_value>column_name</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"COLUMN_TYPE\" name=\"Data type\" gdatype=\"gchararray\" hint=\"datatype\" nullok=\"FALSE\">\n"
"      <gda_value>integer</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"COLUMN_SIZE\" name=\"Size\" gdatype=\"guint\"/>\n"
"    <parameter id=\"COLUMN_SCALE\" name=\"Scale\" gdatype=\"guint\"/>\n"
"    <parameter id=\"COLUMN_NNUL\" name=\"Not NULL\" gdatype=\"gboolean\"/>\n"
"    <parameter id=\"COLUMN_DEFAULT\" name=\"Default\" descr=\"Default value, mandatory if column is NOT NULL\" gdatype=\"gchararray\"/>\n"
"    <parameter id=\"COLUMN_CHECK\" name=\"Check\" descr=\"Check constraint\" gdatype=\"gchararray\"/>\n"
"  </parameters>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <!-- DSN parameters -->\n"
"  <parameters id=\"DB_DEF_P\" name=\"Database's description\">\n"
"    <parameter id=\"DB_NAME\" name=\"Database name\" descr=\"The name of a database to create\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"    <parameter id=\"DB_DIR\" name=\"Directory\" descr=\"Directory where the database file will be\" gdatype=\"gchararray\" nullok=\"FALSE\" plugin=\"filesel:MODE=PICKFOLDER\"/>\n"
"  </parameters>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <parameters id=\"INDEX_DEF_P\" name=\"Index description\">\n"
"    <parameter id=\"INDEX_TYPE\" name=\"Type\" gdatype=\"gchararray\" source=\"types:0\">\n"
"      <gda_value>UNIQUE</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"INDEX_NAME\" name=\"Name\" descr=\"Index name\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"    <parameter id=\"INDEX_ON_TABLE\" name=\"On table\" gdatype=\"gchararray\" nullok=\"FALSE\" source=\"_DICT_TABLES_\"/>\n"
"    <parameter id=\"INDEX_IFNOTEXISTS\" name=\"Only if it does not yet exist\" descr=\"Create index only if it does not yet exist\" gdatype=\"gboolean\">\n"
"      <gda_value>FALSE</gda_value>\n"
"    </parameter>\n"
"  </parameters>\n"
"\n"
"  <!-- Index fields -->\n"
"  <sequence id=\"INDEX_FIELDS_S\" name=\"Indexed field(s)\" minitems=\"1\" maxitems=\"3\">\n"
"    <parameter id=\"INDEX_FIELD\" name=\"Indexed field or expression\" gdatype=\"gchararray\" nullok=\"FALSE\" source=\"_INDEX_ON_TABLE/DICT_FIELDS_\">\n"
"      <gda_value>indexed_field</gda_value>\n"
"    </parameter>\n"
"    <!-- To translators: \"Compare method\" refers to the method SQLite has to compare values -->\n"
"    <parameter id=\"INDEX_COLLATE\" name=\"Compare method\" descr=\"Collation name (BINARY|NOCASE)\" gdatype=\"gchararray\"/>\n"
"    <parameter id=\"INDEX_SORT_ORDER\" name=\"Sort type\" gdatype=\"gchararray\" source=\"sort:0\"/>\n"
"  </sequence>\n"
"\n"
"  <!-- Sources -->\n"
"  <sources>\n"
"    <gda_array name=\"sort\">\n"
"      <gda_array_field name=\"id\" gdatype=\"gchararray\"/>\n"
"      <gda_array_field name=\"text\" gdatype=\"gchararray\"/>\n"
"      <gda_array_data>\n"
"        <gda_array_row>\n"
"          <gda_value>ASC</gda_value>\n"
"          <gda_value>Ascending</gda_value>\n"
"        </gda_array_row>\n"
"        <gda_array_row>\n"
"          <gda_value>DESC</gda_value>\n"
"          <gda_value>Descending</gda_value>\n"
"        </gda_array_row>\n"
"      </gda_array_data>\n"
"    </gda_array>\n"
"\n"
"    <gda_array name=\"types\">\n"
"      <gda_array_field name=\"id\" gdatype=\"gchararray\"/>\n"
"      <gda_array_field name=\"text\" gdatype=\"gchararray\"/>\n"
"      <gda_array_data>\n"
"	<gda_array_row>\n"
"          <gda_value>UNIQUE</gda_value>\n"
"          <gda_value>Unique</gda_value>\n"
"	</gda_array_row>\n"
"      </gda_array_data>\n"
"    </gda_array>\n"
"  </sources>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <parameters id=\"TABLE_DEF_P\" name=\"Table's description\">\n"
"    <parameter id=\"TABLE_NAME\" name=\"Name\" descr=\"Table's name\" gdatype=\"gchararray\" nullok=\"FALSE\">\n"
"      <gda_value>table_name</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"TABLE_TEMP\" name=\"Temporary table\" gdatype=\"gboolean\">\n"
"      <gda_value>FALSE</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"TABLE_IFNOTEXISTS\" name=\"Only if it does not yet exist\" descr=\"Create table only if it does not yet exist\" gdatype=\"gboolean\">\n"
"      <gda_value>FALSE</gda_value>\n"
"    </parameter>\n"
"  </parameters>\n"
"\n"
"  <!-- list of fields -->\n"
"  <gda_array id=\"FIELDS_A\" name=\"Table's columns\">\n"
"    <gda_array_field id=\"COLUMN_NAME\" name=\"Field name\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"    <gda_array_field id=\"COLUMN_TYPE\" name=\"Data type\" gdatype=\"gchararray\" hint=\"datatype\" nullok=\"FALSE\"/>\n"
"    <gda_array_field id=\"COLUMN_SIZE\" name=\"Size\" gdatype=\"guint\"/>\n"
"    <gda_array_field id=\"COLUMN_SCALE\" name=\"Scale\" gdatype=\"guint\"/>\n"
"    <gda_array_field id=\"COLUMN_NNUL\" name=\"Not NULL\" gdatype=\"gboolean\"/>\n"
"    <gda_array_field id=\"COLUMN_AUTOINC\" name=\"Auto increment\" gdatype=\"gboolean\"/>\n"
"    <gda_array_field id=\"COLUMN_UNIQUE\" name=\"Unique\" gdatype=\"gboolean\"/>\n"
"    <gda_array_field id=\"COLUMN_PKEY\" name=\"Primary key\" gdatype=\"gboolean\"/>\n"
"    <gda_array_field id=\"COLUMN_DEFAULT\" name=\"Default\" descr=\"Default value\" gdatype=\"gchararray\"/>\n"
"    <gda_array_field id=\"COLUMN_CHECK\" name=\"Check\" descr=\"Check constraint\" gdatype=\"gchararray\"/>\n"
"    <!-- To translators: \"Compare method\" refers to the method SQLite has to compare values -->\n"
"    <gda_array_field id=\"COLUMN_COLLATE\" name=\"Compare method\" descr=\"Collation name (BINARY|NOCASE)\" gdatype=\"gchararray\"/>\n"
"    <gda_array_field id=\"COLUMN_CONFLICT\" name=\"Conflict\" descr=\"Conflict resolution method (ROLLBACK|ABORT|FAIL|IGNORE|REPLACE)\" gdatype=\"gchararray\"/>\n"
"  </gda_array>\n"
"\n"
"  <!-- foreign key spec: not supported by SQLite -->\n"
"\n"
"  <!-- other table constraints -->\n"
"  <sequence id=\"TABLE_CONSTRAINTS_S\" name=\"Global constraints\">\n"
"    <parameter id=\"CONSTRAINT_STRING\" name=\"Constraint\" gdatype=\"gchararray\">\n"
"      <gda_value>CHECK (column &gt; 0)</gda_value>\n"
"    </parameter>\n"
"  </sequence>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <parameters id=\"VIEW_DEF_P\" name=\"View's description\">\n"
"    <parameter id=\"VIEW_NAME\" name=\"Name\" descr=\"View's name\" gdatype=\"gchararray\" nullok=\"FALSE\">\n"
"      <gda_value>table_name</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"VIEW_TEMP\" name=\"Temporary view\" gdatype=\"gboolean\">\n"
"      <gda_value>FALSE</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"VIEW_IFNOTEXISTS\" name=\"Only if it does not yet exist\" descr=\"Create view only if it does not yet exist\" gdatype=\"gboolean\">\n"
"      <gda_value>FALSE</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"VIEW_DEF\" name=\"Definition\" descr=\"View's definition\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"  </parameters>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <!-- DSN parameters -->\n"
"  <parameters id=\"DB_DESC_P\" name=\"Database's description\">\n"
"    <parameter id=\"DB_NAME\" name=\"Database name\" descr=\"The name of a database to create\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"    <parameter id=\"DB_DIR\" name=\"Directory\" descr=\"Directory where the database file will be\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"  </parameters>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <parameters id=\"INDEX_DESC_P\">\n"
"    <parameter id=\"INDEX_NAME\" name=\"Index\" descr=\"Index to delete\" gdatype=\"gchararray\" nullok=\"FALSE\" source=\"_DICT_INDEXES_\"/>\n"
"    <parameter id=\"INDEX_IFEXISTS\" name=\"If exists\" descr=\"Drop index only if it exists\" gdatype=\"gboolean\"/>\n"
"  </parameters>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <parameters id=\"TABLE_DESC_P\">\n"
"    <parameter id=\"TABLE_NAME\" name=\"Table\" descr=\"Table to delete\" gdatype=\"gchararray\" nullok=\"FALSE\" source=\"_DICT_TABLES_\"/>\n"
"    <parameter id=\"TABLE_IFEXISTS\" name=\"If exists\" descr=\"Drop table only if it exists\" gdatype=\"gboolean\"/>\n"
"  </parameters>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <parameters id=\"VIEW_DESC_P\">\n"
"    <parameter id=\"VIEW_NAME\" name=\"View\" descr=\"View to delete\" gdatype=\"gchararray\" nullok=\"FALSE\" source=\"_DICT_VIEWS_\"/>\n"
"    <parameter id=\"VIEW_IFEXISTS\" name=\"If exists\" descr=\"Drop view only if it exists\" gdatype=\"gboolean\"/>\n"
"  </parameters>\n"
"</serv_op>\0<?xml version=\"1.0\"?>\n"
"<data-set-spec>\n"
"  <parameters>\n"
"    <parameter id=\"DB_NAME\" name=\"Database name\" descr=\"The name of a database to use (without the .db)\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"    <parameter id=\"APPEND_DB_EXTENSION\" name=\"Append '.db'\" descr=\"Defines if the '.db' extension need to be appended to the DB_NAME argument\" gdatype=\"gchararray\" nullok=\"TRUE\"/>\n"
"    <parameter id=\"DB_DIR\" name=\"Directory\" descr=\"Directory where the database file is stored\" gdatype=\"gchararray\" nullok=\"FALSE\" plugin=\"filesel:MODE=PICKFOLDER\"/>\n"
"    <parameter id=\"EXTRA_FUNCTIONS\" name=\"Extra functions\" descr=\"Enable usage of extra functions (gda_upper, ...)\" gdatype=\"gboolean\" nullok=\"TRUE\">\n"
"      <gda_value>TRUE</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"REGEXP\" name=\"Define REGEXP\" descr=\"Define the REGEXP function\" gdatype=\"gboolean\" nullok=\"TRUE\">\n"
"      <gda_value>TRUE</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"EXTRA_COLLATIONS\" name=\"Localized comparisons\" descr=\"Enable usage of extra collation methods (LOCALE and DCASE)\" gdatype=\"gboolean\" nullok=\"TRUE\">\n"
"      <gda_value>TRUE</gda_value>\n"
"    </parameter>\n"
"    <parameter id=\"FK\" name=\"With foreign keys\" descr=\"Enforce foreign keys\" gdatype=\"gboolean\" nullok=\"TRUE\"/>\n"
"    <parameter id=\"EXTENSIONS\" name=\"Allow extensions\" descr=\"Allow SQLite to load extensions using the load_extension() function\" gdatype=\"gboolean\" nullok=\"TRUE\"/>\n"
"  </parameters>\n"
"</data-set-spec>\0<?xml version=\"1.0\"?>\n"
"<serv_op>\n"
"  <parameters id=\"TABLE_DESC_P\">\n"
"    <parameter id=\"TABLE_NAME\" name=\"Table\" descr=\"Table to rename\" gdatype=\"gchararray\" nullok=\"FALSE\" source=\"_DICT_TABLES_\"/>\n"
"    <parameter id=\"TABLE_NEW_NAME\" name=\"New name\" descr=\"New table name\" gdatype=\"gchararray\" nullok=\"FALSE\"/>\n"
"  </parameters>\n"
"</serv_op>\0";

static const gchar *
emb_get_file (const gchar *fname)
{
	gint i;
	for (i = 0; i < 11; i++) {
		EmbFile *efile = &(emb_index[i]);
		if (!strcmp (efile->fname, fname))
			return (emb_string + efile->start);
	}
	return NULL;
}

