#---------------------------------------------------------------------------
# Name:        etg/withimage.py
# Author:      Robin Dunn
#
# Created:     9-Sept-2011
# Copyright:   (c) 2011 by Wide Open Technologies
# Copyright:   (c) 2011-2017 by Total Control Software
# License:     wxWindows License
#---------------------------------------------------------------------------

import etgtools
import etgtools.tweaker_tools as tools

PACKAGE   = "wx"
MODULE    = "_core"
NAME      = "withimage"   # Base name of the file to generate to for this script
DOCSTRING = ""

# The classes and/or the basename of the Doxygen XML files to be processed by
# this script.
ITEMS  = [ 'wxWithImages' ]

#---------------------------------------------------------------------------

def run():
    # Parse the XML file(s) building a collection of Extractor objects
    module = etgtools.ModuleDef(PACKAGE, MODULE, NAME, DOCSTRING, False)
    etgtools.parseDoxyXML(module, ITEMS)

    #-----------------------------------------------------------------
    # Tweak the parsed meta objects in the module object as needed for
    # customizing the generated code and docstrings.

    c = module.find('wxWithImages')
    c.addPrivateCopyCtor()
    c.addPrivateAssignOp()

    c.find('AssignImageList.imageList').transfer = True

    module.addItem(etgtools.DefineDef(name='NO_IMAGE', value='-1'))
    module.addCppCode("#define NO_IMAGE wxWithImages::NO_IMAGE")

    #-----------------------------------------------------------------
    tools.doCommonTweaks(module)
    tools.runGenerators(module)


#---------------------------------------------------------------------------
if __name__ == '__main__':
    run()

