Welcome to wxWidgets, a free and open source cross-platform C++ framework for writing advanced GUI applications using native controls.

wxWidgets 3.1.4 is the latest release in the 3.1 development branch. This release is a "development" one as it makes (very few) incompatible API changes compared to 3.0 and does not guarantee the ABI stability, unlike the 3.0.x series. It is not inherently more buggy or less stable than the "stable" releases and you're encouraged to use it, including in production. If you're already using 3.0, upgrading shouldn't require any special effort, so please try it out.

Please see [**README**](https://raw.githubusercontent.com/wxWidgets/wxWidgets/v3.1.4/docs/readme.txt) for more information about this release and the [change log](https://raw.githubusercontent.com/wxWidgets/wxWidgets/v3.1.4/docs/changes.txt) for more details of the changes in it.


## Source Files and Documentation

If you intend to build wxWidgets from sources (which is recommended), please do **NOT** download the files using the "Source code" links just above, which are automatically generated by GitHub and don't contain the submodules sources which are necessary for building wxWidgets.

Instead, download one of [wxWidgets-3.1.4.zip](https://github.com/wxWidgets/wxWidgets/releases/download/v3.1.4/wxWidgets-3.1.4.zip) or [wxWidgets-3.1.4.7z](https://github.com/wxWidgets/wxWidgets/releases/download/v3.1.4/wxWidgets-3.1.4.7z), for much smaller size, for Microsoft Windows systems or [wxWidgets-3.1.4.tar.bz2](https://github.com/wxWidgets/wxWidgets/releases/download/v3.1.4/wxWidgets-3.1.4.tar.bz2) for Unix ones, including macOS. These archives have exactly the same contents, but use the line endings appropriate for the corresponding platform.

In addition, we provide archives containing the documentation in either HTML or Microsoft CHM formats. Notice that the documentation is also [available online](https://docs.wxwidgets.org/3.1.4).

Finally, Microsoft Windows users may download [Setup.exe file](https://github.com/wxWidgets/wxWidgets/releases/download/v3.1.4/wxMSW-3.1.4-Setup.exe) containing both sources and documentation, however please note that this file does _not_ contain any binaries, please see below for those.

To verify your download please use the following SHA-1 checksums:

    7e19253507156efc61dd8657af798177717775fe  wxMSW-3.1.4-Setup.exe
    d5c642b4adfc413270172deeb807474a129c52fd  wxWidgets-3.1.4-docs-chm.zip
    6d769104a4d8cad7f3e028c6b022f3a850ba99e0  wxWidgets-3.1.4-docs-html.tar.bz2
    445063cbd8e11085b78d8c33e21ba65b54b68fdd  wxWidgets-3.1.4-docs-html.zip
    fe15946b9aacd469586edfe89afac51b3d750209  wxWidgets-3.1.4-headers.7z
    f5eed3129a7cfa9e462e5d3029673b6d87267efd  wxWidgets-3.1.4.7z
    f8c77e6336b5f6414b07e27baa489fb8abc620c4  wxWidgets-3.1.4.tar.bz2
    be1ec2cc03a97682f96e2fb8a50ac7ebf52d6a8d  wxWidgets-3.1.4.zip

## Binaries

We provide pre-built binary files for the following compilers:

* Microsoft Visual C++ compiler versions 9.0, 10.0, 11.0, 12.0, 14.0, 14.1 and 14.2 (corresponding to marketing product names of Microsoft Visual Studio 2008, 2010, 2012, 2013, 2015, 2017 and 2019 respectively). Please note that MSVC 14.x versions are ABI-compatible and the same set of binaries is used for all of them.
* MinGW-w64 versions 7.3 and 8.1 (32-bit binaries use SJLJ exceptions, 64-bit ones use SEH, and all binaries use Win32 threads).
* [TDM-GCC](https://jmeubank.github.io/tdm-gcc/) 9.2.0.

### For Developers

For developing applications with wxWidgets you need to download the compiler-independent `wxWidgets-3.1.4_Headers.7z` file and one of `wxMSW-3.1.4-vcXXX_Dev.7z` or `wxMSW-3.1.4_gccXXX_Dev.7z` files depending on your compiler, its version and the target architecture (x86 if not specified or x64).

Unpack both files into the same directory so that `include` and `lib` directories are at the same level after unpacking. You should be able to compile and link applications using wxWidgets in both debug and release modes but the debug symbols are provided only for debug libraries in this archive, see below for the release build debug symbols.

Note that if you're setting up a new project using these binaries, the simplest
way to do it is to use the provided `wxwidgets.props` file: for this, open the
`View|Property Manager` menu item in the IDE, select "Add Existing Property
Sheet..." from the project context menu and browse to this file in the file
open dialog.

### For End Users

End users may download one of `wxMSW-3.1.4_vcXXX_ReleaseDLL.7z` or `wxMSW-3.1.4_gccXXX_ReleaseDLL.7z` files to get just the DLLs required for running the applications using wxWidgets.

### For Debugging

* Microsoft Visual C++ users: Files `wxMSW-3.1.4_vcXXX_ReleasePDB.7z` contain the debug symbols for the release build of the DLLs. Download them if you want to debug your own applications in release build or if you want to get meaningful information from mini-dumps retrieved from your users machines.
* MinGW-TDM users: Currently the debug symbols are not available for the release build of the DLLs (only the debug versions of the DLLs contains the debug symbols).

### Binary File Download Verification

To verify your download please use the following SHA-1 checksums:

    6a79e7c4356dd8c5b5d687de2f87f583d71f2c2a wxMSW-3.1.4_gcc730_Dev.7z
    8dcb3c582c09d680581f913661784c785c90fa6c wxMSW-3.1.4_gcc730_ReleaseDLL.7z
    2d9c0268c856157c90da95d11ef499cb8bba0ac3 wxMSW-3.1.4_gcc730_x64_Dev.7z
    5f218e7897210c5422e2b9e088b67ba0842dd272 wxMSW-3.1.4_gcc730_x64_ReleaseDLL.7z
    965c3c7429ab21ded9f0fc89d38459423b890107 wxMSW-3.1.4_gcc810_Dev.7z
    a9ce630504da31761bcce2b23108c8190b25005a wxMSW-3.1.4_gcc810_ReleaseDLL.7z
    9c560cb05d6f3ee05a2879192eee82d062cb52e0 wxMSW-3.1.4_gcc810_x64_Dev.7z
    946a5cee45a24d4a50c0cd2c2515524406049e08 wxMSW-3.1.4_gcc810_x64_ReleaseDLL.7z
    da39a3ee5e6b4b0d3255bfef95601890afd80709 wxMSW-3.1.4_gcc920TDM_Dev.7z
    d6af63b5691609f64e8a1281336c908be8385460 wxMSW-3.1.4_gcc920TDM_Dev.7z.part
    1c9ae729f3e4785c1e11a2e6bb44882c22612217 wxMSW-3.1.4_gcc920TDM_ReleaseDLL.7z
    9254447e7ec8b5d73296db901c3745ce42651842 wxMSW-3.1.4_gcc920TDM_x64_Dev.7z
    5b2d57889e55b4f61457b2ac501f61e3756b67ec wxMSW-3.1.4_gcc920TDM_x64_ReleaseDLL.7z
    55ec77bc8b66302b44103b766cf00068659da913 wxMSW-3.1.4_vc90_Dev.7z
    1933b9b471ae2916e00af615ff18ee341b69646b wxMSW-3.1.4_vc90_ReleaseDLL.7z
    f51347d78dbdb68cef0f063f50a2f0782d50c275 wxMSW-3.1.4_vc90_ReleasePDB.7z
    4e8d0ea573d50db624d611add06beaa9b4b6a1d1 wxMSW-3.1.4_vc90_x64_Dev.7z
    fde90dae3f86303dcc7ff80aa7f6287851f5e179 wxMSW-3.1.4_vc90_x64_ReleaseDLL.7z
    7d8cd56de140e86457307d801c561dfaa72f0ede wxMSW-3.1.4_vc90_x64_ReleasePDB.7z
    9668414a32464940df0dcb6d5022b77efe45807a wxMSW-3.1.4_vc100_Dev.7z
    561570696849d513e0b950f9922e1b487f5b37ce wxMSW-3.1.4_vc100_ReleaseDLL.7z
    917c359d7e659162c739664b4b0cc9099f3fc612 wxMSW-3.1.4_vc100_ReleasePDB.7z
    dc895929385d4ef57288703afc801ca4d5925fc4 wxMSW-3.1.4_vc100_x64_Dev.7z
    596300c3122e1888646ac890d5a21b9be64cd2fc wxMSW-3.1.4_vc100_x64_ReleaseDLL.7z
    f1f7e5850d29b1f24fbe26e606723b3e4fa0082b wxMSW-3.1.4_vc100_x64_ReleasePDB.7z
    99f3651d1857f4580347cf941de0bc440586e3b9 wxMSW-3.1.4_vc110_Dev.7z
    63279dfbbf614274e8dd7101ab210c2a5caa9ab1 wxMSW-3.1.4_vc110_ReleaseDLL.7z
    9bbcab032f3c5fc90bd841f4585a4e7d292285eb wxMSW-3.1.4_vc110_ReleasePDB.7z
    3c00a218c2044efc54ea25102858ca67563cbbcd wxMSW-3.1.4_vc110_x64_Dev.7z
    f69c86dc4840d1ecc0d35db0ef0e9137894dae6f wxMSW-3.1.4_vc110_x64_ReleaseDLL.7z
    4462b101aa5371fae26e5c0a776ccb5028c9e954 wxMSW-3.1.4_vc110_x64_ReleasePDB.7z
    a631c1e4ebb6cc12d76584ac27364f0905678fb9 wxMSW-3.1.4_vc120_Dev.7z
    d29b3a699357516de2f1af06fc718f0d58139fe6 wxMSW-3.1.4_vc120_ReleaseDLL.7z
    84093a3b358a47efeab9a5788834eeeb1dc1d1d7 wxMSW-3.1.4_vc120_ReleasePDB.7z
    0a9e1a8818176646f618372ca2a55093c346745b wxMSW-3.1.4_vc120_x64_Dev.7z
    28f5f4dc8768e111f8485b4cf11435b78038f027 wxMSW-3.1.4_vc120_x64_ReleaseDLL.7z
    a7e9f285f15bf4091364f1e81511f8a51c13f0bf wxMSW-3.1.4_vc120_x64_ReleasePDB.7z
    53ca996900a1174b1ef3fb1449cac16de69ad32e wxMSW-3.1.4_vc14x_Dev.7z
    e5276f1d1eb92e40c107097e3ac6835ca434ba98 wxMSW-3.1.4_vc14x_ReleaseDLL.7z
    55d5503078d8fcf0338d757b5493125f9a4f5567 wxMSW-3.1.4_vc14x_ReleasePDB.7z
    33da2620195dc261147f4f7dfb7fe01bb46884e2 wxMSW-3.1.4_vc14x_x64_Dev.7z
    442c7ae5121c29f6718e703e1673268d2737c16b wxMSW-3.1.4_vc14x_x64_ReleaseDLL.7z
    dc7cd62c853f1253b7f0ecacf7d69887af593951 wxMSW-3.1.4_vc14x_x64_ReleasePDB.7z


## Reporting Problems

Please report bugs to the [issue tracker](https://trac.wxwidgets.org/newticket) or the [wx-users mailing list](http://groups.google.com/group/wx-users).
