;; $Id: dbl1de.dsl,v 1.1.1.2 1999/06/28 08:53:21 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; Contributors:
;; Rainer Feuerstein, fire@informatik.uni-wuerzburg.de,
;; Christian Leutloff, leutloff@sundancer.oche.de
;; Ulrich Windl, Ulrich.Windl@rz.uni-regensburg.de
;; Christian Kirsch, ck@held.mind.de
;; Joerg Wittenberger, Joerg.Wittenberger@pobox.com

(define (de-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "&Appendix; namens %t"))

(define (de-article-xref-string gi-or-name)
  (string-append %gentext-de-start-quote%
		 "%t"
		 %gentext-de-end-quote%))

(define (de-bibliography-xref-string gi-or-name)
  "%t")

(define (de-book-xref-string gi-or-name)
  "%t")

(define (de-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "&Chapter; namens %t"))

(define (de-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (de-example-xref-string gi-or-name)
  "&Example; %n")

(define (de-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (de-glossary-xref-string gi-or-name)
  "%t")

(define (de-index-xref-string gi-or-name)
  "%t")

(define (de-listitem-xref-string gi-or-name)
  "%n")

(define (de-part-xref-string gi-or-name)
  "&Part; %n")

(define (de-preface-xref-string gi-or-name)
  "%t")

(define (de-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (de-reference-xref-string gi-or-name)
  "&Reference; %n, %t")

(define (de-sectioning-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "&Section; namens %t"))

(define (de-section-xref-string gi-or-name)
  (de-sectioning-xref-string gi-or-name))

(define (de-sect1-xref-string gi-or-name)
  (de-sectioning-xref-string gi-or-name))

(define (de-sect2-xref-string gi-or-name)
  (de-sectioning-xref-string gi-or-name))

(define (de-sect3-xref-string gi-or-name)
  (de-sectioning-xref-string gi-or-name))

(define (de-sect4-xref-string gi-or-name)
  (de-sectioning-xref-string gi-or-name))

(define (de-sect5-xref-string gi-or-name)
  (de-sectioning-xref-string gi-or-name))

(define (de-sidebar-xref-string gi-or-name)
  "&Sidebar; %t")

(define (de-step-xref-string gi-or-name)
  "&Step; %n")

(define (de-table-xref-string gi-or-name)
  "&Table; %n")

(define (de-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				"wird &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-de-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (de-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (de-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (de-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (de-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (de-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (de-equation-xref-string gind))
      ((equal? name (normalize "example"))  (de-example-xref-string gind))
      ((equal? name (normalize "figure"))   (de-figure-xref-string gind))
      ((equal? name (normalize "glossary")) (de-glossary-xref-string gind))
      ((equal? name (normalize "index"))    (de-index-xref-string gind))
      ((equal? name (normalize "listitem")) (de-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (de-part-xref-string gind))
      ((equal? name (normalize "preface"))  (de-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (de-procedure-xref-string gind))
      ((equal? name (normalize "reference")) (de-reference-xref-string gind))
      ((equal? name (normalize "section"))   (de-section-xref-string gind))
      ((equal? name (normalize "sect1"))    (de-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (de-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (de-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (de-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (de-sect5-xref-string gind))
      ((equal? name (normalize "sidebar"))  (de-sidebar-xref-string gind))
      ((equal? name (normalize "step"))     (de-step-xref-string gind))
      ((equal? name (normalize "table"))    (de-table-xref-string gind))
      (else (de-default-xref-string gind)))))

(define (de-auto-xref-indirect-connector before) 
  ;; In German one usually says "... in dem Buch ..." (probably because
  ;; it's a larger piece of work and more commonly known)
  (cond 
   ((equal? (gi before) (normalize "book"))
    (literal " &in; dem "))
   ((equal? (gi before) (normalize "chapter"))
    (literal " &in; "))
   ((equal? (gi before) (normalize "sect1"))
    (literal " &in; "))
   (else
    (literal " &in; "))))

;; Should the TOC come first or last?
;;
(define %generate-de-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define de-abstract-name	"&Abstract;")
(define de-appendix-name	"&Appendix;")
(define de-article-name	"&Article;")
(define de-bibliography-name	"&Bibliography;")
(define de-book-name		"&Book;")
(define de-calloutlist-name   "")
(define de-caution-name	"&Caution;")
(define de-chapter-name	"&Chapter;")
(define de-copyright-name	"&Copyright;")
(define de-dedication-name	"&Dedication;")
(define de-edition-name	"&Edition;")
(define de-equation-name	"&Equation;")
(define de-example-name	"&Example;")
(define de-figure-name	"&Figure;")
(define de-glossary-name	"&Glossary;")
(define de-glosssee-name	"&GlossSee;")
(define de-glossseealso-name	"&GlossSeeAlso;")
(define de-important-name	"&Important;")
(define de-index-name		"&Index;")
(define de-setindex-name	"&SetIndex;")
(define de-isbn-name		"&ISBN;")
(define de-legalnotice-name	"")
(define de-msgaud-name	"&MsgAud;")
(define de-msglevel-name	"&MsgLevel;")
(define de-msgorig-name	"&MsgOrig;")
(define de-note-name		"&Note;")
(define de-part-name		"&Part;")
(define de-preface-name	"&Preface;")
(define de-procedure-name	"&Procedure;")
(define de-pubdate-name	"&Published;")
(define de-reference-name	"&Reference;")
(define de-refname-name	"&RefName;")
(define de-revhistory-name	"&RevHistory;")
(define de-refsect1-name      "&RefSection;")
(define de-refsect2-name      "&RefSection;")
(define de-refsect3-name      "&RefSection;")
(define de-refsynopsisdiv-name      "&RefSynopsisDiv;")
(define de-revision-name	"&Revision;")
(define de-section-name		"&Section;")
(define de-sect1-name		"&Section;")
(define de-sect2-name		"&Section;")
(define de-sect3-name		"&Section;")
(define de-sect4-name		"&Section;")
(define de-sect5-name		"&Section;")
(define de-simplesect-name	"&Section;")
(define de-seeie-name		"&See;")
(define de-seealsoie-name	"&Seealso;")
(define de-set-name		"&Set;")
(define de-sidebar-name	"&Sidebar;")
(define de-step-name		"&step;")
(define de-table-name		"&Table;")
(define de-tip-name		"&Tip;")
(define de-toc-name		"&TableofContents;")
(define de-warning-name	"&Warning;")

(define (gentext-de-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	de-abstract-name)
     ((equal? name (normalize "appendix"))	de-appendix-name)
     ((equal? name (normalize "article"))	de-article-name)
     ((equal? name (normalize "bibliography"))	de-bibliography-name)
     ((equal? name (normalize "book"))		de-book-name)
     ((equal? name (normalize "calloutlist"))	de-calloutlist-name)
     ((equal? name (normalize "caution"))	de-caution-name)
     ((equal? name (normalize "chapter"))	de-chapter-name)
     ((equal? name (normalize "copyright"))	de-copyright-name)
     ((equal? name (normalize "dedication"))	de-dedication-name)
     ((equal? name (normalize "edition"))	de-edition-name)
     ((equal? name (normalize "equation"))	de-equation-name)
     ((equal? name (normalize "example"))	de-example-name)
     ((equal? name (normalize "figure"))	de-figure-name)
     ((equal? name (normalize "glossary"))	de-glossary-name)
     ((equal? name (normalize "glosssee"))	de-glosssee-name)
     ((equal? name (normalize "glossseealso"))	de-glossseealso-name)
     ((equal? name (normalize "important"))	de-important-name)
     ((equal? name (normalize "index"))		de-index-name)
     ((equal? name (normalize "setindex"))	de-setindex-name)
     ((equal? name (normalize "isbn"))		de-isbn-name)
     ((equal? name (normalize "legalnotice"))	de-legalnotice-name)
     ((equal? name (normalize "msgaud"))	de-msgaud-name)
     ((equal? name (normalize "msglevel"))	de-msglevel-name)
     ((equal? name (normalize "msgorig"))	de-msgorig-name)
     ((equal? name (normalize "note"))		de-note-name)
     ((equal? name (normalize "part"))		de-part-name)
     ((equal? name (normalize "preface"))	de-preface-name)
     ((equal? name (normalize "procedure"))	de-procedure-name)
     ((equal? name (normalize "pubdate"))	de-pubdate-name)
     ((equal? name (normalize "reference"))	de-reference-name)
     ((equal? name (normalize "refname"))	de-refname-name)
     ((equal? name (normalize "revhistory"))	de-revhistory-name)
     ((equal? name (normalize "refsect1"))	de-refsect1-name)
     ((equal? name (normalize "refsect2"))	de-refsect2-name)
     ((equal? name (normalize "refsect3"))	de-refsect3-name)
     ((equal? name (normalize "refsynopsisdiv"))	de-refsynopsisdiv-name)
     ((equal? name (normalize "revision"))	de-revision-name)
     ((equal? name (normalize "section"))	de-section-name)
     ((equal? name (normalize "sect1"))		de-sect1-name)
     ((equal? name (normalize "sect2"))		de-sect2-name)
     ((equal? name (normalize "sect3"))		de-sect3-name)
     ((equal? name (normalize "sect4"))		de-sect4-name)
     ((equal? name (normalize "sect5"))		de-sect5-name)
     ((equal? name (normalize "simplesect"))	de-simplesect-name)
     ((equal? name (normalize "seeie"))		de-seeie-name)
     ((equal? name (normalize "seealsoie"))	de-seealsoie-name)
     ((equal? name (normalize "set"))		de-set-name)
     ((equal? name (normalize "sidebar"))	de-sidebar-name)
     ((equal? name (normalize "step"))		de-step-name)
     ((equal? name (normalize "table"))		de-table-name)
     ((equal? name (normalize "tip"))		de-tip-name)
     ((equal? name (normalize "toc"))		de-toc-name)
     ((equal? name (normalize "warning"))	de-warning-name)
     (else (let* ((msg (string-append
			"gentext-de-element-name: &unexpectedelementname;: "
			name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-de-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define de-equation-intra-label-sep "-")
(define de-example-intra-label-sep "-")
(define de-figure-intra-label-sep "-")
(define de-informalequation-intra-label-sep "-")
(define de-procedure-intra-label-sep ".")
(define de-refentry-intra-label-sep ".")
(define de-reference-intra-label-sep ".")
(define de-refname-intra-label-sep ", ")
(define de-refsect1-intra-label-sep ".")
(define de-refsect2-intra-label-sep ".")
(define de-refsect3-intra-label-sep ".")
(define de-section-intra-label-sep ".")
(define de-sect1-intra-label-sep ".")
(define de-sect2-intra-label-sep ".")
(define de-sect3-intra-label-sep ".")
(define de-sect4-intra-label-sep ".")
(define de-sect5-intra-label-sep ".")
(define de-step-intra-label-sep ".")
(define de-table-intra-label-sep "-")
(define de-_pagenumber-intra-label-sep "-")
(define de-default-intra-label-sep ".")

(define (gentext-de-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	de-equation-intra-label-sep)
     ((equal? name (normalize "example"))	de-example-intra-label-sep)
     ((equal? name (normalize "figure"))	de-figure-intra-label-sep)
     ((equal? name (normalize "informalequation"))	de-informalequation-intra-label-sep)
     ((equal? name (normalize "procedure"))	de-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	de-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	de-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	de-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	de-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	de-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	de-refsect3-intra-label-sep)
     ((equal? name (normalize "section"))	de-section-intra-label-sep)
     ((equal? name (normalize "sect1"))		de-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		de-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		de-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		de-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		de-sect5-intra-label-sep)
     ((equal? name (normalize "step"))		de-step-intra-label-sep)
     ((equal? name (normalize "table"))		de-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	de-_pagenumber-intra-label-sep)
     (else de-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define de-abstract-label-title-sep ": ")
(define de-appendix-label-title-sep " ")
(define de-caution-label-title-sep "")
(define de-chapter-label-title-sep " ")
(define de-equation-label-title-sep " ")
(define de-example-label-title-sep " ")
(define de-figure-label-title-sep " ")
(define de-footnote-label-title-sep " ")
(define de-glosssee-label-title-sep ": ")
(define de-glossseealso-label-title-sep ": ")
(define de-important-label-title-sep ": ")
(define de-note-label-title-sep ": ")
(define de-orderedlist-label-title-sep ". ")
(define de-part-label-title-sep " ")
(define de-procedure-label-title-sep ". ")
(define de-prefix-label-title-sep ". ")
(define de-refentry-label-title-sep "")
(define de-reference-label-title-sep ". ")
(define de-refsect1-label-title-sep " ")
(define de-refsect2-label-title-sep " ")
(define de-refsect3-label-title-sep " ")
(define de-section-label-title-sep " ")
(define de-sect1-label-title-sep " ")
(define de-sect2-label-title-sep " ")
(define de-sect3-label-title-sep " ")
(define de-sect4-label-title-sep " ")
(define de-sect5-label-title-sep " ")
(define de-seeie-label-title-sep " ")
(define de-seealsoie-label-title-sep " ")
(define de-step-label-title-sep ". ")
(define de-table-label-title-sep " ")
(define de-tip-label-title-sep ": ")
(define de-warning-label-title-sep "")
(define de-default-label-title-sep "")

(define (gentext-de-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) de-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) de-appendix-label-title-sep)
     ((equal? name (normalize "caution")) de-caution-label-title-sep)
     ((equal? name (normalize "chapter")) de-chapter-label-title-sep)
     ((equal? name (normalize "equation")) de-equation-label-title-sep)
     ((equal? name (normalize "example")) de-example-label-title-sep)
     ((equal? name (normalize "figure")) de-figure-label-title-sep)
     ((equal? name (normalize "footnote")) de-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) de-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) de-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) de-important-label-title-sep)
     ((equal? name (normalize "note")) de-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) de-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) de-part-label-title-sep)
     ((equal? name (normalize "procedure")) de-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) de-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) de-refentry-label-title-sep)
     ((equal? name (normalize "reference")) de-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) de-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) de-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) de-refsect3-label-title-sep)
     ((equal? name (normalize "section")) de-section-label-title-sep)
     ((equal? name (normalize "sect1")) de-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) de-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) de-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) de-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) de-sect5-label-title-sep)
     ((equal? name (normalize "seeie")) de-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) de-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) de-step-label-title-sep)
     ((equal? name (normalize "table")) de-table-label-title-sep)
     ((equal? name (normalize "tip")) de-tip-label-title-sep)
     ((equal? name (normalize "warning")) de-warning-label-title-sep)
     (else de-default-label-title-sep))))

(define (de-set-label-number-format gind) "1")
(define (de-book-label-number-format gind) "1")
(define (de-prefix-label-number-format gind) "1")
(define (de-part-label-number-format gind) "I")
(define (de-chapter-label-number-format gind) "1")
(define (de-appendix-label-number-format gind) "A")
(define (de-reference-label-number-format gind) "I")
(define (de-example-label-number-format gind) "1")
(define (de-figure-label-number-format gind) "1")
(define (de-table-label-number-format gind) "1")
(define (de-procedure-label-number-format gind) "1")
(define (de-step-label-number-format gind) "1")
(define (de-refsect1-label-number-format gind) "1")
(define (de-refsect2-label-number-format gind) "1")
(define (de-refsect3-label-number-format gind) "1")
(define (de-section-label-number-format gind) "1")
(define (de-sect1-label-number-format gind) "1")
(define (de-sect2-label-number-format gind) "1")
(define (de-sect3-label-number-format gind) "1")
(define (de-sect4-label-number-format gind) "1")
(define (de-sect5-label-number-format gind) "1")
(define (de-default-label-number-format gind) "1")

(define (de-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (de-set-label-number-format gind))
     ((equal? name (normalize "book")) (de-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (de-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (de-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (de-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (de-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (de-reference-label-number-format gind))
     ((equal? name (normalize "example")) (de-example-label-number-format gind))
     ((equal? name (normalize "figure")) (de-figure-label-number-format gind))
     ((equal? name (normalize "table")) (de-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (de-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (de-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (de-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (de-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (de-refsect3-label-number-format gind))
     ((equal? name (normalize "section")) (de-section-label-number-format gind))
     ((equal? name (normalize "sect1")) (de-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (de-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (de-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (de-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (de-sect5-label-number-format gind))
     (else (de-default-label-number-format gind)))))

(define ($lot-title-de$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-de-start-quote% "\U-201E;")

(define %gentext-de-end-quote% "\U-201C;")

(define %gentext-de-start-nested-quote% "\U-201A;")

(define %gentext-de-end-nested-quote% "\U-2018;")

(define %gentext-de-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-de-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-de-page% "")

(define %gentext-de-and% "&and;")

(define %gentext-de-bibl-pages% "&Pgs;")

(define %gentext-de-endnotes% "&Notes;")

(define %gentext-de-table-endnotes% "&TableNotes;:")

(define %gentext-de-index-see% "&See;")

(define %gentext-de-index-seealso% "&SeeAlso;")
