/* gca-document.c generated by valac 0.27.1, the Vala compiler
 * generated from gca-document.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <gio/gunixoutputstream.h>


#define GCA_TYPE_DOCUMENT (gca_document_get_type ())
#define GCA_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DOCUMENT, GcaDocument))
#define GCA_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DOCUMENT, GcaDocumentClass))
#define GCA_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DOCUMENT))
#define GCA_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DOCUMENT))
#define GCA_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DOCUMENT, GcaDocumentClass))

typedef struct _GcaDocument GcaDocument;
typedef struct _GcaDocumentClass GcaDocumentClass;
typedef struct _GcaDocumentPrivate GcaDocumentPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GcaDocumentUnsavedDataPathData GcaDocumentUnsavedDataPathData;

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;

struct _GcaDocument {
	GObject parent_instance;
	GcaDocumentPrivate * priv;
};

struct _GcaDocumentClass {
	GObjectClass parent_class;
};

struct _GcaDocumentPrivate {
	GeditDocument* d_document;
	gboolean d_untitled;
	gboolean d_modified;
	gchar* d_text;
	GFile* d_location;
	gboolean d_dispose_ran;
	gchar* d_path;
	GFile* d_unsaved_file;
};

struct _GcaDocumentUnsavedDataPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GcaDocument* self;
	gchar* result;
	gboolean _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* orig;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint idx;
	const gchar* _tmp6_;
	gint _tmp7_;
	gchar* filename;
	gint _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* cdir;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* tmpdir;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GFile* f;
	const gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GError* e;
	GError* _tmp25_;
	GError* _tmp26_;
	GError* _tmp27_;
	gboolean _tmp28_;
	const gchar* _tmp29_;
	gchar* tmpfilename;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gint tmpfile;
	const gchar* _tmp33_;
	gint _tmp34_;
	GUnixOutputStream* ostream;
	gint _tmp35_;
	GUnixOutputStream* _tmp36_;
	GUnixOutputStream* _tmp37_;
	const gchar* _tmp38_;
	guint8* _tmp39_;
	gint _tmp39__length1;
	guint8* _tmp40_;
	gint _tmp40__length1;
	guint8* b;
	guint8* _tmp41_;
	gint b_length1;
	gint _b_size_;
	GUnixOutputStream* _tmp42_;
	guint8* _tmp43_;
	gint _tmp43__length1;
	GError* _vala1_e;
	GFile* _tmp44_;
	GUnixOutputStream* _tmp45_;
	GError* _tmp46_;
	GError* _tmp47_;
	GUnixOutputStream* _tmp48_;
	const gchar* _tmp49_;
	GFile* _tmp50_;
	GFile* _tmp51_;
	gchar* _tmp52_;
	GError * _inner_error_;
};

struct _GcaSourceLocation {
	gint line;
	gint column;
};


static gpointer gca_document_parent_class = NULL;
static gboolean gca_document_s_needs_tmp_chmod;
static gboolean gca_document_s_needs_tmp_chmod = TRUE;

GType gca_document_get_type (void) G_GNUC_CONST;
#define GCA_DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DOCUMENT, GcaDocumentPrivate))
enum  {
	GCA_DOCUMENT_DUMMY_PROPERTY,
	GCA_DOCUMENT_DOCUMENT,
	GCA_DOCUMENT_LOCATION,
	GCA_DOCUMENT_TEXT,
	GCA_DOCUMENT_IS_MODIFIED,
	GCA_DOCUMENT_CURSOR,
	GCA_DOCUMENT_PATH
};
GcaDocument* gca_document_new (GeditDocument* document);
GcaDocument* gca_document_construct (GType object_type, GeditDocument* document);
static void gca_document_update_modified (GcaDocument* self);
static void gca_document_on_document_modified_changed (GcaDocument* self);
static void _gca_document_on_document_modified_changed_gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
static void gca_document_on_document_end_user_action (GcaDocument* self);
static void _gca_document_on_document_end_user_action_gtk_text_buffer_end_user_action (GtkTextBuffer* _sender, gpointer self);
static void gca_document_on_location_changed (GcaDocument* self);
static void _gca_document_on_location_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gca_document_on_shortname_changed (GcaDocument* self);
static void _gca_document_on_shortname_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gca_document_on_document_saved (GcaDocument* self);
static void _gca_document_on_document_saved_gedit_document_saved (GeditDocument* _sender, gpointer self);
static void gca_document_update_location (GcaDocument* self);
static void gca_document_real_dispose (GObject* base);
static void gca_document_clear_unsaved_file (GcaDocument* self);
static void gca_document_update_path (GcaDocument* self);
gchar* gca_document_get_path (GcaDocument* self);
GeditDocument* gca_document_get_document (GcaDocument* self);
static void gca_document_update_text (GcaDocument* self);
void gca_document_emit_changed (GcaDocument* self);
static void gca_document_unsaved_data_path_data_free (gpointer _data);
void gca_document_unsaved_data_path (GcaDocument* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* gca_document_unsaved_data_path_finish (GcaDocument* self, GAsyncResult* _res_, GError** error);
static gboolean gca_document_unsaved_data_path_co (GcaDocumentUnsavedDataPathData* _data_);
static void gca_document_unsaved_data_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GFile* gca_document_get_location (GcaDocument* self);
const gchar* gca_document_get_text (GcaDocument* self);
gboolean gca_document_get_is_modified (GcaDocument* self);
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
void gca_document_get_cursor (GcaDocument* self, GcaSourceLocation* result);
static void gca_document_finalize (GObject* obj);
static void _vala_gca_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gca_document_on_document_modified_changed_gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	gca_document_on_document_modified_changed ((GcaDocument*) self);
}


static void _gca_document_on_document_end_user_action_gtk_text_buffer_end_user_action (GtkTextBuffer* _sender, gpointer self) {
	gca_document_on_document_end_user_action ((GcaDocument*) self);
}


static void _gca_document_on_location_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gca_document_on_location_changed ((GcaDocument*) self);
}


static void _gca_document_on_shortname_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gca_document_on_shortname_changed ((GcaDocument*) self);
}


static void _gca_document_on_document_saved_gedit_document_saved (GeditDocument* _sender, gpointer self) {
	gca_document_on_document_saved ((GcaDocument*) self);
}


GcaDocument* gca_document_construct (GType object_type, GeditDocument* document) {
	GcaDocument * self = NULL;
	GeditDocument* _tmp0_ = NULL;
	GeditDocument* _tmp1_ = NULL;
	GeditDocument* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeditDocument* _tmp4_ = NULL;
	GeditDocument* _tmp5_ = NULL;
	GeditDocument* _tmp6_ = NULL;
	GeditDocument* _tmp7_ = NULL;
	GeditDocument* _tmp8_ = NULL;
	g_return_val_if_fail (document != NULL, NULL);
	self = (GcaDocument*) g_object_new (object_type, NULL);
	_tmp0_ = document;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->d_document);
	self->priv->d_document = _tmp1_;
	_tmp2_ = self->priv->d_document;
	_tmp3_ = gedit_document_is_untitled (_tmp2_);
	self->priv->d_untitled = _tmp3_;
	self->priv->d_modified = FALSE;
	_g_free0 (self->priv->d_text);
	self->priv->d_text = NULL;
	gca_document_update_modified (self);
	_tmp4_ = self->priv->d_document;
	g_signal_connect_object ((GtkTextBuffer*) _tmp4_, "modified-changed", (GCallback) _gca_document_on_document_modified_changed_gtk_text_buffer_modified_changed, self, 0);
	_tmp5_ = self->priv->d_document;
	g_signal_connect_object ((GtkTextBuffer*) _tmp5_, "end-user-action", (GCallback) _gca_document_on_document_end_user_action_gtk_text_buffer_end_user_action, self, 0);
	_tmp6_ = self->priv->d_document;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::location", (GCallback) _gca_document_on_location_changed_g_object_notify, self, 0);
	_tmp7_ = self->priv->d_document;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::shortname", (GCallback) _gca_document_on_shortname_changed_g_object_notify, self, 0);
	_tmp8_ = self->priv->d_document;
	g_signal_connect_object (_tmp8_, "saved", (GCallback) _gca_document_on_document_saved_gedit_document_saved, self, 0);
	_g_object_unref0 (self->priv->d_location);
	self->priv->d_location = NULL;
	_g_free0 (self->priv->d_path);
	self->priv->d_path = NULL;
	gca_document_update_location (self);
	return self;
}


GcaDocument* gca_document_new (GeditDocument* document) {
	return gca_document_construct (GCA_TYPE_DOCUMENT, document);
}


static void gca_document_real_dispose (GObject* base) {
	GcaDocument * self;
	gboolean _tmp0_ = FALSE;
	self = (GcaDocument*) base;
	_tmp0_ = self->priv->d_dispose_ran;
	if (!_tmp0_) {
		GeditDocument* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		GeditDocument* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		GQuark _tmp5_ = 0U;
		GeditDocument* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		GQuark _tmp8_ = 0U;
		GeditDocument* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		GeditDocument* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		self->priv->d_dispose_ran = TRUE;
		_tmp1_ = self->priv->d_document;
		g_signal_parse_name ("modified-changed", gtk_text_buffer_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gca_document_on_document_modified_changed_gtk_text_buffer_modified_changed, self);
		_tmp3_ = self->priv->d_document;
		g_signal_parse_name ("notify::location", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _gca_document_on_location_changed_g_object_notify, self);
		_tmp6_ = self->priv->d_document;
		g_signal_parse_name ("notify::shortname", G_TYPE_OBJECT, &_tmp7_, &_tmp8_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, _tmp8_, NULL, (GCallback) _gca_document_on_shortname_changed_g_object_notify, self);
		_tmp9_ = self->priv->d_document;
		g_signal_parse_name ("end-user-action", gtk_text_buffer_get_type (), &_tmp10_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _gca_document_on_document_end_user_action_gtk_text_buffer_end_user_action, self);
		_tmp11_ = self->priv->d_document;
		g_signal_parse_name ("saved", gedit_document_get_type (), &_tmp12_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _gca_document_on_document_saved_gedit_document_saved, self);
		gca_document_clear_unsaved_file (self);
	}
	G_OBJECT_CLASS (gca_document_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}


static void gca_document_update_path (GcaDocument* self) {
	gchar* npath = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gca_document_get_path (self);
	_tmp1_ = _tmp0_;
	npath = _tmp1_;
	_tmp2_ = npath;
	_tmp3_ = self->priv->d_path;
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
		gchar* prevpath = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp4_ = self->priv->d_path;
		_tmp5_ = g_strdup (_tmp4_);
		prevpath = _tmp5_;
		_tmp6_ = npath;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->d_path);
		self->priv->d_path = _tmp7_;
		_tmp8_ = prevpath;
		g_signal_emit_by_name (self, "path-changed", _tmp8_);
		_g_free0 (prevpath);
	}
	_g_free0 (npath);
}


static void gca_document_update_location (GcaDocument* self) {
	gboolean _tmp0_ = FALSE;
	GeditDocument* _tmp1_ = NULL;
	GeditDocument* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = gca_document_get_document (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gedit_document_is_untitled (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GeditDocument* _tmp4_ = NULL;
		GeditDocument* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = gca_document_get_document (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = gedit_document_is_local (_tmp5_);
		_tmp0_ = !_tmp6_;
	}
	if (_tmp0_) {
		_g_object_unref0 (self->priv->d_location);
		self->priv->d_location = NULL;
	} else {
		GeditDocument* _tmp7_ = NULL;
		GeditDocument* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		_tmp7_ = gca_document_get_document (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = gedit_document_get_location (_tmp8_);
		_g_object_unref0 (self->priv->d_location);
		self->priv->d_location = _tmp9_;
	}
	gca_document_update_path (self);
}


static void gca_document_update_modified (GcaDocument* self) {
	gboolean _tmp0_ = FALSE;
	GeditDocument* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_modified;
	_tmp1_ = self->priv->d_document;
	_tmp2_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp1_);
	if (_tmp0_ == _tmp2_) {
		return;
	}
	_g_free0 (self->priv->d_text);
	self->priv->d_text = NULL;
	_tmp3_ = self->priv->d_modified;
	self->priv->d_modified = !_tmp3_;
	_tmp4_ = self->priv->d_modified;
	if (_tmp4_) {
		gca_document_update_text (self);
	} else {
		gca_document_emit_changed (self);
	}
}


void gca_document_emit_changed (GcaDocument* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "changed");
}


static void gca_document_clear_unsaved_file (GcaDocument* self) {
	GFile* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_unsaved_file;
	if (_tmp0_ != NULL) {
		{
			GFile* _tmp1_ = NULL;
			_tmp1_ = self->priv->d_unsaved_file;
			g_file_delete (_tmp1_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (self->priv->d_unsaved_file);
		self->priv->d_unsaved_file = NULL;
	}
}


static void gca_document_update_text (GcaDocument* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditDocument* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GeditDocument* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_document;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp0_, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	_tmp3_ = self->priv->d_document;
	_tmp4_ = start;
	_tmp5_ = end;
	_tmp6_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp3_, &_tmp4_, &_tmp5_, TRUE);
	_g_free0 (self->priv->d_text);
	self->priv->d_text = _tmp6_;
	gca_document_clear_unsaved_file (self);
	gca_document_emit_changed (self);
}


static void gca_document_unsaved_data_path_data_free (gpointer _data) {
	GcaDocumentUnsavedDataPathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GcaDocumentUnsavedDataPathData, _data_);
}


void gca_document_unsaved_data_path (GcaDocument* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaDocumentUnsavedDataPathData* _data_;
	GcaDocument* _tmp0_ = NULL;
	_data_ = g_slice_new0 (GcaDocumentUnsavedDataPathData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gca_document_unsaved_data_path);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_document_unsaved_data_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gca_document_unsaved_data_path_co (_data_);
}


gchar* gca_document_unsaved_data_path_finish (GcaDocument* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	GcaDocumentUnsavedDataPathData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void gca_document_unsaved_data_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaDocumentUnsavedDataPathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gca_document_unsaved_data_path_co (_data_);
}


static gboolean gca_document_unsaved_data_path_co (GcaDocumentUnsavedDataPathData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->d_modified;
	if (!_data_->_tmp0_) {
		_data_->result = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->d_unsaved_file;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->self->priv->d_unsaved_file;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_file_get_path (_data_->_tmp2_);
		_data_->result = _data_->_tmp3_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = gca_document_get_path (_data_->self);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->orig = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->orig;
	_data_->_tmp7_ = 0;
	_data_->_tmp7_ = string_last_index_of (_data_->_tmp6_, ".", 0);
	_data_->idx = _data_->_tmp7_;
	_data_->_tmp8_ = 0;
	_data_->_tmp8_ = _data_->idx;
	if (_data_->_tmp8_ != (-1)) {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->orig;
		_data_->_tmp10_ = 0;
		_data_->_tmp10_ = _data_->idx;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->orig;
		_data_->_tmp12_ = 0;
		_data_->_tmp12_ = strlen (_data_->_tmp11_);
		_data_->_tmp13_ = 0;
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = string_slice (_data_->_tmp9_, (glong) (_data_->_tmp10_ + 1), (glong) _data_->_tmp13_);
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = g_strdup_printf ("gca-unsaved-XXXXXX.%s", _data_->_tmp15_);
		_g_free0 (_data_->filename);
		_data_->filename = _data_->_tmp16_;
		_g_free0 (_data_->_tmp15_);
	} else {
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup ("gca-unsaved-XXXXXX");
		_g_free0 (_data_->filename);
		_data_->filename = _data_->_tmp17_;
	}
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = g_get_user_cache_dir ();
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = g_strdup (_data_->_tmp18_);
	_data_->cdir = _data_->_tmp19_;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->cdir;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = g_build_filename (_data_->_tmp20_, "gedit", "plugins", "codeassistance", NULL);
	_data_->tmpdir = _data_->_tmp21_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->tmpdir;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = g_file_new_for_path (_data_->_tmp22_);
	_data_->f = _data_->_tmp23_;
	{
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->f;
		g_file_make_directory_with_parents (_data_->_tmp24_, NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->e;
		if (!g_error_matches (_data_->_tmp25_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->e;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _g_error_copy0 (_data_->_tmp26_);
			_data_->_inner_error_ = _data_->_tmp27_;
			_g_error_free0 (_data_->e);
			goto __finally2;
		}
		_g_error_free0 (_data_->e);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->f);
		_g_free0 (_data_->tmpdir);
		_g_free0 (_data_->cdir);
		_g_free0 (_data_->filename);
		_g_free0 (_data_->orig);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = FALSE;
	_data_->_tmp28_ = gca_document_s_needs_tmp_chmod;
	if (_data_->_tmp28_) {
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->tmpdir;
		g_chmod (_data_->_tmp29_, 0700);
		gca_document_s_needs_tmp_chmod = FALSE;
	}
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->tmpdir;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->filename;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = g_build_filename (_data_->_tmp30_, _data_->_tmp31_, NULL);
	_data_->tmpfilename = _data_->_tmp32_;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->tmpfilename;
	_data_->_tmp34_ = 0;
	_data_->_tmp34_ = g_mkstemp (_data_->_tmp33_);
	_data_->tmpfile = _data_->_tmp34_;
	_data_->_tmp35_ = 0;
	_data_->_tmp35_ = _data_->tmpfile;
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->_tmp35_, TRUE);
	_data_->ostream = _data_->_tmp36_;
	{
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _data_->ostream;
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->self->priv->d_text;
		_data_->_tmp39_ = NULL;
		_data_->_tmp39__length1 = 0;
		_data_->_tmp39_ = string_get_data (_data_->_tmp38_, &_data_->_tmp39__length1);
		_data_->_tmp40_ = NULL;
		_data_->_tmp40__length1 = 0;
		_data_->_tmp40_ = _data_->_tmp39_;
		_data_->_tmp40__length1 = _data_->_tmp39__length1;
		_data_->_state_ = 1;
		g_output_stream_write_async ((GOutputStream*) _data_->_tmp37_, _data_->_tmp40_, (gsize) _data_->_tmp40__length1, G_PRIORITY_DEFAULT, NULL, gca_document_unsaved_data_path_ready, _data_);
		return FALSE;
		_state_1:
		g_output_stream_write_finish ((GOutputStream*) _data_->_tmp37_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			_g_object_unref0 (_data_->ostream);
			_g_free0 (_data_->tmpfilename);
			_g_object_unref0 (_data_->f);
			_g_free0 (_data_->tmpdir);
			_g_free0 (_data_->cdir);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->orig);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = g_new0 (guint8, 1);
		_data_->_tmp41_[0] = (guint8) '\n';
		_data_->b_length1 = 0;
		_data_->_b_size_ = 0;
		_data_->b = _data_->_tmp41_;
		_data_->b_length1 = 1;
		_data_->_b_size_ = _data_->b_length1;
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = _data_->ostream;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43__length1 = 0;
		_data_->_tmp43_ = _data_->b;
		_data_->_tmp43__length1 = _data_->b_length1;
		_data_->_state_ = 2;
		g_output_stream_write_async ((GOutputStream*) _data_->_tmp42_, _data_->_tmp43_, (gsize) _data_->_tmp43__length1, G_PRIORITY_DEFAULT, NULL, gca_document_unsaved_data_path_ready, _data_);
		return FALSE;
		_state_2:
		g_output_stream_write_finish ((GOutputStream*) _data_->_tmp42_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_data_->b = (g_free (_data_->b), NULL);
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			_data_->b = (g_free (_data_->b), NULL);
			_g_object_unref0 (_data_->ostream);
			_g_free0 (_data_->tmpfilename);
			_g_object_unref0 (_data_->f);
			_g_free0 (_data_->tmpdir);
			_g_free0 (_data_->cdir);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->orig);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->b = (g_free (_data_->b), NULL);
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		{
			_data_->_tmp44_ = NULL;
			_data_->_tmp44_ = _data_->f;
			g_file_delete (_data_->_tmp44_, NULL, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			g_clear_error (&_data_->_inner_error_);
			_data_->_inner_error_ = NULL;
		}
		__finally4:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_error_free0 (_data_->_vala1_e);
			_g_error_free0 (_data_->_vala1_e);
			_g_object_unref0 (_data_->ostream);
			_g_free0 (_data_->tmpfilename);
			_g_object_unref0 (_data_->f);
			_g_free0 (_data_->tmpdir);
			_g_free0 (_data_->cdir);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->orig);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		{
			_data_->_tmp45_ = NULL;
			_data_->_tmp45_ = _data_->ostream;
			g_output_stream_close ((GOutputStream*) _data_->_tmp45_, NULL, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch5_g_error;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			g_clear_error (&_data_->_inner_error_);
			_data_->_inner_error_ = NULL;
		}
		__finally5:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_error_free0 (_data_->_vala1_e);
			_g_error_free0 (_data_->_vala1_e);
			_g_object_unref0 (_data_->ostream);
			_g_free0 (_data_->tmpfilename);
			_g_object_unref0 (_data_->f);
			_g_free0 (_data_->tmpdir);
			_g_free0 (_data_->cdir);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->orig);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = _data_->_vala1_e;
		_data_->_tmp47_ = NULL;
		_data_->_tmp47_ = _g_error_copy0 (_data_->_tmp46_);
		_data_->_inner_error_ = _data_->_tmp47_;
		_g_error_free0 (_data_->_vala1_e);
		goto __finally3;
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->ostream);
		_g_free0 (_data_->tmpfilename);
		_g_object_unref0 (_data_->f);
		_g_free0 (_data_->tmpdir);
		_g_free0 (_data_->cdir);
		_g_free0 (_data_->filename);
		_g_free0 (_data_->orig);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp48_ = NULL;
	_data_->_tmp48_ = _data_->ostream;
	g_output_stream_close ((GOutputStream*) _data_->_tmp48_, NULL, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->ostream);
		_g_free0 (_data_->tmpfilename);
		_g_object_unref0 (_data_->f);
		_g_free0 (_data_->tmpdir);
		_g_free0 (_data_->cdir);
		_g_free0 (_data_->filename);
		_g_free0 (_data_->orig);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp49_ = NULL;
	_data_->_tmp49_ = _data_->tmpfilename;
	_data_->_tmp50_ = NULL;
	_data_->_tmp50_ = g_file_new_for_path (_data_->_tmp49_);
	_g_object_unref0 (_data_->self->priv->d_unsaved_file);
	_data_->self->priv->d_unsaved_file = _data_->_tmp50_;
	_data_->_tmp51_ = NULL;
	_data_->_tmp51_ = _data_->self->priv->d_unsaved_file;
	_data_->_tmp52_ = NULL;
	_data_->_tmp52_ = g_file_get_path (_data_->_tmp51_);
	_data_->result = _data_->_tmp52_;
	_g_object_unref0 (_data_->ostream);
	_g_free0 (_data_->tmpfilename);
	_g_object_unref0 (_data_->f);
	_g_free0 (_data_->tmpdir);
	_g_free0 (_data_->cdir);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->orig);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->ostream);
	_g_free0 (_data_->tmpfilename);
	_g_object_unref0 (_data_->f);
	_g_free0 (_data_->tmpdir);
	_g_free0 (_data_->cdir);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->orig);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gca_document_on_document_end_user_action (GcaDocument* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_modified;
	if (_tmp0_) {
		gca_document_update_text (self);
	}
}


static void gca_document_on_document_modified_changed (GcaDocument* self) {
	g_return_if_fail (self != NULL);
	gca_document_update_modified (self);
}


static void gca_document_on_location_changed (GcaDocument* self) {
	g_return_if_fail (self != NULL);
	gca_document_update_location (self);
}


static void gca_document_on_document_saved (GcaDocument* self) {
	g_return_if_fail (self != NULL);
	gca_document_emit_changed (self);
}


static void gca_document_on_shortname_changed (GcaDocument* self) {
	g_return_if_fail (self != NULL);
	gca_document_update_path (self);
}


GeditDocument* gca_document_get_document (GcaDocument* self) {
	GeditDocument* result;
	GeditDocument* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_document;
	result = _tmp0_;
	return result;
}


GFile* gca_document_get_location (GcaDocument* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_location;
	result = _tmp0_;
	return result;
}


const gchar* gca_document_get_text (GcaDocument* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_text;
	result = _tmp0_;
	return result;
}


gboolean gca_document_get_is_modified (GcaDocument* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_modified;
	result = _tmp0_;
	return result;
}


void gca_document_get_cursor (GcaDocument* self, GcaSourceLocation* result) {
	GtkTextMark* mark = NULL;
	GeditDocument* _tmp0_ = NULL;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter iter = {0};
	GeditDocument* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GcaSourceLocation _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	mark = _tmp2_;
	_tmp3_ = self->priv->d_document;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp4_, mark);
	iter = _tmp4_;
	_tmp5_ = gtk_text_iter_get_line (&iter);
	_tmp6_ = gtk_text_iter_get_line_offset (&iter);
	memset (&_tmp7_, 0, sizeof (GcaSourceLocation));
	_tmp7_.line = _tmp5_ + 1;
	_tmp7_.column = _tmp6_ + 1;
	*result = _tmp7_;
	_g_object_unref0 (mark);
	return;
}


gchar* gca_document_get_path (GcaDocument* self) {
	gchar* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_location;
	if (_tmp0_ == NULL) {
		GeditDocument* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = self->priv->d_document;
		g_object_get (_tmp1_, "shortname", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	} else {
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->d_location;
		_tmp5_ = g_file_get_path (_tmp4_);
		result = _tmp5_;
		return result;
	}
}


static void gca_document_class_init (GcaDocumentClass * klass) {
	gca_document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcaDocumentPrivate));
	((GObjectClass *) klass)->dispose = gca_document_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_document_get_property;
	G_OBJECT_CLASS (klass)->finalize = gca_document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_DOCUMENT, g_param_spec_object ("document", "document", "document", gedit_document_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_IS_MODIFIED, g_param_spec_boolean ("is-modified", "is-modified", "is-modified", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_CURSOR, g_param_spec_boxed ("cursor", "cursor", "cursor", GCA_TYPE_SOURCE_LOCATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("path_changed", GCA_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("changed", GCA_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gca_document_instance_init (GcaDocument * self) {
	self->priv = GCA_DOCUMENT_GET_PRIVATE (self);
}


static void gca_document_finalize (GObject* obj) {
	GcaDocument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DOCUMENT, GcaDocument);
	_g_object_unref0 (self->priv->d_document);
	_g_free0 (self->priv->d_text);
	_g_object_unref0 (self->priv->d_location);
	_g_free0 (self->priv->d_path);
	_g_object_unref0 (self->priv->d_unsaved_file);
	G_OBJECT_CLASS (gca_document_parent_class)->finalize (obj);
}


GType gca_document_get_type (void) {
	static volatile gsize gca_document_type_id__volatile = 0;
	if (g_once_init_enter (&gca_document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDocument), 0, (GInstanceInitFunc) gca_document_instance_init, NULL };
		GType gca_document_type_id;
		gca_document_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaDocument", &g_define_type_info, 0);
		g_once_init_leave (&gca_document_type_id__volatile, gca_document_type_id);
	}
	return gca_document_type_id__volatile;
}


static void _vala_gca_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaDocument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_TYPE_DOCUMENT, GcaDocument);
	switch (property_id) {
		case GCA_DOCUMENT_DOCUMENT:
		g_value_set_object (value, gca_document_get_document (self));
		break;
		case GCA_DOCUMENT_LOCATION:
		g_value_set_object (value, gca_document_get_location (self));
		break;
		case GCA_DOCUMENT_TEXT:
		g_value_set_string (value, gca_document_get_text (self));
		break;
		case GCA_DOCUMENT_IS_MODIFIED:
		g_value_set_boolean (value, gca_document_get_is_modified (self));
		break;
		case GCA_DOCUMENT_CURSOR:
		{
			GcaSourceLocation boxed;
			gca_document_get_cursor (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case GCA_DOCUMENT_PATH:
		g_value_take_string (value, gca_document_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



