#include <stdio.h>
#if HAVE_SQLITE3
#include <sqlite3.h>
#else
#if HAVE_SQLITE2
#include <sqlite.h>
#endif
#endif

#ifndef SQLITE_VERSION
/* last resort */
#include <sqlite.h>
#endif

#if defined(_WIN32) || (HAVE_SQLITE3)
#define PCONST(code)							\
    printf("    /* Error code: %d */\n", code);				\
    printf("    public static final int "#code" = %d;\n", code);
#else
#define PCONST(code)							\
    printf("    /**\n");						\
    printf("     * Error code: '%s'\n", sqlite_error_string(code));	\
    printf("     */\n");						\
    printf("    public static final int "#code" = %d;\n", code);
#endif

#define QCONST(code)							\
    printf("    public static final int "#code" = %d;\n", code);

int
main()
{
    int minor = 99999999;
    FILE *f = fopen("VERSION", "r");

    if (f) {
	if (fscanf(f, "%d", &minor) != 1) {
	    minor = 99999999;
	}
	fclose(f);
    }
    printf("/* DO NOT EDIT */\n\n");
    printf("package SQLite;\n\n");
    printf("/**\n");
    printf(" * Container for SQLite constants.\n");
    printf(" */\n\n");
    printf("public final class Constants {\n");
    PCONST(SQLITE_OK);
    PCONST(SQLITE_ERROR);
    PCONST(SQLITE_INTERNAL);
    PCONST(SQLITE_PERM);
    PCONST(SQLITE_ABORT);
    PCONST(SQLITE_BUSY);
    PCONST(SQLITE_LOCKED);
    PCONST(SQLITE_NOMEM);
    PCONST(SQLITE_READONLY);
    PCONST(SQLITE_INTERRUPT);
    PCONST(SQLITE_IOERR);
    PCONST(SQLITE_CORRUPT);
    PCONST(SQLITE_NOTFOUND);
    PCONST(SQLITE_FULL);
    PCONST(SQLITE_CANTOPEN);
    PCONST(SQLITE_PROTOCOL);
    PCONST(SQLITE_EMPTY);
    PCONST(SQLITE_SCHEMA);
    PCONST(SQLITE_TOOBIG);
    PCONST(SQLITE_CONSTRAINT);
    PCONST(SQLITE_MISMATCH);
    PCONST(SQLITE_MISUSE);

#ifndef SQLITE_NOLFS
#define SQLITE_NOLFS (SQLITE_MISUSE + 1)
#endif
    PCONST(SQLITE_NOLFS);

#ifndef SQLITE_AUTH
#define SQLITE_AUTH (SQLITE_NOLFS + 1)
#endif
    PCONST(SQLITE_AUTH);

#ifndef SQLITE_FORMAT
#define SQLITE_FORMAT (SQLITE_AUTH + 1)
#endif
    PCONST(SQLITE_FORMAT);

#ifndef SQLITE_RANGE
#define SQLITE_RANGE (SQLITE_FORMAT + 1)
#endif
    PCONST(SQLITE_RANGE);

#ifndef SQLITE_NOTADB
#define SQLITE_NOTADB (SQLITE_RANGE + 1)
#endif
    PCONST(SQLITE_NOTADB);

#ifndef SQLITE_ROW
#define SQLITE_ROW 100
#endif
    QCONST(SQLITE_ROW);

#ifndef SQLITE_DONE
#define SQLITE_DONE (SQLITE_ROW + 1)
#endif
    QCONST(SQLITE_DONE);

#ifndef SQLITE_INTEGER
#define SQLITE_INTEGER 1
#endif
    QCONST(SQLITE_INTEGER);

#ifndef SQLITE_FLOAT
#define SQLITE_FLOAT 2
#endif
    QCONST(SQLITE_FLOAT);

#ifndef SQLITE_BLOB
#define SQLITE_BLOB 4
#endif
    QCONST(SQLITE_BLOB);

#ifndef SQLITE_NULL
#define SQLITE_NULL 5
#endif
    QCONST(SQLITE_NULL);

#ifndef SQLITE3_TEXT
#define SQLITE3_TEXT 3
#endif
    QCONST(SQLITE3_TEXT);

#ifndef SQLITE_NUMERIC
#define SQLITE_NUMERIC (-1)
#endif
    QCONST(SQLITE_NUMERIC);

#ifndef SQLITE_TEXT
#ifdef HAVE_SQLITE3
#define SQLITE_TEXT 3
#else
#define SQLITE_TEXT (-2)
#endif
#endif
    QCONST(SQLITE_TEXT);

#ifndef SQLITE2_TEXT
#define SQLITE2_TEXT (-2)
#endif
    QCONST(SQLITE2_TEXT);

#ifndef SQLITE_ARGS
#define SQLITE_ARGS (-3)
#endif
    QCONST(SQLITE_ARGS);

#ifndef SQLITE_COPY
#define SQLITE_COPY 0
#endif
    QCONST(SQLITE_COPY);

#ifndef SQLITE_CREATE_INDEX
#define SQLITE_CREATE_INDEX 1
#endif
    QCONST(SQLITE_CREATE_INDEX);

#ifndef SQLITE_CREATE_TABLE
#define SQLITE_CREATE_TABLE 2
#endif
    QCONST(SQLITE_CREATE_TABLE);

#ifndef SQLITE_CREATE_TEMP_INDEX
#define SQLITE_CREATE_TEMP_INDEX 3
#endif
    QCONST(SQLITE_CREATE_TEMP_INDEX);

#ifndef SQLITE_CREATE_TEMP_TABLE
#define SQLITE_CREATE_TEMP_TABLE 4
#endif
    QCONST(SQLITE_CREATE_TEMP_TABLE);

#ifndef SQLITE_CREATE_TEMP_TRIGGER
#define SQLITE_CREATE_TEMP_TRIGGER 5
#endif
    QCONST(SQLITE_CREATE_TEMP_TRIGGER);

#ifndef SQLITE_CREATE_TEMP_VIEW
#define SQLITE_CREATE_TEMP_VIEW 6
#endif
    QCONST(SQLITE_CREATE_TEMP_VIEW);

#ifndef SQLITE_CREATE_TRIGGER
#define SQLITE_CREATE_TRIGGER 7
#endif
    QCONST(SQLITE_CREATE_TRIGGER);

#ifndef SQLITE_CREATE_VIEW
#define SQLITE_CREATE_VIEW 8
#endif
    QCONST(SQLITE_CREATE_VIEW);

#ifndef SQLITE_DELETE
#define SQLITE_DELETE 9
#endif
    QCONST(SQLITE_DELETE);

#ifndef SQLITE_DROP_INDEX
#define SQLITE_DROP_INDEX 10
#endif
    QCONST(SQLITE_DROP_INDEX);

#ifndef SQLITE_DROP_TABLE
#define SQLITE_DROP_TABLE 11
#endif
    QCONST(SQLITE_DROP_TABLE);

#ifndef SQLITE_DROP_TEMP_INDEX
#define SQLITE_DROP_TEMP_INDEX 12
#endif
    QCONST(SQLITE_DROP_TEMP_INDEX);

#ifndef SQLITE_DROP_TEMP_TABLE
#define SQLITE_DROP_TEMP_TABLE 13
#endif
    QCONST(SQLITE_DROP_TEMP_TABLE);

#ifndef SQLITE_DROP_TEMP_TRIGGER
#define SQLITE_DROP_TEMP_TRIGGER 14
#endif
    QCONST(SQLITE_DROP_TEMP_TRIGGER);

#ifndef SQLITE_DROP_TEMP_VIEW
#define SQLITE_DROP_TEMP_VIEW 15
#endif
    QCONST(SQLITE_DROP_TEMP_VIEW);

#ifndef SQLITE_DROP_TRIGGER
#define SQLITE_DROP_TRIGGER 16
#endif
    QCONST(SQLITE_DROP_TRIGGER);

#ifndef SQLITE_DROP_VIEW
#define SQLITE_DROP_VIEW 17
#endif
    QCONST(SQLITE_DROP_VIEW);

#ifndef SQLITE_INSERT
#define SQLITE_INSERT 18
#endif
    QCONST(SQLITE_INSERT);

#ifndef SQLITE_PRAGMA
#define SQLITE_PRAGMA 19
#endif
    QCONST(SQLITE_PRAGMA);

#ifndef SQLITE_READ
#define SQLITE_READ 20
#endif
    QCONST(SQLITE_READ);

#ifndef SQLITE_SELECT
#define SQLITE_SELECT 21
#endif
    QCONST(SQLITE_SELECT);

#ifndef SQLITE_TRANSACTION
#define SQLITE_TRANSACTION 22
#endif
    QCONST(SQLITE_TRANSACTION);

#ifndef SQLITE_UPDATE
#define SQLITE_UPDATE 23
#endif
    QCONST(SQLITE_UPDATE);

#ifndef SQLITE_ATTACH
#define SQLITE_ATTACH 24
#endif
    QCONST(SQLITE_ATTACH);

#ifndef SQLITE_DETACH
#define SQLITE_DETACH 25
#endif
    QCONST(SQLITE_DETACH);

#ifndef SQLITE_DENY
#define SQLITE_DENY 1
#endif
    QCONST(SQLITE_DENY);

#ifndef SQLITE_IGNORE
#define SQLITE_IGNORE 2
#endif
    QCONST(SQLITE_IGNORE);

#ifndef SQLITE_OPEN_AUTOPROXY
#define SQLITE_OPEN_AUTOPROXY 0
#endif
    QCONST(SQLITE_OPEN_AUTOPROXY);

#ifndef SQLITE_OPEN_CREATE
#define SQLITE_OPEN_CREATE 0
#endif
    QCONST(SQLITE_OPEN_CREATE);

#ifndef SQLITE_OPEN_DELETEONCLOSE
#define SQLITE_OPEN_DELETEONCLOSE 0
#endif
    QCONST(SQLITE_OPEN_DELETEONCLOSE);

#ifndef SQLITE_OPEN_EXCLUSIVE
#define SQLITE_OPEN_EXCLUSIVE 0
#endif
    QCONST(SQLITE_OPEN_EXCLUSIVE);

#ifndef SQLITE_OPEN_FULLMUTEX
#define SQLITE_OPEN_FULLMUTEX 0
#endif
    QCONST(SQLITE_OPEN_FULLMUTEX);

#ifndef SQLITE_OPEN_MAIN_DB
#define SQLITE_OPEN_MAIN_DB 0
#endif
    QCONST(SQLITE_OPEN_MAIN_DB);

#ifndef SQLITE_OPEN_MAIN_JOURNAL
#define SQLITE_OPEN_MAIN_JOURNAL 0
#endif
    QCONST(SQLITE_OPEN_MAIN_JOURNAL);

#ifndef SQLITE_OPEN_MASTER_JOURNAL
#define SQLITE_OPEN_MASTER_JOURNAL 0
#endif
    QCONST(SQLITE_OPEN_MASTER_JOURNAL);

#ifndef SQLITE_OPEN_NOMUTEX
#define SQLITE_OPEN_NOMUTEX 0
#endif
    QCONST(SQLITE_OPEN_NOMUTEX);

#ifndef SQLITE_OPEN_PRIVATECACHE
#define SQLITE_OPEN_PRIVATECACHE 0
#endif
    QCONST(SQLITE_OPEN_PRIVATECACHE);

#ifndef SQLITE_OPEN_READONLY
#define SQLITE_OPEN_READONLY 0
#endif
    QCONST(SQLITE_OPEN_READONLY);

#ifndef SQLITE_OPEN_READWRITE
#define SQLITE_OPEN_READWRITE 0
#endif
    QCONST(SQLITE_OPEN_READWRITE);

#ifndef SQLITE_OPEN_SHAREDCACHE
#define SQLITE_OPEN_SHAREDCACHE 0
#endif
    QCONST(SQLITE_OPEN_SHAREDCACHE);

#ifndef SQLITE_OPEN_SUBJOURNAL
#define SQLITE_OPEN_SUBJOURNAL 0
#endif
    QCONST(SQLITE_OPEN_SUBJOURNAL);

#ifndef SQLITE_OPEN_TEMP_DB
#define SQLITE_OPEN_TEMP_DB 0
#endif
    QCONST(SQLITE_OPEN_TEMP_DB);

#ifndef SQLITE_OPEN_TEMP_JOURNAL
#define SQLITE_OPEN_TEMP_JOURNAL 0
#endif
    QCONST(SQLITE_OPEN_TEMP_JOURNAL);

#ifndef SQLITE_OPEN_TRANSIENT_DB
#define SQLITE_OPEN_TRANSIENT_DB 0
#endif
    QCONST(SQLITE_OPEN_TRANSIENT_DB);

#ifndef SQLITE_OPEN_URI
#define SQLITE_OPEN_URI 0
#endif
    QCONST(SQLITE_OPEN_URI);

#ifndef SQLITE_OPEN_WAL
#define SQLITE_OPEN_WAL 0
#endif
    QCONST(SQLITE_OPEN_WAL);

#ifndef SQLITE_STATUS_MALLOC_COUNT
#define SQLITE_STATUS_MALLOC_COUNT 0
#endif
    QCONST(SQLITE_STATUS_MALLOC_COUNT);

#ifndef SQLITE_STATUS_MALLOC_SIZE
#define SQLITE_STATUS_MALLOC_SIZE 0
#endif
    QCONST(SQLITE_STATUS_MALLOC_SIZE);

#ifndef SQLITE_STATUS_MEMORY_USED
#define SQLITE_STATUS_MEMORY_USED 0
#endif
    QCONST(SQLITE_STATUS_MEMORY_USED);

#ifndef SQLITE_STATUS_PAGECACHE_OVERFLOW
#define SQLITE_STATUS_PAGECACHE_OVERFLOW 0
#endif
    QCONST(SQLITE_STATUS_PAGECACHE_OVERFLOW);

#ifndef SQLITE_STATUS_PAGECACHE_SIZE
#define SQLITE_STATUS_PAGECACHE_SIZE 0
#endif
    QCONST(SQLITE_STATUS_PAGECACHE_SIZE);

#ifndef SQLITE_STATUS_PAGECACHE_USED
#define SQLITE_STATUS_PAGECACHE_USED 0
#endif
    QCONST(SQLITE_STATUS_PAGECACHE_USED);

#ifndef SQLITE_STATUS_PARSER_STACK
#define SQLITE_STATUS_PARSER_STACK 0
#endif
    QCONST(SQLITE_STATUS_PARSER_STACK);

#ifndef SQLITE_STATUS_SCRATCH_OVERFLOW
#define SQLITE_STATUS_SCRATCH_OVERFLOW 0
#endif
    QCONST(SQLITE_STATUS_SCRATCH_OVERFLOW);

#ifndef SQLITE_STATUS_SCRATCH_SIZE
#define SQLITE_STATUS_SCRATCH_SIZE 0
#endif
    QCONST(SQLITE_STATUS_SCRATCH_SIZE);

#ifndef SQLITE_STATUS_SCRATCH_USED
#define SQLITE_STATUS_SCRATCH_USED 0
#endif
    QCONST(SQLITE_STATUS_SCRATCH_USED);

#ifndef SQLITE_DBSTATUS_CACHE_HIT
#define SQLITE_DBSTATUS_CACHE_HIT 0
#endif
    QCONST(SQLITE_DBSTATUS_CACHE_HIT);

#ifndef SQLITE_DBSTATUS_CACHE_MISS
#define SQLITE_DBSTATUS_CACHE_MISS 0
#endif
    QCONST(SQLITE_DBSTATUS_CACHE_MISS);

#ifndef SQLITE_DBSTATUS_CACHE_USED
#define SQLITE_DBSTATUS_CACHE_USED 0
#endif
    QCONST(SQLITE_DBSTATUS_CACHE_USED);

#ifndef SQLITE_DBSTATUS_LOOKASIDE_HIT
#define SQLITE_DBSTATUS_LOOKASIDE_HIT 0
#endif
    QCONST(SQLITE_DBSTATUS_LOOKASIDE_HIT);

#ifndef SQLITE_DBSTATUS_LOOKASIDE_MISS_SIZE
#define SQLITE_DBSTATUS_LOOKASIDE_MISS_SIZE 0
#endif
    QCONST(SQLITE_DBSTATUS_LOOKASIDE_MISS_SIZE);

#ifndef SQLITE_DBSTATUS_LOOKASIDE_MISS_FULL
#define SQLITE_DBSTATUS_LOOKASIDE_MISS_FULL 0
#endif
    QCONST(SQLITE_DBSTATUS_LOOKASIDE_MISS_FULL);

#ifndef SQLITE_DBSTATUS_LOOKASIDE_USED
#define SQLITE_DBSTATUS_LOOKASIDE_USED 0
#endif
    QCONST(SQLITE_DBSTATUS_LOOKASIDE_USED);

#ifndef SQLITE_DBSTATUS_SCHEMA_USED
#define SQLITE_DBSTATUS_SCHEMA_USED 0
#endif
    QCONST(SQLITE_DBSTATUS_SCHEMA_USED);

#ifndef SQLITE_DBSTATUS_STMT_USED
#define SQLITE_DBSTATUS_STMT_USED 0
#endif
    QCONST(SQLITE_DBSTATUS_STMT_USED);

#ifndef SQLITE_STMTSTATUS_FULLSCAN_STEP
#define SQLITE_STMTSTATUS_FULLSCAN_STEP 0
#endif
    QCONST(SQLITE_STMTSTATUS_FULLSCAN_STEP);

#ifndef SQLITE_STMTSTATUS_SORT
#define SQLITE_STMTSTATUS_SORT 0
#endif
    QCONST(SQLITE_STMTSTATUS_SORT);

#ifndef SQLITE_STMTSTATUS_AUTOINDEX
#define SQLITE_STMTSTATUS_AUTOINDEX 0
#endif
    QCONST(SQLITE_STMTSTATUS_AUTOINDEX);

    printf("    public static final int drv_minor = %d;\n",
	   minor);

    printf("}\n");
    return 0;
}
