; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -o - < %s -mcpu=sm_70 -mattr=+ptx76 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mcpu=sm_70 -mattr=+ptx76 | %ptxas-verify -arch=sm_70 %}

target triple = "nvptx64-unknown-cuda"

define i32 @szext_wrap_u32(i32 %a, i32 %b) {
; CHECK-LABEL: szext_wrap_u32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [szext_wrap_u32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [szext_wrap_u32_param_1];
; CHECK-NEXT:    szext.wrap.u32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.zext.wrap(i32 %a, i32 %b)
  ret i32 %c
}

define i32 @szext_clamp_u32(i32 %a, i32 %b) {
; CHECK-LABEL: szext_clamp_u32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [szext_clamp_u32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [szext_clamp_u32_param_1];
; CHECK-NEXT:    szext.clamp.u32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.zext.clamp(i32 %a, i32 %b)
  ret i32 %c
}

define i32 @szext_wrap_s32(i32 %a, i32 %b) {
; CHECK-LABEL: szext_wrap_s32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [szext_wrap_s32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [szext_wrap_s32_param_1];
; CHECK-NEXT:    szext.wrap.s32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.sext.wrap(i32 %a, i32 %b)
  ret i32 %c
}

define i32 @szext_clamp_s32(i32 %a, i32 %b) {
; CHECK-LABEL: szext_clamp_s32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [szext_clamp_s32_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [szext_clamp_s32_param_1];
; CHECK-NEXT:    szext.clamp.s32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.sext.clamp(i32 %a, i32 %b)
  ret i32 %c
}

define i32 @szext_clamp_s32_ii() {
; CHECK-LABEL: szext_clamp_s32_ii(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    mov.b32 %r1, 3;
; CHECK-NEXT:    szext.clamp.s32 %r2, %r1, 4;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.sext.clamp(i32 3, i32 4)
  ret i32 %c
}

define i32 @szext_wrap_s32_ir(i32 %a) {
; CHECK-LABEL: szext_wrap_s32_ir(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [szext_wrap_s32_ir_param_0];
; CHECK-NEXT:    szext.wrap.s32 %r2, 5, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.sext.wrap(i32 5, i32 %a)
  ret i32 %c
}

define i32 @szext_clamp_u32_ri(i32 %a) {
; CHECK-LABEL: szext_clamp_u32_ri(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [szext_clamp_u32_ri_param_0];
; CHECK-NEXT:    szext.clamp.u32 %r2, %r1, 7;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %c = call i32 @llvm.nvvm.zext.clamp(i32 %a, i32 7)
  ret i32 %c
}
