; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=instcombine -S < %s | FileCheck %s
;
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

declare void @foo(ptr)
declare void @bar(ptr addrspace(1))

define void @nonnullAfterBitCast() {
; CHECK-LABEL: define void @nonnullAfterBitCast() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @foo(ptr nonnull [[I]])
; CHECK-NEXT:    ret void
;
entry:
  %i = alloca i32, align 4
  call void @foo(ptr %i)
  ret void
}

define void @nonnullAfterSExt(i8 %a) {
; CHECK-LABEL: define void @nonnullAfterSExt
; CHECK-SAME: (i8 [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = zext i8 [[A]] to i64
; CHECK-NEXT:    [[C:%.*]] = add nuw nsw i64 [[B]], 2
; CHECK-NEXT:    [[I2P:%.*]] = inttoptr i64 [[C]] to ptr
; CHECK-NEXT:    call void @foo(ptr nonnull [[I2P]])
; CHECK-NEXT:    ret void
;
entry:
  %b = zext i8 %a to i32              ; <- %b is >= 0
  %c = add nsw nuw i32 %b, 2          ; <- %c is > 0
  %sext = sext i32 %c to i64          ; <- %sext cannot be 0 because %c is not 0
  %i2p = inttoptr i64 %sext to ptr    ; <- no-op int2ptr cast
  call void @foo(ptr %i2p)
  ret void
}

define void @nonnullAfterZExt(i8 %a) {
; CHECK-LABEL: define void @nonnullAfterZExt
; CHECK-SAME: (i8 [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = zext i8 [[A]] to i64
; CHECK-NEXT:    [[C:%.*]] = add nuw nsw i64 [[B]], 2
; CHECK-NEXT:    [[I2P:%.*]] = inttoptr i64 [[C]] to ptr
; CHECK-NEXT:    call void @foo(ptr nonnull [[I2P]])
; CHECK-NEXT:    ret void
;
entry:
  %b = zext i8 %a to i32              ; <- %b is >= 0
  %c = add nsw nuw i32 %b, 2          ; <- %c is > 0
  %zext = zext i32 %c to i64          ; <- %zext cannot be 0 because %c is not 0
  %i2p = inttoptr i64 %zext to ptr    ; <- no-op int2ptr cast
  call void @foo(ptr %i2p)
  ret void
}

declare void @llvm.assume(i1 %b)

define void @nonnullAfterInt2Ptr(i32 %u, i64 %lu) {
; CHECK-LABEL: define void @nonnullAfterInt2Ptr
; CHECK-SAME: (i32 [[U:%.*]], i64 [[LU:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[NZ:%.*]] = sdiv exact i32 100, [[U]]
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[NZ]] to i64
; CHECK-NEXT:    [[I2P:%.*]] = inttoptr i64 [[TMP0]] to ptr
; CHECK-NEXT:    call void @foo(ptr nonnull [[I2P]])
; CHECK-NEXT:    [[NZ_2:%.*]] = sdiv exact i64 100, [[LU]]
; CHECK-NEXT:    [[I2P_2:%.*]] = inttoptr i64 [[NZ_2]] to ptr
; CHECK-NEXT:    call void @foo(ptr nonnull [[I2P_2]])
; CHECK-NEXT:    ret void
;
entry:
  %nz = sdiv exact i32 100, %u         ; %nz cannot be null
  %i2p = inttoptr i32 %nz to ptr       ; extending int2ptr as sizeof(i32) < sizeof(ptr)
  call void @foo(ptr %i2p)

  %nz.2 = sdiv exact i64 100, %lu      ; %nz.2 cannot be null
  %i2p.2 = inttoptr i64 %nz.2 to ptr   ; no-op int2ptr as sizeof(i64) == sizeof(ptr)
  call void @foo(ptr %i2p.2)
  ret void
}

define void @nonnullAfterPtr2Int() {
; CHECK-LABEL: define void @nonnullAfterPtr2Int() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @foo(ptr nonnull [[A]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32
  %p2i = ptrtoint ptr %a to i64      ; no-op ptr2int as sizeof(ptr) == sizeof(i64)
  %i2p = inttoptr i64 %p2i to ptr
  call void @foo(ptr %i2p)
  ret void
}

define void @maybenullAfterInt2Ptr(i128 %llu) {
; CHECK-LABEL: define void @maybenullAfterInt2Ptr
; CHECK-SAME: (i128 [[LLU:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i128 [[LLU]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    [[TMP0:%.*]] = trunc i128 [[LLU]] to i64
; CHECK-NEXT:    [[I2P:%.*]] = inttoptr i64 [[TMP0]] to ptr
; CHECK-NEXT:    call void @foo(ptr [[I2P]])
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp ne i128 %llu, 0
  call void @llvm.assume(i1 %cmp)          ; %llu != 0
  %i2p = inttoptr i128 %llu to ptr    ; truncating int2ptr as sizeof(i128) > sizeof(ptr)
  call void @foo(ptr %i2p)
  ret void
}

define void @maybenullAfterPtr2Int() {
; CHECK-LABEL: define void @maybenullAfterPtr2Int() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr [[A]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 4294967292
; CHECK-NEXT:    [[I2P:%.*]] = inttoptr i64 [[TMP1]] to ptr
; CHECK-NEXT:    call void @foo(ptr [[I2P]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32
  %p2i = ptrtoint ptr %a to i32      ; truncating ptr2int as sizeof(ptr) > sizeof(i32)
  %i2p = inttoptr i32 %p2i to ptr
  call void @foo(ptr %i2p)
  ret void
}

define void @maybenullAfterAddrspacecast(ptr nonnull %p) {
; CHECK-LABEL: define void @maybenullAfterAddrspacecast
; CHECK-SAME: (ptr nonnull [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDRSPCAST:%.*]] = addrspacecast ptr [[P]] to ptr addrspace(1)
; CHECK-NEXT:    call void @bar(ptr addrspace(1) [[ADDRSPCAST]])
; CHECK-NEXT:    call void @foo(ptr nonnull [[P]])
; CHECK-NEXT:    ret void
;
entry:
  %addrspcast = addrspacecast ptr %p to ptr addrspace(1)

; An address space cast can be "a no-op cast or a complex value modification,
; depending on the target and the address space pair". As a consequence, we
; cannot simply assume non-nullness of %p is preserved by the cast.
  call void @bar(ptr addrspace(1) %addrspcast)

  call void @foo(ptr %p)
  ret void
}
