# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr3-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR3-4_64,SCR3_64
# RUN: llvm-mca -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr3-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR3-4_32,SCR3_32
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr4-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR3-4_64,SCR4_64
# RUN: llvm-mca -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr4-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR3-4_32,SCR4_32
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr5-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR5_64
# RUN: llvm-mca -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr5-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR5_32

lw a0, 0(s0)
lw a1, 0(s0)
lw a2, 0(s0)
lw a3, 0(s0)

# CHECK:          Iterations:        1
# CHECK-NEXT:     Instructions:      4

# SCR3-4_32-NEXT: Total Cycles:      6
# SCR3-4_64-NEXT: Total Cycles:      6
# SCR5_32-NEXT:   Total Cycles:      7
# SCR5_64-NEXT:   Total Cycles:      7

# CHECK-NEXT:     Total uOps:        4

# CHECK:          Dispatch Width:    1

# SCR3-4_32-NEXT: uOps Per Cycle:    0.67
# SCR3-4_32-NEXT: IPC:               0.67

# SCR3-4_64-NEXT: uOps Per Cycle:    0.67
# SCR3-4_64-NEXT: IPC:               0.67

# SCR5_32-NEXT:   uOps Per Cycle:    0.57
# SCR5_32-NEXT:   IPC:               0.57

# SCR5_64-NEXT:   uOps Per Cycle:    0.57
# SCR5_64-NEXT:   IPC:               0.57

# CHECK-NEXT:     Block RThroughput: 4.0

# CHECK:          Instruction Info:
# CHECK-NEXT:     [1]: #uOps
# CHECK-NEXT:     [2]: Latency
# CHECK-NEXT:     [3]: RThroughput
# CHECK-NEXT:     [4]: MayLoad
# CHECK-NEXT:     [5]: MayStore
# CHECK-NEXT:     [6]: HasSideEffects (U)

# CHECK:          [1]    [2]    [3]    [4]    [5]    [6]    Instructions:

# SCR3-4_32-NEXT:  1      2     1.00    *                   lw	a0, 0(s0)
# SCR3-4_32-NEXT:  1      2     1.00    *                   lw	a1, 0(s0)
# SCR3-4_32-NEXT:  1      2     1.00    *                   lw	a2, 0(s0)
# SCR3-4_32-NEXT:  1      2     1.00    *                   lw	a3, 0(s0)

# SCR3-4_64-NEXT:  1      2     1.00    *                   lw	a0, 0(s0)
# SCR3-4_64-NEXT:  1      2     1.00    *                   lw	a1, 0(s0)
# SCR3-4_64-NEXT:  1      2     1.00    *                   lw	a2, 0(s0)
# SCR3-4_64-NEXT:  1      2     1.00    *                   lw	a3, 0(s0)

# SCR5_32-NEXT:    1      3     1.00    *                   lw	a0, 0(s0)
# SCR5_32-NEXT:    1      3     1.00    *                   lw	a1, 0(s0)
# SCR5_32-NEXT:    1      3     1.00    *                   lw	a2, 0(s0)
# SCR5_32-NEXT:    1      3     1.00    *                   lw	a3, 0(s0)

# SCR5_64-NEXT:    1      3     1.00    *                   lw	a0, 0(s0)
# SCR5_64-NEXT:    1      3     1.00    *                   lw	a1, 0(s0)
# SCR5_64-NEXT:    1      3     1.00    *                   lw	a2, 0(s0)
# SCR5_64-NEXT:    1      3     1.00    *                   lw	a3, 0(s0)

# SCR3_32:        Resources:
# SCR3_32-NEXT:   [0]   - SCR3RV32_ALU
# SCR3_32-NEXT:   [1]   - SCR3RV32_CFU
# SCR3_32-NEXT:   [2]   - SCR3RV32_DIV
# SCR3_32-NEXT:   [3]   - SCR3RV32_LSU
# SCR3_32-NEXT:   [4]   - SCR3RV32_MUL

# SCR3_64:        Resources:
# SCR3_64-NEXT:   [0]   - SCR3RV64_ALU
# SCR3_64-NEXT:   [1]   - SCR3RV64_CFU
# SCR3_64-NEXT:   [2]   - SCR3RV64_DIV
# SCR3_64-NEXT:   [3]   - SCR3RV64_LSU
# SCR3_64-NEXT:   [4]   - SCR3RV64_MUL

# SCR4_32:        Resources:
# SCR4_32-NEXT:   [0]   - SCR4RV32_ALU
# SCR4_32-NEXT:   [1]   - SCR4RV32_CFU
# SCR4_32-NEXT:   [2]   - SCR4RV32_DIV
# SCR4_32-NEXT:   [3]   - SCR4RV32_FDU
# SCR4_32-NEXT:   [4]   - SCR4RV32_FPU
# SCR4_32-NEXT:   [5]   - SCR4RV32_LSU
# SCR4_32-NEXT:   [6]   - SCR4RV32_MUL

# SCR4_64:        Resources:
# SCR4_64-NEXT:   [0]   - SCR4RV64_ALU
# SCR4_64-NEXT:   [1]   - SCR4RV64_CFU
# SCR4_64-NEXT:   [2]   - SCR4RV64_DIV
# SCR4_64-NEXT:   [3]   - SCR4RV64_FDU
# SCR4_64-NEXT:   [4]   - SCR4RV64_FPU
# SCR4_64-NEXT:   [5]   - SCR4RV64_LSU
# SCR4_64-NEXT:   [6]   - SCR4RV64_MUL

# SCR5_32:        Resources:
# SCR5_32-NEXT:   [0]   - SCR5RV32_ALU
# SCR5_32-NEXT:   [1]   - SCR5RV32_CFU
# SCR5_32-NEXT:   [2]   - SCR5RV32_DIV
# SCR5_32-NEXT:   [3]   - SCR5RV32_FDU
# SCR5_32-NEXT:   [4]   - SCR5RV32_FPU
# SCR5_32-NEXT:   [5]   - SCR5RV32_LSU
# SCR5_32-NEXT:   [6]   - SCR5RV32_MUL

# SCR5_64:        Resources:
# SCR5_64-NEXT:   [0]   - SCR5RV64_ALU
# SCR5_64-NEXT:   [1]   - SCR5RV64_CFU
# SCR5_64-NEXT:   [2]   - SCR5RV64_DIV
# SCR5_64-NEXT:   [3]   - SCR5RV64_FDU
# SCR5_64-NEXT:   [4]   - SCR5RV64_FPU
# SCR5_64-NEXT:   [5]   - SCR5RV64_LSU
# SCR5_64-NEXT:   [6]   - SCR5RV64_MUL

# CHECK:          Resource pressure per iteration:

# SCR3_32-NEXT:   [0]    [1]    [2]    [3]    [4]
# SCR3_32-NEXT:    -      -      -     4.00    -

# SCR3_64-NEXT:   [0]    [1]    [2]    [3]    [4]
# SCR3_64-NEXT:    -      -      -     4.00    -

# SCR4_32-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]
# SCR4_32-NEXT:    -      -      -      -      -     4.00    -

# SCR4_64-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]
# SCR4_64-NEXT:    -      -      -      -      -     4.00    -

# SCR5_32-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]
# SCR5_32-NEXT:    -      -      -      -      -     4.00    -

# SCR5_64-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]
# SCR5_64-NEXT:    -      -      -      -      -     4.00    -

# CHECK:          Resource pressure by instruction:

# SCR3_32-NEXT:   [0]    [1]    [2]    [3]    [4]    Instructions:
# SCR3_32-NEXT:    -      -      -     1.00    -     lw	a0, 0(s0)
# SCR3_32-NEXT:    -      -      -     1.00    -     lw	a1, 0(s0)
# SCR3_32-NEXT:    -      -      -     1.00    -     lw	a2, 0(s0)
# SCR3_32-NEXT:    -      -      -     1.00    -     lw	a3, 0(s0)

# SCR3_64-NEXT:   [0]    [1]    [2]    [3]    [4]    Instructions:
# SCR3_64-NEXT:    -      -      -     1.00    -     lw	a0, 0(s0)
# SCR3_64-NEXT:    -      -      -     1.00    -     lw	a1, 0(s0)
# SCR3_64-NEXT:    -      -      -     1.00    -     lw	a2, 0(s0)
# SCR3_64-NEXT:    -      -      -     1.00    -     lw	a3, 0(s0)

# SCR4_32-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# SCR4_32-NEXT:    -      -      -      -      -     1.00    -     lw	a0, 0(s0)
# SCR4_32-NEXT:    -      -      -      -      -     1.00    -     lw	a1, 0(s0)
# SCR4_32-NEXT:    -      -      -      -      -     1.00    -     lw	a2, 0(s0)
# SCR4_32-NEXT:    -      -      -      -      -     1.00    -     lw	a3, 0(s0)

# SCR4_64-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# SCR4_64-NEXT:    -      -      -      -      -     1.00    -     lw	a0, 0(s0)
# SCR4_64-NEXT:    -      -      -      -      -     1.00    -     lw	a1, 0(s0)
# SCR4_64-NEXT:    -      -      -      -      -     1.00    -     lw	a2, 0(s0)
# SCR4_64-NEXT:    -      -      -      -      -     1.00    -     lw	a3, 0(s0)

# SCR5_32-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# SCR5_32-NEXT:    -      -      -      -      -     1.00    -     lw	a0, 0(s0)
# SCR5_32-NEXT:    -      -      -      -      -     1.00    -     lw	a1, 0(s0)
# SCR5_32-NEXT:    -      -      -      -      -     1.00    -     lw	a2, 0(s0)
# SCR5_32-NEXT:    -      -      -      -      -     1.00    -     lw	a3, 0(s0)

# SCR5_64-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# SCR5_64-NEXT:    -      -      -      -      -     1.00    -     lw	a0, 0(s0)
# SCR5_64-NEXT:    -      -      -      -      -     1.00    -     lw	a1, 0(s0)
# SCR5_64-NEXT:    -      -      -      -      -     1.00    -     lw	a2, 0(s0)
# SCR5_64-NEXT:    -      -      -      -      -     1.00    -     lw	a3, 0(s0)
