; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfhmin,+zvfhmin,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfhmin,+zvfhmin,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFHMIN

define half @vpreduce_fmin_nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vpreduce_fmin_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.s.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmin.vs v9, v8, v9, v0.t
; ZVFH-NEXT:    vfmv.f.s fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vpreduce_fmin_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.s.f v8, fa5
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmin.vs v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call half @llvm.vp.reduce.fmin.nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret half %s
}

define half @vpreduce_fmax_nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vpreduce_fmax_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.s.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmax.vs v9, v8, v9, v0.t
; ZVFH-NEXT:    vfmv.f.s fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vpreduce_fmax_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.s.f v8, fa5
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmax.vs v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call half @llvm.vp.reduce.fmax.nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret half %s
}

define half @vpreduce_fmin_nnan_nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vpreduce_fmin_nnan_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.s.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmin.vs v9, v8, v9, v0.t
; ZVFH-NEXT:    vfmv.f.s fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vpreduce_fmin_nnan_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.s.f v8, fa5
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmin.vs v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call nnan half @llvm.vp.reduce.fmin.nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret half %s
}

define half @vpreduce_fmax_nnan_nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vpreduce_fmax_nnan_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.s.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmax.vs v9, v8, v9, v0.t
; ZVFH-NEXT:    vfmv.f.s fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vpreduce_fmax_nnan_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.s.f v8, fa5
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmax.vs v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call nnan half @llvm.vp.reduce.fmax.nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret half %s
}

define half @vpreduce_fminimum_nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vpreduce_fminimum_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vv v9, v8, v8, v0.t
; ZVFH-NEXT:    fcvt.s.h fa5, fa0
; ZVFH-NEXT:    vcpop.m a1, v9, v0.t
; ZVFH-NEXT:    feq.s a2, fa5, fa5
; ZVFH-NEXT:    xori a2, a2, 1
; ZVFH-NEXT:    or a1, a1, a2
; ZVFH-NEXT:    beqz a1, .LBB4_2
; ZVFH-NEXT:  # %bb.1:
; ZVFH-NEXT:    lui a0, %hi(.LCPI4_0)
; ZVFH-NEXT:    flh fa0, %lo(.LCPI4_0)(a0)
; ZVFH-NEXT:    ret
; ZVFH-NEXT:  .LBB4_2:
; ZVFH-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.s.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmin.vs v9, v8, v9, v0.t
; ZVFH-NEXT:    vfmv.f.s fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vpreduce_fminimum_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    feq.s a1, fa5, fa5
; ZVFHMIN-NEXT:    vcpop.m a2, v8, v0.t
; ZVFHMIN-NEXT:    xori a1, a1, 1
; ZVFHMIN-NEXT:    or a1, a2, a1
; ZVFHMIN-NEXT:    beqz a1, .LBB4_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    lui a0, 523264
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
; ZVFHMIN-NEXT:  .LBB4_2:
; ZVFHMIN-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.s.f v8, fa5
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmin.vs v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call half @llvm.vp.reduce.fminimum.nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret half %s
}

define half @vpreduce_fmaximum_nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vpreduce_fmaximum_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vv v9, v8, v8, v0.t
; ZVFH-NEXT:    fcvt.s.h fa5, fa0
; ZVFH-NEXT:    vcpop.m a1, v9, v0.t
; ZVFH-NEXT:    feq.s a2, fa5, fa5
; ZVFH-NEXT:    xori a2, a2, 1
; ZVFH-NEXT:    or a1, a1, a2
; ZVFH-NEXT:    beqz a1, .LBB5_2
; ZVFH-NEXT:  # %bb.1:
; ZVFH-NEXT:    lui a0, %hi(.LCPI5_0)
; ZVFH-NEXT:    flh fa0, %lo(.LCPI5_0)(a0)
; ZVFH-NEXT:    ret
; ZVFH-NEXT:  .LBB5_2:
; ZVFH-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.s.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmax.vs v9, v8, v9, v0.t
; ZVFH-NEXT:    vfmv.f.s fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vpreduce_fmaximum_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    feq.s a1, fa5, fa5
; ZVFHMIN-NEXT:    vcpop.m a2, v8, v0.t
; ZVFHMIN-NEXT:    xori a1, a1, 1
; ZVFHMIN-NEXT:    or a1, a2, a1
; ZVFHMIN-NEXT:    beqz a1, .LBB5_2
; ZVFHMIN-NEXT:  # %bb.1:
; ZVFHMIN-NEXT:    lui a0, 523264
; ZVFHMIN-NEXT:    fmv.w.x fa5, a0
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
; ZVFHMIN-NEXT:  .LBB5_2:
; ZVFHMIN-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.s.f v8, fa5
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmax.vs v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call half @llvm.vp.reduce.fmaximum.nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret half %s
}

define half @vpreduce_fminimum_nnan_nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vpreduce_fminimum_nnan_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.s.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmin.vs v9, v8, v9, v0.t
; ZVFH-NEXT:    vfmv.f.s fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vpreduce_fminimum_nnan_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.s.f v8, fa5
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmin.vs v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call nnan half @llvm.vp.reduce.fminimum.nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret half %s
}

define half @vpreduce_fmaximum_nnan_nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: vpreduce_fmaximum_nnan_nxv4f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.s.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vfredmax.vs v9, v8, v9, v0.t
; ZVFH-NEXT:    vfmv.f.s fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vpreduce_fmaximum_nnan_nxv4f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.s.f v8, fa5
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfredmax.vs v8, v10, v8, v0.t
; ZVFHMIN-NEXT:    vfmv.f.s fa5, v8
; ZVFHMIN-NEXT:    fcvt.h.s fa0, fa5
; ZVFHMIN-NEXT:    ret
  %s = call nnan half @llvm.vp.reduce.fmaximum.nxv4f16(half %start, <vscale x 4 x half> %val, <vscale x 4 x i1> %m, i32 %evl)
  ret half %s
}
