// NOTE: Assertions have been autogenerated by utils/update_mc_test_checks.py UTC_ARGS: --unique --version 5
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,+real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX11,W32 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64,+real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX11,W64 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,+real-true16 -filetype=null %s 2>&1 | FileCheck --check-prefixes=W32-ERR,GFX11-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64,+real-true16 -filetype=null %s 2>&1 | FileCheck --check-prefixes=W64-ERR,GFX11-ERR --implicit-check-not=error: %s

//===----------------------------------------------------------------------===//
// HW correctly handles fp inline constants for src2 (they have f16 type).
// Check that inline constants are not converted to literals.
//===----------------------------------------------------------------------===//

v_cmp_class_f16_e64 s[10:11], v1.l, 0.5
// W64: v_cmp_class_f16_e64 s[10:11], v1.l, 0.5 ; encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xe1,0x01,0x00]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_class_f16_e64 s10, v1.l, 0.5
// W32: v_cmp_class_f16_e64 s10, v1.l, 0.5      ; encoding: [0x0a,0x00,0x7d,0xd4,0x01,0xe1,0x01,0x00]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmpx_class_f16_e64 v1.l, 0.5
// GFX11: v_cmpx_class_f16_e64 v1.l, 0.5          ; encoding: [0x7e,0x00,0xfd,0xd4,0x01,0xe1,0x01,0x00]

//===----------------------------------------------------------------------===//
// src0 and src2 are packed operands.
// Check that op_sel is not allowed with these operands.
//===----------------------------------------------------------------------===//

v_dot2_f16_f16_e64 v0.l, v1.h, v2, v3.l
// GFX11-ERR: :[[@LINE-1]]:26: error: invalid operand for instruction

v_dot2_f16_f16_e64_dpp v0.l, v1, v2.h, v3.l dpp8:[0,1,2,3,4,4,4,4]
// GFX11-ERR: :[[@LINE-1]]:34: error: invalid operand for instruction

v_dot2_f16_f16_e64_dpp v0.l, v1.h, v2, v3.l quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 fi:1
// GFX11-ERR: :[[@LINE-1]]:30: error: invalid operand for instruction

v_dot2_bf16_bf16_e64 v0.l, v1, v2.h, v3.l
// GFX11-ERR: :[[@LINE-1]]:32: error: invalid operand for instruction

v_dot2_bf16_bf16_e64_dpp v0.l, v1.h, v2, v3.l dpp8:[0,1,2,3,4,4,4,4]
// GFX11-ERR: :[[@LINE-1]]:32: error: invalid operand for instruction

v_dot2_bf16_bf16_e64_dpp v0.l, v1, v2.h, v3.l quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 fi:1
// GFX11-ERR: :[[@LINE-1]]:36: error: invalid operand for instruction

//===----------------------------------------------------------------------===//
// src0 and src1 are vector operands.
// Check that SGPRs are not allowed for these operands.
//===----------------------------------------------------------------------===//

v_dot2_f16_f16_e64_dpp v0.l, s1, v2, v3.l dpp8:[0,1,2,3,4,4,4,4]
// GFX11-ERR: :[[@LINE-1]]:30: error: invalid operand for instruction

v_dot2_f16_f16_e64_dpp v0.l, v1, s2, v3.l dpp8:[0,1,2,3,4,4,4,4]
// GFX11-ERR: :[[@LINE-1]]:34: error: invalid operand for instruction

v_dot2_f16_f16_e64_dpp v0.l, s1, v2, v3.l quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 fi:1
// GFX11-ERR: :[[@LINE-1]]:30: error: invalid operand for instruction

v_dot2_f16_f16_e64_dpp v0.l, v1, s2, v3.l quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 fi:1
// GFX11-ERR: :[[@LINE-1]]:34: error: invalid operand for instruction

v_dot2_bf16_bf16_e64_dpp v0.l, s1, v2, v3.l dpp8:[0,1,2,3,4,4,4,4]
// GFX11-ERR: :[[@LINE-1]]:32: error: invalid operand for instruction

v_dot2_bf16_bf16_e64_dpp v0.l, v1, s2, v3.l dpp8:[0,1,2,3,4,4,4,4]
// GFX11-ERR: :[[@LINE-1]]:36: error: invalid operand for instruction

v_dot2_bf16_bf16_e64_dpp v0.l, s1, v2, v3.l quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX11-ERR: :[[@LINE-1]]:32: error: invalid operand for instruction

v_dot2_bf16_bf16_e64_dpp v0.l, v1, s2, v3.l quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX11-ERR: :[[@LINE-1]]:36: error: invalid operand for instruction

// Ensure bits 8-15 are not zeroed out and .h which should be present on src0 and dst are present.
v_mul_f16_e64 v5.h, v1.h, v2.l
// GFX11: v_mul_f16_e64 v5.h, v1.h, v2.l op_sel:[1,0,1] ; encoding: [0x05,0x48,0x35,0xd5,0x01,0x05,0x02,0x00]
