/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* Copyright 2023 The OpenBLAS Project.                              */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_ZEN;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_ZEN.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES,

  SWITCH_RATIO,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  SBGEMM_ALIGN_K,
  0, // need_amxtile_permission

  sbstobf16_k_ZEN, sbdtobf16_k_ZEN, sbf16tos_k_ZEN, dbf16tod_k_ZEN,

  samax_k_ZEN,  samin_k_ZEN,  smax_k_ZEN,  smin_k_ZEN,
  isamax_k_ZEN, isamin_k_ZEN, ismax_k_ZEN, ismin_k_ZEN,
  snrm2_k_ZEN,  sasum_k_ZEN, ssum_k_ZEN, scopy_k_ZEN, sbdot_k_ZEN,
  dsdot_k_ZEN,
  srot_k_ZEN,   saxpy_k_ZEN,  sscal_k_ZEN, sswap_k_ZEN,
  sbgemv_n_ZEN, sbgemv_t_ZEN, sger_k_ZEN,
  ssymv_L_ZEN, ssymv_U_ZEN,

  sbgemm_kernel_ZEN, sbgemm_beta_ZEN,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_ZEN, sbgemm_itcopy_ZEN,
#else
  sbgemm_oncopy_ZEN, sbgemm_otcopy_ZEN,
#endif
  sbgemm_oncopy_ZEN, sbgemm_otcopy_ZEN,

  strsm_kernel_LN_ZEN, strsm_kernel_LT_ZEN, strsm_kernel_RN_ZEN, strsm_kernel_RT_ZEN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_ZEN, strsm_iunncopy_ZEN, strsm_iutucopy_ZEN, strsm_iutncopy_ZEN,
  strsm_ilnucopy_ZEN, strsm_ilnncopy_ZEN, strsm_iltucopy_ZEN, strsm_iltncopy_ZEN,
#else
  strsm_ounucopy_ZEN, strsm_ounncopy_ZEN, strsm_outucopy_ZEN, strsm_outncopy_ZEN,
  strsm_olnucopy_ZEN, strsm_olnncopy_ZEN, strsm_oltucopy_ZEN, strsm_oltncopy_ZEN,
#endif
  strsm_ounucopy_ZEN, strsm_ounncopy_ZEN, strsm_outucopy_ZEN, strsm_outncopy_ZEN,
  strsm_olnucopy_ZEN, strsm_olnncopy_ZEN, strsm_oltucopy_ZEN, strsm_oltncopy_ZEN,
  strmm_kernel_RN_ZEN, strmm_kernel_RT_ZEN, strmm_kernel_LN_ZEN, strmm_kernel_LT_ZEN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_ZEN, strmm_iunncopy_ZEN, strmm_iutucopy_ZEN, strmm_iutncopy_ZEN,
  strmm_ilnucopy_ZEN, strmm_ilnncopy_ZEN, strmm_iltucopy_ZEN, strmm_iltncopy_ZEN,
#else
  strmm_ounucopy_ZEN, strmm_ounncopy_ZEN, strmm_outucopy_ZEN, strmm_outncopy_ZEN,
  strmm_olnucopy_ZEN, strmm_olnncopy_ZEN, strmm_oltucopy_ZEN, strmm_oltncopy_ZEN,
#endif
  strmm_ounucopy_ZEN, strmm_ounncopy_ZEN, strmm_outucopy_ZEN, strmm_outncopy_ZEN,
  strmm_olnucopy_ZEN, strmm_olnncopy_ZEN, strmm_oltucopy_ZEN, strmm_oltncopy_ZEN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_ZEN, ssymm_iltcopy_ZEN,
#else
  ssymm_outcopy_ZEN, ssymm_oltcopy_ZEN,
#endif
  ssymm_outcopy_ZEN, ssymm_oltcopy_ZEN,

#ifndef NO_LAPACK
  sneg_tcopy_ZEN, slaswp_ncopy_ZEN,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_ZEN,
  sbgemm_small_kernel_nn_ZEN, sbgemm_small_kernel_nt_ZEN, sbgemm_small_kernel_tn_ZEN, sbgemm_small_kernel_tt_ZEN,
  sbgemm_small_kernel_b0_nn_ZEN, sbgemm_small_kernel_b0_nt_ZEN, sbgemm_small_kernel_b0_tn_ZEN, sbgemm_small_kernel_b0_tt_ZEN,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  samax_k_ZEN,  samin_k_ZEN,  smax_k_ZEN,  smin_k_ZEN,
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  isamax_k_ZEN,
#endif 
#if (BUILD_SINGLE==1 ) || (BUILD_COMPLEX==1)
  isamin_k_ZEN, ismax_k_ZEN, ismin_k_ZEN,
  snrm2_k_ZEN,  sasum_k_ZEN,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_ZEN,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_ZEN, sdot_k_ZEN,
//  dsdot_k_ZEN,
  srot_k_ZEN,   saxpy_k_ZEN,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_ZEN,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_ZEN,
  sgemv_n_ZEN,  sgemv_t_ZEN,
#endif
#if BUILD_SINGLE == 1
  sger_k_ZEN,
#endif
#if BUILD_SINGLE == 1  
  ssymv_L_ZEN, ssymv_U_ZEN,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_ZEN,
  sgemm_direct_performant_ZEN,	
#endif

  sgemm_kernel_ZEN, sgemm_beta_ZEN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_ZEN, sgemm_itcopy_ZEN,
#else
  sgemm_oncopy_ZEN, sgemm_otcopy_ZEN,
#endif
  sgemm_oncopy_ZEN, sgemm_otcopy_ZEN,
#endif

#if BUILD_SINGLE == 1 || BUILD_DOUBLE == 1 || BUILD_COMPLEX == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_ZEN,
  sgemm_small_kernel_nn_ZEN, sgemm_small_kernel_nt_ZEN, sgemm_small_kernel_tn_ZEN, sgemm_small_kernel_tt_ZEN,
  sgemm_small_kernel_b0_nn_ZEN, sgemm_small_kernel_b0_nt_ZEN, sgemm_small_kernel_b0_tn_ZEN, sgemm_small_kernel_b0_tt_ZEN,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX == 1)
  strsm_kernel_LN_ZEN, strsm_kernel_LT_ZEN, strsm_kernel_RN_ZEN, strsm_kernel_RT_ZEN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_ZEN, strsm_iunncopy_ZEN, strsm_iutucopy_ZEN, strsm_iutncopy_ZEN,
  strsm_ilnucopy_ZEN, strsm_ilnncopy_ZEN, strsm_iltucopy_ZEN, strsm_iltncopy_ZEN,
#else
  strsm_ounucopy_ZEN, strsm_ounncopy_ZEN, strsm_outucopy_ZEN, strsm_outncopy_ZEN,
  strsm_olnucopy_ZEN, strsm_olnncopy_ZEN, strsm_oltucopy_ZEN, strsm_oltncopy_ZEN,
#endif
  strsm_ounucopy_ZEN, strsm_ounncopy_ZEN, strsm_outucopy_ZEN, strsm_outncopy_ZEN,
  strsm_olnucopy_ZEN, strsm_olnncopy_ZEN, strsm_oltucopy_ZEN, strsm_oltncopy_ZEN,
#endif
#if (BUILD_SINGLE==1)
  strmm_kernel_RN_ZEN, strmm_kernel_RT_ZEN, strmm_kernel_LN_ZEN, strmm_kernel_LT_ZEN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_ZEN, strmm_iunncopy_ZEN, strmm_iutucopy_ZEN, strmm_iutncopy_ZEN,
  strmm_ilnucopy_ZEN, strmm_ilnncopy_ZEN, strmm_iltucopy_ZEN, strmm_iltncopy_ZEN,
#else
  strmm_ounucopy_ZEN, strmm_ounncopy_ZEN, strmm_outucopy_ZEN, strmm_outncopy_ZEN,
  strmm_olnucopy_ZEN, strmm_olnncopy_ZEN, strmm_oltucopy_ZEN, strmm_oltncopy_ZEN,
#endif
  strmm_ounucopy_ZEN, strmm_ounncopy_ZEN, strmm_outucopy_ZEN, strmm_outncopy_ZEN,
  strmm_olnucopy_ZEN, strmm_olnncopy_ZEN, strmm_oltucopy_ZEN, strmm_oltncopy_ZEN,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_ZEN, ssymm_iltcopy_ZEN,
#else
  ssymm_outcopy_ZEN, ssymm_oltcopy_ZEN,
#endif
  ssymm_outcopy_ZEN, ssymm_oltcopy_ZEN,
#ifndef NO_LAPACK
  sneg_tcopy_ZEN, slaswp_ncopy_ZEN,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  damax_k_ZEN,  damin_k_ZEN,  dmax_k_ZEN,  dmin_k_ZEN,
  idamax_k_ZEN, idamin_k_ZEN, idmax_k_ZEN, idmin_k_ZEN,
  dnrm2_k_ZEN, dasum_k_ZEN,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_ZEN,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dcopy_k_ZEN, ddot_k_ZEN,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_ZEN,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  drot_k_ZEN,
  daxpy_k_ZEN,
  dscal_k_ZEN, 
  dswap_k_ZEN,
  dgemv_n_ZEN,  dgemv_t_ZEN,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_ZEN,
  dsymv_L_ZEN,  dsymv_U_ZEN,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
  dgemm_kernel_ZEN, dgemm_beta_ZEN,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_ZEN, dgemm_itcopy_ZEN,
#else
  dgemm_oncopy_ZEN, dgemm_otcopy_ZEN,
#endif
  dgemm_oncopy_ZEN, dgemm_otcopy_ZEN,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_ZEN,
  dgemm_small_kernel_nn_ZEN, dgemm_small_kernel_nt_ZEN, dgemm_small_kernel_tn_ZEN, dgemm_small_kernel_tt_ZEN,
  dgemm_small_kernel_b0_nn_ZEN, dgemm_small_kernel_b0_nt_ZEN, dgemm_small_kernel_b0_tn_ZEN, dgemm_small_kernel_b0_tt_ZEN,
#endif
#endif
#if  (BUILD_DOUBLE==1)   
  dtrsm_kernel_LN_ZEN, dtrsm_kernel_LT_ZEN, dtrsm_kernel_RN_ZEN, dtrsm_kernel_RT_ZEN,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_ZEN, dtrsm_iunncopy_ZEN, dtrsm_iutucopy_ZEN, dtrsm_iutncopy_ZEN,
  dtrsm_ilnucopy_ZEN, dtrsm_ilnncopy_ZEN, dtrsm_iltucopy_ZEN, dtrsm_iltncopy_ZEN,
#else
  dtrsm_ounucopy_ZEN, dtrsm_ounncopy_ZEN, dtrsm_outucopy_ZEN, dtrsm_outncopy_ZEN,
  dtrsm_olnucopy_ZEN, dtrsm_olnncopy_ZEN, dtrsm_oltucopy_ZEN, dtrsm_oltncopy_ZEN,
#endif
  dtrsm_ounucopy_ZEN, dtrsm_ounncopy_ZEN, dtrsm_outucopy_ZEN, dtrsm_outncopy_ZEN,
  dtrsm_olnucopy_ZEN, dtrsm_olnncopy_ZEN, dtrsm_oltucopy_ZEN, dtrsm_oltncopy_ZEN,
  dtrmm_kernel_RN_ZEN, dtrmm_kernel_RT_ZEN, dtrmm_kernel_LN_ZEN, dtrmm_kernel_LT_ZEN,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_ZEN, dtrmm_iunncopy_ZEN, dtrmm_iutucopy_ZEN, dtrmm_iutncopy_ZEN,
  dtrmm_ilnucopy_ZEN, dtrmm_ilnncopy_ZEN, dtrmm_iltucopy_ZEN, dtrmm_iltncopy_ZEN,
#else
  dtrmm_ounucopy_ZEN, dtrmm_ounncopy_ZEN, dtrmm_outucopy_ZEN, dtrmm_outncopy_ZEN,
  dtrmm_olnucopy_ZEN, dtrmm_olnncopy_ZEN, dtrmm_oltucopy_ZEN, dtrmm_oltncopy_ZEN,
#endif
  dtrmm_ounucopy_ZEN, dtrmm_ounncopy_ZEN, dtrmm_outucopy_ZEN, dtrmm_outncopy_ZEN,
  dtrmm_olnucopy_ZEN, dtrmm_olnncopy_ZEN, dtrmm_oltucopy_ZEN, dtrmm_oltncopy_ZEN,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_ZEN, dsymm_iltcopy_ZEN,
#else
  dsymm_outcopy_ZEN, dsymm_oltcopy_ZEN,
#endif
  dsymm_outcopy_ZEN, dsymm_oltcopy_ZEN,

#ifndef NO_LAPACK
  dneg_tcopy_ZEN, dlaswp_ncopy_ZEN,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_ZEN,  qamin_k_ZEN,  qmax_k_ZEN,  qmin_k_ZEN,
  iqamax_k_ZEN, iqamin_k_ZEN, iqmax_k_ZEN, iqmin_k_ZEN,
  qnrm2_k_ZEN,  qasum_k_ZEN,  qsum_k_ZEN, qcopy_k_ZEN, qdot_k_ZEN,
  qrot_k_ZEN,   qaxpy_k_ZEN,  qscal_k_ZEN, qswap_k_ZEN,
  qgemv_n_ZEN,  qgemv_t_ZEN,  qger_k_ZEN,
  qsymv_L_ZEN,  qsymv_U_ZEN,

  qgemm_kernel_ZEN, qgemm_beta_ZEN,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_ZEN, qgemm_itcopy_ZEN,
#else
  qgemm_oncopy_ZEN, qgemm_otcopy_ZEN,
#endif
  qgemm_oncopy_ZEN, qgemm_otcopy_ZEN,
  qtrsm_kernel_LN_ZEN, qtrsm_kernel_LT_ZEN, qtrsm_kernel_RN_ZEN, qtrsm_kernel_RT_ZEN,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_ZEN, qtrsm_iunncopy_ZEN, qtrsm_iutucopy_ZEN, qtrsm_iutncopy_ZEN,
  qtrsm_ilnucopy_ZEN, qtrsm_ilnncopy_ZEN, qtrsm_iltucopy_ZEN, qtrsm_iltncopy_ZEN,
#else
  qtrsm_ounucopy_ZEN, qtrsm_ounncopy_ZEN, qtrsm_outucopy_ZEN, qtrsm_outncopy_ZEN,
  qtrsm_olnucopy_ZEN, qtrsm_olnncopy_ZEN, qtrsm_oltucopy_ZEN, qtrsm_oltncopy_ZEN,
#endif
  qtrsm_ounucopy_ZEN, qtrsm_ounncopy_ZEN, qtrsm_outucopy_ZEN, qtrsm_outncopy_ZEN,
  qtrsm_olnucopy_ZEN, qtrsm_olnncopy_ZEN, qtrsm_oltucopy_ZEN, qtrsm_oltncopy_ZEN,
  qtrmm_kernel_RN_ZEN, qtrmm_kernel_RT_ZEN, qtrmm_kernel_LN_ZEN, qtrmm_kernel_LT_ZEN,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_ZEN, qtrmm_iunncopy_ZEN, qtrmm_iutucopy_ZEN, qtrmm_iutncopy_ZEN,
  qtrmm_ilnucopy_ZEN, qtrmm_ilnncopy_ZEN, qtrmm_iltucopy_ZEN, qtrmm_iltncopy_ZEN,
#else
  qtrmm_ounucopy_ZEN, qtrmm_ounncopy_ZEN, qtrmm_outucopy_ZEN, qtrmm_outncopy_ZEN,
  qtrmm_olnucopy_ZEN, qtrmm_olnncopy_ZEN, qtrmm_oltucopy_ZEN, qtrmm_oltncopy_ZEN,
#endif
  qtrmm_ounucopy_ZEN, qtrmm_ounncopy_ZEN, qtrmm_outucopy_ZEN, qtrmm_outncopy_ZEN,
  qtrmm_olnucopy_ZEN, qtrmm_olnncopy_ZEN, qtrmm_oltucopy_ZEN, qtrmm_oltncopy_ZEN,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_ZEN, qsymm_iltcopy_ZEN,
#else
  qsymm_outcopy_ZEN, qsymm_oltcopy_ZEN,
#endif
  qsymm_outcopy_ZEN, qsymm_oltcopy_ZEN,

#ifndef NO_LAPACK
  qneg_tcopy_ZEN, qlaswp_ncopy_ZEN,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
#if (BUILD_COMPLEX)
  camax_k_ZEN, camin_k_ZEN,
#endif
#if (BUILD_COMPLEX)
  icamax_k_ZEN, 
#endif
#if (BUILD_COMPLEX)
  icamin_k_ZEN,
  cnrm2_k_ZEN, casum_k_ZEN, csum_k_ZEN,
#endif
#if (BUILD_COMPLEX)
  ccopy_k_ZEN, cdotu_k_ZEN, cdotc_k_ZEN,
#endif
#if (BUILD_COMPLEX)
 csrot_k_ZEN,
#endif
#if (BUILD_COMPLEX)
  caxpy_k_ZEN,
  caxpyc_k_ZEN, 
  cscal_k_ZEN, 
  cswap_k_ZEN,

  cgemv_n_ZEN, cgemv_t_ZEN, cgemv_r_ZEN, cgemv_c_ZEN,
  cgemv_o_ZEN, cgemv_u_ZEN, cgemv_s_ZEN, cgemv_d_ZEN,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_ZEN, cgerc_k_ZEN, cgerv_k_ZEN, cgerd_k_ZEN,
  csymv_L_ZEN, csymv_U_ZEN,
  chemv_L_ZEN, chemv_U_ZEN, chemv_M_ZEN, chemv_V_ZEN,
#endif
#if (BUILD_COMPLEX)
  cgemm_kernel_n_ZEN, cgemm_kernel_l_ZEN, cgemm_kernel_r_ZEN, cgemm_kernel_b_ZEN,
  cgemm_beta_ZEN,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_ZEN, cgemm_itcopy_ZEN,
#else
  cgemm_oncopy_ZEN, cgemm_otcopy_ZEN,
#endif
  cgemm_oncopy_ZEN, cgemm_otcopy_ZEN,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_ZEN,
  cgemm_small_kernel_nn_ZEN, cgemm_small_kernel_nt_ZEN, cgemm_small_kernel_nr_ZEN, cgemm_small_kernel_nc_ZEN,
  cgemm_small_kernel_tn_ZEN, cgemm_small_kernel_tt_ZEN, cgemm_small_kernel_tr_ZEN, cgemm_small_kernel_tc_ZEN,
  cgemm_small_kernel_rn_ZEN, cgemm_small_kernel_rt_ZEN, cgemm_small_kernel_rr_ZEN, cgemm_small_kernel_rc_ZEN,
  cgemm_small_kernel_cn_ZEN, cgemm_small_kernel_ct_ZEN, cgemm_small_kernel_cr_ZEN, cgemm_small_kernel_cc_ZEN,
  cgemm_small_kernel_b0_nn_ZEN, cgemm_small_kernel_b0_nt_ZEN, cgemm_small_kernel_b0_nr_ZEN, cgemm_small_kernel_b0_nc_ZEN,
  cgemm_small_kernel_b0_tn_ZEN, cgemm_small_kernel_b0_tt_ZEN, cgemm_small_kernel_b0_tr_ZEN, cgemm_small_kernel_b0_tc_ZEN,
  cgemm_small_kernel_b0_rn_ZEN, cgemm_small_kernel_b0_rt_ZEN, cgemm_small_kernel_b0_rr_ZEN, cgemm_small_kernel_b0_rc_ZEN,
  cgemm_small_kernel_b0_cn_ZEN, cgemm_small_kernel_b0_ct_ZEN, cgemm_small_kernel_b0_cr_ZEN, cgemm_small_kernel_b0_cc_ZEN,
#endif

  ctrsm_kernel_LN_ZEN, ctrsm_kernel_LT_ZEN, ctrsm_kernel_LR_ZEN, ctrsm_kernel_LC_ZEN,
  ctrsm_kernel_RN_ZEN, ctrsm_kernel_RT_ZEN, ctrsm_kernel_RR_ZEN, ctrsm_kernel_RC_ZEN,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_ZEN,  ctrsm_iunncopy_ZEN,  ctrsm_iutucopy_ZEN,  ctrsm_iutncopy_ZEN,
  ctrsm_ilnucopy_ZEN,  ctrsm_ilnncopy_ZEN,  ctrsm_iltucopy_ZEN,  ctrsm_iltncopy_ZEN,
#else
  ctrsm_ounucopy_ZEN,  ctrsm_ounncopy_ZEN,  ctrsm_outucopy_ZEN,  ctrsm_outncopy_ZEN,
  ctrsm_olnucopy_ZEN,  ctrsm_olnncopy_ZEN,  ctrsm_oltucopy_ZEN,  ctrsm_oltncopy_ZEN,
#endif
  ctrsm_ounucopy_ZEN,  ctrsm_ounncopy_ZEN,  ctrsm_outucopy_ZEN,  ctrsm_outncopy_ZEN,
  ctrsm_olnucopy_ZEN,  ctrsm_olnncopy_ZEN,  ctrsm_oltucopy_ZEN,  ctrsm_oltncopy_ZEN,
#endif
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_ZEN,  ctrmm_kernel_RT_ZEN,  ctrmm_kernel_RR_ZEN,  ctrmm_kernel_RC_ZEN,
  ctrmm_kernel_LN_ZEN,  ctrmm_kernel_LT_ZEN,  ctrmm_kernel_LR_ZEN,  ctrmm_kernel_LC_ZEN,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_ZEN,  ctrmm_iunncopy_ZEN,  ctrmm_iutucopy_ZEN,  ctrmm_iutncopy_ZEN,
  ctrmm_ilnucopy_ZEN,  ctrmm_ilnncopy_ZEN,  ctrmm_iltucopy_ZEN,  ctrmm_iltncopy_ZEN,
#else
  ctrmm_ounucopy_ZEN,  ctrmm_ounncopy_ZEN,  ctrmm_outucopy_ZEN,  ctrmm_outncopy_ZEN,
  ctrmm_olnucopy_ZEN,  ctrmm_olnncopy_ZEN,  ctrmm_oltucopy_ZEN,  ctrmm_oltncopy_ZEN,
#endif
  ctrmm_ounucopy_ZEN,  ctrmm_ounncopy_ZEN,  ctrmm_outucopy_ZEN,  ctrmm_outncopy_ZEN,
  ctrmm_olnucopy_ZEN,  ctrmm_olnncopy_ZEN,  ctrmm_oltucopy_ZEN,  ctrmm_oltncopy_ZEN,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_ZEN,  csymm_iltcopy_ZEN,
#else
  csymm_outcopy_ZEN,  csymm_oltcopy_ZEN,
#endif
  csymm_outcopy_ZEN,  csymm_oltcopy_ZEN,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_ZEN,  chemm_iltcopy_ZEN,
#else
  chemm_outcopy_ZEN,  chemm_oltcopy_ZEN,
#endif
  chemm_outcopy_ZEN,  chemm_oltcopy_ZEN,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_ZEN,

  cgemm3m_incopyb_ZEN,  cgemm3m_incopyr_ZEN,
  cgemm3m_incopyi_ZEN,  cgemm3m_itcopyb_ZEN,
  cgemm3m_itcopyr_ZEN,  cgemm3m_itcopyi_ZEN,
  cgemm3m_oncopyb_ZEN,  cgemm3m_oncopyr_ZEN,
  cgemm3m_oncopyi_ZEN,  cgemm3m_otcopyb_ZEN,
  cgemm3m_otcopyr_ZEN,  cgemm3m_otcopyi_ZEN,

  csymm3m_iucopyb_ZEN,  csymm3m_ilcopyb_ZEN,
  csymm3m_iucopyr_ZEN,  csymm3m_ilcopyr_ZEN,
  csymm3m_iucopyi_ZEN,  csymm3m_ilcopyi_ZEN,
  csymm3m_oucopyb_ZEN,  csymm3m_olcopyb_ZEN,
  csymm3m_oucopyr_ZEN,  csymm3m_olcopyr_ZEN,
  csymm3m_oucopyi_ZEN,  csymm3m_olcopyi_ZEN,

  chemm3m_iucopyb_ZEN,  chemm3m_ilcopyb_ZEN,
  chemm3m_iucopyr_ZEN,  chemm3m_ilcopyr_ZEN,
  chemm3m_iucopyi_ZEN,  chemm3m_ilcopyi_ZEN,

  chemm3m_oucopyb_ZEN,  chemm3m_olcopyb_ZEN,
  chemm3m_oucopyr_ZEN,  chemm3m_olcopyr_ZEN,
  chemm3m_oucopyi_ZEN,  chemm3m_olcopyi_ZEN,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX)
#ifndef NO_LAPACK
  cneg_tcopy_ZEN,
  
   claswp_ncopy_ZEN,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_ZEN, zamin_k_ZEN, izamax_k_ZEN, izamin_k_ZEN,
  znrm2_k_ZEN, zasum_k_ZEN, zsum_k_ZEN, zcopy_k_ZEN,
  zdotu_k_ZEN, zdotc_k_ZEN, zdrot_k_ZEN,
  zaxpy_k_ZEN, zaxpyc_k_ZEN, zscal_k_ZEN, zswap_k_ZEN,

  zgemv_n_ZEN, zgemv_t_ZEN, zgemv_r_ZEN, zgemv_c_ZEN,
  zgemv_o_ZEN, zgemv_u_ZEN, zgemv_s_ZEN, zgemv_d_ZEN,
  zgeru_k_ZEN, zgerc_k_ZEN, zgerv_k_ZEN, zgerd_k_ZEN,
  zsymv_L_ZEN, zsymv_U_ZEN,
  zhemv_L_ZEN, zhemv_U_ZEN, zhemv_M_ZEN, zhemv_V_ZEN,

  zgemm_kernel_n_ZEN, zgemm_kernel_l_ZEN, zgemm_kernel_r_ZEN, zgemm_kernel_b_ZEN,
  zgemm_beta_ZEN,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_ZEN, zgemm_itcopy_ZEN,
#else
  zgemm_oncopy_ZEN, zgemm_otcopy_ZEN,
#endif
  zgemm_oncopy_ZEN, zgemm_otcopy_ZEN,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_ZEN,
  zgemm_small_kernel_nn_ZEN, zgemm_small_kernel_nt_ZEN, zgemm_small_kernel_nr_ZEN, zgemm_small_kernel_nc_ZEN,
  zgemm_small_kernel_tn_ZEN, zgemm_small_kernel_tt_ZEN, zgemm_small_kernel_tr_ZEN, zgemm_small_kernel_tc_ZEN,
  zgemm_small_kernel_rn_ZEN, zgemm_small_kernel_rt_ZEN, zgemm_small_kernel_rr_ZEN, zgemm_small_kernel_rc_ZEN,
  zgemm_small_kernel_cn_ZEN, zgemm_small_kernel_ct_ZEN, zgemm_small_kernel_cr_ZEN, zgemm_small_kernel_cc_ZEN,
  zgemm_small_kernel_b0_nn_ZEN, zgemm_small_kernel_b0_nt_ZEN, zgemm_small_kernel_b0_nr_ZEN, zgemm_small_kernel_b0_nc_ZEN,
  zgemm_small_kernel_b0_tn_ZEN, zgemm_small_kernel_b0_tt_ZEN, zgemm_small_kernel_b0_tr_ZEN, zgemm_small_kernel_b0_tc_ZEN,
  zgemm_small_kernel_b0_rn_ZEN, zgemm_small_kernel_b0_rt_ZEN, zgemm_small_kernel_b0_rr_ZEN, zgemm_small_kernel_b0_rc_ZEN,
  zgemm_small_kernel_b0_cn_ZEN, zgemm_small_kernel_b0_ct_ZEN, zgemm_small_kernel_b0_cr_ZEN, zgemm_small_kernel_b0_cc_ZEN,
#endif

  ztrsm_kernel_LN_ZEN, ztrsm_kernel_LT_ZEN, ztrsm_kernel_LR_ZEN, ztrsm_kernel_LC_ZEN,
  ztrsm_kernel_RN_ZEN, ztrsm_kernel_RT_ZEN, ztrsm_kernel_RR_ZEN, ztrsm_kernel_RC_ZEN,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_ZEN,  ztrsm_iunncopy_ZEN,  ztrsm_iutucopy_ZEN,  ztrsm_iutncopy_ZEN,
  ztrsm_ilnucopy_ZEN,  ztrsm_ilnncopy_ZEN,  ztrsm_iltucopy_ZEN,  ztrsm_iltncopy_ZEN,
#else
  ztrsm_ounucopy_ZEN,  ztrsm_ounncopy_ZEN,  ztrsm_outucopy_ZEN,  ztrsm_outncopy_ZEN,
  ztrsm_olnucopy_ZEN,  ztrsm_olnncopy_ZEN,  ztrsm_oltucopy_ZEN,  ztrsm_oltncopy_ZEN,
#endif
  ztrsm_ounucopy_ZEN,  ztrsm_ounncopy_ZEN,  ztrsm_outucopy_ZEN,  ztrsm_outncopy_ZEN,
  ztrsm_olnucopy_ZEN,  ztrsm_olnncopy_ZEN,  ztrsm_oltucopy_ZEN,  ztrsm_oltncopy_ZEN,

  ztrmm_kernel_RN_ZEN,  ztrmm_kernel_RT_ZEN,  ztrmm_kernel_RR_ZEN,  ztrmm_kernel_RC_ZEN,
  ztrmm_kernel_LN_ZEN,  ztrmm_kernel_LT_ZEN,  ztrmm_kernel_LR_ZEN,  ztrmm_kernel_LC_ZEN,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_ZEN,  ztrmm_iunncopy_ZEN,  ztrmm_iutucopy_ZEN,  ztrmm_iutncopy_ZEN,
  ztrmm_ilnucopy_ZEN,  ztrmm_ilnncopy_ZEN,  ztrmm_iltucopy_ZEN,  ztrmm_iltncopy_ZEN,
#else
  ztrmm_ounucopy_ZEN,  ztrmm_ounncopy_ZEN,  ztrmm_outucopy_ZEN,  ztrmm_outncopy_ZEN,
  ztrmm_olnucopy_ZEN,  ztrmm_olnncopy_ZEN,  ztrmm_oltucopy_ZEN,  ztrmm_oltncopy_ZEN,
#endif
  ztrmm_ounucopy_ZEN,  ztrmm_ounncopy_ZEN,  ztrmm_outucopy_ZEN,  ztrmm_outncopy_ZEN,
  ztrmm_olnucopy_ZEN,  ztrmm_olnncopy_ZEN,  ztrmm_oltucopy_ZEN,  ztrmm_oltncopy_ZEN,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_ZEN,  zsymm_iltcopy_ZEN,
#else
  zsymm_outcopy_ZEN,  zsymm_oltcopy_ZEN,
#endif
  zsymm_outcopy_ZEN,  zsymm_oltcopy_ZEN,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_ZEN,  zhemm_iltcopy_ZEN,
#else
  zhemm_outcopy_ZEN,  zhemm_oltcopy_ZEN,
#endif
  zhemm_outcopy_ZEN,  zhemm_oltcopy_ZEN,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_ZEN,

  zgemm3m_incopyb_ZEN,  zgemm3m_incopyr_ZEN,
  zgemm3m_incopyi_ZEN,  zgemm3m_itcopyb_ZEN,
  zgemm3m_itcopyr_ZEN,  zgemm3m_itcopyi_ZEN,
  zgemm3m_oncopyb_ZEN,  zgemm3m_oncopyr_ZEN,
  zgemm3m_oncopyi_ZEN,  zgemm3m_otcopyb_ZEN,
  zgemm3m_otcopyr_ZEN,  zgemm3m_otcopyi_ZEN,

  zsymm3m_iucopyb_ZEN,  zsymm3m_ilcopyb_ZEN,
  zsymm3m_iucopyr_ZEN,  zsymm3m_ilcopyr_ZEN,
  zsymm3m_iucopyi_ZEN,  zsymm3m_ilcopyi_ZEN,
  zsymm3m_oucopyb_ZEN,  zsymm3m_olcopyb_ZEN,
  zsymm3m_oucopyr_ZEN,  zsymm3m_olcopyr_ZEN,
  zsymm3m_oucopyi_ZEN,  zsymm3m_olcopyi_ZEN,

  zhemm3m_iucopyb_ZEN,  zhemm3m_ilcopyb_ZEN,
  zhemm3m_iucopyr_ZEN,  zhemm3m_ilcopyr_ZEN,
  zhemm3m_iucopyi_ZEN,  zhemm3m_ilcopyi_ZEN,

  zhemm3m_oucopyb_ZEN,  zhemm3m_olcopyb_ZEN,
  zhemm3m_oucopyr_ZEN,  zhemm3m_olcopyr_ZEN,
  zhemm3m_oucopyi_ZEN,  zhemm3m_olcopyi_ZEN,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_ZEN, zlaswp_ncopy_ZEN,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_ZEN, xamin_k_ZEN, ixamax_k_ZEN, ixamin_k_ZEN,
  xnrm2_k_ZEN, xasum_k_ZEN, xsum_k_ZEN, xcopy_k_ZEN,
  xdotu_k_ZEN, xdotc_k_ZEN, xqrot_k_ZEN,
  xaxpy_k_ZEN, xaxpyc_k_ZEN, xscal_k_ZEN, xswap_k_ZEN,

  xgemv_n_ZEN, xgemv_t_ZEN, xgemv_r_ZEN, xgemv_c_ZEN,
  xgemv_o_ZEN, xgemv_u_ZEN, xgemv_s_ZEN, xgemv_d_ZEN,
  xgeru_k_ZEN, xgerc_k_ZEN, xgerv_k_ZEN, xgerd_k_ZEN,
  xsymv_L_ZEN, xsymv_U_ZEN,
  xhemv_L_ZEN, xhemv_U_ZEN, xhemv_M_ZEN, xhemv_V_ZEN,

  xgemm_kernel_n_ZEN, xgemm_kernel_l_ZEN, xgemm_kernel_r_ZEN, xgemm_kernel_b_ZEN,
  xgemm_beta_ZEN,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_ZEN, xgemm_itcopy_ZEN,
#else
  xgemm_oncopy_ZEN, xgemm_otcopy_ZEN,
#endif
  xgemm_oncopy_ZEN, xgemm_otcopy_ZEN,

  xtrsm_kernel_LN_ZEN, xtrsm_kernel_LT_ZEN, xtrsm_kernel_LR_ZEN, xtrsm_kernel_LC_ZEN,
  xtrsm_kernel_RN_ZEN, xtrsm_kernel_RT_ZEN, xtrsm_kernel_RR_ZEN, xtrsm_kernel_RC_ZEN,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_ZEN,  xtrsm_iunncopy_ZEN,  xtrsm_iutucopy_ZEN,  xtrsm_iutncopy_ZEN,
  xtrsm_ilnucopy_ZEN,  xtrsm_ilnncopy_ZEN,  xtrsm_iltucopy_ZEN,  xtrsm_iltncopy_ZEN,
#else
  xtrsm_ounucopy_ZEN,  xtrsm_ounncopy_ZEN,  xtrsm_outucopy_ZEN,  xtrsm_outncopy_ZEN,
  xtrsm_olnucopy_ZEN,  xtrsm_olnncopy_ZEN,  xtrsm_oltucopy_ZEN,  xtrsm_oltncopy_ZEN,
#endif
  xtrsm_ounucopy_ZEN,  xtrsm_ounncopy_ZEN,  xtrsm_outucopy_ZEN,  xtrsm_outncopy_ZEN,
  xtrsm_olnucopy_ZEN,  xtrsm_olnncopy_ZEN,  xtrsm_oltucopy_ZEN,  xtrsm_oltncopy_ZEN,

  xtrmm_kernel_RN_ZEN,  xtrmm_kernel_RT_ZEN,  xtrmm_kernel_RR_ZEN,  xtrmm_kernel_RC_ZEN,
  xtrmm_kernel_LN_ZEN,  xtrmm_kernel_LT_ZEN,  xtrmm_kernel_LR_ZEN,  xtrmm_kernel_LC_ZEN,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_ZEN,  xtrmm_iunncopy_ZEN,  xtrmm_iutucopy_ZEN,  xtrmm_iutncopy_ZEN,
  xtrmm_ilnucopy_ZEN,  xtrmm_ilnncopy_ZEN,  xtrmm_iltucopy_ZEN,  xtrmm_iltncopy_ZEN,
#else
  xtrmm_ounucopy_ZEN,  xtrmm_ounncopy_ZEN,  xtrmm_outucopy_ZEN,  xtrmm_outncopy_ZEN,
  xtrmm_olnucopy_ZEN,  xtrmm_olnncopy_ZEN,  xtrmm_oltucopy_ZEN,  xtrmm_oltncopy_ZEN,
#endif
  xtrmm_ounucopy_ZEN,  xtrmm_ounncopy_ZEN,  xtrmm_outucopy_ZEN,  xtrmm_outncopy_ZEN,
  xtrmm_olnucopy_ZEN,  xtrmm_olnncopy_ZEN,  xtrmm_oltucopy_ZEN,  xtrmm_oltncopy_ZEN,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_ZEN,  xsymm_iltcopy_ZEN,
#else
  xsymm_outcopy_ZEN,  xsymm_oltcopy_ZEN,
#endif
  xsymm_outcopy_ZEN,  xsymm_oltcopy_ZEN,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_ZEN,  xhemm_iltcopy_ZEN,
#else
  xhemm_outcopy_ZEN,  xhemm_oltcopy_ZEN,
#endif
  xhemm_outcopy_ZEN,  xhemm_oltcopy_ZEN,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_ZEN,

  xgemm3m_incopyb_ZEN,  xgemm3m_incopyr_ZEN,
  xgemm3m_incopyi_ZEN,  xgemm3m_itcopyb_ZEN,
  xgemm3m_itcopyr_ZEN,  xgemm3m_itcopyi_ZEN,
  xgemm3m_oncopyb_ZEN,  xgemm3m_oncopyr_ZEN,
  xgemm3m_oncopyi_ZEN,  xgemm3m_otcopyb_ZEN,
  xgemm3m_otcopyr_ZEN,  xgemm3m_otcopyi_ZEN,

  xsymm3m_iucopyb_ZEN,  xsymm3m_ilcopyb_ZEN,
  xsymm3m_iucopyr_ZEN,  xsymm3m_ilcopyr_ZEN,
  xsymm3m_iucopyi_ZEN,  xsymm3m_ilcopyi_ZEN,
  xsymm3m_oucopyb_ZEN,  xsymm3m_olcopyb_ZEN,
  xsymm3m_oucopyr_ZEN,  xsymm3m_olcopyr_ZEN,
  xsymm3m_oucopyi_ZEN,  xsymm3m_olcopyi_ZEN,

  xhemm3m_iucopyb_ZEN,  xhemm3m_ilcopyb_ZEN,
  xhemm3m_iucopyr_ZEN,  xhemm3m_ilcopyr_ZEN,
  xhemm3m_iucopyi_ZEN,  xhemm3m_ilcopyi_ZEN,

  xhemm3m_oucopyb_ZEN,  xhemm3m_olcopyb_ZEN,
  xhemm3m_oucopyr_ZEN,  xhemm3m_olcopyr_ZEN,
  xhemm3m_oucopyi_ZEN,  xhemm3m_olcopyi_ZEN,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_ZEN, xlaswp_ncopy_ZEN,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_ZEN,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_ZEN,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_ZEN,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_ZEN,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_ZEN, somatcopy_k_ct_ZEN, somatcopy_k_rn_ZEN, somatcopy_k_rt_ZEN,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_ZEN, domatcopy_k_ct_ZEN, domatcopy_k_rn_ZEN, domatcopy_k_rt_ZEN,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_ZEN, comatcopy_k_ct_ZEN, comatcopy_k_rn_ZEN, comatcopy_k_rt_ZEN,
  comatcopy_k_cnc_ZEN, comatcopy_k_ctc_ZEN, comatcopy_k_rnc_ZEN, comatcopy_k_rtc_ZEN,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_ZEN, zomatcopy_k_ct_ZEN, zomatcopy_k_rn_ZEN, zomatcopy_k_rt_ZEN,
  zomatcopy_k_cnc_ZEN, zomatcopy_k_ctc_ZEN, zomatcopy_k_rnc_ZEN, zomatcopy_k_rtc_ZEN,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_ZEN, simatcopy_k_ct_ZEN, simatcopy_k_rn_ZEN, simatcopy_k_rt_ZEN,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_ZEN, dimatcopy_k_ct_ZEN, dimatcopy_k_rn_ZEN, dimatcopy_k_rt_ZEN,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_ZEN, cimatcopy_k_ct_ZEN, cimatcopy_k_rn_ZEN, cimatcopy_k_rt_ZEN,
  cimatcopy_k_cnc_ZEN, cimatcopy_k_ctc_ZEN, cimatcopy_k_rnc_ZEN, cimatcopy_k_rtc_ZEN,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_ZEN, zimatcopy_k_ct_ZEN, zimatcopy_k_rn_ZEN, zimatcopy_k_rt_ZEN,
  zimatcopy_k_cnc_ZEN, zimatcopy_k_ctc_ZEN, zimatcopy_k_rnc_ZEN, zimatcopy_k_rtc_ZEN,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_ZEN,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_ZEN,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_ZEN,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_ZEN,
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1 || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_LOONGARCH64)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else // (ARCH_LOONGARCH64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1  || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1 || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE) || defined(SAPPHIRERAPIDS)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#ifdef SAPPHIRERAPIDS
#if (BUILD_BFLOAT16 == 1)
  TABLE_NAME.need_amxtile_permission = 1;
#endif
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_BFLOAT16==1
  TABLE_NAME.sbgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sbgemm_p * TABLE_NAME.sbgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sbgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_LOONGARCH64)
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
