/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLVideoElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLVideoElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#if ENABLE(VIDEO)

namespace WebKit {

WebKitDOMHTMLVideoElement* kit(WebCore::HTMLVideoElement* obj)
{
    return WEBKIT_DOM_HTML_VIDEO_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLVideoElement* core(WebKitDOMHTMLVideoElement* request)
{
    return request ? static_cast<WebCore::HTMLVideoElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLVideoElement* wrapHTMLVideoElement(WebCore::HTMLVideoElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_VIDEO_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_VIDEO_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(VIDEO)

G_DEFINE_TYPE(WebKitDOMHTMLVideoElement, webkit_dom_html_video_element, WEBKIT_TYPE_DOM_HTML_MEDIA_ELEMENT)

enum {
    PROP_0,
    PROP_WIDTH,
    PROP_HEIGHT,
    PROP_VIDEO_WIDTH,
    PROP_VIDEO_HEIGHT,
    PROP_POSTER,
    PROP_WEBKIT_SUPPORTS_FULLSCREEN,
    PROP_WEBKIT_DISPLAYING_FULLSCREEN,
    PROP_WEBKIT_DECODED_FRAME_COUNT,
    PROP_WEBKIT_DROPPED_FRAME_COUNT,
};

static void webkit_dom_html_video_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO)
    WebKitDOMHTMLVideoElement* self = WEBKIT_DOM_HTML_VIDEO_ELEMENT(object);
    WebCore::HTMLVideoElement* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO)
    switch (propertyId) {
    case PROP_WIDTH: {
#if ENABLE(VIDEO)
        coreSelf->setUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr, (g_value_get_ulong(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_HEIGHT: {
#if ENABLE(VIDEO)
        coreSelf->setUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr, (g_value_get_ulong(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_POSTER: {
#if ENABLE(VIDEO)
        coreSelf->setAttribute(WebCore::HTMLNames::posterAttr, WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_video_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO)
    WebKitDOMHTMLVideoElement* self = WEBKIT_DOM_HTML_VIDEO_ELEMENT(object);
    WebCore::HTMLVideoElement* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO)
    switch (propertyId) {
    case PROP_WIDTH: {
#if ENABLE(VIDEO)
        g_value_set_ulong(value, coreSelf->getUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_HEIGHT: {
#if ENABLE(VIDEO)
        g_value_set_ulong(value, coreSelf->getUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_VIDEO_WIDTH: {
#if ENABLE(VIDEO)
        g_value_set_ulong(value, coreSelf->videoWidth());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_VIDEO_HEIGHT: {
#if ENABLE(VIDEO)
        g_value_set_ulong(value, coreSelf->videoHeight());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_POSTER: {
#if ENABLE(VIDEO)
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::posterAttr)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_SUPPORTS_FULLSCREEN: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->webkitSupportsFullscreen());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_DISPLAYING_FULLSCREEN: {
#if ENABLE(VIDEO)
        g_value_set_boolean(value, coreSelf->webkitDisplayingFullscreen());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_DECODED_FRAME_COUNT: {
#if ENABLE(VIDEO)
#if ENABLE(MEDIA_STATISTICS)
        g_value_set_ulong(value, coreSelf->webkitDecodedFrameCount());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Statistics")
#endif /* ENABLE(MEDIA_STATISTICS) */
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    case PROP_WEBKIT_DROPPED_FRAME_COUNT: {
#if ENABLE(VIDEO)
#if ENABLE(MEDIA_STATISTICS)
        g_value_set_ulong(value, coreSelf->webkitDroppedFrameCount());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Statistics")
#endif /* ENABLE(MEDIA_STATISTICS) */
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_video_element_class_init(WebKitDOMHTMLVideoElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_video_element_set_property;
    gobjectClass->get_property = webkit_dom_html_video_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_ulong("width", /* name */
                                                           "html_video_element_width", /* short description */
                                                           "read-write  gulong HTMLVideoElement.width", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_ulong("height", /* name */
                                                           "html_video_element_height", /* short description */
                                                           "read-write  gulong HTMLVideoElement.height", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VIDEO_WIDTH,
                                    g_param_spec_ulong("video-width", /* name */
                                                           "html_video_element_video-width", /* short description */
                                                           "read-only  gulong HTMLVideoElement.video-width", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VIDEO_HEIGHT,
                                    g_param_spec_ulong("video-height", /* name */
                                                           "html_video_element_video-height", /* short description */
                                                           "read-only  gulong HTMLVideoElement.video-height", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_POSTER,
                                    g_param_spec_string("poster", /* name */
                                                           "html_video_element_poster", /* short description */
                                                           "read-write  gchar* HTMLVideoElement.poster", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_SUPPORTS_FULLSCREEN,
                                    g_param_spec_boolean("webkit-supports-fullscreen", /* name */
                                                           "html_video_element_webkit-supports-fullscreen", /* short description */
                                                           "read-only  gboolean HTMLVideoElement.webkit-supports-fullscreen", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_DISPLAYING_FULLSCREEN,
                                    g_param_spec_boolean("webkit-displaying-fullscreen", /* name */
                                                           "html_video_element_webkit-displaying-fullscreen", /* short description */
                                                           "read-only  gboolean HTMLVideoElement.webkit-displaying-fullscreen", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_DECODED_FRAME_COUNT,
                                    g_param_spec_ulong("webkit-decoded-frame-count", /* name */
                                                           "html_video_element_webkit-decoded-frame-count", /* short description */
                                                           "read-only  gulong HTMLVideoElement.webkit-decoded-frame-count", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_DROPPED_FRAME_COUNT,
                                    g_param_spec_ulong("webkit-dropped-frame-count", /* name */
                                                           "html_video_element_webkit-dropped-frame-count", /* short description */
                                                           "read-only  gulong HTMLVideoElement.webkit-dropped-frame-count", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_video_element_init(WebKitDOMHTMLVideoElement* request)
{
}

void
webkit_dom_html_video_element_webkit_enter_fullscreen(WebKitDOMHTMLVideoElement* self, GError** error)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->webkitEnterFullscreen(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_video_element_webkit_exit_fullscreen(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self));
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    item->webkitExitFullscreen();
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_video_element_webkit_enter_full_screen(WebKitDOMHTMLVideoElement* self, GError** error)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->webkitEnterFullScreen(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_video_element_webkit_exit_full_screen(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self));
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    item->webkitExitFullScreen();
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_html_video_element_get_width(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), 0);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gulong result = item->getUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_video_element_set_width(WebKitDOMHTMLVideoElement* self, gulong value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self));
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    item->setUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_html_video_element_get_height(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), 0);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gulong result = item->getUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_video_element_set_height(WebKitDOMHTMLVideoElement* self, gulong value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self));
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    item->setUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_html_video_element_get_video_width(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), 0);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gulong result = item->videoWidth();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_html_video_element_get_video_height(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), 0);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gulong result = item->videoHeight();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

gchar*
webkit_dom_html_video_element_get_poster(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), 0);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::posterAttr));
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return 0;
#endif /* ENABLE(VIDEO) */
}

void
webkit_dom_html_video_element_set_poster(WebKitDOMHTMLVideoElement* self, const gchar* value)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::posterAttr, convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_video_element_get_webkit_supports_fullscreen(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), FALSE);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gboolean result = item->webkitSupportsFullscreen();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

gboolean
webkit_dom_html_video_element_get_webkit_displaying_fullscreen(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), FALSE);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gboolean result = item->webkitDisplayingFullscreen();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_html_video_element_get_webkit_decoded_frame_count(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
#if ENABLE(MEDIA_STATISTICS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), 0);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gulong result = item->webkitDecodedFrameCount();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Statistics")
    return static_cast<gulong>(0);
#endif /* ENABLE(MEDIA_STATISTICS) */
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_html_video_element_get_webkit_dropped_frame_count(WebKitDOMHTMLVideoElement* self)
{
#if ENABLE(VIDEO)
#if ENABLE(MEDIA_STATISTICS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_VIDEO_ELEMENT(self), 0);
    WebCore::HTMLVideoElement* item = WebKit::core(self);
    gulong result = item->webkitDroppedFrameCount();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Statistics")
    return static_cast<gulong>(0);
#endif /* ENABLE(MEDIA_STATISTICS) */
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

