/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMTimeRanges.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTimeRangesPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TIME_RANGES_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_TIME_RANGES, WebKitDOMTimeRangesPrivate)

typedef struct _WebKitDOMTimeRangesPrivate {
#if ENABLE(VIDEO)
    RefPtr<WebCore::TimeRanges> coreObject;
#endif // ENABLE(VIDEO)
} WebKitDOMTimeRangesPrivate;

#if ENABLE(VIDEO)

namespace WebKit {

WebKitDOMTimeRanges* kit(WebCore::TimeRanges* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TIME_RANGES(ret);

    return wrapTimeRanges(obj);
}

WebCore::TimeRanges* core(WebKitDOMTimeRanges* request)
{
    return request ? static_cast<WebCore::TimeRanges*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTimeRanges* wrapTimeRanges(WebCore::TimeRanges* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TIME_RANGES(g_object_new(WEBKIT_TYPE_DOM_TIME_RANGES, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(VIDEO)

G_DEFINE_TYPE(WebKitDOMTimeRanges, webkit_dom_time_ranges, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_time_ranges_finalize(GObject* object)
{
    WebKitDOMTimeRangesPrivate* priv = WEBKIT_DOM_TIME_RANGES_GET_PRIVATE(object);
#if ENABLE(VIDEO)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(VIDEO)
    priv->~WebKitDOMTimeRangesPrivate();
    G_OBJECT_CLASS(webkit_dom_time_ranges_parent_class)->finalize(object);
}

static void webkit_dom_time_ranges_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO)
    WebKitDOMTimeRanges* self = WEBKIT_DOM_TIME_RANGES(object);
    WebCore::TimeRanges* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO)
    switch (propertyId) {
    case PROP_LENGTH: {
#if ENABLE(VIDEO)
        g_value_set_ulong(value, coreSelf->length());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_time_ranges_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_time_ranges_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(VIDEO)
    WebKitDOMTimeRangesPrivate* priv = WEBKIT_DOM_TIME_RANGES_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TimeRanges*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(VIDEO)
    return object;
}

static void webkit_dom_time_ranges_class_init(WebKitDOMTimeRangesClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTimeRangesPrivate));
    gobjectClass->constructor = webkit_dom_time_ranges_constructor;
    gobjectClass->finalize = webkit_dom_time_ranges_finalize;
    gobjectClass->get_property = webkit_dom_time_ranges_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "time_ranges_length", /* short description */
                                                           "read-only  gulong TimeRanges.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_time_ranges_init(WebKitDOMTimeRanges* request)
{
    WebKitDOMTimeRangesPrivate* priv = WEBKIT_DOM_TIME_RANGES_GET_PRIVATE(request);
    new (priv) WebKitDOMTimeRangesPrivate();
}

gfloat
webkit_dom_time_ranges_start(WebKitDOMTimeRanges* self, gulong index, GError** error)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TIME_RANGES(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TimeRanges* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gfloat result = item->start(index, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gfloat>(0);
#endif /* ENABLE(VIDEO) */
}

gfloat
webkit_dom_time_ranges_end(WebKitDOMTimeRanges* self, gulong index, GError** error)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TIME_RANGES(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::TimeRanges* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gfloat result = item->end(index, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gfloat>(0);
#endif /* ENABLE(VIDEO) */
}

gulong
webkit_dom_time_ranges_get_length(WebKitDOMTimeRanges* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TIME_RANGES(self), 0);
    WebCore::TimeRanges* item = WebKit::core(self);
    gulong result = item->length();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO) */
}

