/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMValidityState.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMValidityStatePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_VALIDITY_STATE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_VALIDITY_STATE, WebKitDOMValidityStatePrivate)

typedef struct _WebKitDOMValidityStatePrivate {
    RefPtr<WebCore::ValidityState> coreObject;
} WebKitDOMValidityStatePrivate;

namespace WebKit {

WebKitDOMValidityState* kit(WebCore::ValidityState* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_VALIDITY_STATE(ret);

    return wrapValidityState(obj);
}

WebCore::ValidityState* core(WebKitDOMValidityState* request)
{
    return request ? static_cast<WebCore::ValidityState*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMValidityState* wrapValidityState(WebCore::ValidityState* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_VALIDITY_STATE(g_object_new(WEBKIT_TYPE_DOM_VALIDITY_STATE, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMValidityState, webkit_dom_validity_state, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_VALUE_MISSING,
    PROP_TYPE_MISMATCH,
    PROP_PATTERN_MISMATCH,
    PROP_TOO_LONG,
    PROP_RANGE_UNDERFLOW,
    PROP_RANGE_OVERFLOW,
    PROP_STEP_MISMATCH,
    PROP_BAD_INPUT,
    PROP_CUSTOM_ERROR,
    PROP_VALID,
};

static void webkit_dom_validity_state_finalize(GObject* object)
{
    WebKitDOMValidityStatePrivate* priv = WEBKIT_DOM_VALIDITY_STATE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMValidityStatePrivate();
    G_OBJECT_CLASS(webkit_dom_validity_state_parent_class)->finalize(object);
}

static void webkit_dom_validity_state_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMValidityState* self = WEBKIT_DOM_VALIDITY_STATE(object);
    WebCore::ValidityState* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_VALUE_MISSING: {
        g_value_set_boolean(value, coreSelf->valueMissing());
        break;
    }
    case PROP_TYPE_MISMATCH: {
        g_value_set_boolean(value, coreSelf->typeMismatch());
        break;
    }
    case PROP_PATTERN_MISMATCH: {
        g_value_set_boolean(value, coreSelf->patternMismatch());
        break;
    }
    case PROP_TOO_LONG: {
        g_value_set_boolean(value, coreSelf->tooLong());
        break;
    }
    case PROP_RANGE_UNDERFLOW: {
        g_value_set_boolean(value, coreSelf->rangeUnderflow());
        break;
    }
    case PROP_RANGE_OVERFLOW: {
        g_value_set_boolean(value, coreSelf->rangeOverflow());
        break;
    }
    case PROP_STEP_MISMATCH: {
        g_value_set_boolean(value, coreSelf->stepMismatch());
        break;
    }
    case PROP_BAD_INPUT: {
        g_value_set_boolean(value, coreSelf->badInput());
        break;
    }
    case PROP_CUSTOM_ERROR: {
        g_value_set_boolean(value, coreSelf->customError());
        break;
    }
    case PROP_VALID: {
        g_value_set_boolean(value, coreSelf->valid());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_validity_state_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_validity_state_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMValidityStatePrivate* priv = WEBKIT_DOM_VALIDITY_STATE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::ValidityState*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_validity_state_class_init(WebKitDOMValidityStateClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMValidityStatePrivate));
    gobjectClass->constructor = webkit_dom_validity_state_constructor;
    gobjectClass->finalize = webkit_dom_validity_state_finalize;
    gobjectClass->get_property = webkit_dom_validity_state_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE_MISSING,
                                    g_param_spec_boolean("value-missing", /* name */
                                                           "validity_state_value-missing", /* short description */
                                                           "read-only  gboolean ValidityState.value-missing", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE_MISMATCH,
                                    g_param_spec_boolean("type-mismatch", /* name */
                                                           "validity_state_type-mismatch", /* short description */
                                                           "read-only  gboolean ValidityState.type-mismatch", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PATTERN_MISMATCH,
                                    g_param_spec_boolean("pattern-mismatch", /* name */
                                                           "validity_state_pattern-mismatch", /* short description */
                                                           "read-only  gboolean ValidityState.pattern-mismatch", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TOO_LONG,
                                    g_param_spec_boolean("too-long", /* name */
                                                           "validity_state_too-long", /* short description */
                                                           "read-only  gboolean ValidityState.too-long", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RANGE_UNDERFLOW,
                                    g_param_spec_boolean("range-underflow", /* name */
                                                           "validity_state_range-underflow", /* short description */
                                                           "read-only  gboolean ValidityState.range-underflow", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RANGE_OVERFLOW,
                                    g_param_spec_boolean("range-overflow", /* name */
                                                           "validity_state_range-overflow", /* short description */
                                                           "read-only  gboolean ValidityState.range-overflow", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_STEP_MISMATCH,
                                    g_param_spec_boolean("step-mismatch", /* name */
                                                           "validity_state_step-mismatch", /* short description */
                                                           "read-only  gboolean ValidityState.step-mismatch", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BAD_INPUT,
                                    g_param_spec_boolean("bad-input", /* name */
                                                           "validity_state_bad-input", /* short description */
                                                           "read-only  gboolean ValidityState.bad-input", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CUSTOM_ERROR,
                                    g_param_spec_boolean("custom-error", /* name */
                                                           "validity_state_custom-error", /* short description */
                                                           "read-only  gboolean ValidityState.custom-error", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALID,
                                    g_param_spec_boolean("valid", /* name */
                                                           "validity_state_valid", /* short description */
                                                           "read-only  gboolean ValidityState.valid", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_validity_state_init(WebKitDOMValidityState* request)
{
    WebKitDOMValidityStatePrivate* priv = WEBKIT_DOM_VALIDITY_STATE_GET_PRIVATE(request);
    new (priv) WebKitDOMValidityStatePrivate();
}

gboolean
webkit_dom_validity_state_get_value_missing(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->valueMissing();
    return result;
}

gboolean
webkit_dom_validity_state_get_type_mismatch(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->typeMismatch();
    return result;
}

gboolean
webkit_dom_validity_state_get_pattern_mismatch(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->patternMismatch();
    return result;
}

gboolean
webkit_dom_validity_state_get_too_long(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->tooLong();
    return result;
}

gboolean
webkit_dom_validity_state_get_range_underflow(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->rangeUnderflow();
    return result;
}

gboolean
webkit_dom_validity_state_get_range_overflow(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->rangeOverflow();
    return result;
}

gboolean
webkit_dom_validity_state_get_step_mismatch(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->stepMismatch();
    return result;
}

gboolean
webkit_dom_validity_state_get_bad_input(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->badInput();
    return result;
}

gboolean
webkit_dom_validity_state_get_custom_error(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->customError();
    return result;
}

gboolean
webkit_dom_validity_state_get_valid(WebKitDOMValidityState* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_VALIDITY_STATE(self), FALSE);
    WebCore::ValidityState* item = WebKit::core(self);
    gboolean result = item->valid();
    return result;
}

