/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCustomEvent.h"

#include "CustomEvent.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDictionary.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCustomEventTableValues[] =
{
    { "detail", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCustomEventDetail), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCustomEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCustomEventTable = { 4, 3, JSCustomEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCustomEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCustomEventConstructorTable = { 1, 0, JSCustomEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSCustomEventConstructor::constructJSCustomEvent(ExecState* exec)
{
    JSCustomEventConstructor* jsConstructor = jsCast<JSCustomEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    CustomEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillCustomEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<CustomEvent> event = CustomEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillCustomEventInit(CustomEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("detail", eventInit.detail))
        return false;
    return true;
}

const ClassInfo JSCustomEventConstructor::s_info = { "CustomEventConstructor", &Base::s_info, &JSCustomEventConstructorTable, 0, CREATE_METHOD_TABLE(JSCustomEventConstructor) };

JSCustomEventConstructor::JSCustomEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCustomEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCustomEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSCustomEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCustomEventConstructor, JSDOMWrapper>(exec, &JSCustomEventConstructorTable, jsCast<JSCustomEventConstructor*>(cell), propertyName, slot);
}

bool JSCustomEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCustomEventConstructor, JSDOMWrapper>(exec, &JSCustomEventConstructorTable, jsCast<JSCustomEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSCustomEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSCustomEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSCustomEventPrototypeTableValues[] =
{
    { "initCustomEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCustomEventPrototypeFunctionInitCustomEvent), (intptr_t)4, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCustomEventPrototypeTable = { 2, 1, JSCustomEventPrototypeTableValues, 0 };
const ClassInfo JSCustomEventPrototype::s_info = { "CustomEventPrototype", &Base::s_info, &JSCustomEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSCustomEventPrototype) };

JSObject* JSCustomEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCustomEvent>(exec, globalObject);
}

bool JSCustomEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCustomEventPrototype* thisObject = jsCast<JSCustomEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCustomEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSCustomEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCustomEventPrototype* thisObject = jsCast<JSCustomEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCustomEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCustomEvent::s_info = { "CustomEvent", &Base::s_info, &JSCustomEventTable, 0 , CREATE_METHOD_TABLE(JSCustomEvent) };

JSCustomEvent::JSCustomEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CustomEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSCustomEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCustomEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCustomEventPrototype::create(exec->globalData(), globalObject, JSCustomEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSCustomEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCustomEvent* thisObject = jsCast<JSCustomEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCustomEvent, Base>(exec, &JSCustomEventTable, thisObject, propertyName, slot);
}

bool JSCustomEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCustomEvent* thisObject = jsCast<JSCustomEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCustomEvent, Base>(exec, &JSCustomEventTable, thisObject, propertyName, descriptor);
}

JSValue jsCustomEventDetail(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCustomEvent* castedThis = jsCast<JSCustomEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CustomEvent* impl = static_cast<CustomEvent*>(castedThis->impl());
    JSValue result = (impl->detail().hasNoValue() ? jsNull() : impl->detail().jsValue());
    return result;
}


JSValue jsCustomEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCustomEvent* domObject = jsCast<JSCustomEvent*>(asObject(slotBase));
    return JSCustomEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSCustomEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCustomEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCustomEventPrototypeFunctionInitCustomEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCustomEvent::s_info))
        return throwVMTypeError(exec);
    JSCustomEvent* castedThis = jsCast<JSCustomEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCustomEvent::s_info);
    CustomEvent* impl = static_cast<CustomEvent*>(castedThis->impl());
    const String& typeArg(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    ScriptValue detailArg(exec->globalData(), exec->argument(3));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initCustomEvent(typeArg, canBubbleArg, cancelableArg, detailArg);
    return JSValue::encode(jsUndefined());
}


}
