/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMessageEvent.h"

#include "DOMWindow.h"
#include "JSDOMWindow.h"
#include "JSDictionary.h"
#include "KURL.h"
#include "MessageEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMessageEventTableValues[] =
{
    { "origin", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventOrigin), (intptr_t)0, NoIntrinsic },
    { "lastEventId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventLastEventId), (intptr_t)0, NoIntrinsic },
    { "source", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventSource), (intptr_t)0, NoIntrinsic },
    { "data", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventData), (intptr_t)0, NoIntrinsic },
    { "ports", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventPorts), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessageEventTable = { 16, 15, JSMessageEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMessageEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessageEventConstructorTable = { 1, 0, JSMessageEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSMessageEventConstructor::constructJSMessageEvent(ExecState* exec)
{
    JSMessageEventConstructor* jsConstructor = jsCast<JSMessageEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    MessageEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillMessageEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<MessageEvent> event = MessageEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillMessageEventInit(MessageEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("origin", eventInit.origin))
        return false;
    if (!dictionary.tryGetProperty("lastEventId", eventInit.lastEventId))
        return false;
    if (!dictionary.tryGetProperty("source", eventInit.source))
        return false;
    if (!dictionary.tryGetProperty("data", eventInit.data))
        return false;
    if (!dictionary.tryGetProperty("ports", eventInit.ports))
        return false;
    return true;
}

static const HashTable* getJSMessageEventConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageEventConstructorTable);
}

const ClassInfo JSMessageEventConstructor::s_info = { "MessageEventConstructor", &Base::s_info, 0, getJSMessageEventConstructorTable, CREATE_METHOD_TABLE(JSMessageEventConstructor) };

JSMessageEventConstructor::JSMessageEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMessageEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMessageEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSMessageEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageEventConstructor, JSDOMWrapper>(exec, getJSMessageEventConstructorTable(exec), jsCast<JSMessageEventConstructor*>(cell), propertyName, slot);
}

bool JSMessageEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageEventConstructor, JSDOMWrapper>(exec, getJSMessageEventConstructorTable(exec), jsCast<JSMessageEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSMessageEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSMessageEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSMessageEventPrototypeTableValues[] =
{
    { "initMessageEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMessageEventPrototypeFunctionInitMessageEvent), (intptr_t)8, NoIntrinsic },
    { "webkitInitMessageEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMessageEventPrototypeFunctionWebkitInitMessageEvent), (intptr_t)8, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMessageEventPrototypeTable = { 4, 3, JSMessageEventPrototypeTableValues, 0 };
static const HashTable* getJSMessageEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageEventPrototypeTable);
}

const ClassInfo JSMessageEventPrototype::s_info = { "MessageEventPrototype", &Base::s_info, 0, getJSMessageEventPrototypeTable, CREATE_METHOD_TABLE(JSMessageEventPrototype) };

JSObject* JSMessageEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessageEvent>(exec, globalObject);
}

bool JSMessageEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMessageEventPrototype* thisObject = jsCast<JSMessageEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSMessageEventPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSMessageEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMessageEventPrototype* thisObject = jsCast<JSMessageEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSMessageEventPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSMessageEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageEventTable);
}

const ClassInfo JSMessageEvent::s_info = { "MessageEvent", &Base::s_info, 0, getJSMessageEventTable , CREATE_METHOD_TABLE(JSMessageEvent) };

JSMessageEvent::JSMessageEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MessageEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSMessageEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMessageEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMessageEventPrototype::create(exec->globalData(), globalObject, JSMessageEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSMessageEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMessageEvent* thisObject = jsCast<JSMessageEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMessageEvent, Base>(exec, getJSMessageEventTable(exec), thisObject, propertyName, slot);
}

bool JSMessageEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMessageEvent* thisObject = jsCast<JSMessageEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMessageEvent, Base>(exec, getJSMessageEventTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsMessageEventOrigin(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageEvent* castedThis = jsCast<JSMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageEvent* impl = static_cast<MessageEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->origin());
    return result;
}


JSValue jsMessageEventLastEventId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageEvent* castedThis = jsCast<JSMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageEvent* impl = static_cast<MessageEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->lastEventId());
    return result;
}


JSValue jsMessageEventSource(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageEvent* castedThis = jsCast<JSMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageEvent* impl = static_cast<MessageEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->source()));
    return result;
}


JSValue jsMessageEventData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageEvent* castedThis = jsCast<JSMessageEvent*>(asObject(slotBase));
    return castedThis->data(exec);
}


JSValue jsMessageEventPorts(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageEvent* castedThis = jsCast<JSMessageEvent*>(asObject(slotBase));
    return castedThis->ports(exec);
}


JSValue jsMessageEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMessageEvent* domObject = jsCast<JSMessageEvent*>(asObject(slotBase));
    return JSMessageEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSMessageEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMessageEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMessageEventPrototypeFunctionInitMessageEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessageEvent::s_info))
        return throwVMTypeError(exec);
    JSMessageEvent* castedThis = jsCast<JSMessageEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMessageEvent::s_info);
    return JSValue::encode(castedThis->initMessageEvent(exec));
}

EncodedJSValue JSC_HOST_CALL jsMessageEventPrototypeFunctionWebkitInitMessageEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessageEvent::s_info))
        return throwVMTypeError(exec);
    JSMessageEvent* castedThis = jsCast<JSMessageEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMessageEvent::s_info);
    return JSValue::encode(castedThis->webkitInitMessageEvent(exec));
}

void JSMessageEvent::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSMessageEvent* thisObject = jsCast<JSMessageEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    visitor.append(&thisObject->m_data);
}


}
