/* mimetype.c generated by valac 0.38.8, the Vala compiler
 * generated from mimetype.vala, do not modify */

/* mimetype.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2010 Canonical, Ltd.
 *             By Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

typedef struct _ZeitgeistMimeRegex ZeitgeistMimeRegex;
typedef struct _ZeitgeistUriScheme ZeitgeistUriScheme;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _zeitgeist_mime_regex_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_mime_regex_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _zeitgeist_uri_scheme_free0(var) ((var == NULL) ? NULL : (var = (zeitgeist_uri_scheme_free (var), NULL)))

struct _ZeitgeistMimeRegex {
	GRegex* regex;
	gchar* interpretation_uri;
};

struct _ZeitgeistUriScheme {
	gchar* uri_scheme;
	gchar* manifestation_uri;
};


extern gboolean zeitgeist_mimetypes_loaded;
gboolean zeitgeist_mimetypes_loaded = FALSE;
extern gboolean zeitgeist_schemes_loaded;
gboolean zeitgeist_schemes_loaded = FALSE;
extern GHashTable* zeitgeist_mimetypes;
GHashTable* zeitgeist_mimetypes = NULL;
extern GSList* zeitgeist_mimetypes_regexs;
GSList* zeitgeist_mimetypes_regexs = NULL;
extern GSList* zeitgeist_schemes;
GSList* zeitgeist_schemes = NULL;

void zeitgeist_mime_regex_free (ZeitgeistMimeRegex * self);
void zeitgeist_uri_scheme_free (ZeitgeistUriScheme * self);
static void zeitgeist_mime_regex_instance_init (ZeitgeistMimeRegex * self);
ZeitgeistMimeRegex* zeitgeist_mime_regex_new (const gchar* mimetype_regex, const gchar* interpretation_uri, GError** error);
static void zeitgeist_uri_scheme_instance_init (ZeitgeistUriScheme * self);
ZeitgeistUriScheme* zeitgeist_uri_scheme_new (const gchar* uri_scheme, const gchar* manifestation_uri);
void zeitgeist_register_mimetype (const gchar* mimetype, const gchar* interpretation_uri);
static void _g_free0_ (gpointer var);
void zeitgeist_register_mimetype_regex (const gchar* mimetype_regex, const gchar* interpretation_uri);
const gchar* zeitgeist_interpretation_for_mimetype (const gchar* mimetype);
void zeitgeist_ensure_mimetypes_loaded (void);
void zeitgeist_register_uri_scheme (const gchar* uri_scheme, const gchar* manifestation_type);
const gchar* zeitgeist_manifestation_for_uri (const gchar* uri);
void zeitgeist_ensure_schemes_loaded (void);
#define ZEITGEIST_NFO_SOURCE_CODE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#SourceCode"
#define ZEITGEIST_NFO_SPREADSHEET "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Spreadsheet"
#define ZEITGEIST_NFO_PRESENTATION "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Presentation"
#define ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#PaginatedText" \
"Document"
#define ZEITGEIST_NFO_AUDIO "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Audio"
#define ZEITGEIST_NFO_VECTOR_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#VectorImage"
#define ZEITGEIST_NFO_ARCHIVE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Archive"
#define ZEITGEIST_NFO_FILESYSTEM_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FilesystemIma" \
"ge"
#define ZEITGEIST_NFO_SOFTWARE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Software"
#define ZEITGEIST_NFO_EXECUTABLE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Executable"
#define ZEITGEIST_NFO_MEDIA_LIST "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#MediaList"
#define ZEITGEIST_NFO_RASTER_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RasterImage"
#define ZEITGEIST_NFO_ICON "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Icon"
#define ZEITGEIST_NFO_FOLDER "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Folder"
#define ZEITGEIST_NMO_EMAIL "http://www.semanticdesktop.org/ontologies/2007/03/22/nmo#Email"
#define ZEITGEIST_NFO_TEXT_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#TextDocument"
#define ZEITGEIST_NFO_HTML_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#HtmlDocument"
#define ZEITGEIST_NCO_CONTACT "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#Contact"
#define ZEITGEIST_NFO_DOCUMENT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Document"
#define ZEITGEIST_NFO_IMAGE "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Image"
#define ZEITGEIST_NFO_VIDEO "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#Video"
#define ZEITGEIST_NFO_FILE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObjec" \
"t"
#define ZEITGEIST_NFO_WEB_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#WebDataObject"
#define ZEITGEIST_NFO_REMOTE_DATA_OBJECT "http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#RemoteDataObj" \
"ect"


ZeitgeistMimeRegex* zeitgeist_mime_regex_new (const gchar* mimetype_regex, const gchar* interpretation_uri, GError** error) {
	ZeitgeistMimeRegex* self;
	GRegex* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GRegex* _tmp2_;
	GRegex* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (mimetype_regex != NULL, NULL);
	g_return_val_if_fail (interpretation_uri != NULL, NULL);
	self = g_slice_new0 (ZeitgeistMimeRegex);
	zeitgeist_mime_regex_instance_init (self);
	_tmp1_ = mimetype_regex;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_zeitgeist_mime_regex_free0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_regex_unref0 (self->regex);
	self->regex = _tmp3_;
	_tmp4_ = interpretation_uri;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->interpretation_uri);
	self->interpretation_uri = _tmp5_;
	_g_regex_unref0 (_tmp0_);
	return self;
}


static void zeitgeist_mime_regex_instance_init (ZeitgeistMimeRegex * self) {
}


void zeitgeist_mime_regex_free (ZeitgeistMimeRegex * self) {
	_g_regex_unref0 (self->regex);
	_g_free0 (self->interpretation_uri);
	g_slice_free (ZeitgeistMimeRegex, self);
}


ZeitgeistUriScheme* zeitgeist_uri_scheme_new (const gchar* uri_scheme, const gchar* manifestation_uri) {
	ZeitgeistUriScheme* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (uri_scheme != NULL, NULL);
	g_return_val_if_fail (manifestation_uri != NULL, NULL);
	self = g_slice_new0 (ZeitgeistUriScheme);
	zeitgeist_uri_scheme_instance_init (self);
	_tmp0_ = uri_scheme;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->uri_scheme);
	self->uri_scheme = _tmp1_;
	_tmp2_ = manifestation_uri;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->manifestation_uri);
	self->manifestation_uri = _tmp3_;
	return self;
}


static void zeitgeist_uri_scheme_instance_init (ZeitgeistUriScheme * self) {
}


void zeitgeist_uri_scheme_free (ZeitgeistUriScheme * self) {
	_g_free0 (self->uri_scheme);
	_g_free0 (self->manifestation_uri);
	g_slice_free (ZeitgeistUriScheme, self);
}


/**
     * zeitgeist_register_mimetype:
     *
     * Associate a MIME-type with a given interpretation type. Registered
     * MIME-types can be looked up with zeitgeist_interpretation_for_mimetype().
     *
     * You can register a regular expression as mimetype if instead of this
     * function you invoke zeitgeist_register_mimetype_regex().
     *
     * MIME-types are first looked up by their exact name and then if none is
     * found the regular expressions will be checked as fallbacks.
     *
     * This library will install a wide range a common mimetypes for you, so
     * unless you have very specific needs you will normally not have to call
     * this function.
     *
     * @param mimetype  A MIME-type string. Eg. //text/plain//
     * @param interpretation_uri A URI defining the subject interpretation
     *     type to associate with "mimetype"
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void zeitgeist_register_mimetype (const gchar* mimetype, const gchar* interpretation_uri) {
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (mimetype != NULL);
	g_return_if_fail (interpretation_uri != NULL);
	_tmp0_ = zeitgeist_mimetypes;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (zeitgeist_mimetypes);
		zeitgeist_mimetypes = _tmp3_;
	}
	_tmp4_ = zeitgeist_mimetypes;
	_tmp5_ = mimetype;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = interpretation_uri;
	_tmp8_ = g_strdup (_tmp7_);
	g_hash_table_insert (_tmp4_, _tmp6_, _tmp8_);
}


/**
     * zeitgeist_register_mimetype_regex:
     *
     * Associate a range of MIME-types with a given interpretation type.
     * Registered MIME-types can be looked up with
     * zeitgeist_interpretation_for_mimetype().
     *
     * If you only need to register one specific MIME-type, it is more efficient
     * to use zeitgeist_register_mimetype() instead of this function.
     *
     * MIME-types are first looked up by their exact name and then if none is
     * found the regular expressions will be checked as fallbacks.
     *
     * This library will install a wide range a common mimetypes for you, so
     * unless you have very specific needs you will normally not have to call
     * this function.
     *
     * @param mimetype_regex A regular expression matching a certain range of
     *     mimetypes. Eg. //text/.* // to match all //text// subtypes.
     * @param interpretation_uri A URI defining the subject interpretation
     *     type to associate with the matched MIME-types
     */
void zeitgeist_register_mimetype_regex (const gchar* mimetype_regex, const gchar* interpretation_uri) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (mimetype_regex != NULL);
	g_return_if_fail (interpretation_uri != NULL);
	{
		ZeitgeistMimeRegex* entry = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		ZeitgeistMimeRegex* _tmp2_;
		ZeitgeistMimeRegex* _tmp3_;
		_tmp0_ = mimetype_regex;
		_tmp1_ = interpretation_uri;
		_tmp2_ = zeitgeist_mime_regex_new (_tmp0_, _tmp1_, &_inner_error_);
		entry = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = entry;
		entry = NULL;
		zeitgeist_mimetypes_regexs = g_slist_append (zeitgeist_mimetypes_regexs, _tmp3_);
		_zeitgeist_mime_regex_free0 (entry);
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("mimetype.vala:124: Couldn't register mimetype regex: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
     * zeitgeist_interpretation_for_mimetype:
     *
     * Look up the subject interpretation type associated with @mimetype.
     *
     * @param mimetype A MIME-type string. Eg. //text/plain//
     *
     * @return A URI defining the subject interpretation type associated with
     *     "mimetype" or %NULL in case "mimetype" is unknown
     */
const gchar* zeitgeist_interpretation_for_mimetype (const gchar* mimetype) {
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* interpretation = NULL;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	const gchar* _tmp4_;
	GSList* _tmp6_;
	zeitgeist_ensure_mimetypes_loaded ();
	_tmp0_ = mimetype;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = zeitgeist_mimetypes;
	_tmp2_ = mimetype;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	interpretation = (const gchar*) _tmp3_;
	_tmp4_ = interpretation;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = interpretation;
		result = _tmp5_;
		return result;
	}
	_tmp6_ = zeitgeist_mimetypes_regexs;
	{
		GSList* mime_regex_collection = NULL;
		GSList* mime_regex_it = NULL;
		mime_regex_collection = _tmp6_;
		for (mime_regex_it = mime_regex_collection; mime_regex_it != NULL; mime_regex_it = mime_regex_it->next) {
			ZeitgeistMimeRegex* mime_regex = NULL;
			mime_regex = (ZeitgeistMimeRegex*) mime_regex_it->data;
			{
				ZeitgeistMimeRegex* _tmp7_;
				GRegex* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_;
				_tmp7_ = mime_regex;
				_tmp8_ = _tmp7_->regex;
				_tmp9_ = mimetype;
				_tmp10_ = g_regex_match (_tmp8_, _tmp9_, 0, NULL);
				if (_tmp10_) {
					ZeitgeistMimeRegex* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = mime_regex;
					_tmp12_ = _tmp11_->interpretation_uri;
					result = _tmp12_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


/**
     * zeitgeist_register_uri_scheme:
     *
     * Associate a URI scheme with a given subject manifestation type.
     * You can find the manifestation type of a given URI by passing it to
     * zeitgeist_manifestation_for_uri().
     *
     * This library will install a range a common URI schemes for you, so unless
     * you have very specific needs you will normally not have to call this
     * function.
     *
     * @param uri_scheme A URI scheme such as //http:\/\///
     * @param manifestation_type A URI defining the subject manifestation type
     *     to associate with "uri_scheme"
     */
void zeitgeist_register_uri_scheme (const gchar* uri_scheme, const gchar* manifestation_type) {
	ZeitgeistUriScheme* scheme = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ZeitgeistUriScheme* _tmp2_;
	ZeitgeistUriScheme* _tmp3_;
	g_return_if_fail (uri_scheme != NULL);
	g_return_if_fail (manifestation_type != NULL);
	_tmp0_ = uri_scheme;
	_tmp1_ = manifestation_type;
	_tmp2_ = zeitgeist_uri_scheme_new (_tmp0_, _tmp1_);
	scheme = _tmp2_;
	_tmp3_ = scheme;
	scheme = NULL;
	zeitgeist_schemes = g_slist_append (zeitgeist_schemes, _tmp3_);
	_zeitgeist_uri_scheme_free0 (scheme);
}


/**
     * zeitgeist_manifestation_for_uri
     *
     * Look up a subject manifestation type for a given URI. Eg. if you pass in
     * //file:\/\/\/tmp/foo.txt// you will get back
     * ZEITGEIST_NFO_FILE_DATA_OBJECT.
     *
     * @param uri An URI
     *
     * @return A subject manifestation type for @uri or %NULL in case no
     *     suitable manifestation type is known
     */
const gchar* zeitgeist_manifestation_for_uri (const gchar* uri) {
	const gchar* result = NULL;
	GSList* _tmp0_;
	g_return_val_if_fail (uri != NULL, NULL);
	zeitgeist_ensure_schemes_loaded ();
	_tmp0_ = zeitgeist_schemes;
	{
		GSList* scheme_collection = NULL;
		GSList* scheme_it = NULL;
		scheme_collection = _tmp0_;
		for (scheme_it = scheme_collection; scheme_it != NULL; scheme_it = scheme_it->next) {
			ZeitgeistUriScheme* scheme = NULL;
			scheme = (ZeitgeistUriScheme*) scheme_it->data;
			{
				const gchar* _tmp1_;
				ZeitgeistUriScheme* _tmp2_;
				const gchar* _tmp3_;
				gboolean _tmp4_;
				_tmp1_ = uri;
				_tmp2_ = scheme;
				_tmp3_ = _tmp2_->uri_scheme;
				_tmp4_ = g_str_has_prefix (_tmp1_, _tmp3_);
				if (_tmp4_) {
					ZeitgeistUriScheme* _tmp5_;
					const gchar* _tmp6_;
					_tmp5_ = scheme;
					_tmp6_ = _tmp5_->manifestation_uri;
					result = _tmp6_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


void zeitgeist_ensure_mimetypes_loaded (void) {
	gboolean _tmp0_;
	_tmp0_ = zeitgeist_mimetypes_loaded;
	if (_tmp0_) {
		return;
	}
	zeitgeist_register_mimetype ("application/ecmascript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/javascript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/json", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/ms-excel", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/ms-powerpoint", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype ("application/msexcel", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/msword", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/ogg", ZEITGEIST_NFO_AUDIO);
	zeitgeist_register_mimetype ("application/pdf", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/postscript", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/ps", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/rtf", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/soap+xml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/vnd.corel-draw", ZEITGEIST_NFO_VECTOR_IMAGE);
	zeitgeist_register_mimetype ("application/vnd.ms-excel", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/vnd.ms-powerpoint", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype ("application/x-7z-compressed", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-abiword", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/x-applix-presents", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype ("application/x-applix-spreadsheet", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/x-applix-word", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/x-archive", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-bzip", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-bzip-compressed-tar", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-cd-image", ZEITGEIST_NFO_FILESYSTEM_IMAGE);
	zeitgeist_register_mimetype ("application/x-compressed-tar", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-csh", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-deb", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-designer", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-desktop", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-dia-diagram", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-executable", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-fluid", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-glade", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-gnucash", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/x-gnumeric", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/x-gzip", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-java-archive", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-javascript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-killustrator", ZEITGEIST_NFO_VECTOR_IMAGE);
	zeitgeist_register_mimetype ("application/x-kpresenter", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype ("application/x-kspread", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype ("application/x-kword", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("application/x-lzma", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-lzma-compressed-tar", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/x-m4", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-ms-dos-executable", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-perl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-php", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-rpm", ZEITGEIST_NFO_SOFTWARE);
	zeitgeist_register_mimetype ("application/x-ruby", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-shellscript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-shockwave-flash", ZEITGEIST_NFO_EXECUTABLE);
	zeitgeist_register_mimetype ("application/x-sql", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/x-stuffit", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("application/xhtml+xml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/xml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/xml-dtd", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("application/zip", ZEITGEIST_NFO_ARCHIVE);
	zeitgeist_register_mimetype ("audio/x-scpls", ZEITGEIST_NFO_MEDIA_LIST);
	zeitgeist_register_mimetype ("image/gif", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/jpeg", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/pjpeg", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/png", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/svg+xml", ZEITGEIST_NFO_VECTOR_IMAGE);
	zeitgeist_register_mimetype ("image/tiff", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("image/vnd.microsoft.icon", ZEITGEIST_NFO_ICON);
	zeitgeist_register_mimetype ("image/x-xcf", ZEITGEIST_NFO_RASTER_IMAGE);
	zeitgeist_register_mimetype ("inode/directory", ZEITGEIST_NFO_FOLDER);
	zeitgeist_register_mimetype ("message/alternative", ZEITGEIST_NMO_EMAIL);
	zeitgeist_register_mimetype ("message/partial", ZEITGEIST_NMO_EMAIL);
	zeitgeist_register_mimetype ("message/related", ZEITGEIST_NMO_EMAIL);
	zeitgeist_register_mimetype ("text/css", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/csv", ZEITGEIST_NFO_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("text/html", ZEITGEIST_NFO_HTML_DOCUMENT);
	zeitgeist_register_mimetype ("text/javascript", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/plain", ZEITGEIST_NFO_TEXT_DOCUMENT);
	zeitgeist_register_mimetype ("text/vcard", ZEITGEIST_NCO_CONTACT);
	zeitgeist_register_mimetype ("text/x-c", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-c++", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-c++src", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-chdr", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-copying", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-credits", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-csharp", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-csrc", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-dsrc", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-eiffel", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-gettext-translation", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-gettext-translation-template", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-haskell", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-idl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-java", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-jquery-tmpl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-latex", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-lisp", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-lua", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-m4", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-makefile", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-objcsrc", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-ocaml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-pascal", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-patch", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-python", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-sql", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-tcl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-tex", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-troff", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-vala", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/x-vhdl", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype ("text/xml", ZEITGEIST_NFO_SOURCE_CODE);
	zeitgeist_register_mimetype_regex (".*/x-dvi", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype_regex ("application/vnd.ms-excel.*", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype_regex ("application/vnd.ms-powerpoint.*", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype_regex ("application/vnd.oasis.opendocument.graphics.*", ZEITGEIST_NFO_VECTOR_IMAGE);
	zeitgeist_register_mimetype_regex ("application/vnd.oasis.opendocument.presentation.*", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype_regex ("application/vnd.oasis.opendocument.spreadsheet.*", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype_regex ("application/vnd.oasis.opendocument.text.*", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype_regex ("application/vnd.openxmlformats-officedocument.presentationml.presentat" \
"ion.*", ZEITGEIST_NFO_PRESENTATION);
	zeitgeist_register_mimetype_regex ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.*", ZEITGEIST_NFO_SPREADSHEET);
	zeitgeist_register_mimetype_regex ("application/vnd.openxmlformats-officedocument.wordprocessingml.documen" \
"t.*", ZEITGEIST_NFO_PAGINATED_TEXT_DOCUMENT);
	zeitgeist_register_mimetype_regex ("application/vnd\\..*", ZEITGEIST_NFO_DOCUMENT);
	zeitgeist_register_mimetype_regex ("application/x-applix-.*", ZEITGEIST_NFO_DOCUMENT);
	zeitgeist_register_mimetype_regex ("audio/.*", ZEITGEIST_NFO_AUDIO);
	zeitgeist_register_mimetype_regex ("image/.*", ZEITGEIST_NFO_IMAGE);
	zeitgeist_register_mimetype_regex ("video/.*", ZEITGEIST_NFO_VIDEO);
	zeitgeist_mimetypes_loaded = TRUE;
}


void zeitgeist_ensure_schemes_loaded (void) {
	gboolean _tmp0_;
	_tmp0_ = zeitgeist_schemes_loaded;
	if (_tmp0_) {
		return;
	}
	zeitgeist_register_uri_scheme ("file://", ZEITGEIST_NFO_FILE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("http://", ZEITGEIST_NFO_WEB_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("https://", ZEITGEIST_NFO_WEB_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("ssh://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("sftp://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("ftp://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("dav://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("davs://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_register_uri_scheme ("smb://", ZEITGEIST_NFO_REMOTE_DATA_OBJECT);
	zeitgeist_schemes_loaded = TRUE;
}



