	TITLE	TurboDOS DELETE file Resident System Process   09-03-85
	SUBTTL	Copyright (c) 1985 Intercontinental Micro Systems.
;
;Module Function:
;	This module allows a system integrator to delete files
;	on a periodic basis by using the TurboDOS Resident
;	System Process function. Files will be deleted at the
;	Date/Time selected, and only those FCB's which are active
;	will function. This process must reside in the MASTER,
;	and would only be useful if the system is left on 24 hours
;	a day. Optimum time for this function to be activated would
;	be late in the evening or early morning hours when system
;	activity is low. This would eliminate sluggish operation
;	on the system, as the master would be quite involved in
;	doing the file delete operations. An optional flag byte may
;	be set true to activate a FIXDIR operation after the files
;	are deleted. This would help keep TurboDOS's directory "Hashing"
;	optimal.
;
;edit history:
;12-12-83 gwm	created file.
;12-13-83 gwm	added check for T/D internal date set.
;09-03-85 gwm	cleanup of code.
;
	.Z80				; user z80 code
;
;equates for RSP function
;
DLYTIM	EQU	01			; number of minutes to delay
DSKMAP	EQU	12			; FCB area after file name to clear
FCBLEN	EQU	36			; length of FCB's
;
	INCLUDE	EQUATE			; use equate file for O/S constants
;
	NAME	('DELRSP')		; module name
;
;The purpose of this module is to delete selected files from
;which ever drive and user area you wish. This function is performed
;in the background and may be activated on a delay of up to 20 mins.
;
	COMMON	/?INIT?/		; place into init segment
;
;Check to see if TurboDOS internal date/time set yet.
;If not set, then Reg HL will = 8001 hex, else, Julian date
;if system date set.
;If TurboDOS Date/Time set, save and image
;of it at Memory location "JULIAN" for trigger date.
;
USRPR@::CALL	GETDAT
;
;Start resident system process running.
;
	LD	DE,BACKGR		; get process entry address
	JP	CRPROC##		; create process
;
	CSEG
;
;Main RSP function.
;
BACKGR:	LD	C,WSFCN			; warm start function
	CALL	OCNTRY##		; O/S entry point
;
	LD	C,LOGFCN		; do logon function for RSP
	LD	E,0 + 80H		; user 0 priviliged logon in master
	CALL	OCNTRY##		; O/S entry point
;
;Do delay function for RSP, also main return entry point
;after RSP finished.
;
LOOP:	LD	DE,50*60*DLYTIM		; get delay time in minutes
	LD	C,DPFCN			; do dispatch function
	CALL	OTNTRY##		; O/S entry
;
;check for valid julian date at JULIAN location
;
	LD	HL,(JULIAN)		; get the word saved
	LD	A,L			; check for 0000 entry
	OR	H
	JR	NZ,..LP1		; if date/time ready, continue
	CALL	GETDAT			; if its zero, attempt to get date
	JR	LOOP			; and restart from beginning
;
;check for last day count
;
..LP1:	EX	DE,HL			; get last date anything happened
	LD	HL,(JDATE##)		; get present date from TurboDOS
	OR	A			; clear flags
	SBC	HL,DE			; get total elapsed days
	LD	A,(ZRODAY)		; get comparison day
	CP	L			; is this the trigger day?
	JR	NZ,LOOP			; if not, keep checking
;
;check for selected hour RSP is to go active.
;
	LD	HL,HOURS##		; point to internal T/D hours
	LD	A,(HOUR)		; get user selected hour
	CP	(HL)			; is this it?
	JR	NZ,LOOP			; loop till hours comes set
;
;Capture TurboDOS julian date and save it at JULIAN
;to reset days to next operation value.
;
	LD	HL,(JDATE##)		; get julian date from TurboDOS
	LD	(JULIAN),HL		; save it for Restart of RSP.
;
;set to user 0
;
NXTUSR:	LD	A,(BGNUSR)		; get default user number
	LD	E,A			; to reg E
	LD	C,SRUFCN		; set user number
	CALL	OCNTRY##		; O/S entry point
;
;User area selected, delete files if FCB's are active.
;
	LD	B,4			; 4 FCB's to do
	LD	DE,FCB1			; point to first FCB
..NFN:	CALL	DELFCB			; delete file this FCB?
;
	LD	HL,FCBLEN		; length between FCB's
	ADD	HL,DE			; point to next FCB
	EX	DE,HL			; place into DE register
	DJNZ	..NFN			; loop till all FCB's done
;
;check range of user area's thus far accessed.
;
	LD	A,(BGNUSR)		; get user number
	INC	A			; bump it
	LD	(BGNUSR),A		; save it
	CP	32			; stop at user 31
	JR	NZ,NXTUSR		; continue if not user 31
;
;end of active user areas. Reset to user 0.
;
	XOR	A			; clear reg a
	LD	(BGNUSR),A		; reset to beginning user number
;
;check for FIXMAP/FIXDIR operation wanted.
;
	LD	A,(HASHF)		; get hashing flag byte
	OR	A			; do we do fixmap/fixdir?
	JR	Z,LOOP			; if not, back to main entry point
;
;flush buffers to disk drive before doing fixmap/fixdir operation.
;
	LD	A,(DRIVE)		; get drive
	LD	E,A
	LD	D,80H			; un-conditional flush/free buffers
	LD	C,FFBFCN		; function call
	CALL	OTNTRY##		; do it
;
	LD	A,(DRIVE)		; drive to fixmap/fixdir
	LD	E,A
	LD	C,RDMFCN		; fixmap function call
	CALL	OTNTRY##		; do it
	OR	A			; check for errors
	JR	NZ,LOOP			; if errors, abort the rest
;
	LD	A,(DRIVE)		; get drive for fixdir operation
	LD	E,A
	LD	C,RDDFCN		; fixdir function call
	CALL	OTNTRY##		; do it
	JR	LOOP			; keep process running
;
;check for T/D internal date not set yet.
;if not set = (8001 hex).
;
GETDAT:	LD	HL,(JDATE##)		; get julian date internal
	LD	A,80H			; check for correct date
	CP	H
	LD	HL,0			; clear hl in case date/time not set
	JR	Z,SETNOT		; loop till set
;
;capture TurboDOS julian date and save it at JULIAN.
;
	LD	HL,(JDATE##)		; get internal julian date
SETNOT:	LD	(JULIAN),HL		; save it
	RET
;
;Routine to delete files pointed to by DE register.
;Each FCB is first checked to see if 1st byte = FF hex.
;If it = FF, then the delete is skipped, else, file is deleted.
;
DELFCB:	LD	A,(DE)			; first entry = 0ff?
	CP	0FFH
	RET	Z			; return if not active
;
;This FCB is active, delete the file
;
	PUSH	BC			; save counter
	PUSH	DE			; save pointer
	LD	C,DFFCN			; delete file function
	CALL	OCNTRY##		; O/S entry point
	POP	DE			; recover pointer
	POP	BC			; recover counter
	RET
;
	DSEG
;
ZRODAY::DB	1			; trigger day for action
BGNUSR:	DB	0			; starting user number
HOUR::	DB	23			; hour of delete operation to happen
HASHF::	DB	0			; 0=no FIXDIR, 1=do FIXDIR when done
DRIVE::	DB	0			; drive to hash (0=A:,1=B:, ..etc)
JULIAN:	DW	0			; julian date save location
;
FCB1::	DB	-1,'????????BAK'	; -1 = not used
	DB	0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0
;
FCB2::	DB	-1,'????????PRN'	; -1 = not used
	DB	0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0
;
FCB3::	DB	-1,'????????SYM'	; -1 = not used
	DB	0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0
;
FCB4::	DB	-1,'????????$$$'	; -1 = not used
	DB	0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0
;
	END

