	TITLE	'CDCGET -- READ (BOOT) CPM FROM A CDC DRIVE'

;	08-03-81



;   THIS PROGRAM IS USED TO READ (BOOT) CPM FROM A CDC PHOENIX
;   (CMD) HARD DISK DRIVE. AN XCOMP SMS/SMR CONTROLLER IS USED.






;	---PROGRAM CONFIGURATION---
;
;
;   THE FOLLOWING STATEMENTS ARE USED TO CONFIGURE THE PROGRAM.
;
;	1. TEST - SET THIS 'FALSE' BEFORE USING THE PROGRAM.
;
;	2. ENBINT - SET THIS 'TRUE' IF YOU NEED INTERRUPTS ENABLED
;	   WHILE RUNNING THE PROGRAM. SET THIS 'FALSE' IF YOU DO
;	   NOT USE INTERRUPTS.
;
;	3. S100 - SET THIS 'TRUE' IF YOU ARE USING A CONTROLLER WITH
;	   AN S100 BUS INTERFACE (SMS). SET THIS 'FALSE' IF YOU ARE
;	   USING A CONTROLLER WITH A RIBBON CABLE INTERFACE (SMR).
;
;
FALSE	EQU	0		;DEFINE FALSE
TRUE	EQU	NOT FALSE	;..TRUE
;
TEST	EQU	FALSE		;NOT TESTING
;
ENBINT	EQU	FALSE		;WE DON'T USE INTERRUPTS
;
S100	EQU	TRUE		;S-100 BUS CONTROLLER (SMS)






;	---EQUATES---
;
;
MSIZE	EQU	62		;MEMORY SIZE IN K-BYTES
;
BIAS	EQU	(MSIZE-20)*1024	;SYSTEM BIAS
CPM	EQU	BIAS+3400H	;CPM LOAD ADDRESS
BIOS	EQU	CPM+1600H	;COLD BOOT ENTRY POINT
;
STRT	EQU	100H		;PROGRAM START ADDRESS
NSECT	EQU	30		;NUMBER OF SECTORS TO READ
;
DEBUG	EQU	0F000H		;DEBUG ENTRY POINT
TRAP	EQU	0F01EH		;DEBUG TRAP ADDRESS
;
RPT	EQU	80H		;REPEAT
INDEX	EQU	10H		;INDEX BIT
;
;   ASCII CHARACTERS
;
CR	EQU	0DH		;CARRIAGE RETURN
LF	EQU	0AH		;LINE FEED
BELL	EQU	7		;DING!
;
;   CRT I/O
;
CRTS	EQU	9		;STATUS
CRTD	EQU	8		;DATA
CRTBE	EQU	1		;BUFFER EMPTY
CRTDA	EQU	2		;DATA AVAILABLE
;
;   CONTROLLER COMMANDS
;
BANK0	EQU	0		;BANK 0 SELECT
BANK1	EQU	1		;BANK 1 SELECT
DBENB	EQU	2		;DATA BUFFER ENABLE
CBENB	EQU	4		;COMPARE BUFFER ENABLE
START	EQU	8		;START COMMAND
;
;   DRIVE COMMANDS
;
D@CLR	EQU	10H		;FAULT CLEAR
D@TKZ	EQU	40H		;REZERO
;
;   DRIVE TAGS
;
DSTAG	EQU	1		;DRIVE SELECT TAG
TAG1	EQU	2+1		;  TAG1
TAG2	EQU	4+1		;  TAG2
TAG3	EQU	8+1		;  TAG3
;
;   DRIVE/CONTROLLER I/O
;
CBASE	EQU	70H		;BASE ADR OF THE CONTROLLER
	IF	S100	;  ** IF S-100 INTERFACE **
DRCSR	EQU	CBASE		;DRIVE COMMAND/STATUS
CBL	EQU	CBASE+1		;COMMAND BUS, LSB
CBH	EQU	CBASE+2		;  * MSB
DRSB	EQU	CBASE+3		;DRIVE SELECT BITS
CTCSR	EQU	CBASE+4		;CONTROLLER COMMAND/STATUS
CTBFR	EQU	CBASE+5		;CONTROLLER BUFFER ADDRESS
CTDP	EQU	CBASE+6		;CONTROLLER DATA PORT
CLRSEK	EQU	CBASE+7		;CLEAR SEEK END F/F
	ELSE		;  ** IF RIBBON CABLE INTERFACE **
DRCSR	EQU	CBASE+7		;DRIVE COMMAND/STATUS
CBL	EQU	CBASE+6		;COMMAND BUS, LSB
CBH	EQU	CBASE+5		;  * MSB
DRSB	EQU	CBASE+4		;DRIVE SELECT BITS
CTCSR	EQU	CBASE+3		;CONTROLLER COMMAND/STATUS
CTBFR	EQU	CBASE+2		;CONTROLLER BUFFER ADDRESS
CTDP	EQU	CBASE+1		;CONTROLLER DATA PORT
CLRSEK	EQU	CBASE		;CLEAR SEEK END F/F
	ENDIF

	PAGE

	ORG	STRT



;	---PROGRAM ENTRY POINT---
;
;
GET:	LXI	SP,$		;SET STACK
	XRA	A
	OUT	DRCSR		;DESELECT ALL DRIVES
	OUT	CBL		;CLEAR CMD BUS
	OUT	CBH
	OUT	DRSB		;DRIVE 0
	INR	A
	OUT	DRCSR		;SELECT DRIVE 0
;
	LXI	H,RDCODE
	CALL	SQUIRT		;LOAD READ M/CODE
	LXI	H,WRTCODE
	CALL	SQUIRT		;LOAD WRITE M/CODE
;
;   GET LOOP
;
LOOP:	CALL	TKZ		;RESTORE
	JNZ	ERROR		;JIF RESTORE FAILED
	LXI	H,CPM
	SHLD	DMADR		;INIT DMA ADR
	LXI	H,SECTOR
	MVI	M,1		;INIT SECTOR ADR
	INX	H
	MVI	M,NSECT		;INIT SECTOR COUNT
	CALL	HDSEL		;SLCT HEAD ZERO
;
L1:	LXI	H,RTBL
	CALL	DORW		;READ A SECTOR
	JNZ	ERROR		;JIF HAD READ ERROR
;
	MVI	A,DBENB
	OUT	CTCSR		;ENB DATA BFR
	XRA	A
	OUT	CTBFR		;SET BFR ADR = 0
	MOV	B,A		;B = COUNT (256)
	LHLD	DMADR		;ADR OF THE DATA
	IN	CTDP		;PRIME INPUT DATA
L2:	IN	CTDP		;GET DATA FROM BFR
	MOV	M,A		;PUT DATA INTO RAM
	INX	H
	DCR	B
	JNZ	L2
	SHLD	DMADR		;SAVE NEW DMA ADR
;
	LXI	H,SECTOR
	INR	M		;INCR SECTOR ADR
	INX	H
	DCR	M		;DECR SECTOR COUNT
	JNZ	L1		;JIF NOT DONE
;
	IF	TEST
	JMP	DEBUG		;IF WE ARE TESTING
	ELSE
	JMP	BIOS		;RUN CPM
	ENDIF





;	---EXECUTE READ/WRITE COMMANDS---
;
;
DORW:	MOV	A,M
	STA	RETRY		;SET RETRY COUNT
	INX	H
	MOV	A,M
	OUT	CTCSR		;ENB CMP BFR
	INX	H
	MOV	A,M
	OUT	CTBFR		;SET CMP BFR ADR
	INX	H
	SHLD	CTA		;SAVE CMD TBL ADR
;
	LXI	H,CYL
	MVI	B,4
DO1:	MOV	A,M
	OUT	CTDP		;PUT HDR INFO INTO CMP BFR
	INX	H
	DCR	B
	JNZ	DO1
;
DO2:	CALL	RDY		;DRIVE READY ?
	RNZ			;RIF DRIVE NOT RDY
	XRA	A
	OUT	CBH
	OUT	CBL		;CLEAR CMD BUS
	MVI	A,TAG3
	OUT	DRCSR		;SET TAG3
	LHLD	CTA		;CMD TBL ADR
	MOV	A,M		;A = CNTL BANK
	INX	H
	MOV	B,A
	OUT	CTCSR		;SLCT CNTL BANK
	MOV	A,M
	OUT	CTBFR		;SET START ADR
	INX	H
	MOV	A,B
	ORI	START
	OUT	CTCSR		;START R/W CMD
;
DO3:	IN	CTCSR		;CTLR STATUS
	RRC
	JNC	DO3		;WAIT FOR DONE
	NOP			;DELAY FOR H/W
	IN	CTCSR		;GET NON-CHANGING STATUS
	MOV	B,A		;   SAVE IT
	XRA	A
	OUT	CTCSR		;STOP CTLR
	INR	A
	OUT	DRCSR		;CLEAR TAG3
	MOV	A,B
	ANA	M		;TEST CTLR STATUS (0=OK)
	MOV	B,A
	IN	DRCSR		;DRIVE STATUS
	ANI	10H
	CNZ	CLRDF		;CIF CLEAR DRIVE FAULT
	ORA	B		;SET/CLEAR ERROR FLAG (0=OK)
	RZ			;RIF READ/WRITE OK
	LXI	H,RETRY
	DCR	M		;DECR RETRY CNT
	JNZ	DO2		;JIF RETRY READ/WRITE
	LXI	H,MSG3		;ERROR MSG
	ORI	1		;SET ERROR FLAG
	RET




;	---REZERO---
;
;
TKZ:	CALL	RDY		;DRIVE READY ?
	RNZ			;RIF DRIVE NOT RDY
	MVI	A,3
	STA	RETRY		;SET RETRY COUNT
;
TKZ1:	CALL	RTZ		;RESTORE
	RZ			;RIF RESTORE OK
	LXI	H,RETRY
	DCR	M		;DECR RETRY COUNT
	JNZ	TKZ1		;RETRY RESTORE
	LXI	H,MSG2		;ERROR MSG
	ORI	1		;SET ERROR FLAG
	RET
;
RTZ:	MVI	A,1
	OUT	CLRSEK		;CLEAR SEEK END F/F
	XRA	A
	OUT	CBH
	MVI	A,D@TKZ
	OUT	CBL		;SET CMD BUS = REZERO
	MVI	A,TAG3
	DI			;INHIBIT INTPS
	OUT	DRCSR		;SET TAG3
	MVI	A,DSTAG
	OUT	DRCSR		;CLEAR TAG3
	IF	ENBINT		;IF INTPS ENABLED
	EI
	ENDIF
;
;   WAIT FOR SEEK COMPLETE
;
WSC:	IN	CTCSR		;CTLR STATUS
	ANI	40H		;SEEK END INTP
	JZ	WSC		;WAIT FOR SEEK DONE
	IN	DRCSR		;DRIVE STATUS
	ANI	22H		; 'SEEK ERR'  &  'ON CYL'
	XRI	2		;INVERT +ONCYL BIT
	RET			;IF A=0, SEEK OK




;	---HEAD SELECT---
;
;
HDSEL:	XRA	A
	OUT	CBL
	OUT	CBH		;SLCT HEAD 0
	MVI	A,TAG2
	DI			;INHIBIT INTPS
	OUT	DRCSR		;SET TAG2
	MVI	A,DSTAG
	OUT	DRCSR		;CLEAR TAG2
	IF	ENBINT		;IF INTPS ENABLED
	EI
	ENDIF
	RET




;	---DRIVE READY TEST---
;
;
RDY:	IN	DRCSR		;DRIVE STATUS
	ANI	9		;'UNIT SLCT'  &  'DRIVE RDY'
	XRI	9		;INVERT BOTH
	RZ			;RIF DRIVE READY
	LXI	H,MSG1		;ERROR MSG
	ORI	1		;SET ERROR FLAG
	RET




;	---CLEAR DRIVE FAULT---
;
;
CLRDF:	XRA	A
	OUT	CBH
	MVI	A,D@CLR
	OUT	CBL		;SET CMD BUS = FAULT CLEAR
	MVI	A,TAG3
	DI			;INHIBIT INTPS
	OUT	DRCSR		;SET TAG3
	MVI	A,DSTAG
	OUT	DRCSR		;CLEAR TAG3
	IF	ENBINT		;IF INTPS ENABLED
	EI
	ENDIF
	RET




;	---SQUIRT MICROCODE---
;
;
SQUIRT:	MOV	A,M
	OUT	CTCSR		;BANK SLCT
	INX	H
	MOV	A,M
	OUT	CTBFR		;SET CTLR BFR ADR
	INX	H
;
SQ1:	MOV	A,M
	ORA	A
	RZ			;RIF DONE
	INX	H		;INCR TBL ADR
	MOV	B,A		;B = COUNT
	RAL
	JC	SQ3		;JIF REPEAT
;
SQ2:	MOV	A,M
	OUT	CTDP		;OUTPUT CONTROL INFO
	INX	H
	DCR	B
	JNZ	SQ2
	JMP	SQ1		;DO NEXT STRING
;
SQ3:	ORA	A		;CLEAR CY
	RAR
	MOV	B,A		;B = COUNT
	MOV	A,M
	INX	H
SQ4:	OUT	CTDP		;OUTPUT REPEAT CONTROL INFO
	DCR	B
	JNZ	SQ4
	JMP	SQ1		;DO NEXT STRING




;	---READ COMMAND TABLE---
;
;
RTBL:	DB	10		;RETRY COUNT
	DB	4		;CMP BFR ENB
	DB	0EAH		;CMP BFR ADR
	DB	BANK0		;CNTL BANK
	DB	0CCH		;START ADDRESS
	DB	0EH		;STATUS MASK




;	---WRITE MICROCODE---
;
;
WRTCODE	EQU	$		;  CDC 		07-24-81
;
	DB	1		
	DB	0CCH		
	DB	2,40H		
	DB	41H		
	DB	RPT+16,40H	
	DB	RPT+10,6DH	
	DB	1,63H		
	DB	RPT+4,65H	
	DB	RPT+2,67H	
	DB	2,49H		
	DB	40H		
	DB	RPT+13,50H	
	DB	5,5BH		
	DB	0DDH		
	DB	5DH		
	DB	50H		
	DB	0FH		
	DB	0		





;	---READ MICROCODE---
;
;
RDCODE	EQU	$		;  CDC 		07-24-81
;
	DB	0		
	DB	0CCH		
	DB	2,40H		
	DB	41H		
	DB	RPT+16,40H	
	DB	RPT+10,6DH	
	DB	1,63H		
	DB	RPT+4,65H	
	DB	RPT+2,67H	
	DB	1,49H		
	DB	RPT+3,40H	
	DB	RPT+11,6DH	
	DB	4,63H		
	DB	0E7H		
	DB	67H		
	DB	0FH		
	DB	0		




;	---UNRECOVERABLE ERRORS---
;
;   UNRECOVERABLE ERRORS COME HERE TO PRINT
;   ERROR MESSAGES.
;
;
ERROR:	CALL	PRINT		;PRINT ERROR MSG
	CALL	CI		;WAIT FOR THE OPER
	IF	TEST		;IF WE ARE TESTING
	CPI	3		;CNTL-C ?
	CZ	TRAP		;YES, TRAP TO DEBUG
	ENDIF
	LXI	H,CRLF
	CALL	PRINT		;DO CR.LF
	JMP	LOOP		;RETRY BOOT




;	---PRINT MESSAGES---
;
;
PRINT:	MOV	A,M		;A = PRINT DATA
	INX	H		;POINT TO NEXT CHAR
	ORA	A
	RZ			;ZERO ENDS MSG
	MOV	C,A
	CALL	CO		;PRINT A CHAR
	JMP	PRINT




;	---CONSOLE INPUT---
;
;
CI:	IN	CRTS		;CRT STATUS
	ANI	CRTDA
	JZ	CI		;WAIT FOR INPUT CHAR
	IN	CRTD		;INPUT DATA
	ANI	7FH		;KILL PARITY BIT
	RET




;	---CONSOLE OUTPUT---
;
;
CO:	IN	CRTS		;CRT STATUS
	ANI	CRTBE
	JZ	CO		;WAIT FOR BFR EMPTY
	MOV	A,C
	OUT	CRTD		;OUTPUT DATA
	RET




;	---MESSAGES---
;
;
MSG1:	DB	BELL,CR,LF,'* Drive not Ready ',0
;
MSG2:	DB	BELL,CR,LF,'* Restore Failed ',0
;
MSG3:	DB	BELL,CR,LF,'* Read Failed ',0
;
CRLF:	DB	CR,LF,0




;	---STORAGE---
;
;
DMADR:	DS	2		;DMA ADDRESS
CYL:	DW	0		;CYLINDER ADDRESS
HEAD:	DB	0		;HEAD NUMBER
SECTOR:	DS	1		;SECTOR ADDRESS
SCNT:	DS	1		;SECTOR COUNT
RETRY:	DS	1		;RETRY COUNT
CTA:	DS	2		;COMMAND TABLE ADRESS




	END
