; Data_Mstr.asm - data publics for the master agent.

%IF (not(%*Isdef(%MaxErrorCount))) THEN (%Define(MaxErrorCount)(15))FI
%IF (not(%*Isdef(%MaxTimeOutCount))) THEN (%Define(MaxTimeOutCount)(10))FI
%IF (not(%*Isdef(%TimeOutTicks307))) THEN (%Define(TimeOutTicks307)(12))FI
%IF (not(%*Isdef(%TimeOutTicks1_8))) THEN (%Define(TimeOutTicks1_8)(8))FI
%IF (not(%*Isdef(%TimeOutTicks4_0))) THEN (%Define(TimeOutTicks4_0)(8))FI
%IF (not(%*Isdef(%TeleclusterTiming))) THEN
       (%Define(TeleclusterTiming)(7))FI
%IF (not(%*Isdef(%nRepollActive))) THEN (%Define(nRepollActive)(0))FI

%SET(wsTotal, 24)
%SET(nWsUserNum, 256)

%SET(nXBlk,24)
%SET(sXBlk,4096+64)
%SET(nXBlkSmall,24)
%SET(sXBlkSmall,64)
%SET(sioClock,24)

TRUE EQU 0FFh
FALSE EQU 0

; Size of Control Block Definitions

lxBlockHeaderSize EQU 36 ; 
lxBlockRqSize EQU 64  ;max size request block header that can fit in an XBlock

%' Current valid wsTypes
ngenCluster    EQU 7
ngen           EQU 8
ngenMaster     EQU 9
srpCpMaster    EQU 12
srpGpMaster    EQU 20

; ClusterConfig definitions:

standAlone     EQU 0
cluster        EQU 1
master         EQU 2

data SEGMENT PUBLIC 'DATA'

PUBLIC orgWsId
PUBLIC orgWsLocalUserNum
PUBLIC wsUserNumLast
PUBLIC nRepollActive

wsUserNumLast     DW %nWsUserNum-1
orgWsid           DW ?
orgWsLocalUserNum DW ?
nRepollActive     DB %nRepollActive

PUBLIC nXBlk, sXBlk, nXBlkSmall, sXBlkSmall, sXBlkHeader, sXBlkRqMax
PUBLIC nDct, sioClock
PUBLIC fSrpUp
PUBLIC MaxErrorCount
PUBLIC MaxTimeoutCount
PUBLIC TimeoutTicks307
PUBLIC TimeoutTicks1_8
PUBLIC TimeoutTicks4_0
PUBLIC TeleclusterTiming
PUBLIC fGoingDown
PUBLIC fHighSpeed
Public  rgfSrpClock, rgNoWsLine
PUBLIC pfEnableCluster, fEnableCluster

fSrpUp DB 0
rgfSrpClock LABEL BYTE
 fHighSpeed DB 0,0

sioClock DB %sioClock
fGoingDown DB 0
EVEN
 nDct  DW 0
rgNoWsLine  DW %wsTotal,%wsTotal
nXBlk  DW %nXBlk
sXBlk  DW %sXBlk
nXBlkSmall  DW %nXBlkSmall
sXBlkSmall  DW %sXBlkSmall
sXBlkHeader DW lxBlockHeaderSize
sXBlkRqMax  DW lxBlockRqSize

MaxErrorCount DB %MaxErrorCount
MaxTimeoutCount DB %MaxTimeoutCount
TimeoutTicks307 DW %TimeoutTicks307
TimeoutTicks1_8 DW %TimeoutTicks1_8
TimeoutTicks4_0 DW %TimeoutTicks4_0
TeleclusterTiming DW %TeleclusterTiming

pfEnableCluster DD ?	; Gets set to OS fEnableCluster.
fEnableCluster DB FALSE

Public	pCdt, pStat, pDiskStat, nmbHeap
EVEN
pCdt			DD ?
pStat			DD ?
pDiskStat		DD ?
nmbHeap		LABEL BYTE

data ENDS
END
; 2/23/90 by JA Created from sysgen.mdf.
; 7/30/90 by JM obsolete nSectorPerXblock.
; 8/29/90 by JA Config, NetServerData, vf to Data_All.
; 3/11/91 by JA Removed wMySlotBits.
; 5/29/91 by BA Increase timeout ticks from 4 to 8 for 1.8 and 3.68.
; 3/30/93 by JA Added cbLineTable, mpiLinebSlot.
; 03/31/93 by JA recant above.
; 07/13/93 by JF Make XBlock header 4 bytes bigger for cache.