 
; MstrAgntSubs_all.asm
; MstrAgent subroutines
$MOD386

%Set(LogRq,0)
%Set(Debug,0)
%IF (not(%*Isdef(%CTOSp))) THEN (%Define(CTOSp)(0))FI
%IF (not(%*Isdef(%MF))) THEN (%Define(MF)(0))FI
%Set(Master,1)
%INCLUDE(:f1:mstrequ.idf)
%INCLUDE(:f1:ServerHwEqu.edf)

;*****************************************************************************
;  PUBLIC PROCEDURES
;*****************************************************************************
PUBLIC MapWsUserNum
PUBLIC ProcessWsRq
PUBLIC ReturnResponse
PUBLIC GetDAINumber

;*****************************************************************************
;  EXTERNAL PROCEDURES
;*****************************************************************************
EXTRN Crash:FAR
EXTRN GetpStructure:FAR
EXTRN ReleaseXBlock:FAR
EXTRN Request:FAR
EXTRN SendXBlock:FAR
EXTRN ServeAgentRequests:FAR

;*****************************************************************************
;  EXTERNAL DATA
;*****************************************************************************
DGroup GROUP DATA
Data SEGMENT PUBLIC 'DATA'

EXTRN exchAgent:WORD
EXTRN fGoingDown:BYTE
EXTRN nDct:WORD
EXTRN oRgDCT:WORD
EXTRN nChgUserNumRq:WORD
EXTRN nUserNumAllocated:WORD
EXTRN pStat:DWORD							;DHG... in Stat1 of Sysgen
nAvailSmallX	EQU WORD PTR 44
nMinSmallX		EQU WORD PTR 42
nWaitSmallX		EQU WORD PTR 46
nWaitSmallXLow 	EQU WORD PTR nWaitSmallX
nWaitSmallXHigh	EQU WORD PTR nWaitSmallX+2	;...DHG
EXTRN nXBlocksSmallFree:BYTE
EXTRN nXBlockSmallWaits:DWORD
      nXBlockSmallWaitsLow EQU WORD PTR nXBlockSmallWaits
      nXBlockSmallWaitsHigh EQU WORD PTR nXBlockSmallWaits+2
EXTRN nParDesc:WORD
EXTRN nTerminationRq:WORD
EXTRN orgWsId:WORD
EXTRN orgWsLocalUserNum:WORD
EXTRN pRgTerminationRq:DWORD
EXTRN pRgChgUserNumRq:DWORD
EXTRN pSysTime:DWORD
EXTRN rqDelayDisc:WORD
EXTRN saFreeListSmall:WORD
EXTRN sXBlk:WORD
EXTRN sXBlkSmall:WORD
EXTRN wsUserNumLast:WORD
EXTRN nUserNumOffset:WORD

%IF (%LogRq) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;*****************************************************************************
; VARIABLES FOR DEBUGGING
;*****************************************************************************
PUBLIC logRqBuffer, logRqBufferIndex
logRqEntrySize 		EQU 64
logRqBufferSize 	EQU 20
logRqBufferIndexMax EQU (logRqBufferSize-1)*logRqEntrySize
logRqBufferIndex 	DW logRqBufferIndexMax		;so we will start at zero
logRqBuffer 		LABEL WORD	DB  logRqEntrySize*logRqBufferSize DUP(0)
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
PUBLIC fCrashIfXBlockTooSmall
fCrashIfXBlockTooSmall DB 0FFh
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

Data ENDS

MstrAgent_Subs SEGMENT PUBLIC 'CODE'
	ASSUME CS: MstrAgent_Subs, DS: Dgroup

MapWsUserNum PROC FAR
PUBLIC MapWsUserNum
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
;	MapWsUserNum: PROCEDURE(dctUserNum, remoteUserNum) WORD
; dctUserNum is the user number from the dct -- a fixed number from 1 to ndct.
; remoteUserNum is the user number from the original request block.
; Map this pair to a cluster user number. Cluster user numbers start at
; nParDesc, since this is one more than the last user number used by the
; master. There are wsUserNumLast user numbers assigned to cluster 
; workstations. A workstation could use more than one user number if it is
; running a multi-partition OS. The ith entry in the array rgWsId contains 
; zero if not used or a dctUserNum from the dct that is currently using the 
; local userNum i+nParDesc. rgWsLocalUserNum (a misnomer!) is a parallel
; table.  Each entry contains the remoteUserNum from the workstation that is
; currently using the local userNum i+nParDesc.
;       | dctUserNum    | +8
;       | remoteUserNum | +6
;       | CS            | +4
;       | IP            | +2
;       | BP            | <--BP
;*****************************************************************************
	MOV  DI,orgWsId					;DI = offset for SCASB
	MOV  SI,orgWsLocalUserNum
	MOV  AX,[BP+8]					;AX = dctUserNum
	MOV  DX,[BP+6]					;DX = remote UserNum
	MOV  CX,wsUserNumLast			;CX = number of ws user numbers
	PUSH DS
	POP  ES
ASSUME ES:DGroup
	CLD
FindDctUserNum:
	REPNZ SCASW
	JNE  DctUserNumNotFound
; Continue if we found an entry in rgWsId that matches dctUserNum. See if
; the corresponding entry in rgWsLocalUserNum = remoteUserNum.
	MOV  BX,DI						;BX points to word following match
	SUB  BX,orgWsId					;- OFFSET DGROUP: rgWsId
	DEC  BX
	DEC  BX
	CMP  [BX][SI],DX				; rgWsLocalUserNum
	JE   FoundUserNum
	JMP  FindDctUserNum
DctUserNumNotFound:
; We did not find a match, so we must assign a new user number. See if rgWsId
; has a zero entry.
	MOV  DI,orgWsId					;DI = offset for SCASB
	MOV  CX,wsUserNumLast			;CX = number of ws user numbers
	XOR  AX,AX
	REPNZ SCASW
	JNE  NoFreeUserNum
; We found a free user number. Set BX to word index. Then save dctUserNum
; and remoteUserNum.
	MOV  BX,DI						;BX points to word following match
	DEC  BX
	DEC  BX
	MOV  AX,[BP+8]					;AX = dctUserNum
	MOV  [BX],AX					;Save dctUserNum in rgWsId
	SUB  BX,orgWsId					;- OFFSET DGROUP: rgWsId
	MOV  [BX][SI],DX				;Save remoteUserNum in rgWsLocalUserNum
	INC  nUserNumAllocated
	JMP  SHORT FoundUserNum
NoFreeUserNum:
	MOV  AX,0FFFFh
	JMP  SHORT MapWsUserNumRet
FoundUserNum:
	SHR  BX,1
	ADD  BX,nParDesc
	ADD  BX,nUserNumOffset			; CDT offset too	
	XCHG AX,BX
MapWsUserNumRet:
	POP  BP
	RET  4
MapWsUserNum ENDP

ProcessWsRq PROC FAR
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
;	ProcessWsRq: PROCEDURE(saXBlock)
; This procedure is called by the ClusterReceiver process to process a 
; request that has arrived from a workstation.
; This request is in an XBlock that is in the list dctSaXBlockIn
;       | saXBlock | +6
;       | CS       | +4
;       | IP       | +2
;       | BP       | <--BP
;*****************************************************************************
	MOV  ES,[BP+6]					;ES points to XBlock
ASSUME ES:Nothing
	MOV  BX,ES:[xbODct]				;BX points to dct
	CMP  WORD PTR ES:[xbRqCode],rcGetDateTime
	JE   HandleGetDateTime

SaveResponseExchange:
; Save the response exchange of the original request block in the XBlock
; header. SendXBlock will restore it before returning the request. Do this
; here in case we end up at errorReturn.
	MOV  AX,ES:[xbRqRespExch]
	MOV  ES:[xbRespExch],AX
	XOR  DX,DX
	MOV  DL,dctuserNumber[BX]		;Set up the stack for call to MapWsUserNum
	PUSH DX							;dctUserNum
	PUSH ES:[xbRqUserNum]			;remoteUserNum
	MOV  AX,ES:[xbRqCode]
	CMP  AX,rcLogRemote
	JE   HandleLogRemote
	CMP  AX,rcRemakeFh
	JE   HandleRemakeFh
	CMP  AX,rcGetUserStatus
	JE   HandleGetUserStatus

; Search the table of usernumber requests to see if this is a change user
; number request.
	MOV  CX,nChgUserNumRq
	LES  DI,pRgChgUserNumRq
ASSUME ES:Nothing
	CLD
	REPNZ SCASW
	JE   HandleChangeUserNum

MapUserNumber:
	CALL MapWsUserNum				;AX = mapped user number on return
	XCHG DX,AX						;DX = mapped user number
; Pick up the variables we need while DS points to DGroup.
	MOV  AX,sXBlk
; AX = size of XBlock as specified in config.sys.  This includes 64 bytes
; for the request block header, but does not include the XBlock header
; (32 bytes + 2 bytes for xbcbDataSent).
	PUSH DS							;Save address of DGroup
	PUSH AX							;sXblk for TestBigXBlock below
	MOV  AX,sXBlkSmall
ASSUME ES:Nothing
ASSUME DS:Nothing
	MOV  DS,[BP+6]					; DS points to XBLK
; DS points to the XBlock. 
	MOV  DS:[xbRqUserNum],DX		;Store mapped userNum in request block
	INC  DX
	JZ   NoAvailUserNum
	AND  BYTE PTR DS:[xbFlags],xbNotClusterTerm
	CMP  WORD PTR DS:[xbRqCode],rcResetAgent
	JE   TerminateOldCluster

CalculateSize:
;Calculate the total size of the request block.
	MOV  DX,DS:[xbRqNReqPbCb]		;DL = nReqPbCb, DH = nRespPbCb
	MOV  BX,12
	ADD  BL,DS:[xbRq]				;BX = sCntlInfo + 12
	JC   XBufOverflow
	MOV  SI,BX						;BX,SI have offset of first request pb/cb 
	XOR  CX,CX
	MOV  DI,CX						;DI will be size of request data
	MOV  CL,DL						;CX = nReqPbCb
	CMP  CL,20
	JA   XBufOverflow
; Calculate the size of the request data by adding up the request cb
	JCXZ RequestDataSizeCalculated

CalculateRequestDataSize:
	ADD  DI,DS:xbRq[BX+4]			;Add next cb
	JC   XBufOverflow
	INC  DI							;round to even number of bytes
	JZ   XBufOverflow
	AND  DI,0FFFEh
	ADD  BX,6						;Index next pb/cb
	LOOP CalculateRequestDataSize

RequestDataSizeCalculated:
PUBLIC RequestDataSizeCalculated
; DI contains the size of the request data rounded to even number.
; BX has offset of the first response pb/cb pair from xbRq.
; SI has offset of the first request pb/cb pair from xbRq.
; Save offset of first response pb/cb pair so that, when we ship request back,
; we will be able to recalculate the offsets from xbCbDataSent.
	MOV  DS:[xboResponsePb],BL
; Calculate the size of the response data.
	MOV  CL,DH						;CX = nRespPbCb
	CMP  CL,20
	JA   XBufOverflow
	XOR  DX,DX						;DX will be size of response data
	JCXZ ResponseDataSizeCalculated
CalculateResponseDataSize:
	ADD  DX,DS:xbRq[BX+4]			;Add next cb
	JC   XBufOverflow
	INC  DX							;round to even number of bytes
	JZ   XBufOverflow
	AND  DL,0FEh
	ADD  BX,6						;Index next pb/cb
	LOOP CalculateResponseDataSize

ResponseDataSizeCalculated:
PUBLIC ResponseDataSizeCalculated
; Set xbCbData to zero. When it's time to ship the response back, this field
; will tell us if we need to move response data up over the request data.
; Assume we don't have to move.
;
	MOV  WORD PTR DS:[xbCbData],CX
	INC  BX						;Request data starts at even offset
	AND  BL,0FEh
	LEA  CX,2[BX]				;size of rq header +2 for cbDataSent
	ADD  CX,DI					;+ size of request data
	JC   XBufOverflow
	ADD  CX,DX					;+ size of response data
	JC   XBufOverflow

; Top of stack has sXBlock (size of xblock not counting header & xbCbDataSent) 
; AX contains the size of a small request block.
; BX is the offset of the first byte of request data from xbRq (rq header).
; CX is the total size required for the request, +2 for cbDataSent.
; DX contains the size of the response data rounded to even number of bytes.
; DI contains the size of the request data rounded to even number of bytes.
; SI is the offset of the first pb/cb pair from xbRq.

	CLD								;Set up for forward move
	CMP  CX,AX
	POP  AX							;sXBlk pushed above
	JBE  SmallXBlock				;It will fit in small XBlock
	CMP  CX,AX
	JA   XBufTooSmall

BigXBlock:
PUBLIC BigXBlock
; The request will not fit in a small XBlock or there are no small XBlocks.
	CMP  WORD PTR DS:[xbRqCode],rcRead
	JE   HandleReadRequest
; Since we know the size of the request to ship back, save xbCbDataSent.
	LEA  AX,2[BX]						;plus 2 for xbCbDataSent
	ADD  AX,DX							;AX=size of hdr+size of response data
	MOV  DS:[xbCbDataSent],AX			
	ADD  BX,xbRq
; BX is offset of request data from beginning of the XBlock.
; Use this for the request pointers.
	OR   DI,DI
	JZ   NoRequestData
	CMP  DX,DI							;Is resp data bigger than req data?
	JA   ResponseDataBigger				;Yes

; There is request data, and it is bigger than the response data. The request
; data comes before the response data. This means that when we are ready to
; ship the request back, we must move the response data (if any) up next to
; the request block header. Save the size of the response data in xbCbData.
; When it's time to ship the request, this is the size of data that we must
; move up over the request data. 
;
	MOV  DS:[xbCbData],DX				;Save size of response data to move

NoRequestData:
; Come here if there is no request data. This does not necessarily mean that
; there are no request pb/cb pairs, and we will have to step through them.
; xbCbData is zero, so we will not have to do a move before we ship out the
; request. Save the offset of the request data from XBlock in xboffset.
; When it's time to move the response data, this value 
; will be the offset of the destination. 

	MOV  DS:[xboffset],BL
	XOR  CX,CX
	MOV  CL,DS:[xbRqNReqPbCb]			;CX = nReqPbCb
	JCXZ ReqPointersSetup
SetupReqPointers:
	MOV  DS:xbRq[SI],BX					;Store ra
	MOV  DS:xbRq+2[SI],DS				;Store sa
	ADD  BX,DS:xbRq+4[SI]				;Increment ra by cb
	INC  BX
	AND  BL,0FEh						;Round to word boundary
	ADD  SI,6							;Increment offset of pb/cb pair
	LOOP SetupReqPointers
ReqPointersSetup:
	MOV  CL,DS:[xbRqNRespPbCb]			;CX = nRespPbCb
	JCXZ RespPointersSetup
; SI is the offset of the first response pb/cb pair
; BX is the offset from XBlock of the next byte of data following the
; request data. Save this offset in xbStation. When it's time to
; move the response data over the request data, this will be the offset of the
; source.
	MOV  DS:[xbStation],BX
; Now we Set the response pointers.

SetupRespPointers:
	MOV  DS:xbRq[SI],BX					;Store ra
	MOV  DS:xbRq+2[SI],DS				;Store sa
	MOV  DX,DS:xbRq+4[SI]
	OR   DX,DX
	JZ   CalcRespSize
	MOV  WORD PTR DS:[BX], 0			;So handles, cb's etc. are clear
CalcRespSize:
	ADD  BX,DX
	INC  BX
	AND  BL,0FEh						;Round to word boundary
	ADD  SI,6
	LOOP SetupRespPointers
RespPointersSetup:
PUBLIC RespPointersSetup
	JMP  PrepareToIssueRequest

HandleReadRequest:
PUBLIC HandleReadRequest
; A read request is handled specially. The Read request has no request data
; and two response pb/cb pairs. The first response data is the data read, and
; the second response data is the length of the data actually read. We want to
; reverse the order so that the data read is last in the XBlock. Then, when we
; ship the request back, we can ship back only the data actually read. We will
; Set up the pointers so that the ra of each pointer is an offset from
; the beginning of the XBlock. When we ship the response back to the 
; workstation, we will need to calculate the offsets.

; Set up psDataRet to point to the first byte of response data. 
	MOV  WORD PTR DS:[xbRqPsDataRet],xbRqsData
	MOV  DS:[xbRqPsDataRet+2],DS
; Clear sDataRet so ReadResponse reports reasonable size in case ercBadFh etc.
	MOV  WORD PTR DS:[xbRqsData], 0

; Set up pBufferRet to point to the data area, which just follows sDataRet.
	MOV  WORD PTR DS:xbRqPBufferRet,xbRqData
	MOV  DS:[xbRqPBufferRet+2],DS
	JMP  PrepareToIssueRequest


NoSmallXBlocks:
	STI									;Enable
	MOV  DS,[BP+6]						;DS points to XBlock
ASSUME DS:Nothing
	JMP  BigXBlock

ResponseDataBigger:
PUBLIC ResponseDataBigger
; If the response data is bigger than the request data, we will move the
; request data down to leave room for the response data next to the request
; block header. Then, when we ship the request back, the response data will
; be where we want it. We win on requests with small request data and big
; response data such as GetVHB, QueryDCB, ReadDirSector, and GetDirStatus. 
;
	PUSH SI							;Save offset of 1st request pb/cb pair
	PUSH DI							;Save size of request data
	MOV  CX,DI						;CX = size of request data
	SHR  CX,1						;convert byte count to word count
	PUSH DS
	POP  ES
ASSUME ES:Nothing
	MOV  SI,BX						
; SI is offset of request data (source) from start of XBlock
	MOV  DI,SI						;Add size of response data to leave room
	ADD  DI,DX						;for response data
; Move the request data down, leaving room for the response data. We don't
; have to worry about overlap since response data is bigger than request data.
	REPNZ MOVSW						;Move request data down.
	POP  DI							;Restore size of request data
	POP  SI							;Restore offset of 1st request pb/cb pair
	CALL ResponseDataFirst
	JMP  PrepareToIssueRequest

SmallXBlock:
PUBLIC SmallXBlock
; The request will fit in a small XBlock. See if we have a small XBlock.
; BX is the offset of the first byte of request data from xbRq (rq header).
; CX is the total size required for the request, +2 for cbDataSent.
; DX contains the size of the response data rounded to even number of bytes.
; DI contains the size of the request data rounded to even number of bytes.
; SI is the offset of the first pb/cb pair from xbRq.
	POP  DS							;DS points to DGroup
ASSUME DS:DGroup
	PUSH DS
	CLI								;Disable
	MOV  AX,saFreeListSmall
	OR   AX,AX
	JNZ  SmallAvailable
; There is no small XBlock available.
	ADD  nXBlockSmallWaitsLow,1
	ADC  nXBlockSmallWaitsHigh,AX
	PUSH SI
	LES  SI, pStat
	MOV  AX,nXBlockSmallWaitsLow	;DHG... update stats1 in sysgen
	MOV  ES:nWaitSmallXLow[SI],AX
	MOV  AX,nXBlockSmallWaitsHigh
	MOV  ES:nWaitSmallXHigh[SI],AX	;...DHG
	POP  SI
	JMP  NoSmallXBlocks

SmallAvailable:
	DEC  nXBlocksSmallFree
	MOV  AH,0					;DHG...
	MOV  AL,nXBlocksSmallFree	;nAvailSmallX = nAvailSmallX -1
	PUSH SI
	LES  SI, pStat
	MOV  ES:nAvailSmallX[SI],AX
	CMP  AX,ES:nMinSmallX[SI]	;IF nAvailSmallX < nMinSmallX THEN
	JG   @1						;
	MOV  ES:nMinSmallX[SI],AX	; nMinSmallX = nAvailSmallX
@1: POP  SI						;...DHG

	MOV  ES,saFreeListSmall		;ES points to small XBlock
ASSUME ES:Nothing
; Zero xbCbData because we will not have to move any response data when we
; ship the request.
	XOR  AX,AX							
	MOV  ES:[xbCbData],AX
	XCHG AX,WORD PTR ES:[xbSaLink]
	MOV  saFreeListSmall,AX			;Unchain small XBlock	
	MOV  DS,[BP+6]					;DS points to big XBlock
ASSUME DS:Nothing
; ES points to small XBlock, DS points to big XBlock. 
; Move pointer to dct to new XBlock.
	MOV  AX,DS:[xbStatus]			;AX has xblock status flags
	MOV  ES:[xbStatus],AL			;only move status not flags
	MOV  AX,DS:[xbODct]				;AX points to dct that owns big XBlock
	MOV  ES:[xbODct],AX             
	POP  DS							;DS points to DGroup
ASSUME DS:DGroup
	PUSH DS
	PUSH SI							;Save offset of 1st pb/cb pair
	XCHG SI,AX						;SI points to dct that owns big XBlock
; Chain small XBlock onto dctSaXBlockIn.
	MOV  AX,dctSaXBlockIn[SI]
	MOV  ES:[xbSaLink],AX
	MOV  dctSaXBlockIn[SI],ES
	STI				;Enable
; Increment the number of small request blocks owned by this dct.
	INC  dctNOutstandingSmallRq[SI]
	MOV  DS,[BP+6]					;DS points to big XBlock
ASSUME DS:Nothing

; Since we know the size of the request to ship back, put this information in 
; the new XBlock.
	LEA  AX,2[BX]					;plus 2 for xbCbDataSent
	ADD  AX,DX						;AX=size of hdr+size of response data
	MOV  ES:[xbCbDataSent],AX		;Save in xbCbDataSent
; Move the request block header from the big XBlock to the small XBlock. We
; move from xbRq (we skip station, frame, and cbDataSent).

	XCHG AX,DI						;Save size of request data in AX
	MOV  CX,BX						;CX = size of request block header
	SHR  CX,1						;Convert byte count to word count
	MOV  SI,xbRq					;SI and DI are both offsets of
	MOV  DI,SI						;first byte of data to move
	REPNZ MOVSW	
; Now we have moved the request block header from the big XBlock to the small
; XBlock. Increment DI by the size of the response data. This leaves room for
; the response data right next to the request block header so that it will be
; contiguous when we ship it back. Then we move the request data into the area
; following the response data

	ADD  DI,DX						;Add size of response data
	MOV  CX,AX						;CX = size of request data
	SHR  CX,1						;Convert byte count to word count
	REPNZ MOVSW						;Move the request data
	XCHG AX,DI						;Restore size of request data
	POP  SI							;Restore offset of 1st pb/cb pair
; Now Set up pointers in the new request block so that the response data comes
; first.
	PUSH ES							;Save sa of small XBlock to issue request
	PUSH DS							;Save pointer to big XBlock to free
	MOV  AX,ES
	MOV  DS,AX						;DS points to small XBlock
ASSUME DS:Nothing
;
;       | BP             | <--BP
;       | DGroup         | <--BP-2
;       | small XBlock   | <--BP-4
;       | big XBlock     | <--BP-6  This is parameter to ReleaseXBlock

	ADD  BX,xbRq
; BX is offset of response data from beginning of the XBlock.  
; The response data will be right after the request block header in this case.

	CALL ResponseDataFirst
; Now free the big XBlock.
	MOV  DS,[BP-2]					;Restore DS to point to DGroup
	MOV  ES,[BP-6]					;ES points to big XBlock to unchain
ASSUME DS:DGroup, ES:Nothing
	CALL FAR PTR UnchainXBlock		;Unchain big XBlock from saXBlockIn
	CALL ReleaseXBlock				;and put it back on the free list
	POP  DS							;DS points to small XBlock
ASSUME DS:Nothing

PrepareToIssueRequest:
PUBLIC PrepareToIssueRequest
;       | BP       | <--BP
;       | DGroup   | <--BP-2
; DS points to XBlock that contains request to send.
;
; Save the response exchange of the original request block in the XBlock
; header. We must restore it before we return the request. Set the response
; exchange to the Agent exchange.
	MOV  AX,DS						;AX has sa of new XBlock
	MOV  ES,AX						;ES points to new XBlock
	POP  DS							;Restore DS to point to DGroup
ASSUME DS:DGroup, ES:Nothing
	MOV  AX,exchAgent
	XCHG AX,ES:[xbRqRespExch]
	MOV  ES:[xbRespExch],AX
; DS points to DGroup.
; ES contains address of XBlock that contains request.
; See if this is a GetDateTime request. If so, we can handle it here.
	CMP  WORD PTR ES:[xbRqCode],rcGetDateTime
	JNE  IssueRequest
; It is a GetDateTime request.
	CMP  fGoingDown,0FFh
	JNE  HandleDateTime
; The cluster is going down, so return ercMasterGoingDown and the number of
; seconds until the cluster goes down.
	MOV  WORD PTR ES:[xbRqErcRet],ercMasterGoingDown
	MOV  BX,10
	XOR  DX,DX
	MOV  AX,rqDelayDisc				;AX = msec100 left
	DIV  BX							;AX = seconds left
	XOR  BX,BX
	JMP  SHORT SysTimeOk
HandleDateTime:
	MOV  DX, ES
	LES  BX, pSysTime
	CLI								;Disable
	MOV  AX,ES:[BX+2]				;AX = sysTime.seconds
	MOV  CX,ES:[BX+6]				;CX = sysTime.cksm
	MOV  BX,ES:[BX+4]				;BX = sysTime.dayTimes2
	STI								;Enable
	MOV  ES, DX
	OR   BX,BX						
	JZ   InvalidSysTime
	ADD  CX,BX
	ADD  CX,AX
	CMP  CX,magicT
	JE   SysTimeOk
InvalidSysTime:
	XOR  AX,AX
	XOR  BX,BX
SysTimeOk:
	MOV  ES:[xbRqDateTime],AX
	MOV  ES:[xbRqDateTime+2],BX
; Set up for ReturnResponse
	PUSH ES
	CALL FAR PTR ReturnResponse
	JMP  ProcessWsRqRet

PUBLIC IssueRequest
IssueRequest:
	PUSH ES							;Save sa of XBlock in case Request fails
	PUSH ES							;Push sa of XBlock for Request (pRq.sa)
	MOV  BX,xbRq
	PUSH BX							;pRq.ra
%IF (%LogRq) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;*****************************************************************************
; For debugging, log this request. Prepare DI with index of log entry.
;*****************************************************************************
	MOV  DI,logRqBufferIndex
	ADD  DI,logRqEntrySize
	CMP  DI,logRqBufferIndexMax
	JBE  logRqBufferIndexOk
	MOV  DI,0
logRqBufferIndexOk:
	MOV  logRqBufferIndex,DI
	PUSH DS
	PUSH DS
	POP  ES
	MOV  DS,AX
ASSUME DS:Nothing, ES:DGroup
	LEA  DI,logRqBuffer[DI]
	MOV  SI,xbRq
	CLD
	MOV  CX,32
	REP  MOVSW
	POP  DS
ASSUME DS:DGroup, ES:Nothing
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

	PUSH 0FFh						;fFromWs
	CALL ServeAgentRequests			;Returns (erc := Request) if not AgentRq
	POP  DX							;DX is sa of XBlock that contains request
	OR   AX,AX
	JZ   ProcessWsRqRet
ProcessWsRqError:
%IF (%LogRq) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;***For debugging, log this erc***********************************************
	MOV  DI,logRqBufferIndex
	MOV  logRqBuffer+8[DI],AX
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; If this request did not get issued, return it to the workstation.
	PUSH DS							;Save address of DGroup
	MOV  DS,DX						;DS points to XBlock
ASSUME DS:Nothing

ErrorReturn:
PUBLIC ErrorReturn
; DS points to the XBlock.
	MOV  DS:[xbRqErcRet],AX			;Store erc in request block
	XOR  CX,CX
	MOV  CL,DS:[xbRqNRespPbCb]
; Calculate the offset of the first response pb/cb.
	MOV  AL,6
	MUL  BYTE PTR DS:[xbRqNReqPbCb]	;AX = 6 * nReqPbCb
	XCHG BX,AX						;BX = 6 * nReqPbCb
	ADD  BX,12						;BX = 6 * nReqPbCb + 12
	ADD  BL,DS:[xbRq]				;BX = 6 * nReqPbCb + 12 + sCntlInfo
	XOR  AX,AX
	JCXZ ResponsePairsZeroed
ZeroResponsePairs:
	MOV  xbRq[BX],AX				;Zero ra of pb/cb
	MOV  xbRq+2[BX],AX				;Zero sa of pb/cb
	MOV  xbRq+4[BX],AX				;Zero cb of pb/cb
	ADD  BX,6
	LOOP ZeroResponsePairs
ResponsePairsZeroed:
; BX is now the offset of the first byte of request data, or the size of the
; request block header. The size of the request returned will be the size of
; the request block header plus 2 for cbDataSent.
	INC  BX
	AND  BL,0FEh					;Round to even number of bytes
	INC  BX
	INC  BX
	MOV  DS:[xbCbDataSent],BX
	INC  BX
	INC  BX
	MOV  DS:[xbCbData],BX
	PUSH DS
	POP  ES							;ES points to XBlock
	POP  DS							;Restore pointer to DGroup
ASSUME DS:DGroup, ES:Nothing
	CALL SendXBlock
ProcessWsRqRet:
	POP  BP
	RET  2
XBufOverflow:
	POP  AX							;sXBlk pushed above
	JMP  XBufTooSmall

; The request will not fit in a big XBlock.
XBufTooSmall:
	MOV  AX,ercXBufTooSmall
%IF (%Debug) THEN (;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
	PUSH DS
	PUSH AX
	MOV  AX, DGroup
	MOV  DS, AX
ASSUME DS:DGroup
	CMP  fCrashIfXBlockTooSmall,0FFh
	POP  AX
	POP  DS
ASSUME DS:Nothing
	JNE  TooSmallOk
	PUSH AX
	CALL Crash
TooSmallOk:
)FI ;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	JMP  ErrorReturn

VALIDATETerminationRqCode PROC NEAR
	MOV		AX,DS:[xbRqRgTermRq+SI] 	; get termrq to test
	PUSH	CX							; save count of requests
	MOV		CX,DGROUP
	MOV		ES,CX
ASSUME ES:DGroup
	MOV		CX,nTerminationRq			; number of termination Rqs
	LES		DI,pRgTerminationRq			; ES:DI	start of table
ASSUME ES:Nothing
	REPNZ SCASW							; see if contents of AX in table
	JCXZ	NotValidRq					; this one not valid try next
	POP		CX
	RET									; got a good one fill out request
NotValidRq:
	POP		CX
	DEC  WORD PTR DS:[xbRqNTermRqCode] 	; count of rqs to wait on
	INC  SI
	INC  SI								;SI indexes next termRqCode
	LOOP VALIDATEterminationRqCode
	RET
VALIDATETerminationRqCode ENDP
HandleGetDateTime:
	CMP  dctRevisionLevel[BX],91h
	JB   SaveResponseExchange
; This is a GetDateTime request from a workstation that records statistics and
; sends them to us on the back of each Get DT request. Save the statistics in
; the dct.
	PUSH ES							;Save pointer to XBlock
	PUSH DS							;Save pointer to DGroup
	PUSH ES
	POP  DS
ASSUME DS:Nothing
	MOV  SI,xbrqPsDataRet
; DS:SI point to Ws statistics in XBlock that follow GetDateTime request.
	PUSH SS
	POP  ES
ASSUME ES:DGroup
	LEA  DI,dctWsStats[BX]			; ES:DI point to Ws statistics in dct.
	MOV  CX,sizeWsStats/2
	REPNZ MOVSW
	POP  DS							;Restore pointer to DGroup
	POP  ES							;Restore pointer to XBlock
ASSUME DS:DGroup, ES:Nothing
	JMP  SaveResponseExchange

HandleLogRemote:
; LogRemote from cluster workstation needs generic log info "line, wsId"
; Insert the bytes directly into the 1st pbcb data which follows rqHeader.
	MOV  CL,ES:[xbStation]
	MOV  ES:[xbRq+18+6+6+9],CL		; sRqHeader+2pbcb+ibToId
	MOV  CL,dctlogicalLineNumber[BX]
	MOV  ES:[xbRq+18+6+6+8],CL		; sRqHeader+2pbcb+ibToLine
; line is fixed up in FileLog.plm with correct CP offset.
	JMP  MapUserNumber

HandleRemakeFh:
	PUSH DX							;dctUserNum
	PUSH ES:[xbRqRemakeUsernumFh]	;rqRemakeFh.userNumFh
	CALL MapWsUserNum				;AX = mapped user number on return
	MOV  ES,[BP+6]					;ES points to XBlock
ASSUME ES:Nothing
	CMP  AX,1						;IF userNumMapped = 0 (no userNum avail)
	SBB  AX,0						; THEN userNumMapped=0FFFFh;
	MOV  ES:[xbRqRemakeUsernumFh],AX;Store mapped user number in request
	JMP  MapUserNumber

HandleGetUserStatus:
	PUSH DX							;dctUserNum
	PUSH ES:[xbRqUserNum]			;remoteUserNum
	JMP  MapUserNumRq

HandleChangeUserNum:
PUBLIC HandleChangeUserNum
; This is a change user number request. Call MapWsUserNum to map the user
; number of the primary partition of this workstation. Then Set rq.fh to the
; mapped user number.
	PUSH DX							;dctUserNum
	MOV  AX,1
	PUSH AX							;remoteUserNum = 1
MapUserNumRq:
	CALL MapWsUserNum				;AX = mapped user number on return
	MOV  ES,[BP+6]					;ES points to XBlock
ASSUME ES:Nothing
	MOV  ES:[xbRqFh],AX				;Store mapped user number in request
	JMP  MapUserNumber

NoAvailUserNum:
	POP  AX										;sXBlk pushed above
	MOV  AX,ercNoAvailUserNum
	JMP  ErrorReturn


PUBLIC TerminateOldCluster
TerminateOldCluster:
; This is a termination request from a CTOS 2.0 cluster with a list of
; termination request codes inside. The new scheme for remote termination
; is to let termination do the job - we ignore the imbedded list of rq
; codes and send a RemoteTermination request to termination who will
; send out the local list of termination requests synchronously.
	OR   BYTE PTR DS:[xbFlags],xbClusterTerm ;change rqCode back on resp
	MOV  DS:WORD PTR [xbRqCode],rcRemoteTermination
	JMP  CalculateSize
	
ProcessWsRq ENDP

ResponseDataFirst PROC NEAR
ASSUME DS:Nothing
PUBLIC ResponseDataFirst
;*****************************************************************************
; Set up the pointers in the pb/cb pairs in the request so that the response
; data comes first and the request data comes last in the XBlock. We will Set
; up the pointers so that the ra of each pointer is an offset from
; xbCbDataSent. This works because the size of the XBlock header is 34 bytes.
; If we add two to the sa of the XBlock, we will point to xbCbDataSent. Then,
; when we ship the response back to the workstation, the offsets will already
; be Set up.
; DS points to the XBlock.
; BX is offset of response data from start of XBlock (only because we
;    reversed the order of request data and response data.  The response data
;    will come right after the header).
; DI contains the size of the request data rounded to even number of bytes.
; DX contains the size of the response data rounded to even number of bytes.
; SI is the offset of the first pb/cb pair from xbRq.
; on return, registers are as above except for SI
;*****************************************************************************
ASSUME ES:Nothing
	push bx							;Save offset of response data
; Add size of response data to BX. This makes BX the offset of the first byte
; of request data. The request arrives with the request data next to the
; request block header, but we are reversing the order.
	ADD  BX,DX						;Add size of response data
	XOR  CX,CX
	MOV  CL,DS:[xbRqNReqPbCb]		;CX = nReqPbCb
	JCXZ ReqPointersSetupLast
SetupReqPointersLast:
	MOV  DS:xbRq[SI],BX				;Store ra
	MOV  DS:xbRq+2[SI],DS			;Store sa
	ADD  BX,DS:xbRq+4[SI]			;Increment ra by cb
	INC  BX
	AND  BL,0FEh					;Round to word boundary
	ADD  SI,6						;Increment offset of pb/cb pair
	LOOP SetupReqPointersLast
ReqPointersSetupLast:
; SI is the offset of the first response pb/cb pair
; Set BX to the offset of the first byte of response data from xbRq.
; Save offset of first response pb/cb pair so that, when we ship request back,
; we will be able to recalculate the offsets from xbCbDataSent.
	MOV  BX,SI
	MOV  DS:[xboResponsePb],BL
	pop  bx							;Restore offset of response data
	MOV  CL,DS:[xbRqNRespPbCb]		;CL = nRespPbCb
	JCXZ RespPointersSetupFirst
	push bx
SetupRespPointersFirst:
	MOV  DS:xbRq[SI],BX				;Store ra
	MOV  DS:xbRq+2[SI],DS			;Store sa
	MOV  DX,DS:xbRq+4[SI]
	OR   DX,DX
	JZ   CalcRespSize2
	MOV  WORD PTR DS:[BX], 0		;So handles, cb's etc. are clear
CalcRespSize2:
	ADD  BX,DX
	INC  BX
	AND  BL,0FEh					;Round to word boundary
	ADD  SI,6
	LOOP SetupRespPointersFirst
	pop  bx							;Restore BX to offset of response data
RespPointersSetupFirst:
	RET
ResponseDataFirst ENDP

ReturnResponse PROC FAR
ASSUME DS:DGroup
	PUSH BP
	MOV  BP,SP
;*****************************************************************************
;	ReturnResponse: procedure(saXBlock)
; XBlock in currently on the list dctSaXBlockIn
; Ship the response back to the workstation.
;       | saXBlock | +6
;       | CS       | +4
;       | IP       | +2
;       | BP       | <--BP
;*****************************************************************************
	PUSH DS							;Save pointer to DGroup
	MOV  DS,[BP+6]					;DS points to XBlock
ASSUME DS:Nothing
	TEST BYTE PTR DS:[xbFlags],xbClusterTerm
	JZ   TestReadResponse
	; replace rcRemoteTermination with rcResetAgent
	MOV  DS:WORD PTR [xbRqCode],rcResetAgent
	MOV  AL,BYTE PTR DS:[xbFlags]
	AND  AL,0FFh-xbClusterTerm
	MOV  BYTE PTR DS:[xbFlags],AL
	
TestReadResponse:
; If this is a small XBlock, the response data is next to the request block
; header.
	CMP  WORD PTR DS:[xbRqCode],rcRead
	JE   ReadResponse
; Check to see if we must move the response data up over the request data. If
; so, parameters have been Set up for us as follows:
; xbCbData is the size of the response data to move.
; xbStation is the offset from XBlock of the response data.
; xboffset is the offset from XBlock of the request data to move over.
; xbCbDataSent is the size of the request block header and request data to 
; ship back, including xbCbDataSent.
	MOV  CX,DS:[xbCbData]
	JCXZ PrepareOffsets
	MOV  SI,DS:[xbStation]			;SI = offset of response data
	MOV  DI,DS:[xboffset]			;DI = offset of request data
	AND  DI,0FFh
	MOV  AX,DS
	MOV  ES,AX
ASSUME ES:Nothing
	CLD
	SHR  CX,1						;Convert byte count to word count
	REPNZ  MOVSW					;Move Response data over request data
	JMP  SHORT PrepareOffsets

ReadResponse:
; If this is a response to a read, replace sBufferMax with sDataRet so that we
; will return only the data actually read. The size of the data returned will
; be sDataRet + 4 for ssDataRet + 30 for the request block + 2 for cbDataSent

	MOV  AX,DS:[xbRqsData]
	MOV  DS:[xbRqSBufferMax],AX
	ADD  AX,xbRqData-xbCbDataSent	; 36 today.
	MOV  DS:[xbCbDataSent],AX
; Set up psDataRet to offset of first byte of response data from xbCbDataSent. 
	MOV  WORD PTR DS:[xbRqPsDataRet],xbRqsData-lsxblockheader
; Set up pBufferRet to point to the data area, which just follows sDataRet.
	MOV  WORD PTR DS:xbRqPBufferRet,xbRqData-lsxblockheader
	JMP  ShipIt

PrepareOffsets:
; Prepare the offsets of the response data in the request block.  The offset
; of each response pb must point to the response data as an offset from
; xbCbDataSent.  At one time we had it set up so that the pointers were offset
; from xbCbDataSent.  In order to do this we had to allocate two extra 
; pointers for each XBlock and set up the base of the pointer to point to
; xbCbDataSent.  With this method, we didn't need to prepare the offsets, but
; it was not easy to allocate three contiguous pointers for each XBlock when
; the code was made to run on the soft bus.
	XOR  CX,CX
	MOV  CL,DS:[xbrqNRespPbCb]
	JCXZ ShipIt						;No response pointers
	MOV  AL,6
	MUL  BYTE PTR DS:[xbRqNRespPbCb]	;AX = 6 * nReqPbCb
	MOVZX BX,BYTE PTR DS:[xboResponsePb]		
;BX has offset of next response pb
; Calculate the offset of the first byte of response data: offset of first
; response pb + 6*nRespPb
	ADD  AX,BX
	ADD  AX,2					;offset is from xbCbDataSent
NextResponseOffset:
; Store offset of next response data in response pb
	MOV  DS:[xbRq][BX],AX
; Add next cb to calculate offset of next response data.
	ADD  AX,DS:[xbRq+4][BX]
	INC  AX							;Word align
	AND  AL,0FEh
	ADD  BX,6						;BX points to next response pb
	LOOP NextResponseOffset
ShipIt:
; Set up xbCbData: 2 more than xbCbDataSent to include station and frame
	MOV  AX,DS:[xbCbDataSent]
	INC  AX
	INC  AX
	MOV  DS:[xbCbData],AX
	PUSH DS
	POP  ES							;ES points to XBlock to send
	POP  DS							;Restore DS to point to DGroup
ASSUME DS:DGroup, ES:Nothing
	CALL SendXBlock
ReturnResponseRet:
	POP  BP
	RET  2

ReturnResponse ENDP

UnchainXBlock PROC FAR
ASSUME DS:DGroup, ES:Nothing
PUBLIC UnchainXBlock
;*****************************************************************************
; Unchain XBlock from dctSaXBlockIn
; This is called from two places: When we have a request that we have moved
; to a small XBlock, and we wish to unchain the big XBlock, and (2) 
; SendXBlock when we unchain it from saXBlockIn and chain it to saXBlockOut.
; On entry, ES points to XBlock, DS has address of DGroup.
; On return, ES and DX point to XBlock, DS points to DGroup.
; BX points to dct that owns XBlock.
; AX is not disturbed.
; Interrupts are enabled on return.
;*****************************************************************************
	PUSH DS							;Save address of DGroup.
	MOV  DX,ES						;ES and DX point to XBlock to unchain
	MOV  BX,ES:[xbODct]				;BX points to dct
	LEA  SI,dctSaXBlockIn[BX]		;DS:SI points to head of list 
	CLI								;Disable
	JMP  SHORT FindPrevXBlock
TestXBlock:
	MOV  CX,xbSaLink[SI]
	OR   CX,CX
	JNZ  TryNextXBlock
	MOV  AX,ercInternalConsistencyCheck
	PUSH AX
	CALL Crash
TryNextXBlock:
	MOV  DS,CX
ASSUME DS:Nothing
	XOR  SI,SI
FindPrevXBlock:
	CMP  xbSaLink[SI],DX			;DX = ES
	JNE  TestXBlock
; DS:SI points to the previous XBlock or the head of the list.
; Move the next pointer from the XBlock being unchained to the next pointer
; of the previous XBlock.
	MOV  CX,ES:[xbSaLink]
	MOV  xbSaLink[SI],CX
	STI								;Enable
	POP  DS							;Restore DS to point to DGroup
ASSUME DS:DGroup
	RET
UnchainXBlock ENDP


;*******************************************************************
;
;   THIS PROCEDURE IS CALLED BY SOMEONE WHICH WANTS TO KNOW
;   FROM WHAT WORKSTATION IS COMING THIS REQUEST BLOCK 
;   THE DAINumber IDENTIFIES THE WORKSTATION
;
;  GetDAInumber: PROCEDURE (pRQ,pDAInumberRet) WORD REENTRANT PUBLIC;
;
;    pRq.sa               +12 
;    pRq .ra              +10
;    pDAInumberRet .sa    +8
;    pDAInumberRet .ra    +6 
;    CS                   +4
;    IP                   +2
;    BP                   <===BP
;*********************************************************************

GetDAINumber PROC FAR
   	PUSH  BP
	MOV   BP,SP
	SUB   SP,4						; for ppstructureRet
	PUSH  DS						; SAVE USER'S DS
	PUSH  ES						; SAVE USER'S REGISTERS
	PUSH  BX
	PUSH  DX
;Modify following, can't do this anymore now that cluster has own DGroup
;	MOV   ES,[BP+12]				; ES POINTS TO XBLOCK AND RQ
;	MOV   AX,240H					; DS SYSTEM: CALL 
;	PUSH  AX						;GetpStructure(240H,usernum,ppstructureRet)
;	MOV   AX,ES:[xbRqUsernum]
;	PUSH  AX
;	PUSH  SS
;	MOV   AX,BP
;	SUB   AX,4						; for ppstructureRet
;	PUSH  AX
;	CALL  GetPStructure
;	MOV   AX,[BP-2]
	MOV   BX,DGROUP					; Cluster comm's Dgroup
	MOV   DS,BX
ASSUME DS:DGROUP
	MOV   ES,[BP+12]				; ES POINTS TO XBLOCK AND RQ
	MOV   BX,ES:[xboDCT] 			; BX = DCT 
;
; ARE THIS XBLOCK AND THIS DCT VALID ;
;  oRgoDCT < DCT <oRgDCT+ (nDCT *DCTsize)
;
	CMP   BX,oRgDCT
	JB    BadRequest
	MOV	  AX,nDCT
	OR    AX,AX
	JZ    BadRequest
	DEC	  AX
	MOV   DX,DCTsize
	MUl   DX
	ADD   AX,oRgDCT
	CMP   BX,AX
	JG    BadRequest
FindDAINumber:
	CMP   DctDAInumber[BX],NoDAIModule
	JE    DCThasNoDAI
	MOV   AL,DctDAINumber[BX]
	LES   BX,DWORD PTR[BP+6]				; pdaiNumberRet
	MOV   ES:[BX],AL
	XOR   AX,AX								; ERC OK
	JMP   GetDAiret
DCThasNoDAI:
	MOV   AX,ErcNoDAI
	JMP   GetDAiret
BadRequest:
	MOV   AX,ErcBadRq
GetDAIret:
	POP   DX
	POP   BX								; RESTORE USER'S REGISTERS
	POP   ES
	POP   DS
	MOV   SP,BP
	POP   BP
	RET   8
GetDAInumber  ENDP							


MstrAgent_Subs ENDS

	END


; LOG
; 4/23/84 by Jim Frandeen: Created file
; 1/21/85 by Jim Frandeen: Fix bug that caused more than one response pair to
;				create each response pb the same.
; 2/28/85 by Bob Merrell:  Modified for Megaframe
; 3/1/85 by Jim Frandeen: Fix bug that caused request to fail with odd number
;				of control information bytes.
; 4/17/85 by Jim Frandeen: Map user number of GetUserStatus request
; 4/22/86 by JA: ASSUME everywhere
; 9/23/86 by DR CTOS II 2.0 merge
; 1/12/87 By RLM copy xbstatus from large block to small block
; 3/13/87 by MS Declared DCTDAInumber
; 7/27/87 by JA introduce WS mstr fix for odd length cntl info.
; 10/27/87 by JM new remote termination scheme.
; 11/2/87 by JA/RLM clear first word of resp buffers -> cb's handles ok on erc.
; 03/09/88 by RLM in preparetoissuerequest remove bundle term code and reset of
;			  xbstatus.
; 04/12/88 by RLM make xb header 32 bytes
; 06/24/88 by JM/RLM adjust for 32 header fix.
; 08/4/88 by JA remove GetFPSysTime.  Done by filter process.
; 10/18/88 by JA insert line,id into LogRemote generic info.
; 08/28/89 by RLM realign xblocks for better dma on 386srp
; 10/11/89 by DHG XBlock Stats (old UVA).
; 11/06/89 by AT, Use ServeAgentRequests.
; 11/16/89 by JA HandleReadRequest clear sDataRet so ReadResponse ok in erc case.
;				Crazy xbCbDataSent was causing erc45 on WS side.
; 01/09/90 by AT, Use nXBlk, sXBlk, etc. instead of old variables.
; 01/18/90 by JA, ReadResponse set xbCbDataSent using edfs so it can be changed.
; 02/28/90 by JA, use pSysTime because separately linked.
;				rgWsId,rgWsLocalUserNum based on o-ptrs.
; 03/01/90 by JA, exchAgent EXTERNAL.
; 03/02/90 by JA, use pStat since separately linked.
; 03/07/90 by RLM, fix statistics bug in SmallXBlock code.
; 03/07/90 by RLM/JA, fix remakefh bug.
; 04/14/90 by AT, Merged CTOS/XE 3.0 and CTOS/VM 3.3.
; 01/16/91 by JM, response data is not paragraph aligned anymore; this fixes 
;	bug caused by the alignment padding not being included in the xblock size.
; 01/25/91 by JC, changed GetDaiNumber code to use Cluster Comm DGroup
; 04/11/91 by JA/AT, added ProcessWsRq(XBufOverflow).
;
; 01/20/93 by JA, Merged:
; 05/16/90 by AT, POP AX before jumping to ErrorReturn with ercNoAvailUserNum.
; 10/31/90 by MTR, beware of nDct = 0
; 03/23/93 by JF, Rewrite to use only one selector per XBlock
