;******************************* INCLUDE HEADER (_ALL.ASM) *******************;
;*                                                                           *;
;* FILE: Kbd_All.asm                                                         *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: CTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* Operating System (All types) keyboard table definitions.                  *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;*                                                                           *;
;* TITLE:  CTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1990 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;


$INCLUDE (kbd.mdf)
PUBLIC prgInfoIKey, pDiacriticTable, pSpecialKeys, fAltKbdEncoding
PUBLIC pEscKeys, cEscKeys
PUBLIC pUnencoded

DGroup	GROUP	Data, LookupSeg, ExpansionSeg

Data	SEGMENT	PUBLIC	'Data'
prgInfoIKey		DD rgInfoIKey
pSpecialKeys	DD iKbd
%IF (%MF) THEN (
pUnencoded		DD AsciiToUnencoded
)ELSE(
pUnencoded		DD 0
)FI
fAltKbdEncoding DB 0 ; set to true is using alternate 4 byte encoding table,
					 ; also change rgInfoIkey below.


;################################################################
; SPECIAL CHARACTER DEFINITIONS --                              #
;	The following keyboard codes are used by CTOS when in	#
; character mode.  They are used to look up (in the Keyboard	#
; Translation Table) the byte value to be returned to the	#
; caller of "ReadKbd".  If you wish to change the		#
; location of the "CODE" , "SHIFT", "LOCK", "ACTION", or	#
; "FINISH" keys then simply change the following SET macros and	#
; the appropriate entries in the Keyboard Translation Table.	#
;################################################################

%SET(LeftCodeKey, 4Ch)
%SET(RightCodeKey, 4Dh)
%SET(LeftShiftKey, 48h)
%SET(RightShiftKey, 49h)
%SET(LockKey, 45h)
%SET(FinishKey, 04h)
%SET(ActionKey, 43h)

iKbd		LABEL	WORD	; Beginning of special-key list.
	DW 061h		; 'a': Debugger, single process mode.
	DW 062h		; 'b': Debugger, multi process mode.
	DW 07Fh		; <delete>: Forget type-ahead buffer.
	DW 044h		; <overtype>: Blank screen (force screen timeout).
	DW %LeftCodeKey		
	DW %RightCodeKey
	DW %FinishKey
	DW %ActionKey
	DW %LockKey
	DW %LeftShiftKey
	DW %RightShiftKey
	DW 0FFFFh		;iKeyShift2 - reserved BT
	DW 0FFFFh		;iKey00		- reserved BT
	DW 0FFFFh		;iKey000	- reserved BT

;################################################################
;  Keyboard Translation Table					#
;								#
; rgInfoIKey (128) ARRAY OF (Unshifted Value, Shifted Value,	#
; Attributes)   						#
;								#
; The attributes are OR'd together from the following bit	#
; masks:							#
;								#
; 0xxxxxxx (00h) ... does not respond to Lock key as shifted	#
;		     value					#
; 1xxxxxxx (80h) ... responds to Lock key as shifted value	#
;								#
; x00xxxxx (00h) ... no repeating when a key is held down	#
; x01xxxxx (20h) ... repeating starts after 0.2 seconds		#
; x10xxxxx (40h) ... repeating starts after 0.4 seconds		#
; x11xxxxx (60h) ... repeating starts after 0.7 seconds		#
;								#
; xxx00xxx (00h) ... repeat rate is  1 per second		#
; xxx01xxx (08h) ... repeat rate is 10 per second		#
; xxx10xxx (10h) ... repeat rate is 20 per second		#
; xxx11xxx (18h) ... repeat rate is 30 per second		#
;
; xxxxxxx1 (01h) ... diacritical key when shifted
; xxxxxx1x (02h) ... diacritical key when unshifted
;								
;################################################################


attrControl				EQU 000h + 000h + 000h	;no shift lock, no repeat
attrAlpha 				EQU 080h + 060h + 010h	;shift lock, repeats
attrRepeat				EQU 000h + 060h + 010h	;repeats
attrRepeatFast				EQU 000h + 040h + 018h	;repeats, faster
attrShiftDia				EQU 01h; diacritcal key when shifted
attrUnShiftDia				EQU 02h; diacritcal key when unshifted
attrBothDia				EQU 03h; diacritcal key when shifted or unshifted


rgInfoIkey			LABEL		BYTE

; Table entry:				Meaning(s):
DB	0,   0C0h, attrControl 		; 000	 help
DB	01h, 0C1h, attrRepeatFast 	; 001	 up-arrow
DB	02h, 0C2h, attrControl 		; 002	 mark
DB	0Dh, 0C3h, attrControl 		; 003	 bound
DB	04h, 0C4h, attrControl 		; 004	 finish
DB	05h, 0C5h, attrControl 		; 005	 prev page
DB	06h,  10h, attrRepeat 		; 006	 1/2-1/4
DB	07h, 0C7h, attrControl 		; 007	 cancel
DB	08h,  08h, attrRepeat	 	; 008	 backspace
DB	09h,  09h, attrControl 		; 009	 tab
DB	0Ah,  0Ah, attrRepeat 		; 00A	 return
DB	0Bh, 0CBh, attrRepeatFast 	; 00B	 down-arrow
DB	0Ch, 0CCh, attrControl 		; 00C	 next page
DB	0Ah,  0Ah, attrRepeat 		; 00D	 next
DB	0Eh, 0CEh, attrRepeatFast 	; 00E	 left-arrow
DB	12h, 0D2h, attrRepeatFast 	; 00F	 right-arrow

DB	80h,  81h, attrControl 		; 010	 (SH-L)
DB	11h, 0D1h, attrRepeat 		; 011	 scroll-up
DB	0Fh, 0CFh, attrControl 		; 012	 move
DB	13h, 0D3h, attrRepeat 		; 013	 scroll-down
DB	14h, 0D4h, attrControl 		; 014	 copy
DB	15h, 0D5h, attrControl	 	; 015	 f1
DB	16h, 0D6h, attrControl 		; 016	 f2
DB	17h, 0D7h, attrControl 		; 017	 f3
DB	18h, 0D8h, attrControl 		; 018	 f4
DB	19h, 0D9h, attrControl 		; 019	 f5
DB	1Ah, 0DAh, attrControl 		; 01A	 f6
DB	1Bh, 0C9h, attrControl 		; 01B	 GO
DB	1Ch, 0DCh, attrControl 		; 01C	 f7
DB	1Dh, 0CDh, attrControl	 	; 01D	 f8
DB	1Eh, 0CAh, attrControl	 	; 01E	 f9
DB	1Fh, 0DFh, attrControl	 	; 01F	 f10

DB	20h,  20h, attrRepeat 		; 020	 space
DB	39h,  39h, attrRepeat 		; 021	 9 9
DB	82h,  83h, attrControl 		; 022	 (SH-L)
DB	84h,  85h, attrControl 		; 023	 (0)
DB	86h,  87h, attrControl 		; 024	 (NEXT)
DB	0,    0,   0			; 025
DB	0,    0,   0			; 026
DB	27h,  22h, attrRepeat 		; 027	  "
DB	0,    0,   0			; 028
DB	0,    0,   0			; 029
DB	0,    0,   0			; 02A
DB	3Dh,  2Bh, attrRepeat 		; 02B	 + =
DB	2Ch,  2Ch, attrRepeat 		; 02C	 , ,
DB	2Dh,  5Fh, attrRepeat 		; 02D	 - _
DB	2Eh,  2Eh, attrRepeat 		; 02E	 . .
DB	2Fh,  3Fh, attrRepeat 		; 02F	 / ?

DB	30h,  29h, attrRepeat 		; 030	 0 )
DB	31h,  21h, attrRepeat 		; 031	 1 !
DB	32h,  40h, attrRepeat 		; 032	 2 @
DB	33h,  23h, attrRepeat 		; 033	 3 #
DB	34h,  24h, attrRepeat 		; 034	 4 $
DB	35h,  25h, attrRepeat 		; 035	 5 percent
DB	36h,  03h, attrRepeat 		; 036	 6 cent
DB	37h,  26h, attrRepeat 		; 037	 7 &
DB	38h,  2Ah, attrRepeat 		; 038	 8 *
DB	39h,  28h, attrRepeat 		; 039	 9 (
DB	0,    0,   0			; 03A
DB	3Bh,  3Ah, attrRepeat 		; 03B	 ; :
DB	0,    0,   0			; 03C
DB	0,    0,   0			; 03D
DB	0,    0,   0			; 03E
DB	0,    0,   0          		; 03F	 3F = iKeyInvalid

DB	0,    0,   0          		; 040	 40 = iKeyNoKeys
DB	36h,  36h, attrRepeat 		; 041	 6 6
DB	2Dh,  2Dh, attrRepeat 		; 042	 - -
DB	0,    0,   0 			; 043	 reset
DB	0D0h,0D0h, attrControl	 	; 044	 overtype
DB	0,    0,   attrControl	 	; 045	 lock
DB	32h,  32h, attrRepeat 		; 046	 2 2
DB	33h,  33h, attrRepeat 		; 047	 3 3
DB	0,    0,   0 			; 048	 shift
DB	0,    0,   0 			; 049	 shift
DB	30h,  30h, attrRepeat 		; 04A	 0 0
DB	2Eh,  2Eh, attrRepeat 		; 04B	 . .
DB	0,    0,   0 			; 04C	 code
DB	0,    0,   0 			; 04D	 code
DB	0,    0,   0			; 04E
DB	0,    0,   0			; 04F

DB	0,    0,   0			; 050
DB	0,    0,   0			; 051
DB	0,    0,   0			; 052
DB	0,    0,   0			; 053
DB	0,    0,   0			; 054
DB	0,    0,   0			; 055
DB	0,    0,   0			; 056
DB	0,    0,   0			; 057
DB	0,    0,   0			; 058
DB	0,    0,   0			; 059
DB	0,    0,   0			; 05A
DB	5Bh,  3Ch, attrRepeat 		; 05B	 [ <
DB	37h,  7Ch, attrRepeat 		; 05C	 7 |
DB	5Dh,  3Eh, attrRepeat 		; 05D	 ] >
DB	5Eh,  7Eh, attrRepeat 		; 05E	 ^ ~
DB	0,    0,   0			; 05F

DB	31h,  60h, attrRepeat 		; 060	 1 `
DB	61h,  41h, attrAlpha 		; 061	 a A
DB	62h,  42h, attrAlpha 		; 062	 b B
DB	63h,  43h, attrAlpha 		; 063	 c C
DB	64h,  44h, attrAlpha 		; 064	 d D
DB	65h,  45h, attrAlpha 		; 065	 e E
DB	66h,  46h, attrAlpha 		; 066	 f F
DB	67h,  47h, attrAlpha 		; 067	 g G
DB	68h,  48h, attrAlpha 		; 068	 h H
DB	69h,  49h, attrAlpha 		; 069	 i I
DB	6Ah,  4Ah, attrAlpha 		; 06A	 j J
DB	6Bh,  4Bh, attrAlpha 		; 06B	 k K
DB	6Ch,  4Ch, attrAlpha 		; 06C	 l L
DB	6Dh,  4Dh, attrAlpha 		; 06D	 m M
DB	6Eh,  4Eh, attrAlpha 		; 06E	 n N
DB	6Fh,  4Fh, attrAlpha 		; 06F	 o O

DB	70h,  50h, attrAlpha 		; 070	 p P
DB	71h,  51h, attrAlpha 		; 071	 q Q
DB	72h,  52h, attrAlpha 		; 072	 r R
DB	73h,  53h, attrAlpha 		; 073	 s S
DB	74h,  54h, attrAlpha 		; 074	 t T
DB	75h,  55h, attrAlpha 		; 075	 u U
DB	76h,  56h, attrAlpha 		; 076	 v V
DB	77h,  57h, attrAlpha 		; 077	 w W
DB	78h,  58h, attrAlpha 		; 078	 x X
DB	79h,  59h, attrAlpha 		; 079	 y Y
DB	7Ah,  5Ah, attrAlpha 		; 07A	 z Z
DB	34h,  7Bh, attrRepeat 		; 07B	 4 {
DB	38h,  5Ch, attrRepeat 		; 07C	 8 backslash
DB	35h,  7Dh, attrRepeat 		; 07D	 5 }
DB	0,    0,   0			; 07E
DB	7Fh,0C8h, attrRepeat 		; 07F	 del


%InitDiacriticalTables

;
; Diacritical Keys:
;	Diacritical keys are a mechanism to map a regular key into a foriegn
;	key by a two-key sequence. To define the two-key sequence and the
;	resultant key use the macro below. The first argument is the diacritical
;	key, the second parameter is the following key in the sequence and
;	the third key is the resultant. The macro below, which is commented
;	out, would set SHIFT NEXT PAGE (0CCh) as the diacritic key, and the
;	the two key sequence SHIFT NEXT PAGE, '1' (31h) would  	result 	in the 
;	character '2' (32h).
;
;	The attribute for the diacritical key must also be set in the encoding 
;	table 	above. The diacritcal attributes are:
;
;		attrShiftDia				:if the key is diacritical when shifted
;		attrUnShiftDia				:if the key is diacritical when unshifted
;		attrBothDia				:if the key is diacritical shifted and unshifted
;
%' %DiacriticalSet (0CCh, 31h, 32h) 

%EndDiacriticalTables




;
; The macros below define keyboard keys which when depressed result in
; multiple keystrokes being returned to keyboard clients. 
;
; All keys values represent unencoded keystrokes. Any key on the keyboard
; may be defined as a multibyte escape key. Also, different results may be
; defined depending on the shift and code key state. See the CTOS Reference
; manual Appendix C-1 for unencoded value of keyboard keys.
;
; The resulting key sequences must include downstrokes as well as upstrokes
; as well as any shift state required to produce the keyboard characters
; desired. An upstroke is the key value OR'ed with 80h.
;
; The two examples below are 'commented out' by the notation %'
; preceding each macro.
;
; In the first example below, the key '0' on the numeric pad (unencoded 
; value 4Ah) is defined to produce 6 keyboard events - 
;		downstroke 'a' (61h)
;		upstroke 'a' (0E1h)
;		downstroke 'b' (62h)
;		upstroke 'b' (0E2h)
;		downstroke 'c' (63h)
;		upstroke 'c' (0E3h)
; These 6 keyboard events would produce the 3 keyboard characters 'abc'.
;
; In the second example the key '0' on the numeric pad is depressed when the
; shift or shift lock keys are active would produce the keyboard characters
; '[sys]<sys>'. Note that the first keystroke in this list is shift 
; upstroke (0C8h) which turns off the shift state caused by the invoking
; key, shift-'0'.
;
;
;
;
Unshifted EQU 0
Shifted   EQU 3
Coded	  EQU 4
Shift2ed  EQU 8


%InitEscapeKeys
%'%DefEscapeKey(4Ah, Unshifted) (61h,0E1h,62h,0E2h,63h,0E3h)
%'%DefEscapeKey(4Ah, Shifted) (0C8h,5Bh,0DBh,73h,0F3h,79h,0F9h,73h,0F3h,5Dh,0DDh,48h,5Bh,0C8h,0DBh,73h,0F3h,79h,0F9h,73h,0F3h,48h,5Dh,0C8h,0DDh)
%EndEscapeKeys

Data	ENDS



%IF (%Mf) THEN (
KbdTableSeg SEGMENT BYTE PUBLIC 'oemseg'

upStroke	EQU 80h
shiftDown	EQU	48h
shiftUp		EQU	shiftDown + upStroke
codeDown	EQU 4Ch
codeUp		EQU codeDown + upStroke

AsciiToUnencoded LABEL BYTE
ikey000h  DB  2   ,000h,080h,0,0,0,0,0
ikey001h  DB  4   ,043h,061h,0E1h,0C3h,0,0,0		;action-a
ikey002h  DB  4   ,codeDown,062h,0B2h,codeUp,0,0,0	;code-b
ikey003h  DB  4   ,codeDown,063h,0B3h,codeUp,0,0,0	;code-c
ikey004h  DB  4   ,codeDown,064h,0B4h,codeUp,0,0,0	;code-d
ikey005h  DB  4   ,codeDown,073h,0F3h,codeUp,0,0,0	;code-s
ikey006h  DB  4   ,codeDown,066h,0B6h,codeUp,0,0,0	;code-f
ikey007h  DB  4   ,codeDown,067h,0B7h,codeUp,0,0,0	;code-g
ikey008h  DB  2   ,008h,088h,0,0,0,0,0				;backspace
ikey009h  DB  4   ,codeDown,069h,0B9h,codeUp,0,0,0	;code-i
ikey00Ah  DB  2   ,00Ch,08Ch,0,0,0,0,0				;next page
ikey00Bh  DB  4   ,codeDown,06Bh,0B9h,codeUp,0,0,0	;code-k
ikey00Ch  DB  4   ,codeDown,06Ch,0BCh,codeUp,0,0,0	;code-l
ikey00Dh  DB  2   ,00Ah,08Ah,0,0,0,0,0				;return
ikey00Eh  DB  4   ,codeDown,06Eh,0BEh,codeUp,0,0,0	;code-n
ikey00Fh  DB  4   ,codeDown,065h,0B5h,codeUp,0,0,0	;code-e
ikey010h  DB  4   ,codeDown,070h,0F0h,codeUp,0,0,0	;code-p
ikey011h  DB  4   ,codeDown,06Dh,0BDh,codeUp,0,0,0	;code-m
ikey012h  DB  4   ,codeDOwn,072h,0F2h,codeUp,0,0,0	;code-r
ikey013h  DB  4   ,codeDown,077h,0F7h,codeUp,0,0,0	;code-w
ikey014h  DB  4   ,codeDown,074h,0F4h,codeUp,0,0,0	;code-t
ikey015h  DB  4   ,codeDown,075h,0F5h,codeUp,0,0,0	;code-u
ikey016h  DB  2   ,00Bh,08Bh,0,0,0,0,0				;down arrow
ikey017h  DB  2   ,001h,081h,0,0,0,0,0				;up arrow
ikey018h  DB  4   ,codeDown,078h,0F8h,codeUp,0,0,0	;code-x
ikey019h  DB  4   ,codeDown,06Fh,0EFh,codeUp,0,0,0	;code-o
ikey01Ah  DB  2   ,004h,084h,0,0,0,0,0				;finish
ikey01Bh  DB  2   ,01Bh,09Bh,0,0,0,0,0				;go
ikey01Ch  DB  2   ,007h,087h,0,0,0,0,0				;cancel
ikey01Dh  DB  2   ,002h,082h,0,0,0,0,0				;mark
ikey01Eh  DB  6   ,codeDown,shiftDown,64h,0E4h,shiftUp,codeUp,0 ;code-shift-d
ikey01Fh  DB  2   ,codeDown,07Ah,0FAh,codeUp,0,0,0	;code-z
ikey020h  DB  2   ,020h,0A0h,0,0,0,0,0
ikey021h  DB  4   ,shiftDown,031h,0B1h,shiftUp,0,0,0
ikey022h  DB  4   ,shiftDown,027h,0A7h,shiftUp,0,0,0
ikey023h  DB  4   ,shiftDown,033h,0B3h,shiftUp,0,0,0
ikey024h  DB  4   ,shiftDown,034h,0B4h,shiftUp,0,0,0
ikey025h  DB  4   ,shiftDown,035h,0B5h,shiftUp,0,0,0
ikey026h  DB  4   ,shiftDown,037h,0B7h,shiftUp,0,0,0
ikey027h  DB  2   ,027h,0A7h,0,0,0,0,0
ikey028h  DB  4   ,shiftDown,039h,0B9h,shiftUp,0,0,0
ikey029h  DB  4   ,shiftDown,030h,0B0h,shiftUp,0,0,0
ikey02Ah  DB  4   ,shiftDown,038h,0B8h,shiftUp,0,0,0
ikey02Bh  DB  4   ,shiftDown,02Bh,0ABh,shiftUp,0,0,0
ikey02Ch  DB  2   ,02Ch,0ACh,0,0,0,0,0
ikey02Dh  DB  2   ,02Dh,0ADh,0,0,0,0,0
ikey02Eh  DB  2   ,02Eh,0AEh,0,0,0,0,0
ikey02Fh  DB  2   ,02Fh,0AFh,0,0,0,0,0
ikey030h  DB  2   ,030h,0B0h,0,0,0,0,0
ikey031h  DB  2   ,031h,0B1h,0,0,0,0,0
ikey032h  DB  2   ,032h,0B2h,0,0,0,0,0
ikey033h  DB  2   ,033h,0B3h,0,0,0,0,0
ikey034h  DB  2   ,034h,0B4h,0,0,0,0,0
ikey035h  DB  2   ,035h,0B5h,0,0,0,0,0
ikey036h  DB  2   ,036h,0B6h,0,0,0,0,0
ikey037h  DB  2   ,037h,0B7h,0,0,0,0,0
ikey038h  DB  2   ,038h,0B8h,0,0,0,0,0
ikey039h  DB  2   ,039h,00B9h,0,0,0,0,0
ikey03Ah  DB  4   ,shiftDown,03Bh,0BBh,shiftUp,0,0,0
ikey03Bh  DB  2   ,03Bh,0BBh,0,0,0,0,0
ikey03Ch  DB  4   ,shiftDown,05Bh,0DBh,shiftUp,0,0,0
ikey03Dh  DB  2   ,02Bh,0ABh,0,0,0,0,0
ikey03Eh  DB  4   ,shiftDown,05Dh,0DDh,shiftUp,0,0,0
ikey03Fh  DB  4   ,shiftDown,02Fh,0AFh,shiftUp,0,0,0
ikey040h  DB  4   ,shiftDown,032h,0B2h,shiftUp,0,0,0
ikey041h  DB  4   ,shiftDown,061h,0E1h,shiftUp,0,0,0
ikey042h  DB  4   ,shiftDown,062h,0E2h,shiftUp,0,0,0
ikey043h  DB  4   ,shiftDown,063h,0E3h,shiftUp,0,0,0
ikey044h  DB  4   ,shiftDown,064h,0E4h,shiftUp,0,0,0
ikey045h  DB  4   ,shiftDown,065h,0E5h,shiftUp,0,0,0
ikey046h  DB  4   ,shiftDown,066h,0E6h,shiftUp,0,0,0
ikey047h  DB  4   ,shiftDown,067h,0E7h,shiftUp,0,0,0
ikey048h  DB  4   ,shiftDown,068h,0E8h,shiftUp,0,0,0
ikey049h  DB  4   ,shiftDown,069h,0E9h,shiftUp,0,0,0
ikey04Ah  DB  4   ,shiftDown,06Ah,0EAh,shiftUp,0,0,0
ikey04Bh  DB  4   ,shiftDown,06Bh,0EBh,shiftUp,0,0,0
ikey04Ch  DB  4   ,shiftDown,06Ch,0ECh,shiftUp,0,0,0
ikey04Dh  DB  4   ,shiftDown,06Dh,0EDh,shiftUp,0,0,0
ikey04Eh  DB  4   ,shiftDown,06Eh,0EEh,shiftUp,0,0,0
ikey04Fh  DB  4   ,shiftDown,06Fh,0EFh,shiftUp,0,0,0
ikey050h  DB  4   ,shiftDown,070h,0F0h,shiftUp,0,0,0
ikey051h  DB  4   ,shiftDown,071h,0F1h,shiftUp,0,0,0
ikey052h  DB  4   ,shiftDown,072h,0F2h,shiftUp,0,0,0
ikey053h  DB  4   ,shiftDown,073h,0F3h,shiftUp,0,0,0
ikey054h  DB  4   ,shiftDown,074h,0F4h,shiftUp,0,0,0
ikey055h  DB  4   ,shiftDown,075h,0F5h,shiftUp,0,0,0
ikey056h  DB  4   ,shiftDown,076h,0F6h,shiftUp,0,0,0
ikey057h  DB  4   ,shiftDown,077h,0F7h,shiftUp,0,0,0
ikey058h  DB  4   ,shiftDown,078h,0F8h,shiftUp,0,0,0
ikey059h  DB  4   ,shiftDown,079h,0F9h,shiftUp,0,0,0
ikey05Ah  DB  4   ,shiftDown,07Ah,0FAh,shiftUp,0,0,0
ikey05Bh  DB  2   ,05Bh,0DBh,0,0,0,0,0
ikey05Ch  DB  4   ,shiftDown,07Ch,0FCh,shiftUp,0,0,0
ikey05Dh  DB  2   ,05Dh,0DDh,0,0,0,0,0
ikey05Eh  DB  2   ,05Eh,0DEh,0,0,0,0,0
ikey05Fh  DB  4   ,shiftDown,02Dh,0ADh,shiftUp,0,0,0
ikey060h  DB  4   ,shiftDown,060h,0E0h,shiftUp,0,0,0
ikey061h  DB  2   ,061h,0E1h,0,0,0,0,0
ikey062h  DB  2   ,062h,0E2h,0,0,0,0,0
ikey063h  DB  2   ,063h,0E3h,0,0,0,0,0
ikey064h  DB  2   ,064h,0E4h,0,0,0,0,0
ikey065h  DB  2   ,065h,0E5h,0,0,0,0,0
ikey066h  DB  2   ,066h,0E6h,0,0,0,0,0
ikey067h  DB  2   ,067h,0E7h,0,0,0,0,0
ikey068h  DB  2   ,068h,0E8h,0,0,0,0,0
ikey069h  DB  2   ,069h,0E9h,0,0,0,0,0
ikey06Ah  DB  2   ,06Ah,0EAh,0,0,0,0,0
ikey06Bh  DB  2   ,06Bh,0EBh,0,0,0,0,0
ikey06Ch  DB  2   ,06Ch,0ECh,0,0,0,0,0
ikey06Dh  DB  2   ,06Dh,0EDh,0,0,0,0,0
ikey06Eh  DB  2   ,06Eh,0EEh,0,0,0,0,0
ikey06Fh  DB  2   ,06Fh,0EFh,0,0,0,0,0
ikey070h  DB  2   ,070h,0F0h,0,0,0,0,0
ikey071h  DB  2   ,071h,0F1h,0,0,0,0,0
ikey072h  DB  2   ,072h,0F2h,0,0,0,0,0
ikey073h  DB  2   ,073h,0F3h,0,0,0,0,0
ikey074h  DB  2   ,074h,0F4h,0,0,0,0,0
ikey075h  DB  2   ,075h,0F5h,0,0,0,0,0
ikey076h  DB  2   ,076h,0F6h,0,0,0,0,0
ikey077h  DB  2   ,077h,0F7h,0,0,0,0,0
ikey078h  DB  2   ,078h,0F8h,0,0,0,0,0
ikey079h  DB  2   ,079h,0F9h,0,0,0,0,0
ikey07Ah  DB  2   ,07Ah,0FAh,0,0,0,0,0
ikey07Bh  DB  4   ,shiftDown,07Bh,0FBh,shiftUp,0,0,0
ikey07Ch  DB  4   ,shiftDown,05Ch,0DCh,shiftUp,0,0,0
ikey07Dh  DB  4   ,shiftDown,07Dh,0FDh,shiftUp,0,0,0
ikey07Eh  DB  4   ,shiftDown,05Eh,0DEh,shiftUp,0,0,0
ikey07Fh  DB  2   ,07Fh,0FFh,0,0,0,0,0
ikey080h  DB  4   ,codeDown,000h,080h,codeUp,0,0,0
ikey081h  DB  4   ,codeDown,001h,081h,codeUp,0,0,0
ikey082h  DB  4   ,codeDown,002h,082h,codeUp,0,0,0
ikey083h  DB  6   ,codeDown,shiftDown,036h,0B6h,shiftUp,codeUp,0
ikey084h  DB  4   ,codeDown,004h,084h,codeUp,0,0,0
ikey085h  DB  4   ,codeDown,005h,085h,codeUp,0,0,0
ikey086h  DB  4   ,codeDown,006h,086h,codeUp,0,0,0
ikey087h  DB  4   ,codeDown,007h,087h,codeUp,0,0,0
ikey088h  DB  4   ,codeDown,008h,088h,codeUp,0,0,0
ikey089h  DB  4   ,codeDown,009h,089h,codeUp,0,0,0
ikey08Ah  DB  4   ,codeDown,00Ah,08Ah,codeUp,0,0,0
ikey08Bh  DB  4   ,codeDown,00Bh,08Bh,codeUp,0,0,0
ikey08Ch  DB  4   ,codeDown,00Ch,08Ch,codeUp,0,0,0
ikey08Dh  DB  4   ,codeDown,003h,083h,codeUp,0,0,0
ikey08Eh  DB  4   ,codeDown,00Eh,08Eh,codeUp,0,0,0
ikey08Fh  DB  4   ,codeDown,012h,092h,codeUp,0,0,0
ikey090h  DB  6   ,codeDown,shiftDown,006h,086h,shiftUp,codeUp,0
ikey091h  DB  4   ,codeDown,011h,091h,codeUp,0,0,0
ikey092h  DB  4   ,codeDown,00Fh,08Fh,codeUp,0,0,0
ikey093h  DB  4   ,codeDown,013h,093h,codeUp,0,0,0
ikey094h  DB  4   ,codeDown,014h,094h,codeUp,0,0,0
ikey095h  DB  4   ,codeDown,015h,095h,codeUp,0,0,0
ikey096h  DB  4   ,codeDown,016h,096h,codeUp,0,0,0
ikey097h  DB  4   ,codeDown,017h,097h,codeUp,0,0,0
ikey098h  DB  4   ,codeDown,018h,098h,codeUp,0,0,0
ikey099h  DB  4   ,codeDown,019h,099h,codeUp,0,0,0
ikey09Ah  DB  4   ,codeDown,01Ah,09Ah,codeUp,0,0,0
ikey09Bh  DB  4   ,codeDown,01Bh,09Bh,codeUp,0,0,0
ikey09Ch  DB  4   ,codeDown,01Ch,09Ch,codeUp,0,0,0
ikey09Dh  DB  4   ,codeDown,01Dh,09Dh,codeUp,0,0,0
ikey09Eh  DB  4   ,codeDown,01Eh,09Eh,codeUp,0,0,0
ikey09Fh  DB  4   ,codeDown,01Fh,09Fh,codeUp,0,0,0
ikey0A0h  DB  4   ,codeDown,020h,0A0h,codeUp,0,0,0
ikey0A1h  DB  6   ,codeDown,shiftDown,031h,0B1h,shiftUp,codeUp,0
ikey0A2h  DB  6   ,codeDown,shiftDown,027h,0A7h,shiftUp,codeUp,0
ikey0A3h  DB  6   ,codeDown,shiftDown,033h,0B3h,shiftUp,codeUp,0
ikey0A4h  DB  6   ,codeDown,shiftDown,034h,0B4h,shiftUp,codeUp,0
ikey0A5h  DB  6   ,codeDown,shiftDown,035h,0B5h,shiftUp,codeUp,0
ikey0A6h  DB  6   ,codeDown,shiftDown,037h,0B7h,shiftUp,codeUp,0
ikey0A7h  DB  4   ,codeDown,027h,0A7h,codeUp,0,0,0
ikey0A8h  DB  6   ,codeDown,shiftDown,039h,0B9h,shiftUp,codeUp,0
ikey0A9h  DB  6   ,codeDown,shiftDown,030h,0B0h,shiftUp,codeUp,0
ikey0AAh  DB  6   ,codeDown,shiftDown,038h,0B8h,shiftUp,codeUp,0
ikey0ABh  DB  6   ,codeDown,shiftDown,02Bh,0ABh,shiftUp,codeUp,0
ikey0ACh  DB  4   ,codeDown,02Ch,0ACh,codeUp,0,0,0
ikey0ADh  DB  4   ,codeDown,02Dh,0ADh,codeUp,0,0,0
ikey0AEh  DB  4   ,codeDown,02Eh,0AEh,codeUp,0,0,0
ikey0AFh  DB  4   ,codeDown,02Fh,0AFh,codeUp,0,0,0
ikey0B0h  DB  4   ,codeDown,030h,0B0h,codeUp,0,0,0
ikey0B1h  DB  4   ,codeDown,031h,0B1h,codeUp,0,0,0
ikey0B2h  DB  4   ,codeDown,032h,0B2h,codeUp,0,0,0
ikey0B3h  DB  4   ,codeDown,033h,0B3h,codeUp,0,0,0
ikey0B4h  DB  4   ,codeDown,034h,0B4h,codeUp,0,0,0
ikey0B5h  DB  4   ,codeDown,035h,0B5h,codeUp,0,0,0
ikey0B6h  DB  4   ,codeDown,036h,0B6h,codeUp,0,0,0
ikey0B7h  DB  4   ,codeDown,037h,0B7h,codeUp,0,0,0
ikey0B8h  DB  4   ,codeDown,038h,0B8h,codeUp,0,0,0
ikey0B9h  DB  4   ,codeDown,021h,0A1h,codeUp,0,0,0
ikey0BAh  DB  6   ,codeDown,shiftDown,03Bh,0BBh,shiftUp,codeUp,0
ikey0BBh  DB  4   ,codeDown,03Bh,0BBh,codeUp,0,0,0
ikey0BCh  DB  6   ,codeDown,shiftDown,05Bh,0DBh,shiftUp,codeUp,0
ikey0BDh  DB  4   ,codeDown,02Bh,0ABh,codeUp,0,0,0
ikey0BEh  DB  6   ,codeDown,shiftDown,05Dh,0DDh,shiftUp,codeUp,0
ikey0BFh  DB  6   ,codeDown,shiftDown,02Fh,0AFh,shiftUp,codeUp,0
ikey0C0h  DB  6   ,codeDown,shiftDown,032h,0B2h,shiftUp,codeUp,0
ikey0C1h  DB  6   ,codeDown,shiftDown,061h,0E1h,shiftUp,codeUp,0
ikey0C2h  DB  6   ,codeDown,shiftDown,062h,0E2h,shiftUp,codeUp,0
ikey0C3h  DB  6   ,codeDown,shiftDown,063h,0E3h,shiftUp,codeUp,0
ikey0C4h  DB  6   ,codeDown,shiftDown,064h,0E4h,shiftUp,codeUp,0
ikey0C5h  DB  6   ,codeDown,shiftDown,065h,0E5h,shiftUp,codeUp,0
ikey0C6h  DB  6   ,codeDown,shiftDown,066h,0E6h,shiftUp,codeUp,0
ikey0C7h  DB  6   ,codeDown,shiftDown,067h,0E7h,shiftUp,codeUp,0
ikey0C8h  DB  6   ,codeDown,shiftDown,068h,0E8h,shiftUp,codeUp,0
ikey0C9h  DB  6   ,codeDown,shiftDown,069h,0E9h,shiftUp,codeUp,0
ikey0CAh  DB  6   ,codeDown,shiftDown,06Ah,0EAh,shiftUp,codeUp,0
ikey0CBh  DB  6   ,codeDown,shiftDown,06Bh,0EBh,shiftUp,codeUp,0
ikey0CCh  DB  6   ,codeDown,shiftDown,06Ch,0ECh,shiftUp,codeUp,0
ikey0CDh  DB  6   ,codeDown,shiftDown,06Dh,0EDh,shiftUp,codeUp,0
ikey0CEh  DB  6   ,codeDown,shiftDown,06Eh,0EEh,shiftUp,codeUp,0
ikey0CFh  DB  6   ,codeDown,shiftDown,06Fh,0EFh,shiftUp,codeUp,0
ikey0D0h  DB  6   ,codeDown,shiftDown,070h,0F0h,shiftUp,codeUp,0
ikey0D1h  DB  6   ,codeDown,shiftDown,071h,0F1h,shiftUp,codeUp,0
ikey0D2h  DB  6   ,codeDown,shiftDown,072h,0F2h,shiftUp,codeUp,0
ikey0D3h  DB  6   ,codeDown,shiftDown,073h,0F3h,shiftUp,codeUp,0
ikey0D4h  DB  6   ,codeDown,shiftDown,074h,0F4h,shiftUp,codeUp,0
ikey0D5h  DB  6   ,codeDown,shiftDown,075h,0F5h,shiftUp,codeUp,0
ikey0D6h  DB  6   ,codeDown,shiftDown,076h,0F6h,shiftUp,codeUp,0
ikey0D7h  DB  6   ,codeDown,shiftDown,077h,0F7h,shiftUp,codeUp,0
ikey0D8h  DB  6   ,codeDown,shiftDown,078h,0F8h,shiftUp,codeUp,0
ikey0D9h  DB  6   ,codeDown,shiftDown,079h,0F9h,shiftUp,codeUp,0
ikey0DAh  DB  6   ,codeDown,shiftDown,07Ah,0FAh,shiftUp,codeUp,0
ikey0DBh  DB  4   ,codeDown,05Bh,0DBh,codeUp,0,0,0
ikey0DCh  DB  6   ,codeDown,shiftDown,07Ch,0FCh,shiftUp,codeUp,0
ikey0DDh  DB  4   ,codeDown,05Dh,0DDh,codeUp,0,0,0
ikey0DEh  DB  4   ,codeDown,05Eh,0DEh,codeUp,0,0,0
ikey0DFh  DB  6   ,codeDown,shiftDown,02Dh,0ADh,shiftUp,codeUp,0
ikey0E0h  DB  6   ,codeDown,shiftDown,060h,0E0h,shiftUp,codeUp,0
ikey0E1h  DB  4   ,codeDown,061h,0E1h,codeUp,0,0,0
ikey0E2h  DB  4   ,codeDown,062h,0E2h,codeUp,0,0,0
ikey0E3h  DB  4   ,codeDown,063h,0E3h,codeUp,0,0,0
ikey0E4h  DB  4   ,codeDown,064h,0E4h,codeUp,0,0,0
ikey0E5h  DB  4   ,codeDown,065h,0E5h,codeUp,0,0,0
ikey0E6h  DB  4   ,codeDown,066h,0E6h,codeUp,0,0,0
ikey0E7h  DB  4   ,codeDown,067h,0E7h,codeUp,0,0,0
ikey0E8h  DB  4   ,codeDown,068h,0E8h,codeUp,0,0,0
ikey0E9h  DB  4   ,codeDown,069h,0E9h,codeUp,0,0,0
ikey0EAh  DB  4   ,codeDown,06Ah,0EAh,codeUp,0,0,0
ikey0EBh  DB  4   ,codeDown,06Bh,0EBh,codeUp,0,0,0
ikey0ECh  DB  4   ,codeDown,06Ch,0ECh,codeUp,0,0,0
ikey0EDh  DB  4   ,codeDown,06Dh,0EDh,codeUp,0,0,0
ikey0EEh  DB  4   ,codeDown,06Eh,0EEh,codeUp,0,0,0
ikey0EFh  DB  4   ,codeDown,06Fh,0EFh,codeUp,0,0,0
ikey0F0h  DB  4   ,codeDown,070h,0F0h,codeUp,0,0,0
ikey0F1h  DB  4   ,codeDown,071h,0F1h,codeUp,0,0,0
ikey0F2h  DB  4   ,codeDown,072h,0F2h,codeUp,0,0,0
ikey0F3h  DB  4   ,codeDown,073h,0F3h,codeUp,0,0,0
ikey0F4h  DB  4   ,codeDown,074h,0F4h,codeUp,0,0,0
ikey0F5h  DB  4   ,codeDown,075h,0F5h,codeUp,0,0,0
ikey0F6h  DB  4   ,codeDown,076h,0F6h,codeUp,0,0,0
ikey0F7h  DB  4   ,codeDown,077h,0F7h,codeUp,0,0,0
ikey0F8h  DB  4   ,codeDown,078h,0F8h,codeUp,0,0,0
ikey0F9h  DB  4   ,codeDown,079h,0F9h,codeUp,0,0,0
ikey0FAh  DB  4   ,codeDown,07Ah,0FAh,codeUp,0,0,0
ikey0FBh  DB  6   ,codeDown,shiftDown,07Bh,0FBh,shiftUp,codeUp,0
ikey0FCh  DB  6   ,codeDown,shiftDown,05Ch,0DCh,shiftUp,codeUp,0
ikey0FDh  DB  6   ,codeDown,shiftDown,07Dh,0FDh,shiftUp,codeUp,0
ikey0FEh  DB  6   ,codeDown,shiftDown,05Eh,0DEh,shiftUp,codeUp,0
ikey0FFh  DB  4   ,codeDown,07Fh,0FFh,codeUp,0,0,0
KbdTableSeg ENDS
)FI

END
