
;file:  InitOsEnd.asm
;
; last module in object module list.
;
;	Defines public label at high end of boot image.  Put ptr to it in DGroup.
;	Incidentally, make pointer to character map in DGroup.
;	Also define rgSysgen buffer after boot image.

magic EQU 7C39h
sSysgenRgb EQU 512 ; Size must be a multiple of 4.


PUBLIC sgEndOfOsBoot, pEndOfOsBoot, EndOfOsBoot
PUBLIC pCoedRgSwappingRq, pCoedRgTerminationRq
PUBLIC pCoedRgWsAbortRq, pCoedRgChgUserNumRq
PUBLIC pFS

EXTRN FileSys:BYTE

rgTables segment public 'memory'
EXTRN RgSwappingRq:byte, RgTerminationRq:byte
EXTRN RgWsAbortRq:byte, RgChgUserNumRq:byte
rgTables ends

DGroup	GROUP	Data
; OsEnd is the very last segment in the boot image.  It should be
; preceeded by the wrapped file system, which should be preceeded
; by the wrapped cluster or master.

OsEnd	SEGMENT 'COED'
;----------------------- WARNING -----------------------------------
; The sysgen structure at the end of the boot image is currently not
; used, therefore it is comment out.
; 
; Should this feature be resurrected, be warned that this data area
; may be clobbered following the loading of the wrapped file system
; or the wrapped cluster or master.
;
; This happens because plaMemMin and pEndOfOsBoot are reset to recover
; the memory occupied by the wrapped file system and the wrapped
; cluster/master following their loading.  This is done to allow
; the OS to continue to boot in 1Mb for extCrashDump purposes.
;-------------------------------------------------------------------
;	Structure- chksum, size, data.
;rgSysgen DW magic-sSysgenRgb,sSysgenRgb, sSysgenRgb/2 DUP (0)

endOfOsBoot	DW	0
OsEnd	ENDS



;PUBLIC	pRgSysgen, sSysgen, rgSysgen

Data	SEGMENT	WORD PUBLIC	'Data'
pEndOfOsBoot	DD	endOfOsBoot
sgEndOfOsBoot   DW OsEnd
;prgSysgen	DD	rgSysgen
;sSysgen	DW	sSysgenRgb
pCoedRgSwappingRq dd rgSwappingRq
pCoedRgTerminationRq dd rgTerminationRq
pCoedRgWsAbortRq dd rgWsAbortRq
pCoedRgChgUserNumRq dd rgChgUserNumRq
pFS				DD	FileSys
Data	ENDS

END

; Log
;
; 4/23/86  DR: add request pointers for protected mode compatibility
; 10/22/86 JA pFS
; 2/27/89 JA remove pCharacterMap to VidIo_all.plm
; 4/1/91  DR rgSysgen structure commented out of OsEnd
