
; Title: InitPsAlloc.asm
; NOTE: this module must come first in linker command line
;
; 4/9/86  DR  - protected mode compatible
; 5/28/87 Jim Frandeen: make it compatible with 9.x OS
; 3/17/93 JF - Remove code for 9.x OS
; 07/15/93 JM - move CONST above OSTable to InitLoad'ed Srvr works


SegMartSeg	SEGMENT	PUBLIC 'Coed'
SegMartSeg	ENDS

SegMartGroup GROUP SegMartSeg

Coed	SEGMENT	PUBLIC 'Coed'
Coed	ENDS

Array	SEGMENT	PUBLIC 'Array'
Array	ENDS

Const	SEGMENT PUBLIC 'Const'
PUBLIC fOsTableGrowDown
fOsTableGrowDown DB 0
Const	ENDS

Data	SEGMENT	PUBLIC 'Data'
Data	ENDS


OsTable	SEGMENT PUBLIC 'Data'
OsTable	ENDS

Stack	SEGMENT Stack	'Stack'
Stack	ENDS

Memory	SEGMENT	PUBLIC 'Memory'
Memory	ENDS

extrn ExpandAreaSL: far
extrn AllocMemorySL: far

public AllocMemoryInit
public pToDeallocate, cbFree, raNextFree, cbArrayFree
public ArrayHigh, ArrayLow

ercOk equ 0
ercInsufficientMemory equ 400
ercArrayTooSmall equ 26

InitAlloc segment word 'coed'
InitAlloc ends

DGroup	GROUP	Array, Const, Stack, Data, OsTable, Memory
assume ds: DGroup

; We will allocate memory out of Array first. When we run out, we will start allocating memory out of the code space occupied by InitAlloc and other Coed code. Array should be big enough so that all memory that gets initialized to something gets allocated here. We don't want to step on ourselves by allocating memory out of the code segment and then initializing it. If we have any memory left over at the end of initializing, the client will return it by calling ShrinkAreaSL(pToDeallocate, cbFree).

Array segment para public 'Array' ; must be paragraph aligned 
ArrayLow label word
; Currently, no modules ask for memory to be initialized. We must have one page for a buffer to read in the config file.
; 	DW   256 dup(0)  ; must be a multiple of 16
  	DW  2048 dup(?)  ; must be a multiple of 16
  	DW  2048 dup(?)  ; must be a multiple of 16
ArrayHigh 	label word
Array ends

Const segment word public 'Const'
Const ends

Data segment public 'Data'
firstTime  DW  1
fOldOS		DW 0
pToDeallocate label dword
raToDeallocate DW 0
saToDeallocate DW 0
cbFree DW 0
saNextFree DW 0
raNextFree DW 0
cbArrayFree DW (offset ArrayHigh) - offset(ArrayLow)
Data ends

Stack segment word public 'Stack'
Stack ends

Memory segment word public 'Memory'
Memory ends


InitAlloc segment word 'coed'
assume cs: InitAlloc


AllocMemoryInit proc far
; procedure (cb, pobRet, fInit) ErcType public reentrant;
; declare cb word, pobRet pointer, fInit word;
	push bp
	mov bp, sp
	push cx		;Reserve space on the stack for raAlloced
	push cx
	push cx

; stack frame offsets:
	cparaDs     equ [bp-6]
	raAlloced   equ [bp-4]
	saAlloced   equ [bp-2]
	fInit       equ [bp+6]
	pobRet      equ [bp+8]
	cb          equ [bp+12]
	cbArgs      equ 8

; If this is the first time called, initialize variables
	mov	ax, firstTime
	or	ax,ax
	JZ	VariablesInitialized		; This is not the first time called.

; Initialize pToDeallocate by expanding DGroup by 0 bytes
	xor	ax, ax
	push ax
	push ds
	lea	ax, raToDeallocate
	push	ds
	push	ax
	call	ExpandAreaSL
	or	ax,ax
	je		InitSaToDeallocate
	jmp	AllocReturn
InitSaToDeallocate:
	mov	ax, ds
	mov	saToDeallocate, ax

; Initialize the value of cbFree as address(ArrayHigh) - raToDeallocate.
; This is the amount of storage that we can allocate before we have to call ExpandAreaSL to allocate more memory from DGroup.

	mov dx, raToDeallocate
	lea	ax,ArrayHigh
	sub	ax, dx
	mov	cbFree, ax
	xor	ax,ax
	mov	firstTime,ax


;Initialize the value of raNextFree. This is the offset address of the top of the Array.
	lea	ax, ArrayHigh
	mov	raNextFree, ax

VariablesInitialized:

; Round memory requested to number of paragraphs
	mov	ax, cb
	add	ax, 0fh
	and ax, 0fff0h
	mov	cb, ax				;cb is rounded to number of paragraphs
	mov	cx, ax				;cx = cb rounded to number of paragraphs

; now allocate the memory. First, see if we can allocate some from Array.
	mov	ax, cbArrayFree
	or	ax, ax
	jz	ArrayEmpty

; There is still free memory in the Array. See if it's enough.
	sub	ax, cx    ;ax = cbArrayFree - memory asked for
	mov	cbArrayFree, ax
	jae	AllocNextFree

ArrayEmpty:	
; If the memory can't be allocated from the array, check to be sure the 
; client is not going to initialize the memory. This would destroy code.
	mov	cbArrayFree, 0
	mov	ax,fInit
	or	ax, ax
	jz	AllocNextFree
	mov	ax,ercArrayTooSmall
	jmp	AllocReturn

AllocNextFree:
; Allocate the next free memory. First see if we can allocate from initialization memory. This includes the Array and initialization code.
	mov	dx, cbFree
	or	dx, dx
	jz	AllocDsMemory
	sub	dx, cx				;dx = cbFree - cb
	jb	NotEnoughInitMemory

; This memory can be allocated from initialization memory.
	mov	cbFree, dx
	mov	ax, raNextFree
	sub	ax, cx
	mov	raNextFree, ax
	jmp	ReturnObToCaller

NotEnoughInitMemory:
; We don't have enough init memory left to allocate the memory requested. We will allocate some DS memory to fill out the rest.
	neg	dx				;dx = cb - cbFree
	mov	cb,dx
	mov	cbFree, 0

AllocDsMemory:
; Come here if we must allocate DS memory. cb contains the number of bytes to allocate.
	push cb
	push ds
	lea ax, raAlloced
	push ds
	push ax
	call ExpandAreaSL
	cmp ax, ercOk
	jne AllocReturn
	mov ax, raAlloced

ReturnObToCaller:

;  pass back to caller
	les bx, dword ptr [pobRet]
	mov es:[bx], ax

	mov ax, ercOk

AllocReturn:
	mov sp, bp
	pop bp
	ret cbArgs
AllocMemoryInit endp


InitAlloc ends


end; InitAlloc.asm
