
extrn BuildGdtSlot: far
sgSpare              equ 68h
accessWritableData   equ 92h

DGroup group data
data segment public 'data'
data ends

InitRomScn_code segment 'coed'

 
assume cs:InitRomScn_code

; ROM SCAN
;
; Scan BIOS ROM for matching text string.
;
; Usually used to scan a ROM for a text string for machine identification.
;
;
;  Calling sequence:
;
;        IF RomScan(paROM, cbScan, cbString, pbString) THEN
;
;
;            paROM is the physical address in BIOS space to start the scan
;            cbScan is the number of bytes to scan,
;            cbString is the length in bytes of the following string constant,
;            pbString points to the string constant to match.
;
;        Returns TRUE if match, FALASE if no match.

;
pbString   equ   dword ptr [bp+6]
cbString   equ   word  ptr [bp+10]
cbScan     equ   word  ptr [bp+12]
paROMlow   equ   dword ptr [bp+14]
paROMhigh  equ   dword ptr [bp+16]


Public RomScan
RomScan proc far
	push bp                       ;
	mov  bp, sp                   ;
	push sgSpare                  ;sg for init use
	mov  ax, paRomHigh            ;
	push ax                       ;
	mov  ax, paRomLow             ;
	push ax                       ;
	push 0FFFFh                   ;limit, 64k
	push accessWritableData       ;
	call BuildGdtSlot             ;returns sgSpare in ax
	mov  es, ax                   ;es = BIOS selector
	mov  dx, cbString             ;Length of string constant
	mov  cx, cbScan               ;Count of bytes in BIOS to scan
	push ds                       ;save callers DS
	lds  si, pbString             ;Offset of start of string constant
	xor  bx, bx                   ;
	xor  di, di                   ;
searchloop:
	mov  al, DS:[SI+BX]           ;get byte from string constant
	cmp  al, ES:[DI]              ;look for a match
	je   foundOne                 ;JIF found match
	and  bx, bx                   ;
	jnz  skipIncrement            ;
	inc  di                       ;point to next char in BIOS area
skipIncrement:
	dec  cx                       ;
	jz   searchFailed             ;JIF search failed
	xor  bx, bx                   ;back up to start of constant string
	jmp  short searchloop         ;
foundOne:
	inc  bx                       ;index next char in string constant
	inc  di                       ;index next char in BIOS area
	mov  ax, dx                   ;AX = length of string constant
	cmp  ax, bx                   ;
	jg   searchloop               ;continue search
	xor  ax, ax                   ;
	inc  ax                       ;ax = true for match
	jmp short RomScanRet          ;
searchFailed:
	xor  ax, ax                   ;
RomScanRet:
	pop  ds                       ;restore DS
	pop  bp                       ;
	ret  12                       ;
RomScan endp


InitRomScn_code ends
end
; Change log
;
; 11/13/92 FW  created
