/*
 *  CM.Lib.h
 *
 *  CM.Lib (Context Manager) procedural interface prototypes
 *
 *  Copyright 1991, Unisys Corporation.  All rights reserved.
 *
 */

#if !defined _CTOSLIB
#define _CTOSLIB

typedef  unsigned char   Uchar  ;
typedef  unsigned int    Uint   ;
typedef  unsigned long   Ulong  ;
typedef  unsigned short  Ushort ;

typedef  void _far *     Pvoid  ;

#endif

#if defined CMCurrentVersion || defined All
#undef CMCurrentVersion
Ushort _far _cdecl CMCurrentVersion( Pvoid pbCMVersion, Pvoid pbCMRevision ) ;
#endif

#if defined CMQueryConfigFile || defined All
#undef CMQueryConfigFile
Ushort _far _cdecl CMQueryConfigFile( Pvoid pbBuf, Uint cbBuf, Pvoid pcbBufRet ) ;
#endif

#if defined CMQueryContextHandle || defined All
#undef CMQueryContextHandle
Ushort _far _cdecl CMQueryContextHandle( Pvoid pchRet ) ;
#endif

#if defined CMQueryErc || defined All
#undef CMQueryErc
Ushort _far _cdecl CMQueryErc( Pvoid pErcRet ) ;
#endif

#if defined CMQueryParent || defined All
#undef CMQueryParent
Ushort _far _cdecl CMQueryParent( Uint ch, Pvoid pChRet ) ;
#endif

#if defined CMResumeContext || defined All
#undef CMResumeContext
Ushort _far _cdecl CMResumeContext( Uint ch ) ;
#endif

#if defined CMSetParent || defined All
#undef CMSetParent
Ushort _far _cdecl CMSetParent( Uint chToSet, Uint chNewParent ) ;
#endif

#if defined CMStartAppl || defined All
#undef CMStartAppl
Ushort _far _cdecl CMStartAppl( Uchar fName, Pvoid pStartData, Uint sStartData, Pvoid pVLPB, Uchar fDependant, Pvoid pChRet ) ;
#endif

#if defined CMStartApplByBlock || defined All
#undef CMStartApplByBlock
Ushort _far _cdecl CMStartApplByBlock( Pvoid pbBlock, Uint cbBlock, Pvoid pVLPB, Uint sVLPB, Uchar fDependentChild, Pvoid pchRet ) ;
#endif

#if defined CMStartApplByName || defined All
#undef CMStartApplByName
Ushort _far _cdecl CMStartApplByName( Pvoid pbName, Uint cbName, Pvoid pVLPB, Uint sVLPB, Uchar fDependentChild, Pvoid pchRet ) ;
#endif

#if defined CMStartBkgdApplByName || defined All
#undef CMStartBkgdApplByName
Ushort _far _cdecl CMStartBkgdApplByName( Pvoid pbName, Uint cbName, Pvoid pVLPB, Uint sVLPB, Uchar fDependentChild, Pvoid pchRet ) ;
#endif

#if defined CMSuspendContext || defined All
#undef CMSuspendContext
Ushort _far _cdecl CMSuspendContext( Uint ch ) ;
#endif

#if defined CMSwitchContext || defined All
#undef CMSwitchContext
Ushort _far _cdecl CMSwitchContext( Uint ch ) ;
#endif

#if defined CMSwitchToExistingContext || defined All
#undef CMSwitchToExistingContext
Ushort _far _cdecl CMSwitchToExistingContext( Uint ch ) ;
#endif

#if defined CMTellMeWhenMyChildTerms || defined All
#undef CMTellMeWhenMyChildTerms
Ushort _far _cdecl CMTellMeWhenMyChildTerms( Uint Childch, Pvoid pExch ) ;
#endif

#if defined CMTerminateContext || defined All
#undef CMTerminateContext
Ushort _far _cdecl CMTerminateContext( Uint ch ) ;
#endif

#if defined CMTranslateChToFnKey || defined All
#undef CMTranslateChToFnKey
Ushort _far _cdecl CMTranslateChToFnKey( Uint Ch, Pvoid pbFnKeyRet ) ;
#endif

#if defined CMTranslateChToPh || defined All
#undef CMTranslateChToPh
Ushort _far _cdecl CMTranslateChToPh( Uint ch, Pvoid pphRet ) ;
#endif

#if defined CMTranslateFnKeyToInfo || defined All
#undef CMTranslateFnKeyToInfo
Ushort _far _cdecl CMTranslateFnKeyToInfo( Pvoid bFKey, Pvoid pInfoRet ) ;
#endif

#if defined CMTranslatePhToCh || defined All
#undef CMTranslatePhToCh
Ushort _far _cdecl CMTranslatePhToCh( Uint ph, Pvoid pchRet ) ;
#endif

#if defined NotifyCM || defined All
#undef NotifyCM
Ushort _far _cdecl NotifyCM( Uint msgType, Pvoid pbMsg, Uint cbMsg ) ;
#endif

#if defined ICMSCheck || defined All
#undef ICMSCheck
Ushort _far _cdecl ICMSCheck( Pvoid pbMsg, Uint cbMsg, Pvoid pcbMsgRet ) ;
#endif

#if defined ICMSCurrentVersion || defined All
#undef ICMSCurrentVersion
Ushort _far _cdecl ICMSCurrentVersion( Pvoid pbVersion, Pvoid pbRevision ) ;
#endif

#if defined ICMSFlush || defined All
#undef ICMSFlush
Ushort _far _cdecl ICMSFlush( Uint ch ) ;
#endif

#if defined ICMSSend || defined All
#undef ICMSSend
Ushort _far _cdecl ICMSSend( Uint ch, Pvoid pbMsg, Uint cbMsg ) ;
#endif

#if defined ICMSWait || defined All
#undef ICMSWait
Ushort _far _cdecl ICMSWait( Pvoid pbMsg, Uint cbMsg, Pvoid pcbMsgRet ) ;
#endif



#undef All
