/***
*dirent.h - function declarations for directory handling/creation
*
*	Copyright (c) 1985-1990, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This include file contains the function declarations for the library
*	functions related to directory handling and creation.
*	[POSIX]
*
****/

#if !defined(_DIRENT_DEFINED) && defined(_POSIX_SOURCE)

#define _DIRENT_DEFINED

#include <limits.h>
#include <sys/types.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


/* directory structures */

struct dirent {
	ino_t d_ino;
	char d_name[NAME_MAX+1];
	};

typedef struct {
	signed int id;
	signed int fd;
	char path[PATH_MAX+1];
	struct dirent direntry;
	} DIR;


/* function prototypes */

extern signed int            _FAR_ _cdecl closedir(DIR _FAR_ *);
extern DIR _FAR_ *           _FAR_ _cdecl opendir(const char _FAR_ *);
extern struct dirent _FAR_ * _FAR_ _cdecl readdir(DIR _FAR_ *);
extern void                  _FAR_ _cdecl rewinddir(DIR _FAR_ *);

#endif /* !_DIRENT_DEFINED && _POSIX_SOURCE */
