/***
*limits.h - implementation dependent values
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	Contains defines for a number of implementation dependent values
*	which are commonly used in C programs.
*	[POSIX/ANSI]
*
****/

#if !defined(_LIMITS_DEFINED)

#define _LIMITS_DEFINED

#define CHAR_BIT	  8		/* number of bits in a char */
#define SCHAR_MIN	(-127)		/* minimum signed char value */
#define SCHAR_MAX	(+127)		/* maximum signed char value */
#define UCHAR_MAX	  0xFF		/* maximum unsigned char value */
#ifndef _CHAR_UNSIGNED
#define CHAR_MIN	SCHAR_MIN	/* mimimum char value */
#define CHAR_MAX	SCHAR_MAX	/* maximum char value */
#else
#define CHAR_MIN	  0
#define CHAR_MAX	UCHAR_MAX
#endif
#define MB_LEN_MAX	  1		/* max. # bytes in multibyte char */
#define SHRT_MIN	(-32767)	/* minimum (signed) short value */
#define SHRT_MAX	(+32767)	/* maximum (signed) short value */
#define USHRT_MAX	  0xFFFF	/* maximum unsigned short value */
#define INT_MIN 	(-32767)	/* minimum (signed) int value */
#define INT_MAX 	(+32767)	/* maximum (signed) int value */
#define UINT_MAX	  0xFFFF	/* maximum unsigned int value */
#define LONG_MIN	(-2147483647)	/* minimum (signed) long value */
#define LONG_MAX	(+2147483647)	/* maximum (signed) long value */
#define ULONG_MAX	  0xFFFFFFFF	/* maximum unsigned long value */

#if defined(_POSIX_SOURCE)
#define _POSIX_ARG_MAX		4096
#define _POSIX_CHILD_MAX	6
#define _POSIX_LINK_MAX		8
#define _POSIX_MAX_CANON	255
#define _POSIX_MAX_INPUT	255
#define _POSIX_NAME_MAX		14
#define _POSIX_NGROUPS_MAX	0
#define _POSIX_OPEN_MAX		16
#define _POSIX_PATH_MAX		255
#define _POSIX_PIPE_BUF		512
#define _POSIX_SSIZE_MAX	32767
#define _POSIX_STREAM_MAX	8
#define _POSIX_TZNAME_MAX	3

#define _POSIX2_BC_BASE_MAX	99
#define _POSIX2_BC_DIM_MAX	2048
#define _POSIX2_BC_SCALE_MAX	99
#define _POSIX2_BC_STRING_MAX	1000
#define _POSIX2_EQUIV_CLASS_MAX	2
#define _POSIX2_EXPR_NEST_MAX	32
#define _POSIX2_LINE_MAX	2048
#define _POSIX2_MAX_NICE	0
#define _POSIX2_MIN_NICE	0
#define _POSIX2_RE_DUP_MAX	255

#define _XOPEN_VERSION		(-1)
#define _XOPEN_PASS_MAX		8

#define _CTOS_PATH_MAX		105
#define _CTOS_VOL_MAX		12
#define _CTOS_DIR_MAX		12
#define _CTOS_NODE_MAX		12
#define _CTOS_FILE_MAX		50
#define _CTOS_PASS_MAX		12

#define ARG_MAX			_POSIX_ARG_MAX
#define CHILD_MAX		10			/* For PCTS */
#define LINK_MAX		256
#define MAX_CANON		_POSIX_MAX_CANON
#define MAX_INPUT		_POSIX_MAX_INPUT
#define NAME_MAX		50
#define NGROUPS_MAX		8
#define OPEN_MAX		32
#define FOPEN_MAX		OPEN_MAX
#define PATH_MAX		_POSIX_PATH_MAX
#define PIPE_BUF		4096
#define SSIZE_MAX		_POSIX_SSIZE_MAX
#define STREAM_MAX		FOPEN_MAX
#define TZNAME_MAX		_POSIX_TZNAME_MAX

#define BC_BASE_MAX		_POSIX2_BC_BASE_MAX
#define BC_DIM_MAX		_POSIX2_BC_DIM_MAX
#define BC_SCALE_MAX		_POSIX2_BC_SCALE_MAX
#define BC_STRING_MAX		_POSIX2_BC_STRING_MAX
#define EQUIV_CLASS_MAX		_POSIX2_EQUIV_CLASS_MAX
#define EXPR_NEST_MAX		_POSIX2_EXPR_NEST_MAX
#define LINE_MAX		_POSIX2_LINE_MAX
#define MAX_NICE		_POSIX2_MAX_NICE
#define MIN_NICE		_POSIX2_MIN_NICE
#define RE_DUP_MAX		_POSIX2_RE_DUP_MAX

#define PASS_MAX		12

#endif /* _POSIX_SOURCE */

#endif /* !_LIMITS_DEFINED */
