/***
*stdarg.h - defines ANSI-style macros for variable argument functions
*
*	Copyright 1985-1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This file defines ANSI-style macros for accessing arguments
*	of functions which take a variable number of arguments.
*	[POSIX/ANSI]
*
****/

#if !defined(_STDARG_DEFINED)

#define _STDARG_DEFINED

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


#include <stddef.h>

typedef char _FAR_ *va_list;

#define va_start(ap,v) ap = (va_list)&v + sizeof(v)
#define va_arg(ap,t) ((t _FAR_ *)(ap += sizeof(t)))[-1]
#define va_end(ap) ap = NULL

#endif /* !_STDARG_DEFINED */
