/*
 *	Copyright 1991, Unisys Corporation.  All rights reserved.
 */

#ifndef __TAR__
#define __TAR__

/* 
    tar.h as written in pp. 285-287 of POSIX manual.
*/

struct tar_hdr  {
                char name[100];
                char mode[8];
                char uid[8];
                char gid[8];
                char size[12];
                char mtime[12];
                char cksum[8];
                char typeflag[1];
                char linkname[100];
                char magic[6];
                char version[2];
                char uname[32];
                char gname[32];
                char devmajor[8];
                char devminor[8];
                char prefix[155];
                };

#define TMAGIC      "ustar"     /* ustar and a null */
#define TMAGLEN     6
#define TVERSION    "00"        /* 00 and no null */
#define TVERSLEN    2

/* Values used in typeflag field */
#define REGTYPE     '0'         /* Regular file  */
#define AREGTYPE    '\0'        /* Regular file  */
#define LNKTYPE     '1'         /* Link          */
#define SYMTYPE     '2'         /* Reserved      */
#define CHRTYPE     '3'         /* Char. special */
#define BLKTYPE     '4'         /* Block special */
#define DIRTYPE     '5'         /* Directory     */
#define FIFOTYPE    '6'         /* FIFO special  */
#define CONTTYPE    '7'         /* Reserved      */

/* Bits used in the mode field - values in octal */
#define TSUID       04000       /* Set UID on execution    */
#define TSGID       02000       /* Set GID on execution    */
#define TSVTX       01000       /* Reserved                */
                                /* File permissions        */
#define TUREAD      00400       /* read by owner           */
#define TUWRITE     00200       /* write by owner          */
#define TUEXEC      00100       /* execute/search by owner */
#define TGREAD      00040       /* read by group           */
#define TGWRITE     00020       /* write by group          */
#define TGEXEC      00010       /* execute/search by group */
#define TOREAD      00004       /* read by other           */
#define TOWRITE     00002       /* write by other          */
#define TOEXEC      00001       /* execute/search by other */

#endif
