/***
*unistd.h - declarations/definitions for commonly used library functions
*
*	Copyright 1991, Microsoft Corporation.  All rights reserved.
*	Copyright 1991, Unisys Corporation.  All rights reserved.
*
*Purpose:
*	This include file contains the function declarations for
*	commonly used library functions which either don't fit somewhere
*	else, or, like toupper/tolower, can't be declared in the normal
*	place for other reasons.
*	[POSIX/ANSI]
*
****/

#if !defined(_UNISTD_DEFINED)

#define _UNISTD_DEFINED

#include <stddef.h>
#include <sys/types.h>

#if defined(_DLL) && !defined(_MT)
#error Cannot define _DLL without _MT
#endif

#if !defined(_FAR_)
#if defined(_MT)
#define _FAR_ _far
#else
#define _FAR_
#endif
#endif


#define _SC_START            0
#define _SC_END             26

#define _SC_ARG_MAX          0
#define _SC_CHILD_MAX        1
#define _SC_CLK_TCK          2
#define _SC_NGROUPS_MAX      3
#define _SC_OPEN_MAX         4
#define _SC_STREAM_MAX       5
#define _SC_TZNAME_MAX       6
#define _SC_JOB_CONTROL      7
#define _SC_SAVED_IDS        8
#define _SC_VERSION          9
#define _SC_BC_BASE_MAX     10
#define _SC_BC_DIM_MAX      11
#define _SC_BC_SCALE_MAX    12
#define _SC_BC_STRING_MAX   13
#define _SC_EXPR_NEST_MAX   14
#define _SC_LINE_MAX        15
#define _SC_MAX_NICE        16
#define _SC_MIN_NICE        17
#define _SC_EQUIV_CLASS_MAX 18
#define _SC_RE_DUP_MAX      19
#define _SC_2_C_BIND        20
#define _SC_2_C_DEV         21
#define _SC_2_FORT_DEV      22
#define _SC_2_SW_DEV        23
#define _SC_2_VERSION       24
#define _SC_PASS_MAX        25
#define _SC_XOPEN_VERSION   26

#define _PC_START            0
#define _PC_END              8

#define _PC_LINK_MAX         0
#define _PC_MAX_CANON        1
#define _PC_MAX_INPUT        2
#define _PC_NAME_MAX         3
#define _PC_PATH_MAX         4
#define _PC_PIPE_BUF         5
#define _PC_CHOWN_RESTRICTED 6
#define _PC_NO_TRUNC         7
#define _PC_VDISABLE         8

#define _CS_START 0
#define _CS_END   1

#define _CS_PATH  0
#define _CS_SHELL 1

#define STDIN_FILENO  0
#define STDOUT_FILENO 1
#define STDERR_FILENO 2

#define R_OK 4
#define W_OK 2
#define X_OK 1
#define S_OK X_OK
#define F_OK 8

#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

#define _POSIX_2_C_BIND         TRUE
#define _POSIX_JOB_CONTROL      TRUE
#define _POSIX_2_C_DEV          TRUE
#define _POSIX_2_FORT_DEV       FALSE
#define _POSIX_2_SW_DEV         TRUE
#define _POSIX_2_VERSION        199007L /* Draft 10 */
#define _POSIX_SAVED_IDS        TRUE
#define _POSIX_VERSION          198808L /* latest is 199009L */
#define _POSIX_CHOWN_RESTRICTED TRUE
#define _POSIX_NO_TRUNC         TRUE
#define _POSIX_VDISABLE         '\0'


/* function prototypes */

extern pid_t        _FAR_ _cdecl fork(void);
extern signed int   _FAR_ _cdecl execl(const char _FAR_ *, const char _FAR_ *, ...);
extern signed int   _FAR_ _cdecl execle(const char _FAR_ *, const char _FAR_ *, ...);
extern signed int   _FAR_ _cdecl execlp(const char _FAR_ *, const char _FAR_ *, ...);
extern signed int   _FAR_ _cdecl execv(const char _FAR_ *, char _FAR_ * const []);
extern signed int   _FAR_ _cdecl execve(const char _FAR_ *, char _FAR_ * const [], char _FAR_ * const []);
extern signed int   _FAR_ _cdecl execvp(const char _FAR_ *, char _FAR_ * const []);
extern void         _FAR_ _cdecl _exit(signed int);
extern unsigned int _FAR_ _cdecl alarm(unsigned int);
extern signed int   _FAR_ _cdecl pause(void);
extern unsigned int _FAR_ _cdecl sleep(unsigned int);
extern pid_t        _FAR_ _cdecl getpid(void);
extern pid_t        _FAR_ _cdecl getppid(void);
extern uid_t        _FAR_ _cdecl getuid(void);
extern uid_t        _FAR_ _cdecl geteuid(void);
extern gid_t        _FAR_ _cdecl getgid(void);
extern gid_t        _FAR_ _cdecl getegid(void);
extern signed int   _FAR_ _cdecl setuid(uid_t);
extern signed int   _FAR_ _cdecl setgid(gid_t);
extern signed int   _FAR_ _cdecl getgroups(signed int, gid_t []);
extern char _FAR_ * _FAR_ _cdecl getlogin(void);
extern char _FAR_ * _FAR_ _cdecl cuserid(char _FAR_ *);
extern pid_t        _FAR_ _cdecl getpgrp(void);
extern pid_t        _FAR_ _cdecl setsid(void);
extern signed int   _FAR_ _cdecl setpgid(pid_t, pid_t);
extern char _FAR_ * _FAR_ _cdecl getenv(const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl ctermid(char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl ttyname(signed int);
extern signed int   _FAR_ _cdecl isatty(signed int);
extern signed long  _FAR_ _cdecl sysconf(signed int);
extern signed int   _FAR_ _cdecl chdir(const char _FAR_ *);
extern char _FAR_ * _FAR_ _cdecl getcwd(char _FAR_ *, size_t);
extern signed int   _FAR_ _cdecl link(const char _FAR_ *, const char _FAR_ *);
extern signed int   _FAR_ _cdecl unlink(const char _FAR_ *);
extern signed int   _FAR_ _cdecl rmdir(const char _FAR_ *);
extern signed int   _FAR_ _cdecl rename(const char _FAR_ *, const char _FAR_ *);
extern signed int   _FAR_ _cdecl access(const char _FAR_ *, signed int);
extern signed int   _FAR_ _cdecl chown(const char _FAR_ *, uid_t, gid_t);
extern signed long  _FAR_ _cdecl pathconf(const char _FAR_ *, signed int);
extern signed long  _FAR_ _cdecl fpathconf(signed int, signed int);
extern signed int   _FAR_ _cdecl pipe(signed int [2]);
extern signed int   _FAR_ _cdecl dup(signed int);
extern signed int   _FAR_ _cdecl dup2(signed int, signed int);
extern signed int   _FAR_ _cdecl close(signed int);
extern ssize_t      _FAR_ _cdecl read(signed int, void _FAR_ *, size_t);
extern ssize_t      _FAR_ _cdecl write(signed int, const void _FAR_ *, size_t);
extern off_t        _FAR_ _cdecl lseek(signed int, off_t, signed int);
extern signed int   _FAR_ _cdecl tcgetpgrp(signed int);
extern signed int   _FAR_ _cdecl tcsetpgrp(signed int, pid_t);
#if defined(_POSIX1_SOURCE)
extern ssize_t      _FAR_ _cdecl readlink(const char _FAR_ *, void _FAR_ *, size_t);
extern signed int   _FAR_ _cdecl symlink(const char _FAR_ *, const char _FAR_ *);
#endif
#if defined(_POSIX2_SOURCE)
extern size_t       _FAR_ _cdecl confstr(signed int, char _FAR_ *, size_t);
extern signed int   _FAR_ _cdecl getopt(signed int, const char _FAR_ * const [], const char _FAR_ *);
#endif

#endif /* !_UNISTD_DEFINED */
